/**
 * @author Priyanshi Sharma
 */

Ext.define('Academia.view.transport.serviceRoute.ImportServiceRouteDetailsForm',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.importserviceroutedetailsform',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchInnerPanel',
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	//plugins : "formlabelrequired",
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
		margin: 0,
		itemId:'serviceRouteDetailsRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		itemId:'templateNameContainer',
		width:'auto',
		layout : 'hbox',
		items: [{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			itemId:'moduleNameForUpload',
			labelAlign: 'top',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			store:'importutility.ModuleName',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			allowBlank:false,
			width: 300,
		}]
	},{ 	
		xtype:'fieldcontainer',
		items: [{
			xtype : 'filefield',
			ui : 'CustomBtnThird',
			width: 536,
			labelAlign: 'top',
			fieldLabel : getCommonTranslation('UPLOAD_FILE'),
			buttonText : getCommonTranslation('BROWSE_FILE'),
			itemId : 'uploadFileField',
			name : 'file',
			allowBlank:false,
			validateOnChange : true,
			listeners:{
	            change: function(fileField, value) {
	                value = value.replace('C:\\fakepath\\', '');
	                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                fileField.setRawValue(newValue);
	                if (!isNullOrEmpty(newValue)) {
	                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
	                    if (!baseController.isValidFileExtensionForLoader(extension)) {
	                        fileField.reset();
	                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
	                    }
	                }
	            }
	        }
		}]},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		style: {
			'marginLeft': '-16px !important;'
		},
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});








