/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.transport.stopLocation.StopLocationFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.stoplocationformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('STOP_LOCATION'),
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'stopLocationFormItemId',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'hidStopLocationId',
            name: 'id'
        },   {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                fieldLabel: getCommonTranslation('STOP_LOCATION_CODE'),
                xtype: 'textfield',
                itemId: 'locationCodeItemId',
                name: 'locationCode',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: false
            }, {
                fieldLabel: getCommonTranslation('STOP_LOCATION'),
                xtype: 'textfield',
                itemId: 'locationNameItemId',
                name: 'locationName',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',

            items: [{
                xtype: 'button',
                itemId: 'btnSaveStopLocationForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelStopLocationForm',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
