/**
 */

Ext.define('Academia.view.transport.vehicle.FuelConsumptionDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.fuelconsumptiondetailwin',
	title: getTransportTranslation('FUEL_CONSUMPTION_DETAIL'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'fuelconsumptiondetailwinId',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'refillDate',
				itemId:'refillDateId',
				fieldLabel: getTransportTranslation('REFILL_DATE'),
				vtype: 'daterange',
				allowBlank: false,
				maxValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
			},{
				xtype: 'numberfield',
				name:'odometerReading',
				itemId:'odometerReading',
				fieldLabel: getTransportTranslation('ODOMETER_READING'),
				maxLength: 5,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				allowBlank: false,
				enforceMaxLength : true,
				minValue:0
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				name:'approximateAvailableFuel',
				itemId:'approximateAvailableFuel',
				fieldLabel: getTransportTranslation('APPROXIMATE_AVAILABLE_FUEL'),
				maxLength: 5,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				allowBlank: false,
				enforceMaxLength : true,
				minValue:0
			},{
				xtype: 'numberfield',
				name:'currentRefill',
				itemId:'currentRefill',
				fieldLabel: getTransportTranslation('CURRENT_REFILL'),
				maxLength: 5,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				allowBlank: false,
				enforceMaxLength : true,
				minValue:0
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				name:'amount',
				itemId:'amount',
				fieldLabel: getTransportTranslation('AMOUNT'),
				maxLength: 5,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				allowBlank: false,
				enforceMaxLength : true,
				minValue:0
			},{
				xtype: 'textfield',
				name: 'refillBy',
				itemId:'refillBy',
				fieldLabel: getTransportTranslation('REFILL_BY'),
				maxLength:100,
				enforceMaxLength : true,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'refillStation',
				itemId:'refillStation',
				fieldLabel: getTransportTranslation('REFILL_STATION'),
				maxLength:100,
				enforceMaxLength : true,
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtnFuelConsumption',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtnFuelConsumption',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});