/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.transport.vehicle.JourneyAssignmentDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.journeyassignmentdetailwin',
	title: getTransportTranslation('JOURNEY_ASSIGNMENT_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		itemId:'journeyassignmentdetailwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'datefield',
			name: 'dateOfJourney',
			itemId:'dateOfJourney',
		    allowBlank: false,
			fieldLabel: getTransportTranslation('DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('SERVICE_ROUTE_NAME'),
			name: 'serviceName',
			itemId:'serviceName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.serviceRoute.ServiceRouteName',
			valueField: 'id',
			displayField: 'value',
			queryParam:'serviceName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			allowBlank: false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'assignStatus',
			itemId:'assignStatus',
			fieldLabel: getTransportTranslation('ORIGINAL_STATUS'),
			store: 'transport.serviceRoute.VehicleStatus',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{	
			xtype: 'customcombobox',
			name: 'completionStatus',
			itemId:'completionStatus',
			fieldLabel: getTransportTranslation('CURRENT_STATUS'),
			store: 'transport.vehicle.CompletionStatus',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'textfield',
			readOnly : true,
			hidden : true,
			fieldLabel: getTransportTranslation('NO_OF_USERS_SERVICED'),
			name: 'noOfUsers',
			itemId:'noOfUsersServiced'
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});