/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.transport.vehicle.JourneyAssignmentStructure', {
	extend: 'Ext.form.Panel',
	alias: 'widget.journeyassignmentstructure',
	autoScroll: false,
	frame: false,
	border:false,
	
	items: [{
		xtype:'panel',
		width: 'auto',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'displayfield'
			},
			items:[{
				name: 'vehicleCode',
				itemId:'vehicleCode',
				fieldLabel: getTransportTranslation('VEHICLE_CODE')
			},{
				name: 'vehicleType',
				itemId:'vehicleType',
				fieldLabel: getTransportTranslation('VEHICLE_TYPE')
			},{
				name: 'vehicleNo',
				itemId:'vehicleNo',
				fieldLabel: getTransportTranslation('VEHICLE_NO')
			},{
				xtype:'hidden',
				name:'vehicleId',
				itemId:'vehicleId'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'datefield',
				name: 'startDate',
				itemId:'startDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'tillDate',
				editable:false,
				fieldLabel:getTransportTranslation('DATE_FROM')
			},{
				xtype: 'datefield',
				name: 'tillDate',
				itemId:'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'startDate',
				editable:false,
				fieldLabel:getTransportTranslation('DATE_TILL')
			},{
				xtype: 'customcombobox',
				name:'transServiceRouteUserId',
				itemId:'transServiceRouteUserId',
				fieldLabel:getTransportTranslation('USER'),
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				store: 'transport.vehicle.TransServiceRouteUser',
				valueField: 'id',
				displayField: 'value',
				queryParam:'userName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getTransportTranslation('SEARCH'),
				formBind: true,
				itemId: 'SearchBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getTransportTranslation('RESET'),
				itemId: 'cancelBtn',	
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	},{
		xtype:'panel',  
		items:[{
			xtype: 'journeyassignmentlist',
			itemId: 'journeyassignmentlist',
			margin:'0 0 0 0'
		}]
	}]
});
