/**
 * @author Ankur.Jaiswal
 */

Ext.define('Academia.view.transport.vehicle.LicenceHistoryDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.licencehistorydetailwin',
	title: getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'licencehistorydetailwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id',
			itemId: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('TRANS_LICENCE_DISK_NO'),
				name: 'transLicenceDiskNo',
				itemId:'transLicenceDiskNo',
				maxLength:100
			},{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('TRANS_LICENCE_NO'),
				name: 'transLicenceNo',
				itemId:'transLicenceNo',
				maxLength:100
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('TRANS_VEHICLE_LICENCE_NO'),
				name: 'transVehicleLicenceNo',
				itemId:'transVehicleLicenceNo',
				maxLength:100
			},{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('TRANS_VIN'),
				name: 'transVin',
				itemId:'transVin',
				maxLength:100
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('TRANS_ENGINE_NO'),
				name: 'transEngineNo',
				itemId:'transEngineNo',
				maxLength:100
			},{
				xtype: 'numberfield',
				fieldLabel: getTransportTranslation('TRANS_FEES'),
				name: 'transFees',
				itemId:'transFees',
				maxLength: 10,
	            enforceMaxLength: true,
	            hideTrigger: true,
	            keyNavEnabled: false,
	            mouseWheelEnabled: false,
	            allowExponential: false,
	            decimalPrecision : 2
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'numberfield',
				fieldLabel: getTransportTranslation('TRANS_GVM_IN_KG'),
				name: 'transGVM',
				itemId:'transGVM',
	            maxLength: 10,
	            enforceMaxLength: true,
	            hideTrigger: true,
	            keyNavEnabled: false,
	            mouseWheelEnabled: false,
	            allowExponential: false,
	            decimalPrecision : 3
			},{
				xtype: 'numberfield',
				fieldLabel: getTransportTranslation('TRANS_TARE_IN_KG'),
				name: 'transTARE',
				itemId:'transTARE',
	            maxLength: 10,
	            enforceMaxLength: true,
	            hideTrigger: true,
	            keyNavEnabled: false,
	            mouseWheelEnabled: false,
	            allowExponential: false,
	            decimalPrecision : 3
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name:'transDateOfExpiry',
				itemId:'transDateOfExpiry',
				fieldLabel:getTransportTranslation('TRANS_DATE_OF_EXPIRY'),
				allowBlank : false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange'
			},{
				xtype: 'datefield',
				name: 'transDateOfTest',
				itemId:'transDateOfTest',
				fieldLabel: getTransportTranslation('TRANS_DATE_OF_TEST'),
				vtype: 'daterange',
				maxValue: new Date(),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange'
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});