/**
 *  @author Ankur.Jaiswal
 */

Ext.define('Academia.view.transport.vehicle.LicenceHistoryList', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.licencehistorylist',
	store : 'transport.vehicle.LicenceHistoryGridDataStore',
	title: getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.LicenceHistoryGridDataStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
			},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getCommonTranslation('UPLOAD_DOCUMENT'),
			itemId:'uploadLicenceAndRegistrationDocumentLink'
		}],
		listeners: { click: function() { this.showMenu(); }}
	}],
	columns: [{
		header : getTransportTranslation('TRANS_LICENCE_DISK_NO'),
		dataIndex : 'licenceDiskNumber',
		flex:1
	},{
		header : getTransportTranslation('TRANS_LICENCE_NO'),
		dataIndex : 'licenceNumber',
		flex:1
	},{
		header : getTransportTranslation('TRANS_VEHICLE_LICENCE_NO'),
		dataIndex : 'vehicleLicenseNumber',
		flex:1
	},{
		header : getTransportTranslation('TRANS_VIN'),
		dataIndex : 'vin',
		flex:1
	},{
		header : getTransportTranslation('TRANS_FEES'),
		dataIndex : 'fees',
		flex:1
	},{
		header : getTransportTranslation('TRANS_ENGINE_NO'),
		dataIndex : 'engineNumber',
		flex:1
	},{
		header : getTransportTranslation('TRANS_GVM_IN_KG'),
		dataIndex : 'gvm',
		hidden:true,
		flex:1
	},{
		header : getTransportTranslation('TRANS_TARE_IN_KG'),
		dataIndex : 'tare',
		hidden:true,
		flex:1
	},{
		header : getTransportTranslation('TRANS_DATE_OF_EXPIRY'),
		dataIndex : 'expiryDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('TRANS_DATE_OF_TEST'),
		dataIndex : 'testDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentCount',
		flex:1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(value>0){
				return  '<a href="#"> ' + value + '</a>';
			}
			else{
				return '-';
			}
		}
	}]
});