/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.transport.vehicle.VehicleInsuranceDocumentGrid', {
	extend: 'Ext.window.Window',
	alias : 'widget.vehicleinsurancedocumentgrid',
	border: true,
	modal : true,
	title: getProgramandcourseTranslation('DOWNLOAD_DOCUMENT'),
	autoScroll: true,
	maxHeight: 350,
	width: '40%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	items:[{
		xtype: 'form',
		plugins:"formlabelrequired",
		items: [{
			xtype: 'grid',
			itemId:'vehicleinsurancedocumentgridId',
			border:true,
			store : 'transport.vehicle.InsuranceDocument',
			tbar: [{
				xtype : 'button',				
				itemId : 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),
				glyph: ICONGLYPH.DELETEGLYPH		
			}],
			columns :[{
				header : getCommonTranslation('DOCMENT_NAME'),
				dataIndex : 'documentName',
				flex:1,
				renderer:function(value,rec){
					if(!isNullOrEmpty(value)){
						return '<a href="#">'+value+'</a>';
					}
				}
			}]
		}]
	}],
	listeners: {
		afterlayout: function() {
			var height = Ext.getBody().getViewSize().height;
			if (this.getHeight() > height) {
				this.setHeight(height);
			}
			this.center();
		}
	}
});


