/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.transport.vehicle.VehicleSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.vehiclesearch',
	autoScroll: false,
	frame: false,
	border:false,
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('VEHICLE_NO'),
			name: 'vehicleNo',
			multiselect:true,
			itemId:'vehicleNo',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.vehicle.VehicleNo',
			valueField: 'id',
			displayField: 'value',
			queryParam:'vehicleNumber',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('VEHICLE_TYPE'), //Vehicle Type
			name: 'subType',
			itemId:'subType',
			store: 'transport.vehicle.VehicleSubType',
			displayField: 'value',
			valueField: 'id',
			forceSelection:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('PURCHASED_FROM'),
			name: 'vender',
			itemId:'vender',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.vehicle.VehicleVendor',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			valueField: 'id',
			displayField: 'value',
			queryParam:'vendorName',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			xtype: 'textfield',
			labelAlign: 'top'
		},
		items: [{
			fieldLabel: getTransportTranslation('USED_ID_ROUTES'),
			hidden:true,
			name: 'usedIdRoutes',
			itemId:'usedIdRoutes'
		},{
			
			xtype: 'customcombobox',
			name: 'routeName',
			hidden:true,
			itemId: 'routeName',
			fieldLabel: getTransportTranslation('USED_ID_ROUTES'),
			store: 'transport.route.RouteName',
			valueField: 'id',
			displayField: 'value',
			queryParam:'routeName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('MODEL'),
			name: 'model',
			itemId:'model',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.vehicle.VehicleModel',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			valueField: 'id',
			displayField: 'value',
			queryParam:'modelName',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('SERVICED_BY'),
			name: 'servicedBy',
			itemId:'servicedBy',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'transport.vehicle.VehicleServicedBy',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			valueField: 'id',
			displayField: 'value',
			queryParam:'serviceByName',
			enableKeyEvents  : 'true',
			forceSelection:true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerAction: '',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +'</div>';
				}
			}
		}]
	},{
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,
		itemId:'fldMoreFilter',
		collapsible:true,
		collapsed:true,
		width:'100%',
		items: [{
			xtype: 'fieldcontainer',
			style:{marginTop:'10px'},
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top',
				xtype: 'numberfield',
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowDecimals:false,
				allowExponential:false
			},
			items: [{
				fieldLabel: getTransportTranslation('MIN_CAPACITY'),
				name: 'minCapacity',
				minValue:0,
				itemId:'minCapacity'
			},{
				fieldLabel: getTransportTranslation('MAX_CAPACITY'),
				minValue:0,
				name: 'maxCapacity',
				itemId:'maxCapacity'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 256,
				xtype: 'textfield',
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('ROAD_TAX_AUTHORITY'),
				name: 'roadTaxAuthority',
				itemId:'roadTaxAuthority',
				maxLength:100,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				store: 'transport.vehicle.VehicleRoadTaxRoadTaxAuthorStore',
				valueField: 'value',
				displayField: 'value',
				queryParam:'roadTaxVendor',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('INSURED_BY'),
				name: 'insuredBy',
				itemId:'insuredBy',
				maxLength:100,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				store: 'transport.vehicle.VehicleInsuranceInsuredByStore',
				valueField: 'value',
				displayField: 'value',
				queryParam:'insuredBy',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +'</div>';
					}
				}
			}/*,{
				fieldLabel: getTransportTranslation('ROAD_TAX_AUTHORITY'),
				name: 'roadTaxAuthority',
				itemId:'roadTaxAuthority'
			},{
				fieldLabel: getTransportTranslation('INSURED_BY'),
				name: 'insuredBy',
				itemId:'insuredBy'
			}*/]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			hidden:true,
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('EVENT'),
				name: 'event',
				itemId:'event',
				//store: 'quartz.QuartzStateSearch',
				displayField: 'value',
				valueField: 'id',
				forceSelection:true
			},{
				xtype: 'datefield',
				name:'periodFrom',
				itemId:'periodFrom',
				fieldLabel:getTransportTranslation('PERIOD_FROM'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT
			},{
				xtype: 'datefield',
				name:'periodTill',
				itemId:'periodTill',
				fieldLabel:getTransportTranslation('PERIOD_TILL'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			itemId:'fldConFirstDateRow',
			defaults: {
				width: 256,
				xtype: 'datefield',
				labelAlign: 'top',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},
			items: [{
				name:'licenseExpiryDate',
				itemId:'licenseExpiryDateItemId',
				fieldLabel:getTransportTranslation('LICENCE_DATE_OF_EXPIRY'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}, {
				name:'insuranceExpiryBy',
				itemId:'insuranceExpiryBy',
				fieldLabel:getTransportTranslation('INSURANCE_TILL'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			itemId:'fldConSecondDateRow',
			width:'100%',
			defaults: {
				width: 256,
				xtype: 'datefield',
				labelAlign: 'top',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},
			items: [{
				name:'emissionExpiryBy',
				itemId:'emissionExpiryBy',
				fieldLabel:getTransportTranslation('EMISSION_CHECK_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}, {
				name:'roadTaxExpiryBy',
				itemId:'roadTaxExpiryBy',
				fieldLabel:getTransportTranslation('ROAD_TAX_TILL'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SEARCH'),
			formBind: true,
			itemId: 'SearchBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getTransportTranslation('RESET'),
			itemId: 'cancelBtn',	
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			handler: function() {
				this.up('form').getForm().reset();
			}
		}]
	}]
});