/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.tvet.TVETReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.tvetreportgrid',
    store: 'tvet.TVETReportStore',
    title: getCommonTranslation('TVET_REQUEST_DETAILS'),
    border: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	isGridConfigurable: true,
	enableColumnHide: false,
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'tvet.TVETReportStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [{
    	xtype: 'button',
    	itemId: 'btnRefreshItemId',
    	tooltip: getCommonTranslation('REFRESH'),
    	text: getCommonTranslation('REFRESH'),
    	scale: CONSTANTS.BUTTONSIZE
    }],
    initComponent: function() {
        var grid = this;
        //grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('TVET_REQUESTED_BY'),
        dataIndex: 'requestBy',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            return value.value;
        }
    },{
        header: getCommonTranslation('TVET_REQUEST_TIME'),
        dataIndex: 'requestTime',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				return Ext.Date.format(new Date(value), 'd-m-Y H:i:s');
			}
           return '';
        }
    },{
        header: getCommonTranslation('TVET_NO_OF_FILES'),
        dataIndex: 'noOfFiles',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                return "<a href='#'>" + value + "</a>";
            }
            return '';
        }
    },{
        header: getCommonTranslation('TVET_REQUEST_STATUS'),
        dataIndex: 'requestStatus',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
			if (!isNullOrEmpty(value)) {
				if ('PENDING' == value) {
					return getCommonTranslation("TVET_PENDING")
				} else if ('COMPLETED' == value) {
					return getCommonTranslation("TVET_COMPLETED")
				} else if ('IN_PROGRESS' == value) {
					return getCommonTranslation("TVET_IN_PROGRESS")
				} else if ('EMAIL_SENT' == value) {
					return getCommonTranslation("TVET_EMAIL_SENT")
				} else if ('ERROR' == value) {
					return getCommonTranslation("TVET_ERROR")
				} else if ('GENERATED' == value) {
					return getCommonTranslation("TVET_GENERATED")
				}
				return value;
			}
            return '';
        }
    },{
        header: getCommonTranslation('TVET_FILE_LINK'),
        dataIndex: 'fileLink',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                 return "<a href='"+ value +"' target='_blank'>" + value + "</a>";
            }
            return '';
        }
    },{
        header: getCommonTranslation('TVET_ERROR_LOGS'),
        dataIndex: 'errorMsg',
        flex: 1,
        sortable: true,
		style: {
			'white-space': 'nowrap',
	  		'overflow': 'hidden',
	  		'text-overflow': 'ellipsis'
		}
    },{
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYear',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            return value.value;
        }
    }]
});