Ext.define('Academia.view.webcam.ImageCaptureWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.imagecapturewindow',
	title:getCommonTranslation('SELECT_PROFILE_PHOTO'),
	frame: true,
	autoScroll:false,
	resizable:false,
	cropData: null,
	component:null,
	modal:true,
	imagesUrl: '',
	captureImageaUrl:'',
	width: 534,
	items:[{
		xtype:'form',
		style:{margin:'0'},
		items:[{
			xtype:'panel',
			layout: 'hbox',
			height: 300,
			style:{margin:'0'},
			items:[{
				title: getCommonTranslation('CAPTURE'),
				id:'capture_panel',
				itemId:'capturePanelId',
				listeners:{
					afterrender:function(obj){
						Webcam.set({
							width: 320,
							height: 240,
							crop_width: 320,
							crop_height: 240,
							flip_horiz: true,
							image_format: 'jpeg', // image format (may be jpeg or png)
							jpeg_quality: 100 // jpeg image quality from 0 (worst) to 100 (best)
						});
						Webcam.attach('#capture_panel-innerCt');
					}
				}
			},{
				xtype:'panel',
				itemId:'previewPanelId',
				title: getCommonTranslation('CAPTURE'),
				hidden:true
			},{
				xtype:'panel',
				width: 160,
				title: getCommonTranslation('PREVIEW'),
				items:[{
					xtype:'image',
					itemId:'showProfilePhotoPanel',
					width:160,
					height:180
				},{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:130,
					height:150,
					items:[{
						xtype:'image',
						itemId:'showGridPhotoPanel',
						width:52,
						height:52
					},{},{
						xtype:'image',
						itemId:'showDisplayPhotoPanel',
						width:55,
						height:55,
						style:{
							borderRadius:'26px'
						}
					}]
				}]
			},{
				xtype:'panel',
				hidden:true,
				html: "<canvas  id='canvas' width='320' height='240'></canvas>"
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				disabled: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}],
	tbar:[{
		xtype:'button',
		itemId:'capturebuttonId',
		text: getCommonTranslation('CAPTURE')
	},{
		xtype:'button',
		itemId:'previewbuttonId',
		disabled:true,
		text:getCommonTranslation('PREVIEW')
	},{
		xtype:'button',
		text:'Reset',
		itemId:'resetbuttonId',
		disabled:true
	}]

});