/**
 * @license Copyright (c) 2003-2014, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here.
	// For complete reference see:
	// http://docs.ckeditor.com/#!/api/CKEDITOR.config

	// The toolbar groups arrangement, optimized for two toolbar rows.
	config.toolbarGroups = [
		{ name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
		{ name: 'editing',     groups: [ 'find', 'selection', 'spellchecker' ] },
		{ name: 'links' },
		{ name: 'insert' },
		{ name: 'forms' },
		{ name: 'tools' },
		{ name: 'document',	   groups: [ 'mode', 'document', 'doctools' ] },
		{ name: 'others' },
		'/',
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
		{ name: 'paragraph',   groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },
		{ name: 'styles' },
		{ name: 'colors' },
		{ name: 'about' }
	];

	// Remove some buttons provided by the standard plugins, which are
	// not needed in the Standard(s) toolbar.
	config.removeButtons = 'Underline,Subscript,Superscript';

	// Set the most common block elements.
	config.format_tags = 'p;h1;h2;h3;pre';
	
	config.resize_enabled = false;

	// Simplify the dialog windows.
	//config.removeDialogTabs = 'image:advanced;link:advanced';
	
	//config.contentsLangDirection = 'rtl';
	
	//config.language = 'ar';
	//config.entities = false;	// remove for &#39; to single quote on save data 
	config.font_names = 'milestone outline;Old English/old english;Rouge Script/rouge script;Arial/Arial, Helvetica, sans-serif;Comic Sans MS/Comic Sans MS, cursive;Courier New/Courier New, Courier, monospace;Georgia/Georgia, serif;Lucida Sans Unicode/Lucida Sans Unicode, Lucida Grande, sans-serif;Tahoma/Tahoma, Geneva, sans-serif;Times New Roman/Times New Roman, Times, serif;Trebuchet MS/Trebuchet MS, Helvetica, sans-serif;Verdana/Verdana, Geneva, sans-serif';
	config.extraPlugins = 'imagebrowser,filebrowser';
    config.filebrowserImageUploadUrl = 'http://localhost:8080/serosoft-academia-web/rest/ImgageFileResource/uploadImage';
	//config.filebrowserImageUploadUrl = 'http://localhost:8080/serosoft-academia-web/data/imageUpload.html';
	//config.filebrowserBrowseUrl :'resources/js/ckeditor/filemanager/browser/default/browser.html?Connector=http://www.mixedwaves.com/filemanager_in_ckeditor/js/ckeditor/filemanager/connectors/php/connector.php',
    //filebrowserImageBrowseUrl : 'resources/js/ckeditor/filemanager/browser/default/browser.html?Type=Image&amp;Connector=http://www.mixedwaves.com/filemanager_in_ckeditor/js/ckeditor/filemanager/connectors/php/connector.php',
    //filebrowserFlashBrowseUrl :'resources/js/ckeditor/filemanager/browser/default/browser.html?Type=Flash&amp;Connector=http://www.mixedwaves.com/filemanager_in_ckeditor/js/ckeditor/filemanager/connectors/php/connector.php',
    //filebrowserUploadUrl  :'resources/js/ckeditor/filemanager/connectors/php/upload.php?Type=File',	             
     //filebrowserFlashUploadUrl : 'resources/js/ckeditor/filemanager/connectors/php/upload.php?Type=Flash',	 		     
	//config.imageBrowser_listUrl = 'http://localhost:8080/serosoft-academia-web/data/user/image_list.json';
    config.imageBrowser_listUrl = 'http://localhost:8080/serosoft-academia-web/rest/ImgageFileResource/browseImages';

	
};
