/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.config;

import in.serosoft.cb.service.ResultColumnTranslationsService;
import in.serosoft.cb.service.SearchEngineService;
import in.serosoft.messaging.entity.PicklistEnum;
import in.serosoft.messaging.formatter.DateFormatter;
import in.serosoft.messaging.formatter.DateTimeFormatter;
import in.serosoft.messaging.formatter.EnumPickListFormatter;
import in.serosoft.messaging.formatter.NameFormatter;
import in.serosoft.messaging.formatter.TimeFormatter;
import in.serosoft.messaging.service.PicklistEnumService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationBootLoader {
    @Autowired
    SearchEngineService searchEngineService;
    @Autowired
    ResultColumnTranslationsService resultColumnTranslationsService;
    @Autowired
    PicklistEnumService picklistEnumService;

    @PostConstruct
    public void init() {
        EnumPickListFormatter enumPickListFormatter = new EnumPickListFormatter();
        List picklistEnums = this.picklistEnumService.findAll();
        Map picklistEnumTypeMap = this.buildPicklistEnumTypeMap(picklistEnums);
        enumPickListFormatter.setPicklistEnumTypeMap(picklistEnumTypeMap);
        DateFormatter dateFormatter = new DateFormatter();
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatter();
        NameFormatter nameFormatter = new NameFormatter();
        TimeFormatter timeFormatter = new TimeFormatter();
        Map resultColumnTranslations = this.resultColumnTranslationsService.findAllResultColumnTranslations();
        HashMap<String, Object> translationData = new HashMap<String, Object>();
        translationData.put("DATE_FORMATTER", dateFormatter);
        translationData.put("ENUM_FORMATTER", enumPickListFormatter);
        translationData.put("NAME_FORMATTER", nameFormatter);
        translationData.put("RESULT_COLUMNS", resultColumnTranslations);
        translationData.put("TIME_FORMATTER", timeFormatter);
        translationData.put("DATETIME_FORMATTER", dateTimeFormatter);
        this.searchEngineService.setTranslationData(translationData);
    }

    private Map<String, Map<String, Object>> buildPicklistEnumTypeMap(List<PicklistEnum> picklistEnums) {
        HashMap<String, Map<String, Object>> picklistEnumTypeMap = new HashMap<String, Map<String, Object>>();
        for (PicklistEnum picklistEnum : picklistEnums) {
            Map<String, PicklistEnum> picklistEnumCodeMap;
            if (picklistEnumTypeMap.containsKey(picklistEnum.getEnumType())) {
                picklistEnumCodeMap = (Map)picklistEnumTypeMap.get(picklistEnum.getEnumType());
                picklistEnumCodeMap.put(picklistEnum.getCode(), picklistEnum);
                picklistEnumTypeMap.put(picklistEnum.getEnumType(), picklistEnumCodeMap);
                continue;
            }
            picklistEnumCodeMap = new HashMap<String, PicklistEnum>();
            picklistEnumCodeMap.put(picklistEnum.getCode(), picklistEnum);
            picklistEnumTypeMap.put(picklistEnum.getEnumType(), picklistEnumCodeMap);
        }
        return picklistEnumTypeMap;
    }
}

