/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.dao.impl;

import in.serosoft.messaging.dao.GatewayCredentialsDAO;
import in.serosoft.messaging.dao.impl.MsgGenericDAOImpl;
import in.serosoft.messaging.dto.EmailCredentialsDTO;
import in.serosoft.messaging.dto.EmailDomainConfigurationDTO;
import in.serosoft.messaging.dto.EmailValidDomainDTO;
import in.serosoft.messaging.dto.FireBaseServerConfigurationDTO;
import in.serosoft.messaging.dto.RecepientInfoDTO;
import in.serosoft.messaging.dto.SNSBounceRecipientsDTO;
import in.serosoft.messaging.dto.SmsCredentialsDTO;
import in.serosoft.messaging.dto.SystemInternalNotificationInfoDTO;
import in.serosoft.messaging.dto.UserInfoDTO;
import in.serosoft.messaging.entity.PicklistEnum;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BooleanType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;

@Repository(value="gatewayCredentialsDAO")
public class GatewayCredentialsDAOImpl
extends MsgGenericDAOImpl<PicklistEnum, Long>
implements GatewayCredentialsDAO {
    public GatewayCredentialsDAOImpl() {
        super(PicklistEnum.class);
    }

    public EmailCredentialsDTO readEmailGatewayCredentials(Long acadLocId) {
        String sql = "SELECT senderEmailAddress as 'from',userName as smtpUserName,password as smtpPassword,host,port,isUseStasySMTP FROM `email_server_configuration` WHERE `academyLocationId`=" + acadLocId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(EmailCredentialsDTO.class));
        query.addScalar("from", (Type)StringType.INSTANCE);
        query.addScalar("smtpUserName", (Type)StringType.INSTANCE);
        query.addScalar("smtpPassword", (Type)StringType.INSTANCE);
        query.addScalar("host", (Type)StringType.INSTANCE);
        query.addScalar("port", (Type)IntegerType.INSTANCE);
        query.addScalar("isUseStasySMTP", (Type)BooleanType.INSTANCE);
        EmailCredentialsDTO emailCredentialsDTO = (EmailCredentialsDTO)query.uniqueResult();
        if (emailCredentialsDTO == null) {
            sql = "SELECT senderEmailAddress AS 'from',userName AS smtpUserName,PASSWORD AS smtpPassword,HOST,PORT,isUseStasySMTP as isUseStasySMTP FROM `email_server_configuration` WHERE `isDefault` IS TRUE  ORDER BY `lastUpdate` ASC LIMIT 0,1";
            query = this.getCrntSession().createSQLQuery(sql);
            query.setResultTransformer(Transformers.aliasToBean(EmailCredentialsDTO.class));
            query.addScalar("from", (Type)StringType.INSTANCE);
            query.addScalar("smtpUserName", (Type)StringType.INSTANCE);
            query.addScalar("smtpPassword", (Type)StringType.INSTANCE);
            query.addScalar("host", (Type)StringType.INSTANCE);
            query.addScalar("port", (Type)IntegerType.INSTANCE);
            query.addScalar("isUseStasySMTP", (Type)BooleanType.INSTANCE);
            emailCredentialsDTO = (EmailCredentialsDTO)query.uniqueResult();
        }
        return emailCredentialsDTO;
    }

    public SmsCredentialsDTO readSmsGatewayCredentials(Long acadLocId) {
        String sql = "SELECT parameter1 as username,parameter2 as password,parameter3 as senderId,apiPassword as api_password,hostURL as reqUrl,parameter4 as extraParams,isCountryCode AS isCountryCode ,parameter5 as keyWord, parameter6 as tdMarketingId,parameter7 as campaignName FROM `sms_gateway_configuration` WHERE `academyLocationId`=" + acadLocId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SmsCredentialsDTO.class));
        query.addScalar("username", (Type)StringType.INSTANCE);
        query.addScalar("password", (Type)StringType.INSTANCE);
        query.addScalar("senderId", (Type)StringType.INSTANCE);
        query.addScalar("api_password", (Type)StringType.INSTANCE);
        query.addScalar("reqUrl", (Type)StringType.INSTANCE);
        query.addScalar("extraParams", (Type)StringType.INSTANCE);
        query.addScalar("isCountryCode", (Type)BooleanType.INSTANCE);
        query.addScalar("keyWord", (Type)StringType.INSTANCE);
        query.addScalar("campaignName", (Type)StringType.INSTANCE);
        query.addScalar("tdMarketingId", (Type)StringType.INSTANCE);
        SmsCredentialsDTO smsCredentialsDTO = (SmsCredentialsDTO)query.uniqueResult();
        if (smsCredentialsDTO == null) {
            sql = "SELECT parameter1 AS username,parameter2 as password,parameter3 as senderId,apiPassword AS api_password,hostURL as reqUrl,parameter4 AS extraParams,isCountryCode AS isCountryCode ,parameter5 as keyWord, parameter6 as tdMarketingId,parameter7 as campaignName FROM `sms_gateway_configuration` WHERE `isDefault` IS TRUE  ORDER BY `lastUpdate` ASC LIMIT 0,1";
            query = this.getCrntSession().createSQLQuery(sql);
            query.setResultTransformer(Transformers.aliasToBean(SmsCredentialsDTO.class));
            query.addScalar("username", (Type)StringType.INSTANCE);
            query.addScalar("password", (Type)StringType.INSTANCE);
            query.addScalar("senderId", (Type)StringType.INSTANCE);
            query.addScalar("api_password", (Type)StringType.INSTANCE);
            query.addScalar("reqUrl", (Type)StringType.INSTANCE);
            query.addScalar("extraParams", (Type)StringType.INSTANCE);
            query.addScalar("isCountryCode", (Type)BooleanType.INSTANCE);
            query.addScalar("keyWord", (Type)StringType.INSTANCE);
            query.addScalar("campaignName", (Type)StringType.INSTANCE);
            query.addScalar("tdMarketingId", (Type)StringType.INSTANCE);
            smsCredentialsDTO = (SmsCredentialsDTO)query.uniqueResult();
        }
        return smsCredentialsDTO;
    }

    public RecepientInfoDTO readRecipientInfo(Long id) {
        String sql = "SELECT studentId as id from admission where id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientInfoForLimeSurveyStudent(Long id) {
        String sql = "SELECT studentId as id from survey_participant_info where id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientInfoForMsgManualBillGeration(Long id) {
        String sql = "SELECT T1.studentId as ID from bill_header T1 inner join students T2 ON T1.studentId = T2.userId where T1.id in (" + id + ") UNION SELECT T1.userId as ID from bill_header T1 inner join users T2 ON T1.userId = T2.id where T1.id in (" + id + ")";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientInfoForLimeSurveyFaculty(Long id) {
        String sql = "SELECT userId as id from survey_participant_info where id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public UserInfoDTO readStudentCodeInfo(Long id) {
        String sql = "select users.code as studentCode from admission inner join students on students.userId=admission.studentId inner join users on students.userId=users.id where admission.id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("studentCode", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public UserInfoDTO readApplicantCodeInfo(Long id) {
        String sql = "select application.code as applicantCode from application where id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("applicantCode", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public UserInfoDTO readUserCodeInfo(Long id) {
        String sql = "select users.code as userCode from users where id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("userCode", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public UserInfoDTO readLimeSurveyStudentCode(Long id) {
        String sql = "select users.code as studentCode from survey_participant_info inner join students on survey_participant_info.studentId=students.userId inner join users on students.userId=users.id where survey_participant_info.id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("studentCode", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public UserInfoDTO readLimeSurveyStaffCode(Long id) {
        String sql = "select users.code as userCode from survey_participant_info inner join staffs on survey_participant_info.userId=staffs.userId inner join users on staffs.userId=users.id where survey_participant_info.id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("userCode", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public UserInfoDTO readLimeSurveyApplicantCode(Long id) {
        String sql = "select application.code as applicantCode from survey_participant_info inner join application on survey_participant_info.applicantId=application.id where survey_participant_info.id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("applicantCode", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public UserInfoDTO readLimeSurveyEnquiryCode(Long id) {
        String sql = "select enquiry.code as enquiryCode from survey_participant_info inner join enquiry on survey_participant_info.enquiryId=enquiry.id where survey_participant_info.id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("enquiryCode", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public SystemInternalNotificationInfoDTO billMadeFor(String sqlQuery, Long billId) {
        String sql = sqlQuery + billId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public UserInfoDTO readCodeForManualBillReceiptGeneration(String sqlQuery) {
        String sql = sqlQuery;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("code", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public SystemInternalNotificationInfoDTO receiptMadeFor(String sqlQuery, Long receiptId) {
        String sql = sqlQuery + receiptId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public UserInfoDTO readCodeForEvents(String sqlQuery) {
        String sql = sqlQuery;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("code", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public UserInfoDTO getCountryCodeForEvents(String sqlQuery) {
        String sql = sqlQuery;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(UserInfoDTO.class));
        query.addScalar("countryCode", (Type)StringType.INSTANCE);
        UserInfoDTO userInfoDTO = (UserInfoDTO)query.uniqueResult();
        return userInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientInfoForCommitteeEventManagement(Long id) {
        String sql = "select ownerId as id from event_meeting_minutes_task where id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public EmailValidDomainDTO readEmailValidDomain() {
        String sql = "select iAmUserKeyId as iAmUserKey,iAmUserSecretKey as iAmUserSecretKey, validDomains as validDomains, isActive as isActive from email_valid_domain_configuration where `isActive` IS TRUE  ORDER BY `lastUpdate` ASC LIMIT 0,1";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(EmailValidDomainDTO.class));
        query.addScalar("iAmUserKey", (Type)StringType.INSTANCE);
        query.addScalar("iAmUserSecretKey", (Type)StringType.INSTANCE);
        query.addScalar("validDomains", (Type)StringType.INSTANCE);
        query.addScalar("isActive", (Type)BooleanType.INSTANCE);
        EmailValidDomainDTO validDomainDTO = (EmailValidDomainDTO)query.uniqueResult();
        return validDomainDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientInfoForEnqFollowupReminder(Long id) {
        String sql = "select assignTo as id from enq_followup where id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientInfoForDailyAttendaceMissedByFaculty(Long id) {
        String sql = "select facultyId as id from course_coverage_plan where id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientInfoForDailyAttendaceAbsentStudent(Long id) {
        String sql = "select T6.userId AS id FROM student_course_attendance_details scad LEFT JOIN admission T5 ON T5.id = scad.admissionId LEFT JOIN students T6 ON T6.userId = T5.studentId WHERE scad.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientDailyAttendaceAbsentStudentForTheDay(Long id) {
        String sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientDailyAttendaceMissedFacultyForTheDay(Long id) {
        String sql = "select st.userId AS id from sections as s left join staffs AS st ON st.userId = s.facultyId where s.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readAppointmentRecipient(Long id) {
        String sql = "SELECT sa.staffId AS id FROM sg_appointment AS sa INNER JOIN staffs AS st ON st.userId = sa.staffId WHERE sa.id = " + id + " UNION SELECT sa.studentId AS id FROM sg_appointment AS sa INNER JOIN students AS st ON st.userId = sa.studentId WHERE sa.id = " + id + " UNION SELECT p.userId AS id FROM sg_appointment AS sa INNER JOIN parents p ON p.personId = sa.parentId WHERE sa.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readApproveAdvisorRecipient(Long id) {
        String sql = "SELECT T1.advisiorId AS id FROM application_admission_detail T1 WHERE T1.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRejectLeaveRecipient(Long id) {
        String sql = "select requestUserId as id from hr_emp_leave_request where id = " + id + "and status ='REJECTED'";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readApproverLeaveApproveRecipient(Long id) {
        String sql = "SELECT T6.approverId AS id FROM hr_emp_leave_request AS T1 LEFT JOIN hr_emp_leave_request_detail AS T6 ON T6.empLeaveRequestId = T1.id WHERE T1.id =" + id + " AND T6.status = 'pending' and T6.approverLevelId = (select MIN(approverLevelId) from hr_emp_leave_request_detail where empLeaveRequestId" + id + " and status = 'pending')";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRequesterLeaveApproveRecipient(Long id) {
        String sql = "SELECT approverId AS id FROM hr_emp_leave_request_detail WHERE id = " + id + " AND status = 'APPROVED'";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readWithdrawnLeaveRecipient(Long id) {
        String sql = "select requestUserId as id from hr_emp_leave_request where id = " + id + " and status ='WITHDRAWN'";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readCreateLeaveRecipient(Long id) {
        String sql = "select approverId as id from hr_emp_leave_request_detail where id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readStudentPresentMarkedParentsRecipient(Long id, String msgRecipientType) {
        String sql = null;
        switch (msgRecipientType) {
            case "STUDENT_MARKED_PRESENT_CD_MS_FATHER_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_program_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'FATHER' AND T6.whetherDeleted = false AND  T1.id = " + id;
                break;
            }
            case "STUDENT_MARKED_PRESENT_CD_MS_MOTHER_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_program_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'MOTHER' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "STUDENT_MARKED_PRESENT_CD_MS_GUARDIAN_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_program_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "STUDENT_MARKED_PRESENT_CD_MS_LOCAL_GUARDIAN_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_program_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_DAY_WISE_FATHER_ABSENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_program_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'FATHER' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_DAY_WISE_MOTHER_ABSENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_program_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'MOTHER' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_DAY_WISE_GUARDIAN_ABSENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_program_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN_ABSENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_program_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId inner Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "UPDATE_ATTENDANCE_DAY_WISE_FATHER_RCPNT": {
                sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_DAY_WISE_MOTHER_RCPNT": {
                sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_DAY_WISE_GUARDIAN_RCPNT": {
                sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN_RCPNT": {
                sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
                break;
            }
            case "ATTENDANCE_COURSE_WISE_MOTHER_PRESENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_course_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'MOTHER' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_COURSE_WISE_FATHER_PRESENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_course_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'FATHER' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_COURSE_WISE_MOTHER_ABSENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_course_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'MOTHER' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_course_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'FATHER' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_COURSE_WISE_GUARDIAN_PRESENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_course_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_PRESENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_course_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_ABSENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_course_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "ATTENDANCE_COURSE_WISE_GUARDIAN_ABSENT_ONLY_RCPNT": {
                sql = "SELECT T8.userId AS ID FROM student_course_attendance_details as T1 LEFT JOIN admission AS T3 ON T3.id = T1.admissionId LEFT JOIN students AS T4 ON T4.userId = T3.studentId LEFT JOIN persons AS T5 ON T5.id = T4.personId LEFT JOIN person_relationships as T6 ON T6.personId = T5.id LEFT JOIN persons AS T7 ON T7.id = T6.relatedPersonId Left Join parents AS T8 ON T8.personId = T7.id WHERE T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false AND T1.id = " + id;
                break;
            }
            case "UPDATE_ATTENDANCE_COURSE_WISE_FATHER_RCPNT": {
                sql = "select T6.userId AS id FROM student_course_attendance_details scad LEFT JOIN admission T5 ON T5.id = scad.admissionId LEFT JOIN students T6 ON T6.userId = T5.studentId WHERE scad.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_COURSE_WISE_MOTHER_RCPNT": {
                sql = "select T6.userId AS id FROM student_course_attendance_details scad LEFT JOIN admission T5 ON T5.id = scad.admissionId LEFT JOIN students T6 ON T6.userId = T5.studentId WHERE scad.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_COURSE_WISE_GUARDIAN_RCPNT": {
                sql = "select T6.userId AS id FROM student_course_attendance_details scad LEFT JOIN admission T5 ON T5.id = scad.admissionId LEFT JOIN students T6 ON T6.userId = T5.studentId WHERE scad.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_RCPNT": {
                sql = "select T6.userId AS id FROM student_course_attendance_details scad LEFT JOIN admission T5 ON T5.id = scad.admissionId LEFT JOIN students T6 ON T6.userId = T5.studentId WHERE scad.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_SESSION_WISE_FATHER_RCPNT": {
                sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_SESSION_WISE_MOTHER_RCPNT": {
                sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_SESSION_WISE_GUARDIAN_RCPNT": {
                sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
                break;
            }
            case "UPDATE_ATTENDANCE_SESSION_WISE_LOCAL_GUARDIAN_RCPNT": {
                sql = "SELECT T4.userId AS id FROM student_program_attendance_details T2 LEFT JOIN admission T3 ON T3.id = T2.admissionId LEFT JOIN students T4 ON T4.userId = T3.studentId WHERE T2.id =" + id;
                break;
            }
        }
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readUserIdByPersonId(Long id) {
        String sql = "select prnt.userId as id from persons p left join  parents prnt on prnt.personId = p.id where p.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientOfHomeworkAssignment(Long id) {
        String sql = "SELECT T6.facultyId AS id FROM group_hw_assignment T1 LEFT JOIN course_hw_asignment T6 ON T6.id = T1.hwAssignmentId WHERE T1.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientOfGroupHomeworkAssignment(Long id) {
        String sql = "SELECT T1.facultyId AS id FROM course_hw_asignment T1 WHERE T1.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public RecepientInfoDTO readInfoForStudentTransferServiceRequest(Long id) {
        String sql = "SELECT T3.id AS id FROM service_requests T1 LEFT JOIN service_request_settings T2 ON T2.id = T1.serviceRequestSettingId LEFT JOIN users T3 ON T3.id = T1.requester WHERE T1.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readInfoForAssigneeServiceRequest(Long id) {
        String sql = "SELECT T3.id AS id FROM service_requests T1 LEFT JOIN service_request_settings T2 ON T2.id = T1.serviceRequestSettingId LEFT JOIN users T3 ON T3.id = T1.assigneeId WHERE T1.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readInfoForFollowupServiceRequest(Long id) {
        String sql = "SELECT T2.assigneeUserId AS id FROM service_requests T1 LEFT JOIN followup_details T2 ON T2.serviceRequestId = T1.id WHERE T2.whetherLatest = TRUE AND T2.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readInfoForParentTransferServiceRequest(Long id) {
        String sql = "SELECT T1.parentsId AS id FROM service_requests T1 WHERE T1.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public EmailDomainConfigurationDTO readEmailDomainControl() {
        String sql = "select (select group_concat(distinct domain) from email_domain_configuration where controlType = 'ALLOWED' ) as validDomains, (select group_concat(distinct domain) from email_domain_configuration where controlType = 'BLOCKLIST') as inValidDomains;";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(EmailDomainConfigurationDTO.class));
        query.addScalar("validDomains", (Type)StringType.INSTANCE);
        query.addScalar("inValidDomains", (Type)StringType.INSTANCE);
        EmailDomainConfigurationDTO emailDomainConfigurationDTO = (EmailDomainConfigurationDTO)query.uniqueResult();
        return emailDomainConfigurationDTO;
    }

    public FireBaseServerConfigurationDTO findFireBaseServerConfiguration(Long acadLocId) {
        String sql = "SELECT apiKey as 'apiKey',apiURL as apiURL FROM `fire_base_server_configuration` WHERE `isDefault` IS TRUE  ORDER BY `lastUpdate` ASC LIMIT 0,1";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(FireBaseServerConfigurationDTO.class));
        query.addScalar("apiKey", (Type)StringType.INSTANCE);
        query.addScalar("apiURL", (Type)StringType.INSTANCE);
        FireBaseServerConfigurationDTO fbCredentialsDTO = (FireBaseServerConfigurationDTO)query.uniqueResult();
        return fbCredentialsDTO;
    }

    public SystemInternalNotificationInfoDTO readRecipientOfSaveHomeworkAssignment(Long id) {
        String sql = "SELECT T3.userId AS id FROM group_hw_assignment T1 LEFT JOIN admission AS T2 ON T2.id = T1.admissionId LEFT JOIN students AS T3 ON T3.userId = T2.studentId WHERE T1.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public RecepientInfoDTO getUserFromResourceId(Long id) {
        String sql = "SELECT s.userId AS id FROM resource_bookings rb JOIN resource_booking_users rbu ON rbu.resourceBookingId = rb.id JOIN staffs s ON s.userId = rbu.userId WHERE rbu.id =" + id + " UNION SELECT st.userId AS id FROM resource_bookings rb JOIN resource_booking_users rbu ON rbu.resourceBookingId = rb.id join students st on st.userId = rbu.studentId WHERE rbu.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserFromAcademyLocationById(Long id) {
        String sql = "SELECT usr.id AS id FROM academy_location al INNER JOIN academy_location_purpose alp ON alp.academyLocationId = al.id JOIN users usr ON usr.id = alp.ownerId WHERE alp.purposeCode = 'COURSE_EXECUTION' AND al.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getFatherFromIncident(Long id) {
        String sql = "SELECT T4.userId AS id FROM incidents T1  LEFT JOIN persons AS T3 ON T3.id = T1.personId LEFT JOIN students AS T4 ON T4.personId = T3.id WHERE T1.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getALOwnerFromIncident(Long id) {
        String sql = "SELECT T9.userId AS id FROM incidents T1 LEFT JOIN incident_types AS T2 ON T2.id = T1.incidentTypeId LEFT JOIN persons AS T3 ON T3.id = T1.personId LEFT JOIN students AS T4 ON T4.personId = T3.id  LEFT JOIN admission T5 ON T5.studentId = T4.userId LEFT JOIN academy_location T6 ON T6.id = T5.academyLocationId LEFT JOIN academy_location_purpose T7 ON T7.academyLocationId = T6.id LEFT OUTER JOIN users T8 ON T7.ownerId = T8.id INNER JOIN staffs T9 ON T9.userId = T8.id LEFT OUTER JOIN persons T10 ON T9.personId = T10.id LEFT JOIN salutations T11 ON T11.id = T10.salutationId WHERE T5.activeStatus = TRUE AND T7.purposeCode = 'COURSE_EXECUTION' and T1.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getPrincipleFromIncident(Long id) {
        String sql = "SELECT pgd.principalId AS id FROM incidents T1 LEFT JOIN incident_types AS T2 ON T2.id = T1.incidentTypeId LEFT JOIN persons AS T3 ON T3.id = T1.personId LEFT JOIN students AS T4 ON T4.personId = T3.id LEFT JOIN admission T5 ON T5.studentId = T4.userId LEFT JOIN program_batch_students pbs ON pbs.admissionId = T5.id inner JOIN sections sec ON sec.id = pbs.sectionId LEFT JOIN batches b ON b.id = pbs.programBatchId LEFT JOIN programs p ON p.id = b.programId LEFT JOIN program_group pg ON pg.id = p.programGroupId LEFT JOIN program_group_details pgd ON pgd.programGroupId = pg.id and pgd.academyLocationId = T5.academyLocationId WHERE T5.activeStatus = TRUE AND pbs.isCurrentSection = TRUE AND pbs.isCurrentPeriod = TRUE AND pbs.exitDate IS NULL and  T1.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getClassTeacherFromIncident(Long id) {
        String sql = "SELECT sec.facultyId AS id FROM incidents T1 LEFT JOIN incident_types AS T2 ON T2.id = T1.incidentTypeId LEFT JOIN persons AS T3 ON T3.id = T1.personId LEFT JOIN students AS T4 ON T4.personId = T3.id LEFT JOIN admission T5 ON T5.studentId = T4.userId LEFT JOIN program_batch_students pbs ON pbs.admissionId = T5.id Inner JOIN sections sec ON sec.id = pbs.sectionId Inner JOIN staffs T9 ON T9.userId = sec.facultyId where T5.activeStatus = TRUE AND pbs.isCurrentSection = TRUE AND pbs.isCurrentPeriod = TRUE AND pbs.exitDate IS NULL and T1.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getRequesterForCancelledLeave(Long id) {
        String sql = "select requestUserId as id from hr_emp_leave_request where id = " + id + " and status in ('CANCELLED','PARTIALLY CANCELLED','PARTIALLYCANCELLED')";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentFromCourseCoveragePlanMsg(Long id) {
        String sql = "SELECT T1.studentId AS id FROM course_coverage_plan_msg T1 WHERE T1.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getFatherFromCourseCoveragePlanMsg(Long id) {
        String sql = "SELECT T1.studentId AS id FROM course_coverage_plan_msg T1 WHERE T1.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getMotherFromCourseCoveragePlanMsg(Long id) {
        String sql = "SELECT T1.studentId AS id FROM course_coverage_plan_msg T1 WHERE T1.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserForServiceRequestApprover(Long id) {
        String sql = "SELECT T3.id AS id FROM followup_details fd LEFT JOIN users T3 ON T3.id = fd.approverUserId WHERE fd.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserForServiceRequestEscalationApprover(Long id) {
        String sql = "SELECT T3.id AS id FROM approval_details fd LEFT JOIN users T3 ON T3.id = fd.escalatedApproverUserId WHERE fd.id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserFromBillHeaderId(Long id) {
        String sql = "SELECT bh.studentId AS id FROM bill_header bh WHERE bh.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentForBillInvoiceAdhoc(Long id) {
        String sql = "SELECT st.userId AS id\nFROM bill_header b INNER JOIN students st ON st.userId = b.studentId\nWHERE b.id = " + id + " UNION SELECT stf.userId AS id\nFROM bill_header b INNER JOIN staffs stf ON stf.userId = b.userId\nWHERE b.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getReciverByFDItemId(Long id) {
        String sql = "SELECT receiverId AS id FROM fd_management_items WHERE id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentForPlacementJobPosting(Long id) {
        String sql = "select studentId as id from placement_job_student where id =" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getPersonToMeetByAppointmentId(Long id) {
        String sql = "select T1.personToMeetId as id from sg_appointment T1 where T1.id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getFacultyFromCourseCoveragePlanMsg(Long id) {
        String sql = "SELECT T1.facultyId AS id FROM course_coverage_plan_msg T1 WHERE T1.id = " + id + " GROUP BY T1.courseCoveragePlanId";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getFacultyFromCourseCoveragePlanMsgForTimeTableDelete(Long id) {
        String sql = "SELECT T1.facultyId AS id FROM course_coverage_plan_msg T1 WHERE T1.courseCoveragePlanId = " + id + " GROUP BY T1.courseCoveragePlanId";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentIdFrmTransferServiceRouteId(Long id) {
        String sql = "select userId as  id from trans_service_route_users where id = " + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public SNSBounceRecipientsDTO getSNSBounceRecipientsDTO(Long id, String emailId) {
        String sql = "select sns.recipient as emailAddress,sns.notificationType as status from sns_notification sns where sns.recipient = '" + emailId + "' order by sns.id desc limit 1";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SNSBounceRecipientsDTO.class));
        query.addScalar("emailAddress", (Type)StringType.INSTANCE);
        query.addScalar("status", (Type)StringType.INSTANCE);
        SNSBounceRecipientsDTO snsBounceRecipientsDTO = (SNSBounceRecipientsDTO)query.uniqueResult();
        return snsBounceRecipientsDTO;
    }

    public RecepientInfoDTO getHODFromCourseCoveragePlanMsg(Long id) {
        String sql = "SELECT d.hodId AS id FROM course_coverage_plan_msg T1 \nLEFT JOIN\nacademy_location T6 ON T6.id = T1.academyLocationId    \nLEFT JOIN\ndepartment d ON  T1.academyLocationId = d.academyLocationId\nWHERE T1.courseCoveragePlanId =" + id + " GROUP BY T1.courseCoveragePlanId";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserIdForInvgMsg(Long id) {
        String sql = "select sp.userId as id from exam_room_invigilator_allocation eria join supervisor_allocation sp on eria.InvigilatorId = sp.id where sp.id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getInfirmayAppointmentFacultyId(Long recipientUserId) {
        String sql = "select authorityUserId as id from infirmary_details where authorityUserId is not null and id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getInfirmayAppointmentParentId(Long recipientUserId) {
        String sql = "SELECT ids.userId AS id FROM parent_infirmary_details pid inner join infirmary_details ids on ids.id = pid.infirmaryId where pid.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentForHostelLeaveRequest(Long recipientUserId) {
        String sql = "SELECT \n    T4.studentId AS id\nFROM\n    service_requests AS T2\n        INNER JOIN\n    hostel_leave_service_request_details AS T3 ON T3.serviceRequestId = T2.id\n        INNER JOIN\n    hostel_room_allotment AS T4 ON T4.id = T3.roomAllotmentId\nWHERE\n    T2.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getLeaveHandoverUserById(Long recipientUserId) {
        String sql = "SELECT T2.userId AS id FROM  hr_emp_leave_request_handover_user AS T2 WHERE T2.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserIdbyGalleryUsrId(Long recipientUserId) {
        String sql = "SELECT T1.userId AS id FROM gallery_users T1 where T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentUserIdbyHostelAttendanceId(Long recipientUserId) {
        String sql = "SELECT T1.userId AS id FROM hostel_attendance T1 where T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserIdbyHostelAttendanceId(Long recipientUserId) {
        String sql = "SELECT T1.userId AS id FROM gallery_users T1 where T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentPersonIdByParentId(Long recipientUserId) {
        String sql = "SELECT st.userId as id FROM users u INNER JOIN parents prts ON prts.userId = u.id INNER JOIN person_relationships pr ON pr.relatedPersonId = prts.personId INNER JOIN students st ON st.personId = pr.personId WHERE pr.whetherDeleted = FALSE AND u.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserIdByPersonId(Long recipientUserId) {
        String sql = "SELECT T2.userId AS id FROM persons T1 left join parents T2 on T1.id=T2.personId where T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserIdbyPersonServiceId(Long recipientUserId) {
        String sql = "SELECT  st.userId AS id FROM person_services T1 INNER JOIN students st ON st.personId = T1.personId WHERE T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getParentUserIdbyPersonServiceId(Long recipientUserId, String relatioship) {
        String sql = "SELECT  prts.userId AS id FROM person_services T1 INNER JOIN students st ON st.personId = T1.personId INNER JOIN persons p ON p.id = st.personId INNER JOIN person_relationships T8 ON T8.personId = p.id  INNER JOIN persons AS T7 ON T7.id = T8.relatedPersonId INNER JOIN parents prts on prts.personId = T7.id WHERE T1.id = " + recipientUserId + " AND T8.relationship ='" + relatioship + "'";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getDeptHODFromCourseCoveragePlanMsg(Long recipientUserId) {
        String sql = "SELECT \n    d.hodid as id\nFROM\n    course_coverage_plan_msg T1\n        LEFT JOIN\n    courses c ON c.id = T1.courseId\n        LEFT JOIN\n    courses oldc ON oldc.id = T1.oldCourseId\n       LEFT JOIN\n    department d ON  oldc.departmentId = d.id\n   \nWHERE\n    T1.courseCoveragePlanId=" + recipientUserId + " GROUP BY T1.courseCoveragePlanId";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserIdForRevel(Long id) {
        String sql = "select u.id as id from examination_student_revaluation esr left outer join admission admission on esr.admissionId=admission.id left outer join students students on admission.studentId=students.userid left outer join users u on students.userId=u.id  where esr.id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getParentUserIdbyByreval(Long recipientUserId, String relatioship) {
        String sql = "SELECT prts.userId AS id FROM examination_student_revaluation T1 left outer join admission admission on T1.admissionId=admission.id left outer join students st on admission.studentId=st.userid INNER JOIN persons p ON p.id = st.personId INNER JOIN person_relationships T8 ON T8.personId = p.id INNER JOIN persons AS T7 ON T7.id = T8.relatedPersonId INNER JOIN parents prts on prts.personId = T7.id WHERE T1.id = " + recipientUserId + " AND T8.relationship ='" + relatioship + "'";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getPersonToMeetId(Long recipientUserId) {
        String sql = "SELECT personToMeetId as id from sg_appointment where id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getParentId(Long recipientUserId) {
        String sql = "SELECT p.userId as id from sg_appointment s  left join parents p on p.personId=s.parentId where id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getEmployeeJobApplicationUserId(Long recipientUserId) {
        String sql = "SELECT T1.staffId AS id FROM employee_job_application T1 WHERE T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getVehicleServiceDueUser(Long recipientUserId) {
        String sql = "SELECT T1.userId AS id FROM trans_vehicle_service_history T1  WHERE T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getAppointeeId(Long recipientUserId) {
        String sql = "select studentId as id from sg_appointment where id=" + recipientUserId + " and studentId is not null UNION select staffId id from sg_appointment where id=" + recipientUserId + " and staffId is not null";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getAssigneeId(Long recipientUserId) {
        String sql = "select T1.assignedUser as id from file_assignment_detail T1 where  T1.id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getApplicationOwnerId(Long recipientUserId) {
        String sql = "select application.applicationOwner as id from application where id =" + recipientUserId + " and applicationOwner is not null";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getEnquiryOwnerId(Long recipientUserId) {
        String sql = "select enquiry.assignedToUserId as id from enquiry where id =" + recipientUserId + " and assignedToUserId is not null";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserFrmElectionVoterPoolId(Long voterPoolId) {
        String sql = "SELECT s.`userId` AS id FROM `election_voter_pool` T1 INNER JOIN `persons` T2 ON T2.`id` = T1.`personId` INNER JOIN `students` s ON s.`personId` = T2.`id` WHERE T1.`id` =" + voterPoolId + "\r\n UNION SELECT s.`userId` AS id FROM `election_voter_pool` T1 INNER JOIN `persons` T2 ON T2.`id` = T1.`personId` INNER JOIN `staffs` s ON s.`personId` = T2.`id` WHERE T1.`id` =" + voterPoolId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readApplicantInfo(Long recipientUserId) {
        String sql = "SELECT applicationId as id from external_user_association where externalUserId=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readAppFormSubmitRecipientInfo(Long recipientUserId) {
        String sql = "SELECT a.id as id from application_program as ap left join application as a on a.id=ap.applicationId where ap.id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readAppOfferLetterRecipientInfo(Long recipientUserId) {
        String sql = "SELECT a.id as id from application_program as ap left join application as a on a.id=ap.applicationId where ap.id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getApplicantLoginCredentialByExternalUserId(Long externalUserId) {
        String sql = "select T3.id as id   from external_users T1\r\n\tleft join external_user_association T2 on T2.externalUserId=T1.id\r\n    left join application T3 on T3.id=T2.applicationId where T1.id=" + externalUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getApplicationIdFrmAPId(Long recipientUserId) {
        String sql = "SELECT a.id as id from application_program as ap left join application as a on a.id=ap.applicationId where ap.id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getApplicantDocGrpReqByPersonReqDocMasterId(Long personReqDocMasterId) {
        String sql = "select \nT5.id \nfrom person_required_doc_group_master T1 \nleft join document_group_master_required T2 on T2.id=T1.documentGroupMasterRequiredId\nleft join document_group_master T3 on T3.id=T2.documentGroupMasterId\ninner join applicant_person T4 on T4.id=T1.applicantPersonId\nleft join application T5 on T5.applicantPersonId=T4.id\nwhere T1.id= " + personReqDocMasterId + " group by T1.applicantPersonId \nunion\nselect\nT2.userId\nfrom person_required_doc_group_master T1  \ninner join staffs T2 on T2.personId=T1.personId\nwhere T1.id= " + personReqDocMasterId + " group by T1.personId   \nunion\nselect\nT2.userId\nfrom person_required_doc_group_master T1  \ninner join students T2 on T2.personId=T1.personId\nwhere T1.id= " + personReqDocMasterId + " group by T1.personId";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getApplicationFollowUpByuserId(Long recipientUserId) {
        String sql = "select T1.assignTo as id from application_followup T1 where T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentIdByAppliedAndRemovedHold(Long recipientUserId) {
        String sql = "select T1.studentId as id from student_apply_hold_category T1  where T1.id = " + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO getUserIdForApplicationOfferEscalation(Long recipeintUserId) {
        String sql = "select T1.reviewerId as id from app_program_adm_details T1 where T1.id =" + recipeintUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public SystemInternalNotificationInfoDTO getUserIdForApplicationOfferEscalationReview(Long recipeintUserId) {
        String sql = "select T1.firstEscalatedBy as id from app_program_adm_details T1 where T1.id =" + recipeintUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(SystemInternalNotificationInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        SystemInternalNotificationInfoDTO sysInternalNotificationRecepientInfoDTO = (SystemInternalNotificationInfoDTO)query.uniqueResult();
        return sysInternalNotificationRecepientInfoDTO;
    }

    public RecepientInfoDTO getOwnerIdForDocumentResubmission(Long recipientUserId) {
        String sql = "SELECT\nT3.applicationOwner as id\nFROM \napplication_required_documents T1 \nLEFT JOIN \napplication T3 on T1.applicationId = T3.id \nWHERE \nT1.id IN (" + recipientUserId + ")";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentIdCourseSessionDiary(Long recipientUserId) {
        String sql = "SELECT T5.userId AS id FROM course_session_diary T1 LEFT OUTER JOIN  course_variants T2 ON T2.id = T1.courseVariantId LEFT OUTER JOIN student_course_enrollment T3 ON T3.courseVarientId = T2.id LEFT OUTER JOIN admission T4 ON T4.id = T3.admissionId LEFT OUTER JOIN students T5 ON T5.userId = T4.studentId LEFT OUTER JOIN persons T6 ON T6.id = T5.personId WHERE CAST(CONCAT(T1.id, T3.id) AS UNSIGNED) IN (" + recipientUserId + ") AND T1.publishToStudent = 1 AND T1.timeFrom IS NOT NULL AND T3.exitDate IS NULL AND DATE(T1.timeFrom) = DATE_FORMAT((DATE(NOW())), '%Y-%m-%d') ";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getFatherIdCourseSessionDiary(Long recipientUserId) {
        String sql = "SELECT T17.id as id FROM course_session_diary T1 LEFT OUTER JOIN    course_variants T2 ON T2.id = T1.courseVariantId  LEFT OUTER JOIN    student_course_enrollment T3 ON T3.courseVarientId = T2.id LEFT OUTER JOIN  admission T4 ON T4.id = T3.admissionId  LEFT OUTER JOIN students T5 ON T5.userId = T4.studentId LEFT OUTER JOIN  persons T6 ON T6.id = T5.personId        LEFT OUTER JOIN    person_relationships AS T14 ON T14.personId = T6.id LEFT OUTER JOIN    persons AS T15 ON T15.id = T14.relatedPersonId LEFT OUTER JOIN   parents T16 ON T16.personId = T15.id   LEFT JOIN    users T17 ON T17.id = T16.userID WHERE   cast(concat(T1.id,T3.id) AS unsigned) IN (" + recipientUserId + ") AND T1.publishToParent = 1 AND T14.relationship = 'FATHER' AND T1.timeFrom IS NOT NULL AND T3.exitDate IS null  AND DATE(T1.timeFrom) = DATE_FORMAT((DATE(NOW())), '%Y-%m-%d') ";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getMotherIdCourseSessionDiary(Long recipientUserId) {
        String sql = "SELECT T17.id as id FROM course_session_diary T1 LEFT OUTER JOIN    course_variants T2 ON T2.id = T1.courseVariantId  LEFT OUTER JOIN    student_course_enrollment T3 ON T3.courseVarientId = T2.id LEFT OUTER JOIN  admission T4 ON T4.id = T3.admissionId  LEFT OUTER JOIN students T5 ON T5.userId = T4.studentId LEFT OUTER JOIN  persons T6 ON T6.id = T5.personId        LEFT OUTER JOIN    person_relationships AS T14 ON T14.personId = T6.id LEFT OUTER JOIN    persons AS T15 ON T15.id = T14.relatedPersonId LEFT OUTER JOIN   parents T16 ON T16.personId = T15.id   LEFT JOIN    users T17 ON T17.id = T16.userID WHERE   cast(concat(T1.id,T3.id) AS unsigned) IN (" + recipientUserId + ") AND T1.publishToParent = 1 AND T14.relationship = 'MOTHER' AND T1.timeFrom IS NOT NULL AND T3.exitDate IS null  AND DATE(T1.timeFrom) = DATE_FORMAT((DATE(NOW())), '%Y-%m-%d') ";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getUserIdForDetainMsg(Long id) {
        String sql = "select u.id as id from exam_result_event_students esr left outer join admission admission on esr.admissionId=admission.id left outer join students students on admission.studentId=students.userid left outer join users u on students.userId=u.id  where esr.id=" + id;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getParentUserIdForDetain(Long recipientUserId, String relatioship) {
        String sql = "SELECT prts.userId AS id FROM exam_result_event_students T1 left outer join admission admission on T1.admissionId=admission.id left outer join students st on admission.studentId=st.userid INNER JOIN persons p ON p.id = st.personId INNER JOIN person_relationships T8 ON T8.personId = p.id INNER JOIN persons AS T7 ON T7.id = T8.relatedPersonId INNER JOIN parents prts on prts.personId = T7.id WHERE T1.id = " + recipientUserId + " AND T8.relationship ='" + relatioship + "'";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getOwnerIdForPostSchoolStudiesDocumentResubmission(Long postSchoolStudiesId) {
        String sql = "SELECT\nT3.applicationOwner as id\nFROM \npost_school_studies_section T1 \nLEFT JOIN \napplicant_person T2 ON T2.id = T1.applicant_person_id \nLEFT JOIN \napplication T3 on T2.id = T3.applicantPersonId \nWHERE \nT1.id IN (" + postSchoolStudiesId + ")";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getOwnerNameForRejectApplication(Long applicationProgramId) {
        String sql = "SELECT u.printName as firstName from application_program as ap left outer join users as u on ap.lastUpdatedBy=u.id where ap.id=" + applicationProgramId + " limit 1 ";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("firstName", (Type)StringType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readAppFormSubmitRecipientInfoByApplicationId(Long recipientUserId) {
        String sql = "SELECT a.id as id from application as a where a.id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readApplicationAdmissionCommentRecipientInfo(Long recipientUserId) {
        String sql = "SELECT a.reassignUserId as id from application_admission_comments as a where a.id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getStudentForHostelCheckInAndOut(Long recipientUserId) {
        String sql = "select studentId as id from hostel_room_allotment  where id =" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readDocSubmissionAppOwnerRecipientInfo(Long recipientUserId) {
        String sql = "SELECT app.applicationOwner as id from application_required_documents as a left outer join application as app on a.applicationId=app.id where a.id=" + recipientUserId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getApplicationApproverUpByuserId(Long applicationId) {
        String sql = "SELECT \n    (CASE \n        WHEN \n            (SELECT \n                    adu.defaultUserId \n                FROM \n                    application_default_user adu \n                        INNER JOIN \n                    academy_location toacademyl356_ ON adu.academyLocationId = toacademyl356_.id \n                WHERE \n                    adu.academyLocationId = toacademyl3_.id \n                        AND adu.defaultUserId IS NOT NULL \n                LIMIT 1) \n        THEN \n            (SELECT  \n                    usr.id AS name \n                FROM \n                    application_default_user adus \n                        INNER JOIN \n                    academy_location toacademyl35678_ ON adus.academyLocationId = toacademyl35678_.id \n                        LEFT JOIN \n                    users usr ON usr.id = adus.defaultUserId \n                WHERE \n                    adus.academyLocationId = toacademyl3_.id \n                        AND adus.defaultUserId IS NOT NULL \n                LIMIT 1) \n        WHEN applicatio4_.id IS NOT NULL THEN applicatio4_.id \n        ELSE (SELECT  \n                useradmin.id \n            FROM \n                users AS useradmin \n            WHERE \n                code = 'SYSADMIN') \n    END) AS id \nFROM \n    application_program this_ \n        INNER JOIN \n    academy_location toacademyl3_ ON this_.academyLocationId = toacademyl3_.id \n        LEFT OUTER JOIN \n    currency currency12_ ON toacademyl3_.currencyId = currency12_.id \n        INNER JOIN \n    application applicatio1_ ON this_.applicationId = applicatio1_.id \n        LEFT OUTER JOIN \n    application_cf_data applicatio14_ ON applicatio1_.id = applicatio14_.applicationId \n        INNER JOIN \n    users applicatio4_ ON applicatio1_.applicationOwner = applicatio4_.id \n        LEFT OUTER JOIN \n    parents applicatio4_1_ ON applicatio4_.id = applicatio4_1_.userId \n        LEFT OUTER JOIN \n    staffs applicatio4_2_ ON applicatio4_.id = applicatio4_2_.userId \n        LEFT OUTER JOIN \n    persons applicatio4_22_ ON applicatio4_.id = applicatio4_22_.id \n        LEFT OUTER JOIN \n    students applicatio4_3_ ON applicatio4_.id = applicatio4_3_.userId \n        INNER JOIN \n    academy_location issuedfrom5_ ON applicatio1_.issuedFromAcademyLocation = issuedfrom5_.id \n        INNER JOIN \n    applicant_person person2_ ON applicatio1_.applicantPersonId = person2_.id \n        LEFT OUTER JOIN \n    reservation_category reservatio18_ ON applicatio1_.reservationCategoryId = reservatio18_.id \n        LEFT OUTER JOIN \n    application_program_cd applicatio19_ ON this_.id = applicatio19_.applicationProgramId \n        INNER JOIN \n    prog_batch_seat_config programbat6_ ON this_.progBatchSeatConfigId = programbat6_.id \n        INNER JOIN \n    batches batch7_ ON programbat6_.programBatchId = batch7_.id \n        INNER JOIN \n    programs program8_ ON batch7_.programId = program8_.id \n        LEFT OUTER JOIN \n    program_batch_seat_type_cd programbat24_ ON programbat6_.id = programbat24_.progBatchSeatConfigId \nWHERE \n    applicatio1_.id IN (" + applicationId + ") \nORDER BY this_.lastUpdate DESC \nLIMIT 1";
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO getApproverUpByServiceRequestId(Long requestId) {
        String sql = "SELECT  \n    (SELECT  \n            approveruser.id \n        FROM \n            users AS approveruser \n        WHERE \n            approveruser.id = servicereq6_.lastUpdatedBy) AS id \nFROM \n        student_transfer_request_details this_  \n    left outer join \n        service_requests servicereq6_  \n            on this_.serviceRequestId=servicereq6_.id  \n    where \n        servicereq6_.id =" + requestId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }

    public RecepientInfoDTO readSubmitApplicationProgramCoordinatorByApplicationId(Long applicationId) {
        String sql = "SELECT users.id as id from application as a left join application_program as ap on ap.applicationId=a.id left join programs as prog on prog.id=ap.programId left join users as users on prog.approver=users.id where a.id=" + applicationId;
        SQLQuery query = this.getCrntSession().createSQLQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(RecepientInfoDTO.class));
        query.addScalar("id", (Type)LongType.INSTANCE);
        RecepientInfoDTO recepientInfoDTO = (RecepientInfoDTO)query.uniqueResult();
        return recepientInfoDTO;
    }
}

