/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.helper;

import com.lowagie.text.DocumentException;
import in.serosoft.messaging.dto.MessageDTO;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.PrettyXmlSerializer;
import org.htmlcleaner.TagNode;
import org.xhtmlrenderer.pdf.ITextRenderer;

/*
 * Exception performing whole class analysis ignored.
 */
public class LetterQueueHelper {
    public static void generateLetter(MessageDTO messageDTO, String letterBaseDir) {
        String messageContent = messageDTO.getMessageContent();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            LetterQueueHelper.clean((String)messageContent, (ByteArrayOutputStream)out);
            String dir = "MsgLog_" + messageDTO.getMsgLogId();
            String msgSubject = messageDTO.getSubject().length() > 10 ? messageDTO.getSubject().substring(0, 10) : messageDTO.getSubject();
            String fileNAme = "Letter_" + msgSubject + "_" + messageDTO.getRecipientUserId();
            LetterQueueHelper.renderPdf((ByteArrayOutputStream)out, (String)dir, (String)fileNAme, (String)letterBaseDir);
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
        }
    }

    private static void renderPdf(ByteArrayOutputStream out, String directoryName, String fileName, String letterBaseDir) throws FileNotFoundException, DocumentException, IOException {
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocumentFromString(new String(out.toByteArray()));
        renderer.layout();
        String path = LetterQueueHelper.createLetterDocumentsDirectory((String)directoryName, (String)letterBaseDir);
        try (FileOutputStream outputStream = new FileOutputStream(path + "/" + fileName + ".pdf");){
            renderer.createPDF((OutputStream)outputStream);
            renderer.finishPDF();
            out.flush();
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private static String createLetterDocumentsDirectory(String directoryName, String baseDir) throws IOException {
        File directory = new File(baseDir + "/letterMessages/" + directoryName);
        if (directory.exists()) {
            return directory.getCanonicalPath();
        }
        directory.mkdirs();
        return directory.getCanonicalPath();
    }

    private static void clean(String messageContent, ByteArrayOutputStream out) throws IOException {
        HtmlCleaner cleaner = new HtmlCleaner();
        CleanerProperties props = cleaner.getProperties();
        props.setTranslateSpecialEntities(true);
        TagNode node = cleaner.clean(messageContent);
        new PrettyXmlSerializer(props).writeToStream(node, (OutputStream)out, "UTF-8");
    }

    public static void main(String[] args) {
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setMessageContent("<html><head>\t<title></title></head><body><p>Hi,&nbsp;Nikhil&nbsp;Agrawal</p><p>&nbsp;</p><p>Your new creds in academia :</p><p>UserId : nikhil</p><p>password :&nbsp;H`MGK+.78460</p><p>&nbsp;</p><p>Thanks</p><p>AV2</p></body></html> ");
        messageDTO.setMsgLogId(Long.valueOf(111L));
        messageDTO.setRecipientUserId(Long.valueOf(123L));
        messageDTO.setSubject("example1111111111");
        LetterQueueHelper.generateLetter((MessageDTO)messageDTO, (String)"C:\\academia\\letterdir");
    }
}

