/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.helper;

import in.serosoft.cb.model.ResultDocument;
import in.serosoft.messaging.dto.MessageDTO;
import in.serosoft.messaging.dto.MsgBasicInfoDTO;
import in.serosoft.messaging.entity.MsgDeliveryMode;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.entity.MsgTemplate;
import in.serosoft.messaging.entity.MsgTemplateConfig;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogChute;
import org.joda.time.DateTime;

/*
 * Exception performing whole class analysis ignored.
 */
public class MsgContentBuilderHelper {
    private static final String DTENDTIME = "DTENDTIME";
    private static final String INVITATION = "INVITATION";
    private static final SimpleDateFormat INVITEDATEFORMATE = new SimpleDateFormat("yyyyMMdd'T'HHmm'00Z'");
    private static final SimpleDateFormat DD_MM_YYYY_FORMATE = new SimpleDateFormat("dd-MM-yyyy");
    private static final SimpleDateFormat HH_MM_SS_FORMAT = new SimpleDateFormat("dd-mm-yyyy HH:mm:ss");
    private static final SimpleDateFormat YYYYMMDD = new SimpleDateFormat("yyyyMMdd");

    public static String buildMsgContent(byte[] templateStream, HashMap<String, Object> recepientsData, HashMap<String, Object> templateData) {
        try {
            String invite;
            String string = invite = recepientsData.get("INVITATION") != null ? (String)recepientsData.get("INVITATION") : null;
            if (null != invite) {
                String location;
                Date startDate = MsgContentBuilderHelper.parseDate((String)((String)recepientsData.get("DTSTART")));
                Date startTime = null;
                if (null != recepientsData.get("DTSTART_TIME")) {
                    startTime = MsgContentBuilderHelper.parseDateTime((String)((String)recepientsData.get("DTSTART_TIME")));
                }
                Date endDate = recepientsData.get("DTENDTIME") != null ? MsgContentBuilderHelper.parseDate((String)((String)recepientsData.get("DTEND"))) : null;
                String string2 = location = recepientsData.get("INVITE_LOCATION") != null ? (String)recepientsData.get("INVITE_LOCATION") : null;
                if (null == endDate) {
                    endDate = startDate;
                }
                String endTimeValue = recepientsData.get("DTENDTIME") != null ? (String)recepientsData.get("DTENDTIME") : null;
                Date endTime = null;
                Calendar dateCalendar = Calendar.getInstance();
                Calendar timeCalendar = Calendar.getInstance();
                dateCalendar.setTime(startDate);
                if (null != startTime) {
                    timeCalendar.setTime(startTime);
                }
                dateCalendar.set(dateCalendar.get(1), dateCalendar.get(2), dateCalendar.get(5), timeCalendar.get(11), timeCalendar.get(12), timeCalendar.get(13));
                Date start = new Date(dateCalendar.getTimeInMillis() - (long)dateCalendar.getTimeZone().getRawOffset());
                if (null != endTimeValue) {
                    endTime = MsgContentBuilderHelper.parseDateTime((String)endTimeValue);
                    dateCalendar.setTime(endDate);
                    timeCalendar.setTime(endTime);
                    dateCalendar.set(dateCalendar.get(1), dateCalendar.get(2), dateCalendar.get(5), timeCalendar.get(11), timeCalendar.get(12), timeCalendar.get(13));
                } else {
                    dateCalendar.setTime(endDate);
                    dateCalendar.set(dateCalendar.get(1), dateCalendar.get(2), dateCalendar.get(5), timeCalendar.get(11), timeCalendar.get(12), timeCalendar.get(13));
                    dateCalendar.add(12, 15);
                }
                String manageEvent = recepientsData.get("MANAGE_EVENT") != null ? (String)recepientsData.get("MANAGE_EVENT") : "";
                Date end = new Date(dateCalendar.getTimeInMillis() - (long)dateCalendar.getTimeZone().getRawOffset());
                StringBuilder inviteContent = new StringBuilder();
                if (manageEvent.equals("MANAGE_EVENT")) {
                    Date tillDate = null;
                    Boolean whetherRecurring = (Boolean)recepientsData.get("RECURRING_DAY");
                    Boolean whetherComplete = (Boolean)recepientsData.get("COMPLETE_DAY");
                    String repeatOn = null;
                    String[] repeatDays = null;
                    String bday = "";
                    if (whetherRecurring.booleanValue() && whetherComplete.booleanValue()) {
                        tillDate = MsgContentBuilderHelper.parseDate((String)((String)recepientsData.get("UNTIL")));
                        repeatOn = (String)recepientsData.get("BYDAY");
                        repeatDays = repeatOn.split(",");
                    } else if (whetherRecurring.booleanValue()) {
                        tillDate = MsgContentBuilderHelper.parseDate((String)((String)recepientsData.get("UNTIL")));
                        repeatOn = (String)recepientsData.get("BYDAY");
                        repeatDays = repeatOn.split(",");
                    }
                    StringBuilder repeat = new StringBuilder();
                    if (repeatDays != null && repeatDays.length > 0) {
                        for (String repeatDay : repeatDays) {
                            repeat.append(repeatDay.substring(0, 2) + ",");
                        }
                    }
                    Calendar tillDateCalendar = Calendar.getInstance();
                    Calendar tillTimeCalendar = Calendar.getInstance();
                    if (tillDate == null) {
                        tillDate = startDate;
                    }
                    if (null != endTimeValue) {
                        endTime = MsgContentBuilderHelper.parseDateTime((String)endTimeValue);
                        tillDateCalendar.setTime(tillDate);
                        tillTimeCalendar.setTime(endTime);
                        tillDateCalendar.set(tillDateCalendar.get(1), tillDateCalendar.get(2), tillDateCalendar.get(5), tillTimeCalendar.get(11), tillTimeCalendar.get(12), tillTimeCalendar.get(13));
                    } else {
                        tillDateCalendar.setTime(tillDate);
                        tillDateCalendar.set(tillDateCalendar.get(1), tillDateCalendar.get(2), tillDateCalendar.get(5), tillTimeCalendar.get(11), tillTimeCalendar.get(12), tillTimeCalendar.get(13));
                        tillDateCalendar.add(12, 15);
                    }
                    Date untilDate = new Date(tillDateCalendar.getTimeInMillis() - (long)tillDateCalendar.getTimeZone().getRawOffset());
                    inviteContent = inviteContent.append("BEGIN:VCALENDAR\r\nPRODID: BCP - Meeting\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nBEGIN:VEVENT\r\nATTENDEE;ROLE=REQ-PARTICIPANT;RSVP=TRUE:" + recepientsData.get("EMAIL_ID") + "\r\nORGANIZER:MAILTO:" + recepientsData.get("ORG_MAIL_TO") + "\r\nDTSTAMP:" + INVITEDATEFORMATE.format(new Date()));
                    if (!whetherComplete.booleanValue()) {
                        inviteContent = inviteContent.append("\r\nDTSTART:" + INVITEDATEFORMATE.format(start) + "\r\nDTEND:" + INVITEDATEFORMATE.format(end) + "\r\n");
                    } else {
                        DateTime dtOrg = new DateTime((Object)end);
                        DateTime dtPlusOne1 = dtOrg.plusDays(1);
                        inviteContent = inviteContent.append("\r\nDTSTART;VALUE=DATE:" + YYYYMMDD.format(start) + "\r\nDTEND;VALUE=DATE:" + YYYYMMDD.format(dtPlusOne1.toDate()) + "\r\n");
                    }
                    if (whetherRecurring.booleanValue() && !repeatOn.isEmpty()) {
                        inviteContent.append("RRULE:FREQ=WEEKLY;");
                        inviteContent.append("WKST=SU;");
                        inviteContent.append("UNTIL=" + INVITEDATEFORMATE.format(untilDate) + ";");
                        inviteContent.append("BYDAY=" + repeat.substring(0, repeat.length() - 1) + "\r\n");
                    }
                    inviteContent = inviteContent.append("TRANSP:OPAQUE\r\nSEQUENCE:0\r\nUID:" + UUID.randomUUID().toString() + "\r\nDESCRIPTION:" + recepientsData.get("INVITE_DESC") + "\r\nSUMMARY:" + recepientsData.get("INVITE_SUM") + "\r\nCLASS:PUBLIC\r\nEND:VEVENT\r\nEND:VCALENDAR");
                } else {
                    inviteContent = inviteContent.append("BEGIN:VCALENDAR\r\nPRODID: BCP - Meeting\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nBEGIN:VEVENT\r\nATTENDEE;ROLE=REQ-PARTICIPANT;RSVP=TRUE:" + recepientsData.get("EMAIL_ID") + "\r\nORGANIZER:MAILTO:" + recepientsData.get("ORG_MAIL_TO") + "\r\nDTSTAMP:" + INVITEDATEFORMATE.format(new Date()) + "\r\nDTSTART:" + INVITEDATEFORMATE.format(start) + "\r\nDTEND:" + INVITEDATEFORMATE.format(end) + "\r\n");
                    if (null != location && !"NA".equals(location)) {
                        inviteContent = inviteContent.append("LOCATION:" + recepientsData.get("INVITE_LOCATION") + "\r\n");
                    }
                    inviteContent = inviteContent.append("TRANSP:OPAQUE\r\nSEQUENCE:0\r\nUID:" + UUID.randomUUID().toString() + "\r\nDESCRIPTION:" + recepientsData.get("INVITE_DESC") + "\r\nSUMMARY:" + recepientsData.get("INVITE_SUM") + "\r\nCLASS:PUBLIC\r\nEND:VEVENT\r\nEND:VCALENDAR");
                }
                System.out.println(inviteContent.toString());
                return inviteContent.toString();
            }
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("runtime.log.logsystem.log4j.logger", (Object)NullLogChute.class.getName());
            ve.init();
            if (recepientsData != null && templateData != null) {
                MsgContentBuilderHelper.replaceNullWithEmptyString(recepientsData, templateData);
            } else if (recepientsData != null) {
                MsgContentBuilderHelper.replaceNullWithEmptyStringForRecipientData(recepientsData, templateData);
            }
            VelocityContext vc = new VelocityContext();
            vc.put("recipientData", recepientsData);
            vc.put("templateData", templateData);
            StringWriter writer = new StringWriter();
            String templateString = IOUtils.toString((byte[])templateStream, (String)StandardCharsets.UTF_8.toString());
            templateString = templateString.replace("&quot;", "\"");
            templateString = templateString.replace("\ufffd", " ");
            ve.evaluate((Context)vc, (Writer)writer, "", templateString);
            return writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void replaceNullWithEmptyString(HashMap<String, Object> recepientsData, HashMap<String, Object> templateData) {
        for (String key : recepientsData.keySet()) {
            if (recepientsData.get(key) != null) continue;
            recepientsData.put(key, "");
        }
        for (String key : templateData.keySet()) {
            if (templateData.get(key) != null) continue;
            templateData.put(key, "");
        }
    }

    private static void replaceNullWithEmptyStringForRecipientData(HashMap<String, Object> recepientsData, HashMap<String, Object> templateData) {
        for (String key : recepientsData.keySet()) {
            if (recepientsData.get(key) != null) continue;
            recepientsData.put(key, "");
        }
        if (templateData != null) {
            for (String key : templateData.keySet()) {
                if (templateData.get(key) != null) continue;
                templateData.put(key, "");
            }
        }
    }

    public static MessageDTO buildMessageDTO(MsgDeliveryMode deliveryMode, MsgTemplate msgTemplate, ResultDocument recepientData, ResultDocument templateData, MsgRecipientTypeLog msgRecipientTypeLog, List<MsgRecipientLog> msgRecipientLogs, List<String> attachmentPaths, MsgTemplateConfig msgTemplateConfig) {
        String msgContent = MsgContentBuilderHelper.buildMsgContent((byte[])msgTemplate.getMsgContent(), (HashMap)recepientData, (HashMap)templateData);
        BigInteger rcpntId = (BigInteger)recepientData.get((Object)"ID");
        MsgRecipientLog msgRecipientLog = MsgContentBuilderHelper.findMsgRecipientLog((Long)deliveryMode.getId(), (Long)rcpntId.longValue(), msgRecipientLogs);
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setContact(msgRecipientLog.getDeliveryContact());
        messageDTO.setCountryCode(msgRecipientLog.getCountryCode());
        messageDTO.setMessageContent(msgContent);
        messageDTO.setMsgRecipientType(msgRecipientTypeLog.getMsgRecipientType());
        messageDTO.setRecipientUserId(Long.valueOf(rcpntId.longValue()));
        messageDTO.setMsgRecipientLogId(msgRecipientLog.getId());
        messageDTO.setMessageTypeCode(msgTemplateConfig.getMsgMessageType().getCode());
        if (msgTemplate.getSubjectLine() != null) {
            String subjectLine = MsgContentBuilderHelper.buildMsgContent((byte[])msgTemplate.getSubjectLine().getBytes(), (HashMap)recepientData, (HashMap)templateData);
            messageDTO.setSubject(subjectLine);
        }
        messageDTO.setWhetherBulkMessage(msgTemplateConfig.getWhetherBulkMesaging());
        messageDTO.setAttachmentPaths(attachmentPaths);
        return messageDTO;
    }

    public static MessageDTO buildMessageDTO(MsgRecipientLog msgRecipientLog, MsgTemplate msgTemplate, ResultDocument recepientData, ResultDocument templateData, MsgRecipientTypeLog msgRecipientTypeLog, List<String> attachmentPaths, MsgTemplateConfig msgTemplateConfig) {
        String msgContent = MsgContentBuilderHelper.buildMsgContent((byte[])msgTemplate.getMsgContent(), (HashMap)recepientData, (HashMap)templateData);
        BigInteger rcpntId = null;
        Long dataId = null;
        String msgCategory = null;
        if (recepientData != null) {
            rcpntId = (BigInteger)recepientData.get((Object)"ID");
            if (null != recepientData.get((Object)"DATA_ID")) {
                dataId = ((BigInteger)recepientData.get((Object)"DATA_ID")).longValue();
            }
            msgCategory = (String)recepientData.get((Object)"MSG_CATEGORY");
        }
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setContact(msgRecipientLog.getDeliveryContact());
        messageDTO.setCountryCode(msgRecipientLog.getCountryCode());
        messageDTO.setMessageContent(msgContent);
        messageDTO.setMsgRecipientType(msgRecipientTypeLog.getMsgRecipientType());
        if (rcpntId != null) {
            messageDTO.setRecipientUserId(Long.valueOf(rcpntId.longValue()));
        }
        messageDTO.setMsgRecipientLogId(msgRecipientLog.getId());
        messageDTO.setMessageTypeCode(msgTemplateConfig.getMsgMessageType().getCode());
        if (msgTemplate.getSubjectLine() != null) {
            String invite;
            String string = invite = recepientData.get((Object)"INVITATION") != null ? (String)recepientData.get((Object)"INVITATION") : null;
            if (null != invite) {
                messageDTO.setSubject(msgTemplate.getSubjectLine());
                messageDTO.setIsInvitation(true);
            } else {
                String subjectLine = MsgContentBuilderHelper.buildMsgContent((byte[])msgTemplate.getSubjectLine().getBytes(), (HashMap)recepientData, (HashMap)templateData);
                messageDTO.setSubject(subjectLine);
                messageDTO.setIsInvitation(false);
            }
        }
        messageDTO.setWhetherBulkMessage(msgTemplateConfig.getWhetherBulkMesaging());
        messageDTO.setAttachmentPaths(attachmentPaths);
        MsgBasicInfoDTO basicInfo = new MsgBasicInfoDTO();
        basicInfo.setDataId(dataId);
        basicInfo.setCategory(msgCategory);
        messageDTO.setMsgBasicInfoDTO(basicInfo);
        if ("" != recepientData.get((Object)"PDF_PASSWORD") && null != recepientData.get((Object)"PDF_PASSWORD")) {
            messageDTO.setPdfPassword((byte[])recepientData.get((Object)"PDF_PASSWORD"));
        }
        return messageDTO;
    }

    private static MsgRecipientLog findMsgRecipientLog(Long deliveryModeId, Long recipientId, List<MsgRecipientLog> msgRecipientLogs) {
        for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
            Long modeId = msgRecipientLog.getMsgDeliveryMode().getId();
            Long msgRecipientId = msgRecipientLog.getRecipientId();
            if (modeId != deliveryModeId || !msgRecipientId.equals(recipientId)) continue;
            return msgRecipientLog;
        }
        return null;
    }

    public static MessageDTO buildAdhocRecipientsMessageDTO(MsgTemplate msgTemplate, MsgRecipientTypeLog msgRecipientTypeLog, MsgRecipientLog msgRecipientLog, List<String> attachmentsPaths, MsgTemplateConfig msgTemplateConfig) {
        String msgContent = MsgContentBuilderHelper.buildMsgContent((byte[])msgTemplate.getMsgContent(), null, null);
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setContact(msgRecipientLog.getDeliveryContact());
        messageDTO.setCountryCode(msgRecipientLog.getCountryCode());
        messageDTO.setMessageContent(msgContent);
        messageDTO.setMsgRecipientType(msgRecipientTypeLog.getMsgRecipientType());
        messageDTO.setRecipientUserId(null);
        messageDTO.setMsgRecipientLogId(msgRecipientLog.getId());
        if (msgTemplate.getSubjectLine() != null) {
            String subjectLine = MsgContentBuilderHelper.buildMsgContent((byte[])msgTemplate.getSubjectLine().getBytes(), null, null);
            messageDTO.setSubject(subjectLine);
        }
        messageDTO.setWhetherBulkMessage(msgTemplateConfig.getWhetherBulkMesaging());
        messageDTO.setAttachmentPaths(attachmentsPaths);
        return messageDTO;
    }

    public static Date parseDate(String dateFormat) {
        try {
            return DD_MM_YYYY_FORMATE.parse(dateFormat);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDateTime(String dateFormat) {
        try {
            return HH_MM_SS_FORMAT.parse(dateFormat);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

