/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.helper;

import in.serosoft.messaging.entity.AdhocMsgEventConfig;
import in.serosoft.messaging.entity.MsgDeliveryMode;
import in.serosoft.messaging.entity.MsgDeliveryModeLog;
import in.serosoft.messaging.entity.MsgEventConfig;
import in.serosoft.messaging.entity.MsgEventRecipientConfig;
import in.serosoft.messaging.entity.MsgEventScope;
import in.serosoft.messaging.entity.MsgEventScopeRecord;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.MsgLogContextParam;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.entity.MsgScopeParam;
import in.serosoft.messaging.entity.MsgTemplate;
import in.serosoft.messaging.entity.MsgTemplateConfig;
import in.serosoft.messaging.entity.ScheduleMessageEventLog;
import in.serosoft.messaging.entity.SysMsgEvtDefaultConfig;
import in.serosoft.messaging.entity.SysMsgEvtDefaultScope;
import in.serosoft.messaging.entity.UserTriggeredMsgEvtLog;
import in.serosoft.messaging.enumeration.StatusCode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class MsgLogHelper {
    private static final String EVENT_TRIGGER_ACAD_LOC_ID = "EVENT_TRIGGER_ACAD_LOC_ID";

    public static MsgLog buildMsgLogRecord(MsgEventConfig msgEventConfig, SysMsgEvtDefaultConfig sysMsgEvtDefaultConfig, Map<String, String> eventContextScopeParamMap) {
        Date currentSystemDate = Calendar.getInstance().getTime();
        MsgLog msgLog = new MsgLog();
        msgLog.setMsgEventConfig(msgEventConfig);
        Set msgLogContextParams = MsgLogHelper.buildMsgLogContextParams((MsgLog)msgLog, (SysMsgEvtDefaultConfig)sysMsgEvtDefaultConfig, eventContextScopeParamMap);
        msgLog.setMsgLogContextParams(msgLogContextParams);
        msgLog.setMsgPriority(msgEventConfig.getSendingPriority());
        msgLog.setRecordCreatedTimeStamp(currentSystemDate);
        msgLog.setStatusCode(StatusCode.START);
        return msgLog;
    }

    private static Set<MsgLogContextParam> buildMsgLogContextParams(MsgLog msgLog, SysMsgEvtDefaultConfig sysMsgEvtDefaultConfig, Map<String, String> eventContextScopeParamMap) {
        HashSet<MsgLogContextParam> msgLogContextParams = new HashSet<MsgLogContextParam>();
        Set msgEvtDefaultScopes = sysMsgEvtDefaultConfig.getSysMsgEvtDefaultScopes();
        for (SysMsgEvtDefaultScope sysMsgEvtDefaultScope : msgEvtDefaultScopes) {
            String msgScopeCode = sysMsgEvtDefaultScope.getMsgScopeParam().getMsgScope().getCode();
            MsgLogContextParam msgLogContextParam = null;
            if (!msgScopeCode.equals("EVENT_CONTEXT_SCOPE")) continue;
            msgLogContextParam = new MsgLogContextParam();
            msgLogContextParam.setMsgLog(msgLog);
            msgLogContextParam.setMsgScopeParam(sysMsgEvtDefaultScope.getMsgScopeParam());
            msgLogContextParam.setParamValue(eventContextScopeParamMap.get(sysMsgEvtDefaultScope.getMsgScopeParam().getParamKey()));
            msgLogContextParams.add(msgLogContextParam);
        }
        MsgLogContextParam msgLogContextParam = new MsgLogContextParam();
        msgLogContextParam.setMsgLog(msgLog);
        MsgScopeParam msgScopeParam = new MsgScopeParam();
        msgScopeParam.setId(Long.valueOf(14L));
        msgLogContextParam.setMsgScopeParam(msgScopeParam);
        msgLogContextParam.setParamValue(eventContextScopeParamMap.get("EVENT_TRIGGER_ACAD_LOC_ID"));
        msgLogContextParams.add(msgLogContextParam);
        return msgLogContextParams;
    }

    public static Map<String, String> buildEventContextScopeParamMap(MsgEventConfig systemMsgEventConfig, UserTriggeredMsgEvtLog userTriggeredMsgEvtLog) {
        HashMap<String, String> eventContextScopeParamMap = new HashMap<String, String>();
        eventContextScopeParamMap.put("CONFIG_LEVEL_VALUE", systemMsgEventConfig.getMsgConfigLevelValue().toString());
        eventContextScopeParamMap.put("CONTEXT_RECORD_ID", userTriggeredMsgEvtLog.getContextRecordId().toString());
        eventContextScopeParamMap.put("EVENT_TRIGGER_DATE", userTriggeredMsgEvtLog.getCreatedTimeStamp().toString());
        eventContextScopeParamMap.put("EXTRA_PARAMS", userTriggeredMsgEvtLog.getExtraParam());
        String acadLocId = null;
        if (userTriggeredMsgEvtLog.getAcademyLocationId() != null) {
            acadLocId = userTriggeredMsgEvtLog.getAcademyLocationId().toString();
        }
        eventContextScopeParamMap.put("EVENT_TRIGGER_ACAD_LOC_ID", acadLocId);
        return eventContextScopeParamMap;
    }

    public static Map<String, String> buildEventContextScopeParamMap(MsgEventConfig systemMsgEventConfig, ScheduleMessageEventLog scheduleMessageEventLog) {
        HashMap<String, String> eventContextScopeParamMap = new HashMap<String, String>();
        eventContextScopeParamMap.put("CONFIG_LEVEL_VALUE", systemMsgEventConfig.getMsgConfigLevelValue().toString());
        eventContextScopeParamMap.put("EVENT_TRIGGER_DATE", scheduleMessageEventLog.getCreatedTimeStamp().toString());
        String acadLocId = systemMsgEventConfig.getMsgConfigLevelValue().toString();
        if (systemMsgEventConfig.getMsgConfigLevel() != null && systemMsgEventConfig.getMsgConfigLevel().getCode().equals("Organization")) {
            acadLocId = null;
        }
        eventContextScopeParamMap.put("EVENT_TRIGGER_ACAD_LOC_ID", acadLocId);
        return eventContextScopeParamMap;
    }

    public static List<MsgRecipientTypeLog> buildMsgRcpntTypeLogs(MsgLog msgLog, MsgEventConfig msgEventConfig) {
        ArrayList<MsgRecipientTypeLog> msgRecipientTypeLogs = new ArrayList<MsgRecipientTypeLog>();
        Set msgEventRecipientConfigs = msgEventConfig.getMsgEventRecipientConfigs();
        for (MsgEventRecipientConfig msgEventRecipientConfig : msgEventRecipientConfigs) {
            MsgRecipientTypeLog msgRecipientTypeLog = new MsgRecipientTypeLog();
            msgRecipientTypeLog.setMsgEventRecipientConfig(msgEventRecipientConfig);
            msgRecipientTypeLog.setMsgRecipientType(msgEventRecipientConfig.getMsgRecipientType());
            msgRecipientTypeLog.setStatusCode(StatusCode.START);
            msgRecipientTypeLog.setTotalCount(Integer.valueOf(0));
            msgRecipientTypeLog.setMsgLog(msgLog);
            msgRecipientTypeLogs.add(msgRecipientTypeLog);
        }
        return msgRecipientTypeLogs;
    }

    public static List<MsgDeliveryModeLog> createMsgDeliveryModeLogRecords(MsgRecipientTypeLog msgRecipientTypeLog, MsgTemplateConfig msgTemplateConfig) {
        ArrayList<MsgDeliveryModeLog> msgDeliveryModeLogs = new ArrayList<MsgDeliveryModeLog>();
        Set msgTemplates = msgTemplateConfig.getMsgTemplates();
        for (MsgTemplate msgTemplate : msgTemplates) {
            MsgDeliveryModeLog msgDeliveryModeLog = MsgLogHelper.buildMsgDeliveryModeLog((MsgRecipientTypeLog)msgRecipientTypeLog, (MsgDeliveryMode)msgTemplate.getMsgDeliveryMode());
            msgDeliveryModeLogs.add(msgDeliveryModeLog);
        }
        return msgDeliveryModeLogs;
    }

    private static MsgDeliveryModeLog buildMsgDeliveryModeLog(MsgRecipientTypeLog msgRecipientTypeLog, MsgDeliveryMode msgDeliveryMode) {
        MsgDeliveryModeLog msgDeliveryModeLog = new MsgDeliveryModeLog();
        msgDeliveryModeLog.setSuccessCount(Integer.valueOf(0));
        msgDeliveryModeLog.setMsgRecipientTypeLog(msgRecipientTypeLog);
        msgDeliveryModeLog.setFailureCount(Integer.valueOf(0));
        msgDeliveryModeLog.setMsgDeliveryMode(msgDeliveryMode);
        return msgDeliveryModeLog;
    }

    public static Map<Long, Object> buildInitRuleContextMap(SysMsgEvtDefaultConfig sysMsgEvtDefaultConfig, Map<String, String> eventContextScopeParamMap, List<MsgEventScope> msgEventScopes) {
        Set msgEvtDefaultScopes = sysMsgEvtDefaultConfig.getSysMsgEvtDefaultScopes();
        HashMap<Long, Object> initRuleContextMap = new HashMap<Long, Object>();
        for (SysMsgEvtDefaultScope sysMsgEvtDefaultScope : msgEvtDefaultScopes) {
            String msgScopeCode = sysMsgEvtDefaultScope.getMsgScopeParam().getMsgScope().getCode();
            if (!msgScopeCode.equals("EVENT_CONTEXT_SCOPE")) continue;
            Long msgScopeParamId = sysMsgEvtDefaultScope.getMsgScopeParam().getId();
            String msgScopeParamValue = eventContextScopeParamMap.get(sysMsgEvtDefaultScope.getMsgScopeParam().getParamKey());
            initRuleContextMap.put(msgScopeParamId, msgScopeParamValue);
        }
        for (MsgEventScope msgEventScope : msgEventScopes) {
            Long msgScopeParamId = msgEventScope.getMsgScopeParam().getId();
            List msgScopeParamValue = MsgLogHelper.buildMsgScopeRecords((Set)msgEventScope.getMsgEventScopeRecords());
            initRuleContextMap.put(msgScopeParamId, msgScopeParamValue);
        }
        return initRuleContextMap;
    }

    private static List<Long> buildMsgScopeRecords(Set<MsgEventScopeRecord> msgEventScopeRecords) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (MsgEventScopeRecord msgEventScopeRecord : msgEventScopeRecords) {
            ids.add(msgEventScopeRecord.getRecordId());
        }
        return ids;
    }

    public static MsgLog buildMsgLogRecord(AdhocMsgEventConfig adhocMsgEventConfig, Map<String, MsgScopeParam> msgScopeParams) {
        Date currentSystemDate = Calendar.getInstance().getTime();
        MsgLog msgLog = new MsgLog();
        msgLog.setMsgEventConfig((MsgEventConfig)adhocMsgEventConfig);
        Set msgLogContextParams = MsgLogHelper.buildMsgLogContextParams((MsgLog)msgLog, (AdhocMsgEventConfig)adhocMsgEventConfig, msgScopeParams);
        msgLog.setMsgLogContextParams(msgLogContextParams);
        msgLog.setMsgPriority(adhocMsgEventConfig.getSendingPriority());
        msgLog.setRecordCreatedTimeStamp(currentSystemDate);
        msgLog.setStatusCode(StatusCode.START);
        return msgLog;
    }

    private static Set<MsgLogContextParam> buildMsgLogContextParams(MsgLog msgLog, AdhocMsgEventConfig adhocMsgEventConfig, Map<String, MsgScopeParam> msgScopeParams) {
        HashSet<MsgLogContextParam> msgLogContextParams = new HashSet<MsgLogContextParam>();
        MsgLogContextParam msgLogContextParam = new MsgLogContextParam();
        msgLogContextParam.setMsgLog(msgLog);
        msgLogContextParam.setMsgScopeParam(msgScopeParams.get("EVENT_TRIGGER_DATE"));
        msgLogContextParam.setParamValue(new Date().toString());
        msgLogContextParams.add(msgLogContextParam);
        msgLogContextParam = new MsgLogContextParam();
        msgLogContextParam.setMsgLog(msgLog);
        msgLogContextParam.setMsgScopeParam(msgScopeParams.get("EVENT_TRIGGER_ACAD_LOC_ID"));
        msgLogContextParam.setParamValue(adhocMsgEventConfig.getAcademyLocationId().toString());
        msgLogContextParams.add(msgLogContextParam);
        msgLogContextParam = new MsgLogContextParam();
        msgLogContextParam.setMsgLog(msgLog);
        msgLogContextParam.setMsgScopeParam(msgScopeParams.get("MSG_FROM_USER_ID"));
        msgLogContextParam.setParamValue(adhocMsgEventConfig.getAuthorId().toString());
        msgLogContextParams.add(msgLogContextParam);
        return msgLogContextParams;
    }
}

