/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.helper;

import in.serosoft.cb.model.ResultDocument;
import in.serosoft.messaging.dto.Attachment;
import in.serosoft.messaging.dto.EmailDomainConfigurationDTO;
import in.serosoft.messaging.dto.SNSBounceRecipientsDTO;
import in.serosoft.messaging.entity.AdhocRecipients;
import in.serosoft.messaging.entity.MsgDeliveryModeLog;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.service.GatewayCredentialsService;
import in.serosoft.messaging.service.MsgUnblockEmailIdService;
import in.serosoft.messaging.util.MsgServerApplicationContextUtil;
import in.serosoft.messaging.utility.ServerApplicationContextUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class MsgRcpntTypeQueueHelper {
    private static final String MOBILE_NO = "MOBILE_NO";
    private static final String MOBILE_CODE = "MOBILE_CODE";
    private static final String EMAIL_ID_NOT_VALID = "EMAIL_ID_NOT_VALID";
    private static final String EMAIL_ID = "EMAIL_ID";
    private static final String EMAIL = "EMAIL";
    private static final String CONTACT_NOT_AVAILABLE = "CONTACT_NOT_AVAILABLE";
    private static final String ALTERNATE_EMAIL_ID = "ALTERNATE_EMAIL_ID";

    public static List<MsgRecipientLog> createMessageRecipientsLog(MsgRecipientTypeLog msgRecipientTypeLog, List<ResultDocument> recepients, List<MsgDeliveryModeLog> msgDeliveryModeLogs) {
        ArrayList<MsgRecipientLog> msgRecipientLogs = new ArrayList<MsgRecipientLog>();
        for (ResultDocument recepient : recepients) {
            BigInteger id = (BigInteger)recepient.get((Object)"ID");
            for (MsgDeliveryModeLog msgDeliveryModeLog : msgDeliveryModeLogs) {
                MsgRecipientLog msgRecipientLog = new MsgRecipientLog();
                String mode = msgDeliveryModeLog.getMsgDeliveryMode().getCode();
                if (mode.equals("SMS")) {
                    if (recepient.get((Object)"MOBILE_NO") == null) continue;
                    msgRecipientLog.setDeliveryContact(recepient.get((Object)"MOBILE_NO").toString());
                } else if (mode.equals("EMAIL")) {
                    if (recepient.get((Object)"EMAIL_ID") == null) continue;
                    msgRecipientLog.setDeliveryContact(recepient.get((Object)"EMAIL_ID").toString());
                } else if (mode.equals("SYS_INTERNAL_MSG")) {
                    msgRecipientLog.setDeliveryContact(id.toString());
                }
                msgRecipientLog.setMsgRecipientTypeLog(msgRecipientTypeLog);
                msgRecipientLog.setRecipientId(Long.valueOf(id.longValue()));
                msgRecipientLog.setMsgDeliveryMode(msgDeliveryModeLog.getMsgDeliveryMode());
                msgRecipientLog.setStatusCode(StatusCode.START);
                msgRecipientLogs.add(msgRecipientLog);
            }
        }
        return msgRecipientLogs;
    }

    public static Attachment readAttachment(String path) {
        Attachment attachment = new Attachment();
        try {
            File file = new File(path);
            attachment.setByte(FileUtils.readFileToByteArray((File)file));
            attachment.setFileName(file.getName());
            return attachment;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while Reading file from path : " + path, e);
        }
    }

    public static List<String> readAttachment() {
        ArrayList<String> attachmentPaths = new ArrayList<String>();
        return attachmentPaths;
    }

    public static List<Long> convertStringToListOfLong(String selectedRcpntIds) {
        selectedRcpntIds = selectedRcpntIds.substring(1, selectedRcpntIds.length() - 1);
        StringTokenizer st = new StringTokenizer(selectedRcpntIds, ",");
        ArrayList<Long> rcpntIds = new ArrayList<Long>();
        while (st.hasMoreTokens()) {
            rcpntIds.add(Long.valueOf(st.nextToken()));
        }
        return rcpntIds;
    }

    public static List<MsgRecipientLog> createMessageAdhocRecipientsLog(MsgRecipientTypeLog msgRecipientTypeLog, List<AdhocRecipients> adhocRecipients, List<MsgDeliveryModeLog> msgDeliveryModeLogs) {
        ArrayList<MsgRecipientLog> msgRecipientLogs = new ArrayList<MsgRecipientLog>();
        for (AdhocRecipients adhocRecipient : adhocRecipients) {
            for (MsgDeliveryModeLog msgDeliveryModeLog : msgDeliveryModeLogs) {
                String mode = msgDeliveryModeLog.getMsgDeliveryMode().getCode();
                if (mode.equals("EMAIL") && adhocRecipient.getContactType().equals("EMAIL")) {
                    MsgRcpntTypeQueueHelper.buildAdhocRecipientLogs((MsgRecipientTypeLog)msgRecipientTypeLog, msgRecipientLogs, (AdhocRecipients)adhocRecipient, (MsgDeliveryModeLog)msgDeliveryModeLog);
                }
                if (!mode.equals("SMS") || !adhocRecipient.getContactType().equals("MOBILE_NO")) continue;
                MsgRcpntTypeQueueHelper.buildAdhocRecipientLogs((MsgRecipientTypeLog)msgRecipientTypeLog, msgRecipientLogs, (AdhocRecipients)adhocRecipient, (MsgDeliveryModeLog)msgDeliveryModeLog);
            }
        }
        return msgRecipientLogs;
    }

    private static void buildAdhocRecipientLogs(MsgRecipientTypeLog msgRecipientTypeLog, List<MsgRecipientLog> msgRecipientLogs, AdhocRecipients adhocRecipient, MsgDeliveryModeLog msgDeliveryModeLog) {
        byte[] contactBytes = adhocRecipient.getContacts();
        String contacts = new String(contactBytes);
        List<String> contactList = Arrays.asList(contacts.split(","));
        for (String contact : contactList) {
            MsgRecipientLog msgRecipientLog = new MsgRecipientLog();
            msgRecipientLog.setDeliveryContact(contact);
            msgRecipientLog.setMsgRecipientTypeLog(msgRecipientTypeLog);
            msgRecipientLog.setMsgDeliveryMode(msgDeliveryModeLog.getMsgDeliveryMode());
            msgRecipientLog.setStatusCode(StatusCode.START);
            msgRecipientLogs.add(msgRecipientLog);
        }
    }

    public static List<MsgRecipientLog> createMessageRecipientsLog(MsgRecipientTypeLog msgRecipientTypeLog, List<ResultDocument> recipients, List<MsgDeliveryModeLog> msgDeliveryModeLogs, Map<Long, ResultDocument> distributionListContextData, EmailDomainConfigurationDTO emailDomainConfigurationDTO) {
        String key;
        ArrayList<MsgRecipientLog> msgRecipientLogs = new ArrayList<MsgRecipientLog>();
        for (Map map : recipients) {
            BigInteger id = (BigInteger)map.get("ID");
            for (MsgDeliveryModeLog msgDeliveryModeLog : msgDeliveryModeLogs) {
                MsgRecipientLog msgRecipientLog = new MsgRecipientLog();
                MsgRecipientLog msgRecipientLogForAlternateEmail = new MsgRecipientLog();
                String mode = msgDeliveryModeLog.getMsgDeliveryMode().getCode();
                if (mode.equals("SMS")) {
                    if (map.get("MOBILE_NO") == null) {
                        msgRecipientLog.setFailureCode("CONTACT_NOT_AVAILABLE");
                    } else {
                        msgRecipientLog.setDeliveryContact(map.get("MOBILE_NO").toString());
                        if (map.get("MOBILE_CODE") != null) {
                            if (map.get("MOBILE_CODE").toString().contains("+")) {
                                msgRecipientLog.setCountryCode(map.get("MOBILE_CODE").toString());
                            } else {
                                msgRecipientLog.setCountryCode("+" + map.get("MOBILE_CODE").toString());
                            }
                        }
                    }
                } else if (mode.equals("EMAIL")) {
                    if (map.get("EMAIL_ID") == null) {
                        msgRecipientLog.setFailureCode("CONTACT_NOT_AVAILABLE");
                    } else {
                        MsgRcpntTypeQueueHelper.checkDomainAndSetDetails((String)map.get("EMAIL_ID").toString(), (MsgRecipientLog)msgRecipientLog, (EmailDomainConfigurationDTO)emailDomainConfigurationDTO);
                    }
                    if (map.get("ALTERNATE_EMAIL_ID") == null) {
                        msgRecipientLogForAlternateEmail.setFailureCode("CONTACT_NOT_AVAILABLE");
                    } else {
                        MsgRcpntTypeQueueHelper.checkDomainAndSetDetails((String)map.get("ALTERNATE_EMAIL_ID").toString(), (MsgRecipientLog)msgRecipientLogForAlternateEmail, (EmailDomainConfigurationDTO)emailDomainConfigurationDTO);
                        msgRecipientLogForAlternateEmail.setMsgRecipientTypeLog(msgRecipientTypeLog);
                        msgRecipientLogForAlternateEmail.setRecipientId(Long.valueOf(id.longValue()));
                        msgRecipientLogForAlternateEmail.setMsgDeliveryMode(msgDeliveryModeLog.getMsgDeliveryMode());
                        msgRecipientLogForAlternateEmail.setStatusCode(StatusCode.START);
                    }
                } else if (mode.equals("SYS_INTERNAL_MSG")) {
                    msgRecipientLog.setDeliveryContact(id.toString());
                } else if (mode.equalsIgnoreCase("PushNotification")) {
                    if (map.get("DEVICE_ID") == null) {
                        msgRecipientLog.setFailureCode("DEVICE_ID_NOT_AVAILABLE");
                    } else {
                        String deviceId = map.get("DEVICE_ID").toString();
                        if (deviceId.length() > 1500) {
                            String subString = deviceId.substring(0, 1499);
                            msgRecipientLog.setDeliveryContact(subString);
                        } else {
                            msgRecipientLog.setDeliveryContact(deviceId);
                        }
                    }
                }
                msgRecipientLog.setMsgRecipientTypeLog(msgRecipientTypeLog);
                msgRecipientLog.setRecipientId(Long.valueOf(id.longValue()));
                msgRecipientLog.setMsgDeliveryMode(msgDeliveryModeLog.getMsgDeliveryMode());
                msgRecipientLog.setStatusCode(StatusCode.START);
                if (distributionListContextData.get(id.longValue()) != null) {
                    try {
                        msgRecipientLog.setRecipientContextData(new ObjectMapper().writeValueAsString((Object)distributionListContextData.get(id.longValue())));
                        if (mode.equals("EMAIL") && msgRecipientLogForAlternateEmail != null) {
                            msgRecipientLogForAlternateEmail.setRecipientContextData(new ObjectMapper().writeValueAsString((Object)distributionListContextData.get(id.longValue())));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                msgRecipientLogs.add(msgRecipientLog);
                if (map.get("ALTERNATE_EMAIL_ID") == null || !mode.equals("EMAIL") || msgRecipientLogForAlternateEmail == null) continue;
                msgRecipientLogs.add(msgRecipientLogForAlternateEmail);
            }
        }
        HashMap<String, MsgRecipientLog> mapRecipientData = new HashMap<String, MsgRecipientLog>();
        ArrayList<MsgRecipientLog> arrayList = new ArrayList<MsgRecipientLog>();
        if (msgRecipientTypeLog.getMsgRecipientType().getCode().equalsIgnoreCase("MSG_COURSEWISE_WEEKLY_STUDENT")) {
            for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                key = msgRecipientLog.getRecipientId() + "-" + msgRecipientLog.getMsgDeliveryMode();
                mapRecipientData.put(key, msgRecipientLog);
            }
            for (Map.Entry entry : mapRecipientData.entrySet()) {
                arrayList.add((MsgRecipientLog)entry.getValue());
            }
            return arrayList;
        }
        if (msgRecipientTypeLog.getMsgRecipientType().getCode().equalsIgnoreCase("MSG_COURSEWISE_WEEKLY_PARENT")) {
            for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                key = msgRecipientLog.getRecipientId() + "-" + msgRecipientLog.getMsgDeliveryMode();
                mapRecipientData.put(key, msgRecipientLog);
            }
            for (Map.Entry entry : mapRecipientData.entrySet()) {
                arrayList.add((MsgRecipientLog)entry.getValue());
            }
            return arrayList;
        }
        if (msgRecipientTypeLog.getMsgRecipientType().getCode().equalsIgnoreCase("CONSOLIDATED_ATTENDANCE_MISSED_BY_FACULTY_RCPNT_TYPE")) {
            for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                key = msgRecipientLog.getRecipientId() + "-" + msgRecipientLog.getMsgDeliveryMode();
                mapRecipientData.put(key, msgRecipientLog);
            }
            for (Map.Entry entry : mapRecipientData.entrySet()) {
                arrayList.add((MsgRecipientLog)entry.getValue());
            }
            return arrayList;
        }
        if (msgRecipientTypeLog.getMsgRecipientType().getCode().equalsIgnoreCase("CONSOLIDATED_ATTENDANCE_MISSED_BY_TEACHER_RCPNT_TYPE")) {
            for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                key = msgRecipientLog.getRecipientId() + "-" + msgRecipientLog.getMsgDeliveryMode();
                mapRecipientData.put(key, msgRecipientLog);
            }
            for (Map.Entry entry : mapRecipientData.entrySet()) {
                arrayList.add((MsgRecipientLog)entry.getValue());
            }
            return arrayList;
        }
        if (msgRecipientTypeLog.getMsgRecipientType().getCode().equalsIgnoreCase("HOMEWORK_ASSIGNMENT_SUBMISSION_GRP_RCPNT")) {
            for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                key = msgRecipientLog.getRecipientId() + "-" + msgRecipientLog.getMsgDeliveryMode();
                mapRecipientData.put(key, msgRecipientLog);
            }
            for (Map.Entry entry : mapRecipientData.entrySet()) {
                arrayList.add((MsgRecipientLog)entry.getValue());
            }
            return arrayList;
        }
        if (msgRecipientTypeLog.getMsgRecipientType().getCode().equalsIgnoreCase("HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_RECIPIENT")) {
            for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                key = msgRecipientLog.getRecipientId() + "-" + msgRecipientLog.getMsgDeliveryMode();
                mapRecipientData.put(key, msgRecipientLog);
            }
            for (Map.Entry entry : mapRecipientData.entrySet()) {
                arrayList.add((MsgRecipientLog)entry.getValue());
            }
            return arrayList;
        }
        if (msgRecipientTypeLog.getMsgRecipientType().getCode().equalsIgnoreCase("HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_RECIPIENT")) {
            for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                key = msgRecipientLog.getRecipientId() + "-" + msgRecipientLog.getMsgDeliveryMode();
                mapRecipientData.put(key, msgRecipientLog);
            }
            for (Map.Entry entry : mapRecipientData.entrySet()) {
                arrayList.add((MsgRecipientLog)entry.getValue());
            }
            return arrayList;
        }
        return msgRecipientLogs;
    }

    private static void checkDomainAndSetDetails(String emailId, MsgRecipientLog msgRecipientLog, EmailDomainConfigurationDTO emailDomainConfigurationDTO) {
        if (emailDomainConfigurationDTO.getValidDomains() == null) {
            emailDomainConfigurationDTO.setValidDomains("");
        }
        if (emailDomainConfigurationDTO.getInValidDomains() == null) {
            emailDomainConfigurationDTO.setInValidDomains("");
        }
        ArrayList<Object> validDomains = new ArrayList();
        ArrayList<Object> inValidDomains = new ArrayList();
        if (emailDomainConfigurationDTO.getValidDomains() != null && emailDomainConfigurationDTO.getValidDomains() != "") {
            validDomains = new ArrayList<String>(Arrays.asList(emailDomainConfigurationDTO.getValidDomains().split(",")));
        }
        if (emailDomainConfigurationDTO.getInValidDomains() != null && emailDomainConfigurationDTO.getInValidDomains() != "") {
            inValidDomains = new ArrayList<String>(Arrays.asList(emailDomainConfigurationDTO.getInValidDomains().split(",")));
        }
        msgRecipientLog.setDeliveryContact(emailId);
        MsgUnblockEmailIdService msgUnblockEmailIdService = (MsgUnblockEmailIdService)MsgServerApplicationContextUtil.getBeanById((String)"msgUnblockEmailIdService");
        List msgUnblockEmailId = msgUnblockEmailIdService.findEmailIdsbyEmailId(emailId);
        if (validDomains != null && !validDomains.isEmpty()) {
            boolean validEmail = false;
            for (String string : validDomains) {
                if (!emailId.toLowerCase().endsWith(string.toLowerCase())) continue;
                validEmail = true;
                break;
            }
            if (!validEmail) {
                if (msgUnblockEmailId != null && msgUnblockEmailId.size() == 0) {
                    msgRecipientLog.setFailureCode("EMAIL_ID_NOT_VALID");
                    msgRecipientLog.setDeliveryStatus("EMAIL_ID_NOT_VALID");
                } else {
                    msgRecipientLog.setFailureCode(null);
                    msgRecipientLog.setDeliveryStatus(null);
                }
            }
        } else if (inValidDomains != null && !inValidDomains.isEmpty()) {
            boolean inValidEmail = false;
            for (String string : inValidDomains) {
                if (!emailId.toLowerCase().endsWith(string.toLowerCase())) continue;
                inValidEmail = true;
                break;
            }
            if (inValidEmail) {
                if (msgUnblockEmailId != null && msgUnblockEmailId.size() == 0) {
                    msgRecipientLog.setFailureCode("EMAIL_ID_NOT_VALID");
                    msgRecipientLog.setDeliveryStatus("EMAIL_ID_NOT_VALID");
                } else {
                    msgRecipientLog.setFailureCode(null);
                    msgRecipientLog.setDeliveryStatus(null);
                }
            }
        }
        try {
            GatewayCredentialsService gatewayCredentialService;
            SNSBounceRecipientsDTO isSNSEmailValid;
            if (!"EMAIL_ID_NOT_VALID".equals(msgRecipientLog.getFailureCode()) && null != (isSNSEmailValid = (gatewayCredentialService = (GatewayCredentialsService)ServerApplicationContextUtil.getBeanById((String)"gatewayCredentialsService")).getSNSBounceRecipientsDTO(null, emailId)) && !"Delivery".equalsIgnoreCase(isSNSEmailValid.getStatus())) {
                msgRecipientLog.setFailureCode("SNS_EMAIL_RESTRICTED");
                msgRecipientLog.setDeliveryStatus("Blocked");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Long> buildRecipientIds(List<ResultDocument> receipients) {
        ArrayList<Long> receipientIds = new ArrayList<Long>();
        for (Map map : receipients) {
            Long id = Long.valueOf(map.get("USER_ID").toString());
            receipientIds.add(id);
        }
        return receipientIds;
    }

    public static List<Long> buildRecipientIdsAndDistributionContext(List<ResultDocument> receipients, Map<Long, ResultDocument> recipientContextData) {
        ArrayList<Long> receipientIds = new ArrayList<Long>();
        for (ResultDocument resultDocument : receipients) {
            Long id = Long.valueOf(resultDocument.get((Object)"USER_ID").toString());
            recipientContextData.put(id, resultDocument);
            receipientIds.add(id);
        }
        return receipientIds;
    }
}

