/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.entity.AdhocMsgEventConfig;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.helper.MsgLogHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.service.AdhocMsgEventConfigService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgScopeParamService;
import in.serosoft.messaging.service.SchedulerService;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="adhocMsgEvtQueueListener")
public class AdhocMsgEvtQueueListener
implements MessageListener {
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    SchedulerService schedulerService;
    @Autowired
    AdhocMsgEventConfigService adhocMsgEventConfigService;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    MsgScopeParamService msgScopeParamService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        DEBUGCOMMONLOGGER.debug((Object)("###### listened message on AdhocMsgEvtQueue ###### " + new Date()));
        Long adhocMsgEventCnfgId = MsgQueueHelper.getMessageContent((Message)message);
        AdhocMsgEventConfig adhocMsgEventConfig = (AdhocMsgEventConfig)this.adhocMsgEventConfigService.findById(adhocMsgEventCnfgId);
        Map msgScopeParams = this.msgScopeParamService.findAllMsgScopeParams();
        MsgLog msgLog = MsgLogHelper.buildMsgLogRecord((AdhocMsgEventConfig)adhocMsgEventConfig, (Map)msgScopeParams);
        Long msgLogId = this.msgLogService.create((Object)msgLog);
        this.messageQueueTemplate.convertAndSend("MsgLogQueue", (Object)msgLogId);
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        DEBUGCOMMONLOGGER.debug((Object)("Adhoc Event ID Processed & Send to MSG_LOG_QUEUE ID " + msgLogId + " adhocMsgEventCnfgId " + adhocMsgEventCnfgId));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

