/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.docgen.model.DynamicDocumentData;
import in.serosoft.docgen.service.DocumentGeneratorService;
import in.serosoft.messaging.entity.MsgDeliveryMode;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgRecipientDocuments;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.helper.MsgRcpntsQueueHelper;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgRecipientDocumentsService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="documentGeneratorQueueListener")
public class DocumentGeneratorQueueListener
implements MessageListener {
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    MsgRecipientDocumentsService msgRecipientDocumentsService;
    @Autowired
    DocumentGeneratorService htmlTemplateDocGenService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"DocumentGeneratorQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        DEBUGCOMMONLOGGER.debug((Object)"###### listened message on DocumentGeneratorQueue #1 ######");
        try {
            Map logIds = MsgQueueHelper.getLogIds((Message)message);
            Long recipientId = (Long)logIds.get("recipientId");
            Long msgRcpntTypeLogId = (Long)logIds.get("msgRcpntTypeLogId");
            MsgRecipientTypeLog msgRecipientTypeLog = (MsgRecipientTypeLog)this.msgRecipientTypeLogService.findById(msgRcpntTypeLogId);
            List msgRecipientLogs = this.msgRecipientLogService.findAllByRecipientTypeAndRecipientId(msgRcpntTypeLogId, recipientId);
            MsgRecipientLog msgRecipientLog = (MsgRecipientLog)msgRecipientLogs.get(0);
            Set docIds = this.buildDocIds(msgRecipientLog.getDynamicDocuments());
            DEBUGCOMMONLOGGER.debug((Object)("DocumentGeneratorQueue #01 recipientId " + recipientId + " msgRcpntTypeLogId " + msgRcpntTypeLogId + " msgRecipientLog.get(0) " + msgRecipientLog));
            for (Long docId : docIds) {
                DynamicDocumentData documentData = this.generateDocument(docId, msgRecipientTypeLog.getMsgRecipientType().getIdParamName(), msgRecipientLog.getRecipientId());
                this.persistDocument(documentData, docId, msgRecipientTypeLog, msgRecipientLog.getRecipientId());
                DEBUGCOMMONLOGGER.debug((Object)("DocumentGeneratorQueue DynamicDocumentData #02 docId " + docId + " getMsgRecipientType " + msgRecipientTypeLog.getMsgRecipientType() + " getIdParamName " + msgRecipientTypeLog.getMsgRecipientType().getIdParamName() + " getRecipientId " + msgRecipientLog.getRecipientId()));
            }
            this.publishToNextQueue(msgRecipientLogs);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void publishToNextQueue(List<MsgRecipientLog> msgRecipientLogs) {
        for (MsgRecipientLog msgRecipientLogRecord : msgRecipientLogs) {
            MsgDeliveryMode msgDeliveryMode = msgRecipientLogRecord.getMsgDeliveryMode();
            String queueName = MsgRcpntsQueueHelper.findQueueNameForDeliveryMode((String)msgDeliveryMode.getCode());
            this.messageQueueTemplate.convertAndSend(queueName, (Object)msgRecipientLogRecord.getId());
            DEBUGCOMMONLOGGER.debug((Object)("DocumentGeneratorQueue publishToNextQueue #04 queueName " + queueName + " msgRecipientLogs " + msgRecipientLogRecord.getId()));
        }
    }

    private void persistDocument(DynamicDocumentData documentData, Long docId, MsgRecipientTypeLog msgRecipientTypeLog, Long recipientId) {
        MsgRecipientDocuments msgRecipientDocument = new MsgRecipientDocuments();
        msgRecipientDocument.setRecipientId(recipientId);
        msgRecipientDocument.setMsgRecipientTypeLog(msgRecipientTypeLog);
        msgRecipientDocument.setDocument(documentData.getData());
        msgRecipientDocument.setDocId(docId);
        msgRecipientDocument.setDocumentName(documentData.getFileName());
        Long id = this.msgRecipientDocumentsService.create((Object)msgRecipientDocument);
        DEBUGCOMMONLOGGER.debug((Object)("DocumentGeneratorQueue persistDocument #03 MsgRecipientDocuments " + id + " File Name " + documentData.getFileName()));
    }

    private DynamicDocumentData generateDocument(Long docId, String idParamName, Long recipientId) {
        HashMap<String, Long> contextMap = new HashMap<String, Long>();
        contextMap.put(idParamName, recipientId);
        contextMap.put("PRM_APPLICATION_PROGRAM_ID", 10L);
        DynamicDocumentData documentData = this.htmlTemplateDocGenService.generateDocumentByDocumentOwnerConfig(docId, contextMap);
        return documentData;
    }

    private Set<Long> buildDocIds(String dynamicDocuments) {
        HashSet<Long> docIds = new HashSet<Long>();
        Set ids = StringUtils.commaDelimitedListToSet((String)dynamicDocuments);
        for (String docId : ids) {
            docIds.add(Long.valueOf(docId));
        }
        return docIds;
    }
}

