/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.docgen.domain.DocumentOwnerConfiguration;
import in.serosoft.docgen.service.DocumentTypeEntityMappingService;
import in.serosoft.messaging.entity.AdhocMsgDynamicAttachment;
import in.serosoft.messaging.entity.MsgDynamicDocumentApplicability;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.helper.RabbitMQHelper;
import in.serosoft.messaging.service.AdhocMsgDynamicAttachmentService;
import in.serosoft.messaging.service.AdhocMsgEventConfigService;
import in.serosoft.messaging.service.MsgDynamicDocumentApplicabilityService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="documentMgntQueueListener")
public class DocumentMgntQueueListener
implements MessageListener {
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    AdhocMsgEventConfigService adhocMsgEventConfigService;
    @Autowired
    AdhocMsgDynamicAttachmentService adhocMsgDynamicAttachmentService;
    @Autowired
    DocumentTypeEntityMappingService documentTypeEntityMappingService;
    @Autowired
    MsgDynamicDocumentApplicabilityService msgDynamicDocumentApplicabilityService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"DocumentMgntQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        Long msgRcpntTypeLogId = MsgQueueHelper.getMessageContent((Message)message);
        DEBUGCOMMONLOGGER.debug((Object)"###### listened message on DocumentMgntQueueListener for Adhoc Message dynamic attachments ######");
        try {
            MsgRecipientTypeLog msgRecipientTypeLog = (MsgRecipientTypeLog)this.msgRecipientTypeLogService.findById(msgRcpntTypeLogId);
            if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
                // empty if block
            }
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #1 Read msgRecipientTypeLog record msgRecipientTypeLogId:" + msgRecipientTypeLog.getId()));
            List DocumentOwnerConfigs = this.findAllDynamicAttachemnts(msgRecipientTypeLog);
            if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
                // empty if block
            }
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #4 found DynamicAttachemnts attached (SIZE) :" + DocumentOwnerConfigs.size()));
            List documentConfigLevels = this.buildConfigLevels(DocumentOwnerConfigs);
            if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
                // empty if block
            }
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #6 ConfigLevels size : " + documentConfigLevels.size()));
            DEBUGCOMMONLOGGER.debug((Object)"DocumentMgntQueueListener #6 Build map of docs - owner wise , config level wise set of docs ");
            Map ownerDocuments = this.buildOwnerDocumnetsMap(DocumentOwnerConfigs);
            if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
                // empty if block
            }
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #7 ownerDocuments size: " + ownerDocuments.size()));
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #8 checking Document Applicability For Recipients msgRecipientTypeLog " + msgRecipientTypeLog));
            Map recipientDocs = this.checkDocumentApplicabilityForRecipients(msgRecipientTypeLog, documentConfigLevels, ownerDocuments);
            if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
                // empty if block
            }
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #9 Applicabile docs of Recipients (size): " + recipientDocs.size()));
            DEBUGCOMMONLOGGER.debug((Object)"DocumentMgntQueueListener #10 update msgRecipientLogs for DynamicDocuments");
            for (Long rcpntId : recipientDocs.keySet()) {
                Set docOwnerConfigs = (Set)recipientDocs.get(rcpntId);
                List msgRecipientLogs = this.msgRecipientLogService.updateDynamicDocuments(rcpntId, msgRcpntTypeLogId, docOwnerConfigs);
                this.publishToNextQueue(msgRecipientLogs, msgRcpntTypeLogId);
            }
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #11 push to next queue recipientDocs keySet : " + recipientDocs.keySet()));
        }
        catch (MessageCentralException ex) {
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #12 " + ex.getMessage()));
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"DocumentMgntQueue", (Long)msgRcpntTypeLogId);
            this.msgErrorsService.create((Object)msgErrors);
            ex.printStackTrace();
            return;
        }
        catch (AmqpAuthenticationException | AmqpConnectException | AmqpIOException ex) {
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #12.1 " + ex.getMessage()));
            String errorcode = RabbitMQHelper.findRabitMqErrorCode((AmqpException)ex);
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)errorcode, null, (String)"DocumentMgntQueue", (Long)msgRcpntTypeLogId);
            this.msgErrorsService.create((Object)msgErrors);
            ex.printStackTrace();
            return;
        }
        catch (NullPointerException ex) {
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #12.2 " + ex.getMessage()));
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"CONFIGURATION_ERROR", null, (String)"DocumentMgntQueue", (Long)msgRcpntTypeLogId);
            this.msgErrorsService.create((Object)msgErrors);
            ex.printStackTrace();
            return;
        }
        catch (Exception ex) {
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #12.3 " + ex.getMessage()));
            ex.printStackTrace();
            return;
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void publishToNextQueue(List<MsgRecipientLog> msgRecipientLogs, Long msgRcpntTypeLogId) {
        List recipientIds = this.findUniqueRecipients(msgRecipientLogs);
        HashMap<String, Long> logIds = new HashMap<String, Long>();
        for (Long recipientId : recipientIds) {
            logIds.put("recipientId", recipientId);
            logIds.put("msgRcpntTypeLogId", msgRcpntTypeLogId);
            this.messageQueueTemplate.convertAndSend("DocumentGeneratorQueue", logIds);
        }
    }

    private List<Long> findUniqueRecipients(List<MsgRecipientLog> msgRecipientLogs) {
        ArrayList<Long> recipientIds = new ArrayList<Long>();
        for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
            if (recipientIds.contains(msgRecipientLog.getRecipientId())) continue;
            recipientIds.add(msgRecipientLog.getRecipientId());
        }
        return recipientIds;
    }

    private Map<Long, Set<Long>> checkDocumentApplicabilityForRecipients(MsgRecipientTypeLog msgRecipientTypeLog, List<String> documentConfigLevels, Map<String, Set<Long>> ownerDocuments) {
        HashMap<Long, Set<Long>> recipientDocs = new HashMap<Long, Set<Long>>();
        for (String configLevelCode : documentConfigLevels) {
            MsgDynamicDocumentApplicability msgDynamicDocumentApplicability = this.msgDynamicDocumentApplicabilityService.findRecipientTypeAndConfigLevel(msgRecipientTypeLog.getMsgRecipientType().getId(), configLevelCode);
            String adhocSqlQuery = msgDynamicDocumentApplicability.getAdhocMsgSqlQuery();
            adhocSqlQuery = adhocSqlQuery.replace("RCPNT_TYPE_LOG_ID", msgRecipientTypeLog.getId().toString());
            adhocSqlQuery = adhocSqlQuery.replace("OWNER_IDS", this.buildOwnerIdsCommaSeperatedString(ownerDocuments));
            Map rcpntOwnerMap = this.msgDynamicDocumentApplicabilityService.executeAdhocSqlQuery(adhocSqlQuery);
            this.addRecipientDocumnets(recipientDocs, rcpntOwnerMap, configLevelCode, ownerDocuments);
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #8.1 checkDocumentApplicabilityForRecipients with replace RCPNT_TYPE_LOG_ID" + adhocSqlQuery));
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #8.2 checkDocumentApplicabilityForRecipients with replace OWNER_IDS" + adhocSqlQuery));
        }
        return recipientDocs;
    }

    private String buildOwnerIdsCommaSeperatedString(Map<String, Set<Long>> ownerDocuments) {
        HashSet<String> ownerids = new HashSet<String>();
        for (String string : ownerDocuments.keySet()) {
            ownerids.add(string.substring(0, string.indexOf(35)));
        }
        return StringUtils.collectionToCommaDelimitedString(ownerids);
    }

    private void addRecipientDocumnets(Map<Long, Set<Long>> recipientDocs, Map<Long, Long> rcpntOwnerMap, String configLevelCode, Map<String, Set<Long>> ownerDocuments) {
        for (Long rcpntId : rcpntOwnerMap.keySet()) {
            Long ownerID = rcpntOwnerMap.get(rcpntId);
            Set<Long> ownerConfigLevelDocuments = ownerDocuments.get(ownerID + "#" + configLevelCode);
            Set<Long> docs = recipientDocs.get(rcpntId);
            if (docs != null) {
                docs.addAll(ownerConfigLevelDocuments);
                recipientDocs.put(rcpntId, docs);
                continue;
            }
            docs = new HashSet<Long>();
            docs.addAll(ownerConfigLevelDocuments);
            recipientDocs.put(rcpntId, docs);
        }
    }

    private List<String> buildConfigLevels(List<DocumentOwnerConfiguration> documentOwnerConfigs) {
        ArrayList<String> documentConfigLevels = new ArrayList<String>();
        for (DocumentOwnerConfiguration documentOwnerConfiguration : documentOwnerConfigs) {
            String configLevelCode = documentOwnerConfiguration.getDocumentTypeId().getConfigLevel().name();
            if (documentConfigLevels.contains(configLevelCode)) continue;
            documentConfigLevels.add(configLevelCode);
        }
        return documentConfigLevels;
    }

    private Map<String, Set<Long>> buildOwnerDocumnetsMap(List<DocumentOwnerConfiguration> documentOwnerConfigs) {
        HashMap<String, Set<Long>> ownerDocs = new HashMap<String, Set<Long>>();
        for (DocumentOwnerConfiguration documentOwnerConfiguration : documentOwnerConfigs) {
            Long ownerId = documentOwnerConfiguration.getOwnerId();
            HashSet<Long> docs = (HashSet<Long>)ownerDocs.get(ownerId);
            String configLevelCode = documentOwnerConfiguration.getDocumentTypeId().getConfigLevel().name();
            if (docs != null) {
                docs.add(documentOwnerConfiguration.getId());
                ownerDocs.put(ownerId + "#" + configLevelCode, docs);
            } else {
                docs = new HashSet<Long>();
                docs.add(documentOwnerConfiguration.getId());
                ownerDocs.put(ownerId + "#" + configLevelCode, docs);
            }
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #6.1 buildOwnerDocumnetsMap of docs - owner wise , config level wise set of docs ownerId " + ownerId + " configLevelCode " + configLevelCode));
        }
        return ownerDocs;
    }

    private List<DocumentOwnerConfiguration> findAllDynamicAttachemnts(MsgRecipientTypeLog msgRecipientTypeLog) throws Exception {
        MsgLog msgLog = (MsgLog)this.msgLogService.findById(msgRecipientTypeLog.getMsgLog().getId());
        Long msgEventConfigId = msgLog.getMsgEventConfig().getId();
        Object config = this.adhocMsgEventConfigService.findById(msgEventConfigId);
        List attachments = new ArrayList();
        ArrayList<DocumentOwnerConfiguration> dydtOwnerCnfgs = new ArrayList<DocumentOwnerConfiguration>();
        if (config != null) {
            attachments = this.adhocMsgDynamicAttachmentService.findAllByMsgEventConfigId(msgEventConfigId);
            DEBUGCOMMONLOGGER.debug((Object)("DocumentMgntQueueListener #4 findAllDynamicAttachemnts : msgEventConfigId " + msgEventConfigId + " attachments " + attachments.size()));
            for (AdhocMsgDynamicAttachment adhocMsgDynamicAttachment : attachments) {
                DocumentOwnerConfiguration docOwnerConfig = this.documentTypeEntityMappingService.findWithTypeById(adhocMsgDynamicAttachment.getDydtOwnerCnfgId());
                dydtOwnerCnfgs.add(docOwnerConfig);
            }
        }
        return dydtOwnerCnfgs;
    }
}

