/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.dto.EmailCredentialsDTO;
import in.serosoft.messaging.dto.MessageDTO;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.listener.EmailQueueListener;
import in.serosoft.messaging.service.DataProviderEvaluationService;
import in.serosoft.messaging.service.GatewayCredentialsService;
import in.serosoft.messaging.service.MsgContentBuilderService;
import in.serosoft.messaging.service.MsgDeliveryModeLogService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.MsgTemplateConfigService;
import in.serosoft.messaging.service.MsgTemplateService;
import in.serosoft.messaging.service.TemplateConfigDocumentsService;
import in.serosoft.messaging.utility.AWSMailSender;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="emailQueueListener")
public class EmailQueueListener
implements MessageListener {
    private static Logger debugLogger = Logger.getLogger((String)"EmailQueueListenerLogger");
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    GatewayCredentialsService gatewayCredentialsService;
    @Autowired
    MsgDeliveryModeLogService msgDeliveryModeLogService;
    @Autowired
    DataProviderEvaluationService dataProviderEvaluationService;
    @Autowired
    MsgTemplateService msgTemplateService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    TemplateConfigDocumentsService templateConfigDocumentsService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Autowired
    MsgTemplateConfigService messageTemplateConfigService;
    @Autowired
    MsgContentBuilderService msgContentBuilderService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${msg.email.toAddress}")
    private String toAddress;
    @Value(value="${msg.email.fromAddress}")
    private String fromAddress;
    @Value(value="${msg.email.smtp_username}")
    private String smtpUserName;
    @Value(value="${msg.email.smtp_password}")
    private String smtpPassword;
    @Value(value="${msg.email.host}")
    private String host;
    @Value(value="${msg.email.port}")
    private Integer port;
    @Value(value="${msg.keyId}")
    private String keyId;
    @Value(value="${msg.secretKey}")
    private String secretKey;
    public static ConcurrentLinkedQueue<Message> queueList = new ConcurrentLinkedQueue();
    processMsg pr1;
    processMsg pr2;
    processMsg pr3;
    processMsg pr4;
    processMsg pr5;

    public void onMessage(Message message) {
        try {
            this.checkAndStartThreads();
            queueList.add(message);
            Thread.sleep(300L);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"EmailQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void checkAndStartThreads() {
        try {
            if (this.pr1 == null || !this.pr1.isStarted()) {
                this.pr1 = null;
                this.pr1 = new processMsg(this);
                this.pr1.setContinue(true);
                this.pr1.start();
            }
        }
        catch (Exception c) {
            this.pr1.setContinue(false);
            this.pr1 = null;
        }
        try {
            if (this.pr2 == null || !this.pr2.isStarted()) {
                this.pr2 = null;
                this.pr2 = new processMsg(this);
                this.pr2.setContinue(true);
                this.pr2.start();
            }
        }
        catch (Exception c) {
            this.pr2.setContinue(false);
            this.pr2 = null;
        }
        try {
            if (this.pr3 == null || !this.pr3.isStarted()) {
                this.pr3 = null;
                this.pr3 = new processMsg(this);
                this.pr3.setContinue(true);
                this.pr3.start();
            }
        }
        catch (Exception c) {
            this.pr3.setContinue(false);
            this.pr3 = null;
        }
        try {
            if (this.pr4 == null || !this.pr4.isStarted()) {
                this.pr4 = null;
                this.pr4 = new processMsg(this);
                this.pr4.setContinue(true);
                this.pr4.start();
            }
        }
        catch (Exception c) {
            this.pr4.setContinue(false);
            this.pr4 = null;
        }
        try {
            if (this.pr5 == null || !this.pr5.isStarted()) {
                this.pr5 = null;
                this.pr5 = new processMsg(this);
                this.pr5.setContinue(true);
                this.pr5.start();
            }
        }
        catch (Exception c) {
            this.pr5.setContinue(false);
            this.pr5 = null;
        }
    }

    public void handleMessage(Message message) {
        debugLogger.debug((Object)"############# listened message on EmailQueue ##########");
        try {
            Long msgRcpntLogId = MsgQueueHelper.getMessageContent((Message)message);
            debugLogger.debug((Object)("EmailQueueListener #1 processing msgRcpntLogId :" + msgRcpntLogId));
            debugLogger.debug((Object)"EmailQueueListener #2 Building contents");
            MessageDTO messageDTO = this.msgContentBuilderService.buildContents(msgRcpntLogId, debugLogger, "EmailQueueListener");
            this.appendFooter(messageDTO);
            debugLogger.debug((Object)"EmailQueueListener #3 Sending email using AWS Mailer");
            EmailCredentialsDTO emialCredentialsDTO = this.gatewayCredentialsService.readEmailGatewayCredentials(messageDTO.getEventTriggerAcademyLocationId());
            String messageId = AWSMailSender.sendMail((MessageDTO)messageDTO, (EmailCredentialsDTO)emialCredentialsDTO, (String)this.keyId, (String)this.secretKey);
            debugLogger.debug((Object)"EmailQueueListener #4 FINISH");
            MsgRecipientLog msgRecipientLog = (MsgRecipientLog)this.msgRecipientLogService.findById(msgRcpntLogId);
            msgRecipientLog.setStatusCode(StatusCode.FINISH);
            msgRecipientLog.setMessageId(messageId);
            msgRecipientLog.setLastUpdate(new Date());
            this.msgRecipientLogService.update((Object)msgRecipientLog);
            debugLogger.debug((Object)(" Email EndDate " + new Date()));
        }
        catch (SendFailedException ex) {
            debugLogger.debug((Object)"EmailQueueListener #5 Invalid Addresses Exception occurred");
            ex.printStackTrace();
        }
        catch (MessagingException e1) {
            debugLogger.debug((Object)"EmailQueueListener #6 MessagingException occurred");
            e1.printStackTrace();
        }
        catch (NullPointerException ex) {
            debugLogger.debug((Object)" EmailQueueListener #7 Excetption occured");
            ex.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"CONFIGURATION_ERROR", null, (String)"EmailQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
        }
        catch (MessageCentralException ex) {
            ex.printStackTrace();
            debugLogger.debug((Object)" EmailQueueListener #8 Excetption occured");
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"EmailQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void appendFooter(MessageDTO messageDTO) {
        String footer = "<p style='color:#B8B8B8'><em>Sent By Academia</em></p><p>&nbsp;</p></body></html>";
        String content = messageDTO.getMessageContent();
        int lastIndex = content.lastIndexOf("</body>");
        if (lastIndex < 0) {
            lastIndex = content.lastIndexOf("</p>");
        }
        if (lastIndex != -1) {
            content = content.substring(0, lastIndex) + footer;
        }
        messageDTO.setMessageContent(content);
    }

    static /* synthetic */ String access$000(EmailQueueListener x0) {
        return x0.messagingConsolePrint;
    }

    static /* synthetic */ Logger access$100() {
        return DEBUGCOMMONLOGGER;
    }

    static /* synthetic */ Logger access$200() {
        return debugLogger;
    }

    static /* synthetic */ void access$300(EmailQueueListener x0, MessageDTO x1) {
        x0.appendFooter(x1);
    }

    static /* synthetic */ String access$400(EmailQueueListener x0) {
        return x0.keyId;
    }

    static /* synthetic */ String access$500(EmailQueueListener x0) {
        return x0.secretKey;
    }
}

