/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.dto.MessageDTO;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.LetterQueueHelper;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.service.MsgContentBuilderService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="letterQueueListener")
public class LetterQueueListener
implements MessageListener {
    private static Logger debugLogger = Logger.getLogger((String)"LetterQueueListenerLogger");
    @Value(value="${document.constant.letter.dir}")
    private String letterBaseDir;
    @Autowired
    MsgContentBuilderService msgContentBuilderService;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgErrorsService msgErrorsService;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"LetterQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        debugLogger.debug((Object)"############# listened message on LetterQueue ##########");
        MessageDTO messageDTO = null;
        try {
            Long msgRcpntLogId = MsgQueueHelper.getMessageContent((Message)message);
            debugLogger.debug((Object)("LetterQueueListener #1 Processing for msgRcpntLogId :" + msgRcpntLogId));
            debugLogger.debug((Object)"LetterQueueListener #2 Building Message Contents");
            messageDTO = this.msgContentBuilderService.buildContents(msgRcpntLogId, debugLogger, "LetterQueueListener");
            debugLogger.debug((Object)"LetterQueueListener #3 Generating Letter");
            LetterQueueHelper.generateLetter((MessageDTO)messageDTO, (String)this.letterBaseDir);
            debugLogger.debug((Object)"LetterQueueListener #4 Finish");
            MsgRecipientLog msgRecipientLog = (MsgRecipientLog)this.msgRecipientLogService.findById(msgRcpntLogId);
            msgRecipientLog.setStatusCode(StatusCode.FINISH);
            this.msgRecipientLogService.update((Object)msgRecipientLog);
        }
        catch (NullPointerException ex) {
            debugLogger.debug((Object)" LetterQueueListener #5 Excetption occured");
            ex.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"CONFIGURATION_ERROR", null, (String)"LetterQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (MessageCentralException ex) {
            debugLogger.debug((Object)" LetterQueueListener #6 Excetption occured");
            ex.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"LetterQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (Exception e1) {
            debugLogger.debug((Object)"LetterQueueListener #7 Exception Occured \n");
            e1.printStackTrace();
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

