/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.entity.MsgDeliveryModeLog;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgEventConfig;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.entity.MsgTemplateConfig;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgLogHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.helper.RabbitMQHelper;
import in.serosoft.messaging.service.MsgDeliveryModeLogService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgEventConfigService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgTemplateConfigService;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="msgLogQueueListener")
public class MsgLogQueueListener
implements MessageListener {
    private static Logger debugLogger = Logger.getLogger((String)"MsgLogQueueListenerLogger");
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    MsgEventConfigService msgEventConfigService;
    @Autowired
    MsgTemplateConfigService msgTemplateConfigService;
    @Autowired
    MsgDeliveryModeLogService msgDeliveryModeLogService;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"MsgLogQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        debugLogger.debug((Object)"############# listened message on MsgLogQueue ##########");
        Long msgLogId = MsgQueueHelper.getMessageContent((Message)message);
        DEBUGCOMMONLOGGER.debug((Object)("###### listened message on MsgLogQueue ###### " + msgLogId));
        try {
            MsgLog msgLog = (MsgLog)this.msgLogService.findById(msgLogId);
            debugLogger.debug((Object)(" MsgLogQueueListener #1 Read msgLog  record : msgLogId" + msgLog.getId()));
            MsgEventConfig msgEventConfig = (MsgEventConfig)this.msgEventConfigService.findById(msgLog.getMsgEventConfig().getId());
            debugLogger.debug((Object)(" MsgLogQueueListener #2 Read msgEventConfig  record : msgEventConfigId" + msgEventConfig.getId()));
            List msgRecipientTypeLogs = MsgLogHelper.buildMsgRcpntTypeLogs((MsgLog)msgLog, (MsgEventConfig)msgEventConfig);
            debugLogger.debug((Object)(" MsgLogQueueListener #3 build MsgRcpntType Logs. (size) : " + msgRecipientTypeLogs.size()));
            DEBUGCOMMONLOGGER.debug((Object)(" MsgLogQueueListener #2 & #3 Read msgEventConfig  record : msgEventConfigId" + msgEventConfig.getId() + " MsgRcpntType Logs. (size) : " + msgRecipientTypeLogs.size()));
            debugLogger.debug((Object)" MsgLogQueueListener #4 creating msgRcpntTypeLog for each rcpnt type");
            for (MsgRecipientTypeLog msgRecipientTypeLog : msgRecipientTypeLogs) {
                Long msgRcpntTypeLogId = this.msgRecipientTypeLogService.create((Object)msgRecipientTypeLog);
                debugLogger.debug((Object)(" MsgLogQueueListener #4.1 created msgRcpntTypeLog for rcpnt type log  id : " + msgRcpntTypeLogId));
                MsgTemplateConfig msgTemplateConfig = (MsgTemplateConfig)this.msgTemplateConfigService.findById(msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgTemplateConfig().getId());
                debugLogger.debug((Object)(" MsgLogQueueListener #4.2 read msgTemplateConfig for rcpnt type. id  : " + msgTemplateConfig.getId()));
                debugLogger.debug((Object)" MsgLogQueueListener #4.3 creating MsgDeliveryModeLogs for given rcpntType");
                List modeLogs = MsgLogHelper.createMsgDeliveryModeLogRecords((MsgRecipientTypeLog)msgRecipientTypeLog, (MsgTemplateConfig)msgTemplateConfig);
                for (MsgDeliveryModeLog msgDeliveryModeLog : modeLogs) {
                    this.msgDeliveryModeLogService.create((Object)msgDeliveryModeLog);
                    debugLogger.debug((Object)(" MsgLogQueueListener #4.3.1 created MsgDeliveryModeLog for given rcpntType for mode :" + msgDeliveryModeLog.getMsgDeliveryMode().getCode()));
                }
                debugLogger.debug((Object)(" MsgLogQueueListener #5   Pushing to MessageRecipientType Log Queue msgRcpntTypeLogId=" + msgRcpntTypeLogId));
                this.messageQueueTemplate.convertAndSend("MsgReceipntTypeLogQueue", (Object)msgRcpntTypeLogId);
                debugLogger.debug((Object)(" MsgLogQueueListener #6   Pushed to MessageRecipientType Log Queue msgRcpntTypeLogId=" + msgRcpntTypeLogId));
                DEBUGCOMMONLOGGER.debug((Object)(" MsgLogQueueListener #4.1 created msgRcpntTypeLog for rcpnt type log  id : " + msgRcpntTypeLogId + " msgTemplateConfig " + msgTemplateConfig.getId() + " modeLogs " + modeLogs.size()));
            }
            msgLog.setStatusCode(StatusCode.FINISH);
            this.msgLogService.update((Object)msgLog);
            debugLogger.debug((Object)(" MsgLogQueueListener #7  Updated MsgLog status to finish. msgLogId : " + msgLog.getId()));
            DEBUGCOMMONLOGGER.debug((Object)("MsgLogQueueListener #7  Updated MsgLog status to finish. msgLogId : " + msgLog.getId()));
        }
        catch (MessageCentralException ex) {
            debugLogger.debug((Object)" MsgLogQueueListener #8 Excetption occured");
            DEBUGCOMMONLOGGER.debug((Object)(" MsgLogQueueListener #8 Excetption occured" + ex.getMessage()));
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"MsgLogQueue", (Long)msgLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (AmqpAuthenticationException | AmqpConnectException | AmqpIOException ex) {
            debugLogger.debug((Object)" MsgLogQueueListener #9 Excetption occured");
            DEBUGCOMMONLOGGER.debug((Object)(" MsgLogQueueListener #9 Excetption occured" + ex.getMessage()));
            String errorcode = RabbitMQHelper.findRabitMqErrorCode((AmqpException)ex);
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)errorcode, null, (String)"MsgLogQueue", (Long)msgLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (NullPointerException ex) {
            debugLogger.debug((Object)" MsgLogQueueListener #10 Excetption occured");
            DEBUGCOMMONLOGGER.debug((Object)(" MsgLogQueueListener #10 Excetption occured" + ex.getMessage()));
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"MsgLogQueue", (Long)msgLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

