/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.helper.RabbitMQHelper;
import in.serosoft.messaging.service.AdhocMsgDynamicAttachmentService;
import in.serosoft.messaging.service.AdhocMsgEventConfigService;
import in.serosoft.messaging.service.AdhocRecipientsService;
import in.serosoft.messaging.service.DataProviderEvaluationService;
import in.serosoft.messaging.service.MsgDeliveryModeLogService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgEventConfigService;
import in.serosoft.messaging.service.MsgRcpntTypeLogQueueService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="msgRcpntTypeLogQueueListener")
public class MsgRcpntTypeLogQueueListener
implements MessageListener {
    private static final Logger debugLogger = Logger.getLogger((String)"MsgRcpntTypeLogQueueListenerLogger");
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    MsgDeliveryModeLogService msgDeliveryModeLogService;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    DataProviderEvaluationService dataProviderEvaluationService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Autowired
    AdhocMsgEventConfigService adhocMsgEventConfigService;
    @Autowired
    AdhocRecipientsService adhocRecipientsService;
    @Autowired
    MsgEventConfigService msgEventConfigService;
    @Autowired
    AdhocMsgDynamicAttachmentService adhocMsgDynamicAttachmentService;
    @Autowired
    MsgRcpntTypeLogQueueService msgRcpntTypeLogQueueService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"MsgReceipntTypeLogQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        Long msgRcpntTypeLogId = MsgQueueHelper.getMessageContent((Message)message);
        debugLogger.debug((Object)(" MsgRcpntTypeLogQueueListener #1 read log id on queue msgRcpntTypeLogId:" + msgRcpntTypeLogId));
        DEBUGCOMMONLOGGER.debug((Object)("######listened message on MsgRcpntTypeLogQueueListener ###### msgRcpntTypeLogId" + msgRcpntTypeLogId));
        try {
            MsgRecipientTypeLog msgRecipientTypeLog = (MsgRecipientTypeLog)this.msgRecipientTypeLogService.findById(msgRcpntTypeLogId);
            debugLogger.debug((Object)(" MsgRcpntTypeLogQueueListener #2 read log record. msgRcpntTypeLogId:" + msgRecipientTypeLog.getId()));
            Map msgContextMap = this.msgRuleEvaluationService.buildMessageContextMap(msgRecipientTypeLog);
            debugLogger.debug((Object)(" MsgRcpntTypeLogQueueListener #3 build msgContextMap (size):" + msgContextMap.size()));
            Map distributionListWithContextData = this.msgRcpntTypeLogQueueService.buildDistributionListWithExtraDetails(msgRecipientTypeLog, msgContextMap);
            debugLogger.debug((Object)(" MsgRcpntTypeLogQueueListener #4 buildDistributionList With Extra recipient Details (size)" + distributionListWithContextData.size()));
            List receipientIds = new ArrayList();
            receipientIds.addAll(distributionListWithContextData.keySet());
            debugLogger.debug((Object)(" MsgRcpntTypeLogQueueListener #5 found recipients (SIZE) : " + receipientIds.size()));
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #6.1 evaluating distribution rule for recipeints");
            receipientIds = this.msgRcpntTypeLogQueueService.evaluateDistributionRule(msgRecipientTypeLog, msgContextMap);
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #6.2 evaluated distribution rule for recipeints");
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #7 checking if recipeints found after distribution rule");
            DEBUGCOMMONLOGGER.debug((Object)(" MsgRcpntTypeLogQueueListener #1 checking if recipeints found after distribution rule " + receipientIds.size() + " distributionListWithContextData" + distributionListWithContextData.size()));
            if (receipientIds.size() == 0 && !msgRecipientTypeLog.getMsgRecipientType().getCode().equals("AdhocRecipients")) {
                debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #8 No recipeints found after distribution rule. Logging error & Exit");
                MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"NO_RECIPIENT_FOUND", null, (String)"MsgReceipntTypeLogQueue", (Long)msgRcpntTypeLogId);
                this.msgErrorsService.create((Object)msgErrors);
                return;
            }
            debugLogger.debug((Object)(" MsgRcpntTypeLogQueueListener #9  recipeints found after distribution rule. (SIZE) :" + receipientIds.size()));
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #10  Reading Recipients Data ");
            List adhocRecipients = null;
            List recepients = null;
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #10.1 check if  AdhocRecipients  ");
            if (msgRecipientTypeLog.getMsgRecipientType().getCode().equals("AdhocRecipients")) {
                Long msgEventConfigId = msgRecipientTypeLog.getMsgLog().getMsgEventConfig().getId();
                adhocRecipients = this.adhocRecipientsService.findAllByMsgEventConfigId(msgEventConfigId);
                debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #10.2 read AdhocRecipients data  ");
            } else {
                debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #10.3 system User recipient. Reading data");
                recepients = this.msgRcpntTypeLogQueueService.readRecipientsBasicDetails(msgRecipientTypeLog, receipientIds);
                debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #10.4 read recipient data  ");
            }
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #11 build MsgRecipientLogs");
            List msgRecipientLogs = this.msgRcpntTypeLogQueueService.buildAndCreateMsgRecipientLogs(msgRecipientTypeLog, recepients, adhocRecipients, distributionListWithContextData);
            System.out.println("write on msg sent report..." + new Date());
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #12 publishToNextQueue");
            this.msgRcpntTypeLogQueueService.publishToNextQueue(msgRecipientTypeLog, msgRecipientLogs);
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #13 updating msgRecipientTypeLog status");
            msgRecipientTypeLog.setStatusCode(StatusCode.FINISH);
            this.msgRecipientTypeLogService.update((Object)msgRecipientTypeLog);
            debugLogger.debug((Object)" MsgRcpntTypeLogQueueListener #14 updated msgRecipientTypeLog status to FINISH");
            DEBUGCOMMONLOGGER.debug((Object)(" MsgRcpntTypeLogQueueListener #3 build MsgRecipientLogs & Finish " + msgRecipientLogs.size()));
        }
        catch (MessageCentralException ex) {
            debugLogger.debug((Object)" MsgLogQueueListener #15 Excetption occured");
            DEBUGCOMMONLOGGER.debug((Object)(" MsgLogQueueListener #4 Excetption occured" + ex.getMessage()));
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"MsgReceipntTypeLogQueue", (Long)msgRcpntTypeLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (AmqpAuthenticationException | AmqpConnectException | AmqpIOException ex) {
            debugLogger.debug((Object)" MsgLogQueueListener #16 Excetption occured");
            DEBUGCOMMONLOGGER.debug((Object)(" MsgLogQueueListener #5 Excetption occured" + ex.getMessage()));
            String errorcode = RabbitMQHelper.findRabitMqErrorCode((AmqpException)ex);
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)errorcode, null, (String)"MsgReceipntTypeLogQueue", (Long)msgRcpntTypeLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (NullPointerException ex) {
            debugLogger.debug((Object)" MsgLogQueueListener #17 Excetption occured");
            DEBUGCOMMONLOGGER.debug((Object)(" MsgLogQueueListener #6 NullPointerException occured" + ex.getMessage()));
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"CONFIGURATION_ERROR", null, (String)"MsgReceipntTypeLogQueue", (Long)msgRcpntTypeLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

