/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.cb.model.ResultDocument;
import in.serosoft.messaging.dto.MessageDTO;
import in.serosoft.messaging.entity.MsgDeliveryMode;
import in.serosoft.messaging.entity.MsgDeliveryModeLog;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.entity.MsgTemplate;
import in.serosoft.messaging.entity.MsgTemplateConfig;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.MsgContentBuilderHelper;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.helper.MsgRcpntTypeQueueHelper;
import in.serosoft.messaging.helper.MsgRcpntsQueueHelper;
import in.serosoft.messaging.helper.RabbitMQHelper;
import in.serosoft.messaging.service.DataProviderEvaluationService;
import in.serosoft.messaging.service.MsgDeliveryModeLogService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.MsgTemplateConfigService;
import in.serosoft.messaging.service.MsgTemplateService;
import in.serosoft.messaging.service.TemplateConfigDocumentsService;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="msgRcpntsQueueListener")
public class MsgRcpntsQueueListener
implements MessageListener {
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    MsgTemplateConfigService msgTemplateConfigService;
    @Autowired
    MsgDeliveryModeLogService msgDeliveryModeLogService;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    DataProviderEvaluationService dataProviderEvaluationService;
    @Autowired
    MsgTemplateService msgTemplateService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    TemplateConfigDocumentsService templateConfigDocumentsService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"MsgReceipntsQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        DEBUGCOMMONLOGGER.debug((Object)"###### listened message on MsgReceipntsQueueListner ######");
        Long msgDeliveryLogId = MsgQueueHelper.getMessageContent((Message)message);
        try {
            MsgDeliveryModeLog msgDeliveryModeLog = (MsgDeliveryModeLog)this.msgDeliveryModeLogService.findById(msgDeliveryLogId);
            MsgRecipientTypeLog msgRecipientTypeLog = (MsgRecipientTypeLog)this.msgRecipientTypeLogService.findById(msgDeliveryModeLog.getMsgRecipientTypeLog().getId());
            MsgLog msgLog = (MsgLog)this.msgLogService.findById(msgRecipientTypeLog.getMsgLog().getId());
            List msgRecipientLogs = this.msgRecipientLogService.findAllByRcpntTypeAndDeliveryMode(msgRecipientTypeLog.getId(), msgDeliveryModeLog.getMsgDeliveryMode().getId());
            DEBUGCOMMONLOGGER.debug((Object)("MsgReceipntsQueueListner #1 msgRecipientLogs (Size) " + msgRecipientLogs.size()));
            if (msgRecipientTypeLog.getMsgRecipientType().getCode().equals("AdhocRecipients")) {
                MsgTemplateConfig msgTemplateConfig = (MsgTemplateConfig)this.msgTemplateConfigService.findById(msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgTemplateConfig().getId());
                this.templateConfigDocumentsService.findByMsgTemplateConfigId(msgTemplateConfig.getId());
                List attachmentsPaths = MsgRcpntTypeQueueHelper.readAttachment();
                MsgDeliveryMode deliveryMode = msgDeliveryModeLog.getMsgDeliveryMode();
                MsgTemplate msgTemplate = this.msgTemplateService.findByMsgTemplateCnfgAndMode(msgTemplateConfig.getId(), deliveryMode.getId());
                String queueName = MsgRcpntsQueueHelper.findQueueNameForDeliveryMode((String)deliveryMode.getCode());
                DEBUGCOMMONLOGGER.debug((Object)("MsgReceipntsQueueListner #2 msgTemplateConfig " + queueName + " " + msgTemplateConfig.getId()));
                for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                    MessageDTO messageDTO = MsgContentBuilderHelper.buildAdhocRecipientsMessageDTO((MsgTemplate)msgTemplate, (MsgRecipientTypeLog)msgRecipientTypeLog, (MsgRecipientLog)msgRecipientLog, (List)attachmentsPaths, (MsgTemplateConfig)msgTemplateConfig);
                    messageDTO.setMsgLogId(msgLog.getId());
                    this.messageQueueTemplate.convertAndSend(queueName, (Object)messageDTO);
                }
                return;
            }
            List receipientIds = MsgRcpntsQueueHelper.buildRecepientsList((List)msgRecipientLogs);
            List recipientsData = this.dataProviderEvaluationService.readRecipientsData(msgRecipientTypeLog, receipientIds);
            DEBUGCOMMONLOGGER.debug((Object)("MsgReceipntsQueueListener #3 recipientsData (Size) " + recipientsData.size()));
            Map msgContextMap = this.msgRuleEvaluationService.buildMessageContextMap(msgRecipientTypeLog);
            msgContextMap.put(4L, receipientIds);
            MsgTemplateConfig msgTemplateConfig = (MsgTemplateConfig)this.msgTemplateConfigService.findById(msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgTemplateConfig().getId());
            ResultDocument templateData = this.dataProviderEvaluationService.readTemplateData(msgTemplateConfig, msgContextMap);
            this.templateConfigDocumentsService.findByMsgTemplateConfigId(msgTemplateConfig.getId());
            List attachmentsPaths = MsgRcpntTypeQueueHelper.readAttachment();
            DEBUGCOMMONLOGGER.debug((Object)("MsgReceipntsQueueListener #4 Read Attachments Size " + attachmentsPaths.size()));
            MsgDeliveryMode deliveryMode = msgDeliveryModeLog.getMsgDeliveryMode();
            MsgTemplate msgTemplate = this.msgTemplateService.findByMsgTemplateCnfgAndMode(msgTemplateConfig.getId(), deliveryMode.getId());
            String queueName = MsgRcpntsQueueHelper.findQueueNameForDeliveryMode((String)deliveryMode.getCode());
            DEBUGCOMMONLOGGER.debug((Object)("MsgReceipntsQueueListener #5 buildContents & push to respective delivery mode queue " + queueName + " msgTemplateConfig " + msgTemplateConfig.getId()));
            for (ResultDocument recepientData : recipientsData) {
                MessageDTO messageDTO = MsgContentBuilderHelper.buildMessageDTO((MsgDeliveryMode)deliveryMode, (MsgTemplate)msgTemplate, (ResultDocument)recepientData, (ResultDocument)templateData, (MsgRecipientTypeLog)msgRecipientTypeLog, (List)msgRecipientLogs, (List)attachmentsPaths, (MsgTemplateConfig)msgTemplateConfig);
                messageDTO.setMsgLogId(msgLog.getId());
                this.messageQueueTemplate.convertAndSend(queueName, (Object)messageDTO);
            }
        }
        catch (MessageCentralException ex) {
            DEBUGCOMMONLOGGER.debug((Object)("MsgReceipntsQueueListener #6 MessageCentralException " + ex.getMessage()));
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"MsgReceipntsQueue", (Long)msgDeliveryLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (AmqpAuthenticationException | AmqpConnectException | AmqpIOException ex) {
            DEBUGCOMMONLOGGER.debug((Object)("MsgReceipntsQueueListener #7 Exception " + ex.getMessage()));
            String errorcode = RabbitMQHelper.findRabitMqErrorCode((AmqpException)ex);
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)errorcode, null, (String)"MsgReceipntsQueue", (Long)msgDeliveryLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (NullPointerException ex) {
            DEBUGCOMMONLOGGER.debug((Object)("MsgReceipntsQueueListener #8 NullPointerException " + ex.getMessage()));
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"CONFIGURATION_ERROR", null, (String)"MsgReceipntsQueue", (Long)msgDeliveryLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

