/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.listener.PushNotificationQueueListener;
import in.serosoft.messaging.service.DataProviderEvaluationService;
import in.serosoft.messaging.service.GatewayCredentialsService;
import in.serosoft.messaging.service.MsgContentBuilderService;
import in.serosoft.messaging.service.MsgDeliveryModeLogService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.MsgTemplateConfigService;
import in.serosoft.messaging.service.MsgTemplateService;
import in.serosoft.messaging.service.TemplateConfigDocumentsService;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="pushNotificationQueueListener")
public class PushNotificationQueueListener
implements MessageListener {
    private static Logger debugLogger = Logger.getLogger((String)"PushNotificationQueueListenerLogger");
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    GatewayCredentialsService gatewayCredentialsService;
    @Autowired
    MsgDeliveryModeLogService msgDeliveryModeLogService;
    @Autowired
    DataProviderEvaluationService dataProviderEvaluationService;
    @Autowired
    MsgTemplateService msgTemplateService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    TemplateConfigDocumentsService templateConfigDocumentsService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Autowired
    MsgTemplateConfigService messageTemplateConfigService;
    @Autowired
    MsgContentBuilderService msgContentBuilderService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    public static ConcurrentLinkedQueue<Message> queueList = new ConcurrentLinkedQueue();
    processMsg pr1;
    processMsg pr2;
    processMsg pr3;
    processMsg pr4;
    processMsg pr5;

    public void onMessage(Message message) {
        try {
            this.checkAndStartThreads();
            queueList.add(message);
            Thread.sleep(300L);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"EmailQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void checkAndStartThreads() {
        try {
            if (this.pr1 == null || !this.pr1.isStarted()) {
                this.pr1 = null;
                this.pr1 = new processMsg(this);
                this.pr1.setContinue(true);
                this.pr1.start();
            }
        }
        catch (Exception c) {
            this.pr1.setContinue(false);
            this.pr1 = null;
        }
        try {
            if (this.pr2 == null || !this.pr2.isStarted()) {
                this.pr2 = null;
                this.pr2 = new processMsg(this);
                this.pr2.setContinue(true);
                this.pr2.start();
            }
        }
        catch (Exception c) {
            this.pr2.setContinue(false);
            this.pr2 = null;
        }
        try {
            if (this.pr3 == null || !this.pr3.isStarted()) {
                this.pr3 = null;
                this.pr3 = new processMsg(this);
                this.pr3.setContinue(true);
                this.pr3.start();
            }
        }
        catch (Exception c) {
            this.pr3.setContinue(false);
            this.pr3 = null;
        }
        try {
            if (this.pr4 == null || !this.pr4.isStarted()) {
                this.pr4 = null;
                this.pr4 = new processMsg(this);
                this.pr4.setContinue(true);
                this.pr4.start();
            }
        }
        catch (Exception c) {
            this.pr4.setContinue(false);
            this.pr4 = null;
        }
        try {
            if (this.pr5 == null || !this.pr5.isStarted()) {
                this.pr5 = null;
                this.pr5 = new processMsg(this);
                this.pr5.setContinue(true);
                this.pr5.start();
            }
        }
        catch (Exception c) {
            this.pr5.setContinue(false);
            this.pr5 = null;
        }
    }

    static /* synthetic */ String access$000(PushNotificationQueueListener x0) {
        return x0.messagingConsolePrint;
    }

    static /* synthetic */ Logger access$100() {
        return debugLogger;
    }
}

