/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.cb.model.CBSearchResult;
import in.serosoft.cb.model.ResultDocument;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgEventConfig;
import in.serosoft.messaging.entity.MsgInitRuleConfig;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.ScheduleMessageEventLog;
import in.serosoft.messaging.entity.SysMsgEvtDefaultConfig;
import in.serosoft.messaging.entity.SystemMsgEvent;
import in.serosoft.messaging.entity.SystemMsgEventConfig;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgLogHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgEventScopeService;
import in.serosoft.messaging.service.MsgInitRuleConfigService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.RepeatitionEventService;
import in.serosoft.messaging.service.ScheduleMessageEventLogService;
import in.serosoft.messaging.service.SysMsgEvtDefaultConfigService;
import in.serosoft.messaging.service.SystemMsgEventService;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="scheduleMsgEvtLogQueueListener")
public class ScheduleMsgEvtLogQueueListener
implements MessageListener {
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    MsgInitRuleConfigService msgInitRuleConfigService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    SysMsgEvtDefaultConfigService sysMsgEvtDefaultConfigService;
    @Autowired
    ScheduleMessageEventLogService scheduleMessageEventLogService;
    @Autowired
    MsgEventScopeService msgEventScopeService;
    @Autowired
    RepeatitionEventService repeatitionEventService;
    @Autowired
    SystemMsgEventService systemMsgEventService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"ScheduleMsgEvtLogQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        DEBUGCOMMONLOGGER.debug((Object)"###### listened message on ScheduleMessageEventLogListener ######");
        Long scheduleMessageEventLogId = MsgQueueHelper.getMessageContent((Message)message);
        ScheduleMessageEventLog scheduleMessageEventLog = (ScheduleMessageEventLog)this.scheduleMessageEventLogService.findById(scheduleMessageEventLogId);
        SystemMsgEventConfig systemMsgEventConfig = scheduleMessageEventLog.getSystemMsgEventConfig();
        SystemMsgEvent systemMsgEvent = (SystemMsgEvent)this.systemMsgEventService.findById(systemMsgEventConfig.getSystemMsgEvent().getId());
        SysMsgEvtDefaultConfig sysMsgEvtDefaultConfig = this.sysMsgEvtDefaultConfigService.findByEventId(systemMsgEvent.getId());
        Map eventContextScopeParamMap = MsgLogHelper.buildEventContextScopeParamMap((MsgEventConfig)systemMsgEventConfig, (ScheduleMessageEventLog)scheduleMessageEventLog);
        MsgInitRuleConfig msgInitRuleConfig = (MsgInitRuleConfig)this.msgInitRuleConfigService.findById(systemMsgEventConfig.getMsgInitRuleConfig().getId());
        List msgEventScopes = this.msgEventScopeService.findByMsgEventConfigId(systemMsgEventConfig.getId());
        Map msginitRuleContextMap = MsgLogHelper.buildInitRuleContextMap((SysMsgEvtDefaultConfig)sysMsgEvtDefaultConfig, (Map)eventContextScopeParamMap, (List)msgEventScopes);
        Boolean whetherToProceed = true;
        if (systemMsgEvent.getWhetherInitiationRuleApplicable().booleanValue()) {
            whetherToProceed = this.evaluateInitiationRule(eventContextScopeParamMap, msgInitRuleConfig, msginitRuleContextMap);
        }
        DEBUGCOMMONLOGGER.debug((Object)("ScheduleMessageEventLog  ID " + scheduleMessageEventLogId + " systemMsgEvent " + systemMsgEvent.getId() + " whetherToProceed " + whetherToProceed));
        if (whetherToProceed.booleanValue()) {
            MsgLog msgLog = MsgLogHelper.buildMsgLogRecord((MsgEventConfig)systemMsgEventConfig, (SysMsgEvtDefaultConfig)sysMsgEvtDefaultConfig, (Map)eventContextScopeParamMap);
            msgLog.setScheduleMessageEventLog(scheduleMessageEventLog);
            Long msgLogId = this.msgLogService.create((Object)msgLog);
            this.messageQueueTemplate.convertAndSend("MsgLogQueue", (Object)msgLogId);
            if (systemMsgEvent.getWhetherRepetationApplicable().booleanValue()) {
                this.repeatitionEventService.repeat(systemMsgEventConfig, msgLog, "SCHEDULED");
            }
            scheduleMessageEventLog.setStatusCode(StatusCode.FINISH);
            this.scheduleMessageEventLogService.update((Object)scheduleMessageEventLog);
            DEBUGCOMMONLOGGER.debug((Object)("ScheduleMessageEventLog Finish & msgLogId " + msgLogId + " scheduleMessageEventLog " + scheduleMessageEventLog.getId()));
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            DEBUGCOMMONLOGGER.debug((Object)("ScheduleMessageEventLogQueueListener " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private Boolean evaluateInitiationRule(Map<String, String> eventContextScopeParamMap, MsgInitRuleConfig msgInitRuleConfig, Map<Long, Object> msginitRuleContextMap) {
        CBSearchResult cbSearchResult = this.msgRuleEvaluationService.evaluateRule(msgInitRuleConfig, msginitRuleContextMap);
        String ctxRecordIds = this.buildContextRecordIds(cbSearchResult);
        if (ctxRecordIds != null) {
            eventContextScopeParamMap.put("CONTEXT_RECORD_ID", ctxRecordIds);
            return true;
        }
        return false;
    }

    private String buildContextRecordIds(CBSearchResult cbSearchResult) {
        List resultRecords = cbSearchResult.getResultDocuments();
        String ctxRecordIds = "";
        if (resultRecords.size() > 0) {
            for (ResultDocument resultDocument : resultRecords) {
                ctxRecordIds = ctxRecordIds + resultDocument.get((Object)"ID").toString() + ",";
            }
            ctxRecordIds = ctxRecordIds.substring(0, ctxRecordIds.length() - 1);
            return ctxRecordIds;
        }
        return null;
    }
}

