/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.model.SystemScheduledEventModel;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.SchedulerService;
import in.serosoft.messaging.service.SystemMsgEventConfigService;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="scheduleMsgQueueListener")
public class ScheduleMsgQueueListener
implements MessageListener {
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    SchedulerService schedulerService;
    @Autowired
    SystemMsgEventConfigService systemMsgEventConfigService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"ScheduleMsgQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            System.out.println("############# listened message on ScheduledMsgEventQueue ##########");
        }
        DEBUGCOMMONLOGGER.debug((Object)"######listened message on ScheduledMsgEventQueueListener ######");
        try {
            SystemScheduledEventModel scheduledEventModel = MsgQueueHelper.getSystemScheduledEventModel((Message)message);
            if (scheduledEventModel.getAction() != null && scheduledEventModel.getAction().equals("SCHEDULE")) {
                this.schedulerService.addTrigger(scheduledEventModel.getEventCode(), scheduledEventModel.getCronExpression(), scheduledEventModel.getSystemMessageEventconfigId(), "ScheduledEventJob");
                DEBUGCOMMONLOGGER.debug((Object)("SCHEDULE ScheduledMsgEventQueueListener" + scheduledEventModel.getEventCode()));
            } else if (scheduledEventModel.getAction() != null && scheduledEventModel.getAction().equals("UNSCHEDULE")) {
                this.schedulerService.removeTrigger(scheduledEventModel.getEventCode());
                DEBUGCOMMONLOGGER.debug((Object)("UNSCHEDULE ScheduledMsgEventQueueListener" + scheduledEventModel.getEventCode()));
            }
        }
        catch (ClassNotFoundException e1) {
            DEBUGCOMMONLOGGER.debug((Object)("ScheduledMsgEventQueueListener " + e1.getMessage()));
            e1.printStackTrace();
        }
        catch (IOException e1) {
            DEBUGCOMMONLOGGER.debug((Object)("ScheduledMsgEventQueueListener " + e1.getMessage()));
            e1.printStackTrace();
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            DEBUGCOMMONLOGGER.debug((Object)("ScheduledMsgEventQueueListener " + e.getMessage()));
            e.printStackTrace();
        }
    }
}

