/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.dto.MessageDTO;
import in.serosoft.messaging.dto.SmsCredentialsDTO;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.listener.SmsQueueListener;
import in.serosoft.messaging.service.GatewayCredentialsService;
import in.serosoft.messaging.service.MsgContentBuilderService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.utility.Gateway4SMSUtil;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="smsQueueListener")
public class SmsQueueListener
implements MessageListener {
    private static final Logger debugLogger = Logger.getLogger((String)"SmsQueueListenerLogger");
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    GatewayCredentialsService gatewayCredentialsService;
    @Autowired
    MsgContentBuilderService msgContentBuilderService;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${msg.sms.username}")
    private String username;
    @Value(value="${msg.sms.password}")
    private String password;
    @Value(value="${msg.sms.api_password}")
    private String api_password;
    @Value(value="${msg.sms.senderId}")
    private String senderId;
    @Value(value="${msg.sms.reqUrl1}")
    private String reqUrl;
    @Value(value="${msg.sms.route}")
    private String route;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    public static ConcurrentLinkedQueue<Message> queueList = new ConcurrentLinkedQueue();
    processMsg pr1;
    processMsg pr2;
    processMsg pr3;
    processMsg pr4;
    processMsg pr5;

    public void onMessage(Message message) {
        try {
            this.checkAndStartThreads();
            queueList.add(message);
            Thread.sleep(300L);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"ScheduleMsgQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void checkAndStartThreads() {
        try {
            if (this.pr1 == null || !this.pr1.isStarted()) {
                this.pr1 = null;
                this.pr1 = new processMsg(this);
                this.pr1.setContinue(true);
                this.pr1.start();
            }
        }
        catch (Exception c) {
            this.pr1.setContinue(false);
            this.pr1 = null;
        }
        try {
            if (this.pr2 == null || !this.pr2.isStarted()) {
                this.pr2 = null;
                this.pr2 = new processMsg(this);
                this.pr2.setContinue(true);
                this.pr2.start();
            }
        }
        catch (Exception c) {
            this.pr2.setContinue(false);
            this.pr2 = null;
        }
        try {
            if (this.pr3 == null || !this.pr3.isStarted()) {
                this.pr3 = null;
                this.pr3 = new processMsg(this);
                this.pr3.setContinue(true);
                this.pr3.start();
            }
        }
        catch (Exception c) {
            this.pr3.setContinue(false);
            this.pr3 = null;
        }
        try {
            if (this.pr4 == null || !this.pr4.isStarted()) {
                this.pr4 = null;
                this.pr4 = new processMsg(this);
                this.pr4.setContinue(true);
                this.pr4.start();
            }
        }
        catch (Exception c) {
            this.pr4.setContinue(false);
            this.pr4 = null;
        }
        try {
            if (this.pr5 == null || !this.pr5.isStarted()) {
                this.pr5 = null;
                this.pr5 = new processMsg(this);
                this.pr5.setContinue(true);
                this.pr5.start();
            }
        }
        catch (Exception c) {
            this.pr5.setContinue(false);
            this.pr5 = null;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        debugLogger.debug((Object)"############# listened message on SmsQueue ##########");
        MessageDTO messageDTO = null;
        try {
            Long msgRcpntLogId = MsgQueueHelper.getMessageContent((Message)message);
            debugLogger.debug((Object)("SmsQueueListener #1  processing msgRcpntLogId :" + msgRcpntLogId));
            debugLogger.debug((Object)"SmsQueueListener #2 Building message contents");
            messageDTO = this.msgContentBuilderService.buildContents(msgRcpntLogId, debugLogger, "SmsQueueListener");
            debugLogger.debug((Object)"SmsQueueListener #3 Sending sms via Gateway4SMSUtil");
            if (messageDTO.getMsgRecipientLogId() != null) {
                SmsCredentialsDTO smsCredentialsDTO = this.gatewayCredentialsService.readSmsGatewayCredentials(messageDTO.getEventTriggerAcademyLocationId());
                String messageContent = messageDTO.getMessageContent().replaceAll("\u00a0", " ");
                messageContent = messageContent.replace("\u00c2", " ");
                messageContent = messageContent.replace("\u00e2", " ");
                String response = null;
                response = smsCredentialsDTO.getIsCountryCode().booleanValue() && smsCredentialsDTO.getIsCountryCode() != null ? (messageDTO.getCountryCode() != null ? Gateway4SMSUtil.sendsms((String)(messageDTO.getCountryCode() + "" + messageDTO.getContact()), (SmsCredentialsDTO)smsCredentialsDTO, (String)messageContent) : Gateway4SMSUtil.sendsms((String)messageDTO.getContact(), (SmsCredentialsDTO)smsCredentialsDTO, (String)messageContent)) : Gateway4SMSUtil.sendsms((String)messageDTO.getContact(), (SmsCredentialsDTO)smsCredentialsDTO, (String)messageContent);
                debugLogger.debug((Object)"SmsQueueListener #4 FINISH");
                MsgRecipientLog msgRecipientLog = (MsgRecipientLog)this.msgRecipientLogService.findById(msgRcpntLogId);
                msgRecipientLog.setStatusCode(StatusCode.FINISH);
                msgRecipientLog.setMsgContent(messageContent);
                msgRecipientLog.setLastUpdate(new Date());
                if (Gateway4SMSUtil.isError((String)response)) {
                    msgRecipientLog.setDeliveryStatus("FAILED");
                    msgRecipientLog.setMessageId(response);
                    msgRecipientLog.setFailureCode(response);
                } else {
                    msgRecipientLog.setStatusCode(StatusCode.FINISH);
                    msgRecipientLog.setMessageId(response);
                }
                this.msgRecipientLogService.update((Object)msgRecipientLog);
            }
        }
        catch (NullPointerException ex) {
            debugLogger.debug((Object)" SmsQueueListener #5 Excetption occured");
            ex.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"CONFIGURATION_ERROR", null, (String)"SMSQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
        }
        catch (MessageCentralException ex) {
            debugLogger.debug((Object)" SmsQueueListener #6 Excetption occured");
            ex.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"SMSQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
        }
        catch (Exception e1) {
            debugLogger.debug((Object)"SmsQueueListener #7 Exception Occured \n");
            e1.printStackTrace();
        }
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
    }

    static /* synthetic */ String access$000(SmsQueueListener x0) {
        return x0.messagingConsolePrint;
    }

    static /* synthetic */ Logger access$100() {
        return DEBUGCOMMONLOGGER;
    }

    static /* synthetic */ Logger access$200() {
        return debugLogger;
    }
}

