/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.file.handler.FileHandler;
import in.serosoft.messaging.dto.MessageDTO;
import in.serosoft.messaging.dto.RecepientInfoDTO;
import in.serosoft.messaging.dto.SystemInternalNotificationInfoDTO;
import in.serosoft.messaging.entity.MsgDocument;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgInbox;
import in.serosoft.messaging.entity.MsgRecipient;
import in.serosoft.messaging.entity.MsgRecipientDocuments;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.service.GatewayCredentialsService;
import in.serosoft.messaging.service.MsgContentBuilderService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgInboxService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientService;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="sysInternalMsgQueueListener")
public class SysInternalMsgQueueListener
implements MessageListener {
    private static Logger debugLogger = Logger.getLogger((String)"SysInternalMsgQueueListenerLogger");
    @Autowired
    FileHandler fileHandler;
    @Autowired
    MsgInboxService msgInboxService;
    @Autowired
    MsgRecipientService msgRecipientService;
    @Autowired
    MsgContentBuilderService msgContentBuilderService;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Autowired
    GatewayCredentialsService gatewayCredentialsService;
    @Value(value="${document.constant.base.dir}")
    private String baseDir;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"SysInternalMsgQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        debugLogger.debug((Object)"############# listened message on SysInternalMsgQueue ##########");
        MessageDTO messageDTO = null;
        try {
            RecepientInfoDTO recepientInfoDTO;
            Long msgRcpntLogId = MsgQueueHelper.getMessageContent((Message)message);
            debugLogger.debug((Object)("SysInternalMsgQueueListener #1 processing for msgRcpntLogId:" + msgRcpntLogId));
            debugLogger.debug((Object)"SysInternalMsgQueueListener #2 Building message contents");
            messageDTO = this.msgContentBuilderService.buildContents(msgRcpntLogId, debugLogger, "SysInternalMsgQueueListener");
            debugLogger.debug((Object)"SysInternalMsgQueueListener #3 Building Internal message record & persisiting in DB");
            MsgInbox msg = this.buildInternalMsg(messageDTO);
            MsgRecipientLog msgRecipientLog1 = (MsgRecipientLog)this.msgRecipientLogService.findById(msgRcpntLogId);
            String msgRecipientType = msgRecipientLog1.getMsgRecipientTypeLog().getMsgRecipientType().getCode();
            if (msgRecipientLog1.getMsgRecipientTypeLog() != null && msgRecipientLog1.getMsgRecipientTypeLog().getMsgEventRecipientConfig() != null && msgRecipientLog1.getMsgRecipientTypeLog().getMsgEventRecipientConfig().getMsgTemplateConfig() != null && msgRecipientLog1.getMsgRecipientTypeLog().getMsgEventRecipientConfig().getMsgTemplateConfig().getSystemMsgEvent() == null) {
                msg.setWhetherAdhoc(Boolean.TRUE);
            } else {
                msg.setWhetherAdhoc(Boolean.FALSE);
            }
            if (msgRecipientLog1.getUserType() != null) {
                msg.setUserType(msgRecipientLog1.getUserType());
            }
            if ("ADD_EXTERNAL_USER_RECIPIENT_INFO".equals(msgRecipientType) || "APPROVE_ADMISSION_APPLICANT_INFO".equals(msgRecipientType) || "Academy_Location_Expiry".equals(msgRecipientType) || "ACADEMY_LOCATION_PURPOSE_OWNER".equals(msgRecipientType) || "SUBMIT_APPLICATION_RECIPIENTS".equals(msgRecipientType) || "CREATE_ENQUIRY_VELOCITY_RECIPIENTS".equals(msgRecipientType) || "ADD_EXTERNAL_USER_VELOCITY_RECIPIENT_INFO".equals(msgRecipientType) || "COMPLETE_ADMISSION_VELOCITY_INFO".equals(msgRecipientType) || "MSG_COURSEWISE_WEEKLY_PARENT".equals(msgRecipientType) || "BULK_DOCUMENT_DOWNLOAD_RECIPIENT".equals(msgRecipientType) || "Fee Payer Adhoc".equals(msgRecipientType) || "Applicant Person Adhoc".equals(msgRecipientType) || "LEAVE_ESCALETED_APPROVER_RECIPIENT".equals(msgRecipientType) || "Enquirer".equals(msgRecipientType) || "OUTSTANDING_BILL_FP_REM_ON_DAY_S1_RCPNT".equals(msgRecipientType) || "OUTSTANDING_BILL_FP_REM_ON_DAY_S2_RCPNT".equals(msgRecipientType) || "OUTSTANDING_BILL_FP_REM_RCPNT".equals(msgRecipientType) || "OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_RCPNT".equals(msgRecipientType) || "ENQUIRY_APPOINTMENT_RECIPIENT".equals(msgRecipientType) || "APPLICANT_INSPCTN_DOC_ADHOC".equals(msgRecipientType) || "FATHER_PAY_LATER_APPLICANT_RCPNT".equals(msgRecipientType) || "MOTHER_PAY_LATER_APPLICANT_RCPNT".equals(msgRecipientType) || "FEE_PAYR_INSPCTN_DOC_ADHOC".equals(msgRecipientType) || "FATHER_INSPCTN_DOC_ADHOC".equals(msgRecipientType) || "MOTHER_INSPCTN_DOC_ADHOC".equals(msgRecipientType) || "APPLICANT_FORM_SUBMISSION_RECIPIENT".equals(msgRecipientType) || "ELECTION_ADHOC_EXTERNAL_USR".equals(msgRecipientType) || "CAL_APPOINTMENT_RECIPIENT".equals(msgRecipientType)) {
                msg.setMessageType("GeneralMessage");
            }
            if ("REJECT_APPLICATION_RECIPIENTS".equals(msgRecipientType) || "WAITING_FOR_OFFER_LETTER_RECIPIENT".equals(msgRecipientType)) {
                msg.setUserType("APPLICANT");
            }
            this.msgInboxService.create((Object)msg);
            if ("APPLICANT_RESET_PASSWORD_RECIPIENT".equals(msgRecipientType) || "EXTERNAL_USER_FORGOT_PASSWORD_RECEPIENT_INFO".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.readApplicantInfo(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("APPROVE_APPLICATION_RECIPIENTS".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.readAppFormSubmitRecipientInfo(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("APPLICANT_FORM_SUBMIT_RECIPIENTS".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.readAppFormSubmitRecipientInfoByApplicationId(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("RCPNT_TYPE_APPLICANT_DTP".equals(msgRecipientType) || "Applicant".equals(msgRecipientType) || "SEND_PROVISIONAL_OFFER_LETTER_INFO".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.readAppOfferLetterRecipientInfo(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("APPLICANT_LOGIN_CREDENTIAL_INFO".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.getApplicantLoginCredentialByExternalUserId(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("APPLICATION_AND_ADMISSION_COMMENTS_RECIPIENT".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.readApplicationAdmissionCommentRecipientInfo(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("DOCUMENT_SUBMISSION_APPLICATION_OWNER_RECIPIENT".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.readDocSubmissionAppOwnerRecipientInfo(messageDTO.getRecipientUserId());
                if (recepientInfoDTO == null || recepientInfoDTO.getId() == null) {
                    recepientInfoDTO = new RecepientInfoDTO();
                    recepientInfoDTO.setId(Long.valueOf(1L));
                }
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("APPLICANT_ADHOC".equals(msgRecipientType)) {
                messageDTO.setRecipientUserId(messageDTO.getRecipientUserId());
                msgRecipientLog1.setDeliveryContact(messageDTO.getRecipientUserId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("APPLICANT_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.getApplicantDocGrpReqByPersonReqDocMasterId(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("STUDENT_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.getApplicantDocGrpReqByPersonReqDocMasterId(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            if ("EMPLOYEE_DOCUMENT_GROUP_MASTER_REQUEST_RECIPIENT".equals(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.getApplicantDocGrpReqByPersonReqDocMasterId(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            }
            msgRecipientLog1.setLastUpdate(new Date());
            if ("student".equalsIgnoreCase(msgRecipientType)) {
                recepientInfoDTO = this.gatewayCredentialsService.readRecipientInfo(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            } else if ("LIME_SURVEY_STU_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                SystemInternalNotificationInfoDTO recepientInfoDTOLimeSurveStudentRcpnt = this.gatewayCredentialsService.readRecipientInfoForLimeSurveyStudent(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTOLimeSurveStudentRcpnt.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTOLimeSurveStudentRcpnt.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            } else if ("MsgManualBill".equalsIgnoreCase(msgRecipientType)) {
                SystemInternalNotificationInfoDTO recepientInfoDTOMsgManualBill = this.gatewayCredentialsService.readRecipientInfoForMsgManualBillGeration(messageDTO.getRecipientUserId());
                if (recepientInfoDTOMsgManualBill == null) {
                    msgRecipientLog1.setDeliveryContact(null);
                    msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                    return;
                }
                messageDTO.setRecipientUserId(recepientInfoDTOMsgManualBill.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTOMsgManualBill.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            } else if ("LIME_SURVEY_FAC_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                SystemInternalNotificationInfoDTO recepientInfoDTOLimeSurveFacultyRcpnt = this.gatewayCredentialsService.readRecipientInfoForLimeSurveyFaculty(messageDTO.getRecipientUserId());
                messageDTO.setRecipientUserId(recepientInfoDTOLimeSurveFacultyRcpnt.getId());
                msgRecipientLog1.setDeliveryContact(recepientInfoDTOLimeSurveFacultyRcpnt.getId().toString());
                this.msgRecipientLogService.update((Object)msgRecipientLog1);
            } else {
                SystemInternalNotificationInfoDTO attendance;
                SystemInternalNotificationInfoDTO approveAdvisor;
                SystemInternalNotificationInfoDTO dailyAttendanceMissedByFaculty;
                SystemInternalNotificationInfoDTO recipientInfoCommitteeEventManagement;
                if ("LIME_SURVEY_APP_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    msgRecipientLog1.setDeliveryContact(null);
                    msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                    return;
                }
                if ("LIME_SURVEY_ENQ_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    msgRecipientLog1.setDeliveryContact(null);
                    msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                    return;
                }
                if ("MSG_COMMITTEE_TASK_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recipientInfoCommitteeEventManagement = this.gatewayCredentialsService.readRecipientInfoForCommitteeEventManagement(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recipientInfoCommitteeEventManagement.getId());
                    msgRecipientLog1.setDeliveryContact(recipientInfoCommitteeEventManagement.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("MEETING_MEMBER".equalsIgnoreCase(msgRecipientType)) {
                    recipientInfoCommitteeEventManagement = this.gatewayCredentialsService.readRecipientInfoForCommitteeEventManagement(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recipientInfoCommitteeEventManagement.getId());
                    msgRecipientLog1.setDeliveryContact(recipientInfoCommitteeEventManagement.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("ENQUIRY_FOLLOWUP_REMINDER_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recipientInfoCommitteeEventManagement = this.gatewayCredentialsService.readRecipientInfoForEnqFollowupReminder(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recipientInfoCommitteeEventManagement.getId());
                    msgRecipientLog1.setDeliveryContact(recipientInfoCommitteeEventManagement.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("ENQUIRY_FOLLOWUP_VELOCITY_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    SystemInternalNotificationInfoDTO enquiryFollowupRecipient = this.gatewayCredentialsService.readRecipientInfoForEnqFollowupReminder(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(enquiryFollowupRecipient.getId());
                    msgRecipientLog1.setDeliveryContact(enquiryFollowupRecipient.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("DAILY_ATTENDANCE_MISSED_BY_FACULTY_RCPNT_TYPE".equalsIgnoreCase(msgRecipientType)) {
                    dailyAttendanceMissedByFaculty = this.gatewayCredentialsService.readRecipientInfoForDailyAttendaceMissedByFaculty(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(dailyAttendanceMissedByFaculty.getId());
                    msgRecipientLog1.setDeliveryContact(dailyAttendanceMissedByFaculty.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("DAILY_STUDENT_MARKED_ABSENT_FOR_THE_SESSION_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_COURSE_WISE_STUDENT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    dailyAttendanceMissedByFaculty = this.gatewayCredentialsService.readRecipientInfoForDailyAttendaceAbsentStudent(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(dailyAttendanceMissedByFaculty.getId());
                    msgRecipientLog1.setDeliveryContact(dailyAttendanceMissedByFaculty.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("DAILY_STUDENT_MARKED_ABSENT_FOR_THE_DAY_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_DAY_WISE_STUDENT_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_SESSION_WISE_STUDENT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    dailyAttendanceMissedByFaculty = this.gatewayCredentialsService.readRecipientDailyAttendaceAbsentStudentForTheDay(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(dailyAttendanceMissedByFaculty.getId());
                    msgRecipientLog1.setDeliveryContact(dailyAttendanceMissedByFaculty.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("DAILY_ATTENDANCE_MISSED_BY_TEACHER_RCPNT_TYPE".equalsIgnoreCase(msgRecipientType)) {
                    dailyAttendanceMissedByFaculty = this.gatewayCredentialsService.readRecipientDailyAttendaceMissedFacultyForTheDay(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(dailyAttendanceMissedByFaculty.getId());
                    msgRecipientLog1.setDeliveryContact(dailyAttendanceMissedByFaculty.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPOINTMENT_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    SystemInternalNotificationInfoDTO appointment = this.gatewayCredentialsService.readAppointmentRecipient(messageDTO.getRecipientUserId());
                    if (appointment != null) {
                        messageDTO.setRecipientUserId(appointment.getId());
                        msgRecipientLog1.setDeliveryContact(appointment.getId().toString());
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("Appointment user id is null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPROVE_ADMISSION_ADVISOR_INFO".equalsIgnoreCase(msgRecipientType)) {
                    approveAdvisor = this.gatewayCredentialsService.readApproveAdvisorRecipient(messageDTO.getRecipientUserId());
                    if (approveAdvisor != null) {
                        messageDTO.setRecipientUserId(approveAdvisor.getId());
                        msgRecipientLog1.setDeliveryContact(approveAdvisor.getId().toString());
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("Advisor user id is null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("LEAVE_REJECT_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    approveAdvisor = this.gatewayCredentialsService.readRejectLeaveRecipient(messageDTO.getRecipientUserId());
                    if (approveAdvisor != null) {
                        messageDTO.setRecipientUserId(approveAdvisor.getId());
                        msgRecipientLog1.setDeliveryContact(approveAdvisor.getId().toString());
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("Requester user id is null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("LEAVE_APPROVER_APPROVE_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    approveAdvisor = this.gatewayCredentialsService.readApproverLeaveApproveRecipient(messageDTO.getRecipientUserId());
                    if (approveAdvisor != null) {
                        messageDTO.setRecipientUserId(approveAdvisor.getId());
                        msgRecipientLog1.setDeliveryContact(approveAdvisor.getId().toString());
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("Approver user id is null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("LEAVE_REQUESTER_APPROVE_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    approveAdvisor = this.gatewayCredentialsService.readRequesterLeaveApproveRecipient(messageDTO.getRecipientUserId());
                    if (approveAdvisor != null) {
                        messageDTO.setRecipientUserId(approveAdvisor.getId());
                        msgRecipientLog1.setDeliveryContact(approveAdvisor.getId().toString());
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("Requester user id is null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("LEAVE_WITHDRAWN_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    approveAdvisor = this.gatewayCredentialsService.readWithdrawnLeaveRecipient(messageDTO.getRecipientUserId());
                    if (approveAdvisor != null) {
                        messageDTO.setRecipientUserId(approveAdvisor.getId());
                        msgRecipientLog1.setDeliveryContact(approveAdvisor.getId().toString());
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("Requester user id is null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("LEAVE_CREATE_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    approveAdvisor = this.gatewayCredentialsService.readCreateLeaveRecipient(messageDTO.getRecipientUserId());
                    if (approveAdvisor != null) {
                        messageDTO.setRecipientUserId(approveAdvisor.getId());
                        msgRecipientLog1.setDeliveryContact(approveAdvisor.getId().toString());
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("approver user id is null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("STUDENT_MARKED_PRESENT_CD_MS_FATHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "STUDENT_MARKED_PRESENT_CD_MS_MOTHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "STUDENT_MARKED_PRESENT_CD_MS_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType) || "STUDENT_MARKED_PRESENT_CD_MS_LOCAL_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_DAY_WISE_FATHER_ABSENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_DAY_WISE_MOTHER_ABSENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN_ABSENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_DAY_WISE_GUARDIAN_ABSENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_DAY_WISE_MOTHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_DAY_WISE_FATHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_DAY_WISE_LOCAL_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_DAY_WISE_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_SESSION_WISE_MOTHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_SESSION_WISE_FATHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_SESSION_WISE_LOCAL_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_SESSION_WISE_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    attendance = this.gatewayCredentialsService.readStudentPresentMarkedParentsRecipient(messageDTO.getRecipientUserId(), msgRecipientType);
                    if (attendance != null) {
                        if (attendance.getId() != null) {
                            messageDTO.setRecipientUserId(attendance.getId());
                            msgRecipientLog1.setDeliveryContact(attendance.getId().toString());
                        } else {
                            msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                            msgRecipientLog1.setFailureCode("Parents/Guardian user id null");
                        }
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("Parents/Guardian user id null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("ATTENDANCE_COURSE_WISE_MOTHER_PRESENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_COURSE_WISE_FATHER_PRESENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_COURSE_WISE_MOTHER_ABSENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_COURSE_WISE_GUARDIAN_PRESENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_PRESENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_ABSENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ATTENDANCE_COURSE_WISE_GUARDIAN_ABSENT_ONLY_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_COURSE_WISE_FATHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_COURSE_WISE_MOTHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_COURSE_WISE_LOCAL_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType) || "UPDATE_ATTENDANCE_COURSE_WISE_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    attendance = this.gatewayCredentialsService.readStudentPresentMarkedParentsRecipient(messageDTO.getRecipientUserId(), msgRecipientType);
                    if (attendance != null) {
                        if (attendance.getId() != null) {
                            messageDTO.setRecipientUserId(attendance.getId());
                            msgRecipientLog1.setDeliveryContact(attendance.getId().toString());
                        } else {
                            msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                            msgRecipientLog1.setFailureCode("Parents/Guardian user id null");
                        }
                    } else {
                        msgRecipientLog1.setStatusCode(StatusCode.FINISH);
                        msgRecipientLog1.setFailureCode("Parents/Guardian user id null");
                    }
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("GRADEBOOK_PUBLISH_STUDENT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readRecipientInfo(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("GRADEBOOK_PUBLISH_PARENT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    this.gatewayCredentialsService.readUserIdByPersonId(messageDTO.getRecipientUserId());
                } else if ("SERVICE_REQUEST_STUDENT_CREATION_RCPNT".equalsIgnoreCase(msgRecipientType) || "SR_LEAVE_STUDENT_INTIMATION_RCPNT".equalsIgnoreCase(msgRecipientType) || "SR_STUDENT_LEAVE_APPROVE_RCPNT".equalsIgnoreCase(msgRecipientType) || "SR_STUDENT_LEAVE_REJECT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readInfoForStudentTransferServiceRequest(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("SERVICE_REQUEST_ASSINEE_RCPNT".equalsIgnoreCase(msgRecipientType) || "SR_LEAVE_ASSIGNEE_INTIMATION_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readInfoForAssigneeServiceRequest(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("SERVICE_REQUEST_FOLLOWUP_ASSIGN_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readInfoForFollowupServiceRequest(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("HOMEWORK_ASSIGNMENT_SUBMISSION_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readRecipientOfHomeworkAssignment(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("HOMEWORK_ASSIGNMENT_SUBMISSION_GRP_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readRecipientOfHomeworkAssignment(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("SERVICE_REQUEST_PARENT_CREATION_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readInfoForParentTransferServiceRequest(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("HOMEWORK_ASSIGNMENT_SAVE_RCPNT".equalsIgnoreCase(msgRecipientType) || "HOMEWORK_ASSIGNMENT_SUBMIT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readRecipientOfSaveHomeworkAssignment(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("EVENT_REMINDER_PRIOR_RECIPIENTS".equalsIgnoreCase(msgRecipientType) || "EVENT_REMINDER_ON_DATE_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserFromResourceId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("LEAVE_CANCELLED_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getRequesterForCancelledLeave(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("DAILYENQADMAPPCOUNT_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserFromAcademyLocationById(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("POSITIVE_INCIDENT_PARENT_GUARDIAN1_RCPNT".equalsIgnoreCase(msgRecipientType) || "NEGATIVE_INCIDENT_PARENT_GUARDIAN1_RCPNT".equalsIgnoreCase(msgRecipientType) || "POSITIVE_INCIDENT_PARENT_GUARDIAN2_RCPNT".equalsIgnoreCase(msgRecipientType) || "NEGATIVE_INCIDENT_PARENT_GUARDIAN2_RCPNT".equalsIgnoreCase(msgRecipientType) || "POSITIVE_INCIDENT_LOCAL_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType) || "NEGATIVE_INCIDENT_LOCAL_GUARDIAN_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getFatherFromIncident(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("POSITIVE_INCIDENT_PRINCIPLE_RCPNT".equalsIgnoreCase(msgRecipientType) || "NEGATIVE_INCIDENT_PRINCIPLE_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getPrincipleFromIncident(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("NEGATIVE_INCIDENT_ALOWNER_RCPNT".equalsIgnoreCase(msgRecipientType) || "POSITIVE_INCIDENT_ALOWNER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getALOwnerFromIncident(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("POSITIVE_INCIDENT_CLASSTEACHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "NEGATIVE_INCIDENT_CLASTEACHER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getClassTeacherFromIncident(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("TIME_TABLE_UPDATE_FOR_STUDENT_RCPNT".equalsIgnoreCase(msgRecipientType) || "TIME_TABLE_DELETE_FOR_STUDENT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentFromCourseCoveragePlanMsg(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("TIME_TABLE_UPDATE_FOR_MOTHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "TIME_TABLE_DELETE_FOR_MOTHER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getMotherFromCourseCoveragePlanMsg(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("TIME_TABLE_UPDATE_FOR_FATHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "TIME_TABLE_DELETE_FOR_FATHER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getFatherFromCourseCoveragePlanMsg(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("SERVICE_REQUEST_APPROVER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserForServiceRequestApprover(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("SERVICE_REQUEST_ESCALATE_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserForServiceRequestEscalationApprover(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("OUTSTANDING_BILL_STU_REM_ON_DAY_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_STU_REM_ON_DAY_S2_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_FATHER_REM_ON_3DAY_PRIOR_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_MOTHER_REM_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_STUDENT_REM_RCPNT".equalsIgnoreCase(msgRecipientType) || "OUTSTANDING_BILL_FATHER_REM_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserFromBillHeaderId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("HOMEWORK_ASSIGNMENT_STUDENT_ADHOC".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.readRecipientOfSaveHomeworkAssignment(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("GEN_INVOICE_STUDENT_ADHOC".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentForBillInvoiceAdhoc(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("ITEM_RECEIVED_NOTIFICATION_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getReciverByFDItemId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("PLACEMENT_JOB_POSTING_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentForPlacementJobPosting(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("PERSON_TO_MEET_APPOINTMENT_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getPersonToMeetByAppointmentId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPLICATION_FOLLOW_UP_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getApplicationFollowUpByuserId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("TIME_TABLE_UPDATE_FOR_FACULTY_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getFacultyFromCourseCoveragePlanMsg(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("TIME_TABLE_DELETE_FOR_FACULTY_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getFacultyFromCourseCoveragePlanMsgForTimeTableDelete(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("TIME_TABLE_UPDATE_FOR_HOD_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getHODFromCourseCoveragePlanMsg(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("TIME_TABLE_DELETE_FOR_HOD_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getDeptHODFromCourseCoveragePlanMsg(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("SERVICE_ROUTE_RCPNT_ADHOC".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentIdFrmTransferServiceRouteId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("EXAMINATION_INVIGILATOR_ALLOCATION_INFO".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserIdForInvgMsg(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("CLINIC_APPOINTMENT_FACULTY_RCPNT".equalsIgnoreCase(msgRecipientType) || "INTERVENTION_APPOINTMENT_FACULTY_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getInfirmayAppointmentFacultyId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("CLINIC_APPOINTMENT_PARENT_RCPNT".equalsIgnoreCase(msgRecipientType) || "INTERVENTION_APPOINTMENT_PARENT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getInfirmayAppointmentParentId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("STUDENT_HOSTEL_LEAVE_APPROVE_RCPNT".equalsIgnoreCase(msgRecipientType) || "STUDENT_HOSTEL_LEAVE_REJECT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentForHostelLeaveRequest(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("LEAVE_WORK_HAND_OVER_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getLeaveHandoverUserById(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("SHARE_FOLDER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserIdbyGalleryUsrId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("HOSTEL_ATTENDANCE_ABSENT_STUDENT_RCPNT".equalsIgnoreCase(msgRecipientType) || "HOSTEL_ATTENDANCE_ABSENT_FATHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "HOSTEL_ATTENDANCE_ABSENT_MOTHER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentUserIdbyHostelAttendanceId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("BIRTHDAY_GREETING_FATHER_RCPNT".equalsIgnoreCase(msgRecipientType) || "BIRTHDAY_GREETING_MOTHER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentPersonIdByParentId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("Parent Adhoc".equals(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserIdByPersonId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("HOSTEL_APPLICATION_REJECT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserIdbyPersonServiceId(messageDTO.getRecipientUserId());
                    if (null != recepientInfoDTO) {
                        messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                        msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                        this.msgRecipientLogService.update((Object)msgRecipientLog1);
                    }
                } else if ("FATHER_HOSTEL_APPLICATION_REJECT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getParentUserIdbyPersonServiceId(messageDTO.getRecipientUserId(), "FATHER");
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("MOTHER_HOSTEL_APPLICATION_REJECT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getParentUserIdbyPersonServiceId(messageDTO.getRecipientUserId(), "MOTHER");
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("REVALUATION_APPROVAL_REJECTION_TO_STUDENT_INFO".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserIdForRevel(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("FATHER_REVALUATION_APPROVAL_REJECTION_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getParentUserIdbyByreval(messageDTO.getRecipientUserId(), "FATHER");
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("MOTHER_REVALUATION_APPROVAL_REJECTION_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getParentUserIdbyByreval(messageDTO.getRecipientUserId(), "MOTHER");
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPOINTMENT_ON_DAY_PERSON_TO_MEET_RCPNT".equalsIgnoreCase(msgRecipientType) || "APPOINTMENT_ON_DAY_PERSON_TO_MEET_OTHER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getPersonToMeetId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPOINTMENT_ONE_DAY_PRIOR_PARENT_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getParentId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("JOB_APPLICATION_DTP".equalsIgnoreCase(msgRecipientType) || "Employee Job Application".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getEmployeeJobApplicationUserId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("VEHICLE_SERVICE_DUE_SCHEDULED_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getVehicleServiceDueUser(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPOINTMENT_ONE_DAY_PRIOR_OTHER_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getAppointeeId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("ASSIGN_FILE_RECIPIENT".equalsIgnoreCase(msgRecipientType) || "FORWARD_FILE_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getAssigneeId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPLICATION_RE_ASSIGN_RECIPIENT".equalsIgnoreCase(msgRecipientType) || "APPLICATION_OWNER_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getApplicationOwnerId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("ELECTION_ADHOC".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserFrmElectionVoterPoolId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("CREATE_ENQUIRY_OWNER_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getEnquiryOwnerId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("ADD_PROGRAM_TO_APPROVE_ADMISSION_RECIPIENT".equalsIgnoreCase(msgRecipientType) || "APPLICATION_REJECTION_POST_ASSESSMENT_VELOCITY_RCPNT".equalsIgnoreCase(msgRecipientType) || "ASSESSMENT_SELECTION_VELOCITY_RCPNT".equalsIgnoreCase(msgRecipientType) || "REJECT_APPLICATION_RECIPIENTS".equalsIgnoreCase(msgRecipientType) || "WAITING_FOR_OFFER_LETTER_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getApplicationIdFrmAPId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPLY_HOLD_NOTIFICATION_TO_STUDENT_EVENT_RECIPIENT".equalsIgnoreCase(msgRecipientType) || "REMOVAL_HOLD_NOTIFICATION_TO_STUDENT_EVENT_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentIdByAppliedAndRemovedHold(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPLICATION_OFFER_ESCALATION_RECIPIENTS".equalsIgnoreCase(msgRecipientType) || "REASSIGN_ESCALATION_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserIdForApplicationOfferEscalation(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPLICATION_ESCALATED_OFFER_IS_REVIEWED_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserIdForApplicationOfferEscalationReview(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPLICANT_DOCUMENT_RESUBMISSION_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getOwnerIdForDocumentResubmission(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("DOCUMENT_RESUBMISSION_APPLICATION_OWNER_RECIPIENT".equals(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getOwnerIdForPostSchoolStudiesDocumentResubmission(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("COURSE_SESSION_DAIRY_STUDENT_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentIdCourseSessionDiary(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("COURSE_SESSION_DAIRY_FATHER_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getFatherIdCourseSessionDiary(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("COURSE_SESSION_DAIRY_MOTHER_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getMotherIdCourseSessionDiary(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("EXAM_ATTENDANCE_BASED_DETENTION_STUDENT_INFO".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getUserIdForDetainMsg(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("FATHER_EXAM_ATTENDANCE_BASED_DETENTION_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getParentUserIdForDetain(messageDTO.getRecipientUserId(), "FATHER");
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("MOTHER_EXAM_ATTENDANCE_BASED_DETENTION_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getParentUserIdForDetain(messageDTO.getRecipientUserId(), "MOTHER");
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("SUBMIT_APPLICATION_COURSE_COORDINATOR_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getProgramCoordinatorByApplication(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("STUDENT_HOSTEL_CHECK_IN_RCPNT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getStudentForHostelCheckInAndOut(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("APPLICATION_TRANSFER_NOTIFICATION_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getApplicationApproverUpByuserId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                } else if ("STUDENT_TRANSFER_NOTIFICATION_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                    recepientInfoDTO = this.gatewayCredentialsService.getApproverUpByServiceRequestId(messageDTO.getRecipientUserId());
                    messageDTO.setRecipientUserId(recepientInfoDTO.getId());
                    msgRecipientLog1.setDeliveryContact(recepientInfoDTO.getId().toString());
                    this.msgRecipientLogService.update((Object)msgRecipientLog1);
                }
            }
            MsgRecipient msgRcpntEntry = this.buildMsgRcpntEntry(msg, messageDTO);
            this.msgRecipientService.create((Object)msgRcpntEntry);
            debugLogger.debug((Object)"SysInternalMsgQueueListener #4 FINISH");
            MsgRecipientLog msgRecipientLog = (MsgRecipientLog)this.msgRecipientLogService.findById(msgRcpntLogId);
            msgRecipientLog.setStatusCode(StatusCode.FINISH);
            this.msgRecipientLogService.update((Object)msgRecipientLog);
        }
        catch (NullPointerException ex) {
            debugLogger.debug((Object)" SysInternalMsgQueueListener #5 Excetption occured");
            ex.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"CONFIGURATION_ERROR", null, (String)"SysInternalMsgQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (MessageCentralException ex) {
            debugLogger.debug((Object)" SysInternalMsgQueueListener #6 Excetption occured");
            ex.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"SysInternalMsgQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (Exception e1) {
            debugLogger.debug((Object)"SysInternalMsgQueueListener #5 Exception Occurred");
            e1.printStackTrace();
        }
        try {
            Thread.sleep(3000L);
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private MsgRecipient buildMsgRcpntEntry(MsgInbox msgInbox, MessageDTO messageDTO) {
        MsgRecipient msgRecipient = new MsgRecipient();
        msgRecipient.setMsgInbox(msgInbox);
        msgRecipient.setMsgRecipientType(messageDTO.getMsgRecipientType());
        msgRecipient.setRecipientUserId(messageDTO.getRecipientUserId());
        msgRecipient.setWhetherRead(Boolean.valueOf(false));
        return msgRecipient;
    }

    private MsgInbox buildInternalMsg(MessageDTO messageDTO) {
        MsgInbox msg = new MsgInbox();
        msg.setCreatedTime(new Date());
        msg.setMessageBody(messageDTO.getMessageContent().getBytes());
        msg.setMessageFrom(messageDTO.getMsgFromUserId());
        msg.setMessageType(messageDTO.getMessageTypeCode());
        msg.setSubject(messageDTO.getSubject());
        if (messageDTO.getWhetherBulkMessage() != null) {
            msg.setWhetherCommonMessage(messageDTO.getWhetherBulkMessage());
        } else {
            msg.setWhetherCommonMessage(Boolean.valueOf(false));
        }
        this.addAttchments(messageDTO, msg);
        return msg;
    }

    private void addAttchments(MessageDTO messageDTO, MsgInbox msg) {
        Set msgDocuments = null;
        msg.setWhetherAttachement(Boolean.valueOf(false));
        if (messageDTO.getAttachmentPaths() != null && messageDTO.getAttachmentPaths().size() > 0) {
            msg.setWhetherAttachement(Boolean.valueOf(true));
            msgDocuments = this.buildStaticDocumentAttachments(messageDTO.getAttachmentPaths(), msg);
        }
        if (messageDTO.getMsgRecipientDynamicDocuments() != null && messageDTO.getMsgRecipientDynamicDocuments().size() > 0) {
            msg.setWhetherCommonMessage(Boolean.valueOf(true));
            msg.setWhetherAttachement(Boolean.valueOf(true));
            Set msgDynamicDocuments = this.buildDynamicDocumentAttachments(messageDTO, msg);
            if (msgDocuments != null) {
                msgDocuments.addAll(msgDynamicDocuments);
            } else {
                msgDocuments = msgDynamicDocuments;
            }
        }
        msg.setMsgDocuments(msgDocuments);
    }

    private Set<MsgDocument> buildStaticDocumentAttachments(List<String> attachmentPaths, MsgInbox msgInbox) {
        HashSet<MsgDocument> msgDocuments = new HashSet<MsgDocument>();
        for (String path : attachmentPaths) {
            MsgDocument msgDocument = new MsgDocument();
            msgDocument.setDocumentName(path.substring(path.lastIndexOf(File.separatorChar) + 1, path.length()));
            path = path.replaceAll(this.baseDir, "");
            msgDocument.setDocumentPath(path);
            msgDocument.setMsgInbox(msgInbox);
            msgDocuments.add(msgDocument);
        }
        return msgDocuments;
    }

    private Set<MsgDocument> buildDynamicDocumentAttachments(MessageDTO messageDTO, MsgInbox msgInbox) {
        List msgRecipientDocuments = messageDTO.getMsgRecipientDynamicDocuments();
        HashSet<MsgDocument> msgDocuments = new HashSet<MsgDocument>();
        for (MsgRecipientDocuments msgRecipientDocument : msgRecipientDocuments) {
            MsgDocument msgDocument = new MsgDocument();
            msgDocument.setDocumentName(msgRecipientDocument.getDocumentName());
            msgDocument.setDocument(msgRecipientDocument.getDocument());
            msgDocument.setMsgInbox(msgInbox);
            msgDocuments.add(msgDocument);
        }
        return msgDocuments;
    }
}

