/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.cb.model.ResultDocument;
import in.serosoft.docgen.model.DynamicDocumentData;
import in.serosoft.docgen.service.DocumentGeneratorService;
import in.serosoft.messaging.entity.MsgDeliveryMode;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgRecipientDocuments;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.helper.MsgRcpntsQueueHelper;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgRecipientDocumentsService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.MsgScopeParamService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="sysMsgEventDocGenQueueListener")
public class SysMsgEventDocGenQueueListener
implements MessageListener {
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    MsgRecipientDocumentsService msgRecipientDocumentsService;
    @Autowired
    DocumentGeneratorService htmlTemplateDocGenService;
    @Autowired
    MsgScopeParamService msgScopeParamService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"SysMsgEventDocGenQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        DEBUGCOMMONLOGGER.debug((Object)"###### listened message on SysMsgEventDocGenQueueListener ######");
        try {
            Long msgRcpntLogId = MsgQueueHelper.getMessageContent((Message)message);
            MsgRecipientLog msgRecipientLog = (MsgRecipientLog)this.msgRecipientLogService.findById(msgRcpntLogId);
            MsgRecipientTypeLog msgRecipientTypeLog = msgRecipientLog.getMsgRecipientTypeLog();
            Map docIdParams = this.buildDocIdParams(msgRecipientLog);
            DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocGenQueue Read doc config & generate required parameter map & call doc engine to generate documents - msgRecipientTypeLog " + msgRecipientTypeLog.getId()));
            Map msgContextMap = this.msgRuleEvaluationService.buildMessageContextMap(msgRecipientTypeLog);
            for (Long docId : docIdParams.keySet()) {
                List docGenParams = (List)docIdParams.get(docId);
                DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocGenQueue - docId " + docId + " docGenParams " + docGenParams));
                if (this.docAlreadyExists(msgRecipientTypeLog, msgRecipientLog, docId)) continue;
                DynamicDocumentData documentData = this.generateDocument(docId, docGenParams, msgContextMap, msgRecipientLog);
                this.persistDocument(documentData, docId, msgRecipientTypeLog, msgRecipientLog.getRecipientId());
                DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocGenQueue #2 !docAlreadyExists Generate Document - File Name " + documentData.getFileName()));
            }
            this.publishToNextQueue(msgRecipientLog);
            DEBUGCOMMONLOGGER.debug((Object)"SysMsgEventDocGenQueue #3 Sent To Next Queue");
        }
        catch (Exception e1) {
            DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocGenQueueListener #4 Exception " + e1.getMessage()));
            e1.printStackTrace();
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean docAlreadyExists(MsgRecipientTypeLog msgRecipientTypeLog, MsgRecipientLog msgRecipientLog, Long docId) {
        return this.msgRecipientDocumentsService.checkWhetherDocAlreadyExist(msgRecipientTypeLog.getId(), msgRecipientLog.getRecipientId(), docId);
    }

    private Map<Long, List<Map<String, String>>> buildDocIdParams(MsgRecipientLog msgRecipientLog) throws JsonParseException, JsonMappingException, IOException {
        HashMap<Long, List<Map<String, String>>> docIdParams = new HashMap<Long, List<Map<String, String>>>();
        List docWithExtraParamReffMapList = (List)new ObjectMapper().readValue(msgRecipientLog.getDocGenParamMapDef(), ArrayList.class);
        Set ids = StringUtils.commaDelimitedListToSet((String)msgRecipientLog.getDynamicDocuments());
        for (String docId : ids) {
            String extraParamListString = this.findDocExtrsParams(docWithExtraParamReffMapList, docId);
            List extraParamList = (List)new ObjectMapper().readValue(extraParamListString, ArrayList.class);
            docIdParams.put(Long.valueOf(docId), extraParamList);
        }
        return docIdParams;
    }

    private String findDocExtrsParams(List<Map<String, String>> docWithExtraParamReffMapList, String docId) {
        for (Map<String, String> map : docWithExtraParamReffMapList) {
            if (!map.get("reff").equals(docId)) continue;
            return map.get("docGenParamdef");
        }
        return null;
    }

    private DynamicDocumentData generateDocument(Long docId, List<Map<String, String>> docGenParams, Map<Long, Object> msgContextMap, MsgRecipientLog msgRecipientLog) throws JsonParseException, JsonMappingException, IOException {
        Map contextMap = this.buildRequiredExtraParamMap(msgRecipientLog, msgContextMap, docGenParams);
        contextMap.put(msgRecipientLog.getMsgRecipientTypeLog().getMsgRecipientType().getIdParamName(), msgRecipientLog.getRecipientId());
        DynamicDocumentData documentData = this.htmlTemplateDocGenService.generateDocumentByDocumentOwnerConfig(docId, contextMap);
        return documentData;
    }

    private Map<String, Object> buildRequiredExtraParamMap(MsgRecipientLog msgRecipientLog, Map<Long, Object> msgContextMap, List<Map<String, String>> docGenParams) throws JsonParseException, JsonMappingException, IOException {
        String distrbutionContextData = msgRecipientLog.getRecipientContextData();
        ResultDocument rd = (ResultDocument)new ObjectMapper().readValue(distrbutionContextData, ResultDocument.class);
        Map msgScopeParams = this.msgScopeParamService.findByMsgScope("EVENT_CONTEXT_SCOPE");
        msgScopeParams.putAll(this.msgScopeParamService.findByMsgScope("DISTRIBUTION_SCOPE"));
        HashMap<String, Object> extraParamMap = new HashMap<String, Object>();
        for (Map<String, String> map : docGenParams) {
            String paramKey = map.get("MSG_PARAM");
            String docGenParamKey = map.get("DOC_GEN_PARAM");
            Long msgScopeParamId = (Long)msgScopeParams.get(paramKey);
            Long id = null;
            if (msgContextMap.get(msgScopeParamId) != null) {
                id = Long.valueOf((String)msgContextMap.get(msgScopeParamId));
            }
            if (id == null) {
                id = ((Integer)rd.get((Object)paramKey)).longValue();
            }
            extraParamMap.put(docGenParamKey, id);
        }
        return extraParamMap;
    }

    private void publishToNextQueue(MsgRecipientLog msgRecipientLog) {
        MsgDeliveryMode msgDeliveryMode = msgRecipientLog.getMsgDeliveryMode();
        String queueName = MsgRcpntsQueueHelper.findQueueNameForDeliveryMode((String)msgDeliveryMode.getCode());
        DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocGenQueue #1 publishToNextQueue - Queue Name " + queueName));
        this.messageQueueTemplate.convertAndSend(queueName, (Object)msgRecipientLog.getId());
    }

    private void persistDocument(DynamicDocumentData documentData, Long docId, MsgRecipientTypeLog msgRecipientTypeLog, Long recipientId) {
        MsgRecipientDocuments msgRecipientDocument = new MsgRecipientDocuments();
        msgRecipientDocument.setRecipientId(recipientId);
        msgRecipientDocument.setMsgRecipientTypeLog(msgRecipientTypeLog);
        msgRecipientDocument.setDocument(documentData.getData());
        msgRecipientDocument.setDocId(docId);
        msgRecipientDocument.setDocumentName(documentData.getFileName());
        Long id = this.msgRecipientDocumentsService.create((Object)msgRecipientDocument);
        DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocGenQueue #1 persistDocument - msgRecipientDocument " + id + " docId " + docId + " recipientId " + recipientId));
    }
}

