/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.cb.model.ResultDocument;
import in.serosoft.docgen.domain.DocumentOwnerConfiguration;
import in.serosoft.docgen.model.ws.WSDynamicDocumentType;
import in.serosoft.docgen.service.DocumentTypeEntityMappingService;
import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgEventRecipientConfig;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgScopeParam;
import in.serosoft.messaging.entity.MsgTemplateConfigDoc;
import in.serosoft.messaging.entity.SysMsgEvtRecipientDoc;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgEventRecipientConfigService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.MsgScopeParamService;
import in.serosoft.messaging.service.MsgTemplateConfigDocService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="sysMsgEventDocMgntQueueListener")
public class SysMsgEventDocMgntQueueListener
implements MessageListener {
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    DocumentTypeEntityMappingService documentTypeEntityMappingService;
    @Autowired
    MsgTemplateConfigDocService msgTemplateConfigDocService;
    @Autowired
    MsgEventRecipientConfigService msgEventRecipientConfigService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    MsgScopeParamService msgScopeParamService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"SysMsgEventDocMgntQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        DEBUGCOMMONLOGGER.debug((Object)"###### listened message on SysMsgEventDocMgntQueueListener ######");
        try {
            Long msgRcpntLogId = MsgQueueHelper.getMessageContent((Message)message);
            MsgRecipientLog msgRecipientLog = (MsgRecipientLog)this.msgRecipientLogService.findById(msgRcpntLogId);
            Long msgEventConfigId = msgRecipientLog.getMsgRecipientTypeLog().getMsgLog().getMsgEventConfig().getId();
            MsgEventRecipientConfig msgEventRecipientConfig = this.msgEventRecipientConfigService.findByMsgEventConfigAndRecipientType(msgEventConfigId, msgRecipientLog.getMsgRecipientTypeLog().getMsgRecipientType().getId());
            List templateAttachments = this.msgTemplateConfigDocService.findByMsgTemplateConfigId(msgEventRecipientConfig.getMsgTemplateConfig().getId());
            Map msgContextMap = this.msgRuleEvaluationService.buildMessageContextMap(msgRecipientLog.getMsgRecipientTypeLog());
            Map docIdParamMap = this.findDocuments(templateAttachments, msgContextMap, msgRecipientLog.getRecipientContextData());
            DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocMgntQueue #1 - msgRcpntLogId" + msgRcpntLogId + " msgEventConfigId " + msgEventConfigId + " MsgTemplateConfigDoc " + templateAttachments.size()));
            if (docIdParamMap != null && docIdParamMap.size() > 0) {
                this.updateMsgRecipientLogWithDocuments(msgRecipientLog, docIdParamMap);
                DEBUGCOMMONLOGGER.debug((Object)"SysMsgEventDocMgntQueue #3 Push Into SYS_MSG_EVT_DOC_GEN_QUEUE");
                this.messageQueueTemplate.convertAndSend("SysMsgEventDocGenQueue", (Object)msgRecipientLog.getId());
            }
        }
        catch (Exception e1) {
            DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocMgntQueue #4 Exception " + e1.getMessage()));
            e1.printStackTrace();
        }
        try {
            if (null != this.messagingThreadSleep) {
                Long val = Long.parseLong(this.messagingThreadSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void updateMsgRecipientLogWithDocuments(MsgRecipientLog msgRecipientLog, Map<Long, String> docIdParamMap) throws JsonGenerationException, JsonMappingException, IOException {
        String docGenParamMapDef = this.buildDocGenParamDef(docIdParamMap);
        String dynamicDocuments = StringUtils.join(docIdParamMap.keySet(), (char)',');
        msgRecipientLog.setDocGenParamMapDef(docGenParamMapDef);
        msgRecipientLog.setDynamicDocuments(dynamicDocuments);
        this.msgRecipientLogService.update((Object)msgRecipientLog);
        DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocMgntQueue #3 updateMsgRecipientLogWithDocuments - dynamicDocuments " + dynamicDocuments));
    }

    private String buildDocGenParamDef(Map<Long, String> docIdParamMap) throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList docWithExtraParamReffMapList = new ArrayList();
        for (Long docId : docIdParamMap.keySet()) {
            HashMap<String, String> docWithExtraParamReffMap = new HashMap<String, String>();
            docWithExtraParamReffMap.put("reff", docId.toString());
            docWithExtraParamReffMap.put("docGenParamdef", docIdParamMap.get(docId));
            docWithExtraParamReffMapList.add(docWithExtraParamReffMap);
        }
        return new ObjectMapper().writeValueAsString(docWithExtraParamReffMapList);
    }

    private Map<Long, String> findDocuments(List<MsgTemplateConfigDoc> templateAttachments, Map<Long, Object> msgContextMap, String distributionListContextData) {
        HashMap<Long, String> documents = new HashMap<Long, String>();
        for (MsgTemplateConfigDoc msgTemplateConfigDoc : templateAttachments) {
            Long docTypeId = msgTemplateConfigDoc.getSysMsgEvtRecipientDoc().getDocTypeId();
            Long ownerId = this.findOwnerId(msgTemplateConfigDoc.getSysMsgEvtRecipientDoc(), msgContextMap, distributionListContextData);
            List docs = this.documentTypeEntityMappingService.findByDocTypeIdAndOwnerId(docTypeId, ownerId);
            String extraParams = msgTemplateConfigDoc.getSysMsgEvtRecipientDoc().getDocGenParamMapDef();
            for (DocumentOwnerConfiguration documentOwnerConfiguration : docs) {
                DEBUGCOMMONLOGGER.debug((Object)"SysMsgEventDocMgntQueue #1.1 inside findDocuments...");
                if (null != documentOwnerConfiguration.getDocumentTypeId() && "OFFER_LETTER".equals(documentOwnerConfiguration.getDocumentTypeId().getTypeCode())) {
                    Long apID = Long.valueOf(msgContextMap.get(1L).toString());
                    WSDynamicDocumentType mapDocId = this.documentTypeEntityMappingService.readAppOfferLetterByApplicationProgId(apID);
                    DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocMgntQueue #1.2 findDocuments apID " + apID + " mapDocId " + mapDocId));
                    if (null != mapDocId && null != mapDocId.getDocumentTypeId()) {
                        documents.put(mapDocId.getDocumentTypeId(), extraParams);
                        DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocMgntQueue #1.2 findDocuments mapDocId " + mapDocId.getDocumentTypeId()));
                        break;
                    }
                    if (!documentOwnerConfiguration.getUseDefaultTemplate().booleanValue()) continue;
                    documents.put(documentOwnerConfiguration.getId(), extraParams);
                    DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocMgntQueue #1.3 findDocuments default template " + documentOwnerConfiguration.getId()));
                    break;
                }
                documents.put(documentOwnerConfiguration.getId(), extraParams);
            }
            DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocMgntQueue #1 findDocuments - docTypeId " + docTypeId + " ownerId " + ownerId + " Docs Size " + docs.size()));
        }
        return documents;
    }

    private Long findOwnerId(SysMsgEvtRecipientDoc sysMsgEvtRecipientDoc, Map<Long, Object> msgContextMap, String distributionListContextData) {
        Long msgScopeParamId = sysMsgEvtRecipientDoc.getMsgScopeParam().getId();
        Long OwnerId = null;
        if (msgContextMap.get(msgScopeParamId) != null) {
            OwnerId = Long.valueOf(msgContextMap.get(msgScopeParamId).toString());
        }
        if (OwnerId == null) {
            OwnerId = this.findOwnerIdFromDistributionContext(msgScopeParamId, distributionListContextData);
        }
        return OwnerId;
    }

    private Long findOwnerIdFromDistributionContext(Long msgScopeParamId, String distributionListContextData) {
        try {
            ResultDocument rd = (ResultDocument)new ObjectMapper().readValue(distributionListContextData, ResultDocument.class);
            MsgScopeParam msgScopeParam = (MsgScopeParam)this.msgScopeParamService.findById(msgScopeParamId);
            return ((Integer)rd.get((Object)msgScopeParam.getParamKey())).longValue();
        }
        catch (IOException e) {
            DEBUGCOMMONLOGGER.debug((Object)("SysMsgEventDocMgntQueue #4.1 IOException  " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }
}

