/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.listener;

import in.serosoft.messaging.entity.MsgErrors;
import in.serosoft.messaging.entity.MsgEventConfig;
import in.serosoft.messaging.entity.MsgInitRuleConfig;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.SysMsgEvtDefaultConfig;
import in.serosoft.messaging.entity.SystemMsgEvent;
import in.serosoft.messaging.entity.SystemMsgEventConfig;
import in.serosoft.messaging.entity.UserTriggeredMsgEvtLog;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.exception.MessageCentralException;
import in.serosoft.messaging.helper.MsgErrorsHelper;
import in.serosoft.messaging.helper.MsgLogHelper;
import in.serosoft.messaging.helper.MsgQueueHelper;
import in.serosoft.messaging.helper.RabbitMQHelper;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgEventScopeService;
import in.serosoft.messaging.service.MsgInitRuleConfigService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.RepeatitionEventService;
import in.serosoft.messaging.service.SysMsgEvtDefaultConfigService;
import in.serosoft.messaging.service.UserTriggeredMsgEvtLogService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="userTriggeredMsgQueueListener")
public class UserTriggeredMsgQueueListener
implements MessageListener {
    private static final Logger DEBUGLOGGER = Logger.getLogger((String)"UserTriggeredMsgQueueListenerLogger");
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    UserTriggeredMsgEvtLogService userTriggeredMsgEvtLogService;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    MsgInitRuleConfigService msgInitRuleConfigService;
    @Autowired
    SysMsgEvtDefaultConfigService sysMsgEvtDefaultConfigService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    MsgEventScopeService msgEventScopeService;
    @Autowired
    RepeatitionEventService repeatitionEventService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Value(value="${messaging.consolePrint}")
    private String messagingConsolePrint;
    @Value(value="${messaging.thredSleep}")
    private String messagingThreadSleep;
    @Value(value="${messaging.initialThredSleep}")
    private String initialThredSleep;

    public void onMessage(Message message) {
        try {
            this.handleMessage(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"UNKNOWN_ERROR", null, (String)"UserTriggeredMsgEvtLogQueue", null);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }

    public void handleMessage(Message message) {
        try {
            if (null != this.initialThredSleep) {
                Long val = Long.parseLong(this.initialThredSleep);
                Thread.sleep(val);
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        System.out.println("UserTrigger Queue..." + new Date());
        if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
            // empty if block
        }
        DEBUGCOMMONLOGGER.debug((Object)"###### listened message on userTriggeredMsgQueue ######");
        DEBUGLOGGER.debug((Object)"############# listened message on userTriggeredMsgQueue ##########");
        Long userTriggeredMsgLogId = MsgQueueHelper.getMessageContent((Message)message);
        DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #1 User Trigger Message Event Log Id:=" + userTriggeredMsgLogId));
        SystemMsgEvent systemMsgEvent = null;
        SystemMsgEventConfig systemMsgEventConfig = null;
        SysMsgEvtDefaultConfig sysMsgEvtDefaultConfig = null;
        UserTriggeredMsgEvtLog userTriggeredMsgEvtLog = null;
        List msgEventScopes = null;
        Map eventContextScopeParamMap = null;
        try {
            try {
                userTriggeredMsgEvtLog = (UserTriggeredMsgEvtLog)this.userTriggeredMsgEvtLogService.findById(userTriggeredMsgLogId);
                if (this.messagingConsolePrint.equalsIgnoreCase("Yes")) {
                    // empty if block
                }
                DEBUGCOMMONLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #2 User Trigger Message Event Log :=" + userTriggeredMsgEvtLog.getId()));
                DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #2 User Trigger Message Event Log :=" + userTriggeredMsgEvtLog.getId()));
                systemMsgEventConfig = userTriggeredMsgEvtLog.getSystemMsgEventConfig();
                DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #2 System Message Event Log :=" + systemMsgEventConfig.getId()));
                systemMsgEvent = systemMsgEventConfig.getSystemMsgEvent();
                DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #3 System Message Event Code :=" + systemMsgEvent.getCode()));
                sysMsgEvtDefaultConfig = this.sysMsgEvtDefaultConfigService.findByEventId(systemMsgEventConfig.getSystemMsgEvent().getId());
                DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #4 System Message Event DefaultConfig :=" + sysMsgEvtDefaultConfig.getId()));
                msgEventScopes = this.msgEventScopeService.findByMsgEventConfigId(systemMsgEventConfig.getId());
                DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #5  Message Event Scope Applicable (Size) :=" + msgEventScopes.size()));
                eventContextScopeParamMap = MsgLogHelper.buildEventContextScopeParamMap((MsgEventConfig)systemMsgEventConfig, (UserTriggeredMsgEvtLog)userTriggeredMsgEvtLog);
                DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #5   Event Context Scope Map (Size) :=" + eventContextScopeParamMap.size()));
            }
            catch (NullPointerException ex) {
                DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #6   Failure Point Reading Basic Configuration");
                DEBUGCOMMONLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #6   Failure Point Reading Basic Configuration " + ex.getMessage()));
                ex.printStackTrace();
                MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"CONFIGURATION_ERROR", null, (String)"UserTriggeredMsgEvtLogQueue", (Long)userTriggeredMsgLogId);
                this.msgErrorsService.create((Object)msgErrors);
                return;
            }
            DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #7   Check if Initiation Rule applicable Yes:No" + systemMsgEvent.getWhetherInitiationRuleApplicable()));
            Boolean isInitationConditionSatisfied = true;
            try {
                if (systemMsgEvent.getWhetherInitiationRuleApplicable().booleanValue()) {
                    DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #7.1   Execute Intiation Rule ");
                    MsgInitRuleConfig msgInitRuleConfig = (MsgInitRuleConfig)this.msgInitRuleConfigService.findById(systemMsgEventConfig.getMsgInitRuleConfig().getId());
                    DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #7.2  Message Intiation Rule Config Id=" + msgInitRuleConfig.getId()));
                    Map msginitRuleContextMap = MsgLogHelper.buildInitRuleContextMap((SysMsgEvtDefaultConfig)sysMsgEvtDefaultConfig, (Map)eventContextScopeParamMap, (List)msgEventScopes);
                    DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #7.3  Message Intiation Rule Context Map Size =" + msginitRuleContextMap.size()));
                    isInitationConditionSatisfied = this.msgRuleEvaluationService.isValidInitiationRule(msgInitRuleConfig, msginitRuleContextMap);
                    DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #7.4  Intiation Rule Satisfied =" + isInitationConditionSatisfied));
                }
            }
            catch (NullPointerException ex) {
                DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #7.5  Intiation Rule Checking Failure Point");
                DEBUGCOMMONLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #7.5  Intiation Rule Checking Failure Point " + ex.getMessage()));
                ex.printStackTrace();
                MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"INIT_RULE_CONFIG_ERROR", null, (String)"UserTriggeredMsgEvtLogQueue", (Long)userTriggeredMsgLogId);
                this.msgErrorsService.create((Object)msgErrors);
                return;
            }
            DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #8  Proceed to next step # Create Message Log");
            try {
                if (isInitationConditionSatisfied.booleanValue()) {
                    DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #8.1  Build Message Log record");
                    MsgLog msgLog = MsgLogHelper.buildMsgLogRecord((MsgEventConfig)systemMsgEventConfig, (SysMsgEvtDefaultConfig)sysMsgEvtDefaultConfig, (Map)eventContextScopeParamMap);
                    msgLog.setUserTriggeredMsgEvtLog(userTriggeredMsgEvtLog);
                    Long msgLogId = this.msgLogService.create((Object)msgLog);
                    DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #8.2   Message Log record Id=" + msgLogId));
                    DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #8.3   Pushing to Message Log Queue Msg Log Id=" + msgLogId));
                    this.messageQueueTemplate.convertAndSend("MsgLogQueue", (Object)msgLogId);
                    DEBUGLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #8.4   Pushed to Message Log Queue Msg Log Id=" + msgLogId));
                    DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #8.5   Check Repeation Applicable");
                    if (systemMsgEvent.getWhetherRepetationApplicable().booleanValue()) {
                        DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #8.5.1   Configure Repeation Cycle");
                        this.repeatitionEventService.repeat(systemMsgEventConfig, msgLog, "USER_TRIGGERED");
                        DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #8.5.2  Configured Repeation Cycle");
                    }
                }
            }
            catch (NullPointerException ex) {
                DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #8.6   Failure Point moving to next queue and repetation section");
                DEBUGCOMMONLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #8.6   Failure Point moving to next queue and repetation section " + ex.getMessage()));
                ex.printStackTrace();
                MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"UserTriggeredMsgEvtLogQueue", (Long)userTriggeredMsgLogId);
                this.msgErrorsService.create((Object)msgErrors);
                return;
            }
            DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #9   Mark as Finish for User Event Log");
            userTriggeredMsgEvtLog.setStatusCode(StatusCode.FINISH);
            this.userTriggeredMsgEvtLogService.update((Object)userTriggeredMsgEvtLog);
            DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #10   Done with User Trigged Message Queue Listener ");
        }
        catch (MessageCentralException ex) {
            DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #11 Excetption occured");
            DEBUGCOMMONLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #11 Excetption occured " + ex.getMessage()));
            ex.printStackTrace();
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)"DB_TRANSACTION_ERROR", null, (String)"UserTriggeredMsgEvtLogQueue", (Long)userTriggeredMsgLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
        catch (AmqpAuthenticationException | AmqpConnectException | AmqpIOException ex) {
            DEBUGLOGGER.debug((Object)" UserTriggeredMsgQueueListener #12  Exception occured ");
            DEBUGCOMMONLOGGER.debug((Object)(" UserTriggeredMsgQueueListener #12  Exception occured " + ex.getMessage()));
            ex.printStackTrace();
            String errorcode = RabbitMQHelper.findRabitMqErrorCode((AmqpException)ex);
            MsgErrors msgErrors = MsgErrorsHelper.buildMsgErrorReocrd((String)errorcode, (String)systemMsgEvent.getCode(), (String)"UserTriggeredMsgEvtLogQueue", (Long)userTriggeredMsgLogId);
            this.msgErrorsService.create((Object)msgErrors);
            return;
        }
    }
}

