/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.rs;

import in.serosoft.messaging.dto.NotificationDTO;
import in.serosoft.messaging.service.SNSNotificationService;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/sns/")
public class SNSResource {
    public static final String NOTIFICATION_TYPE_BOUNCE = "notificationType\":\"Bounce";
    public static final String NOTIFICATION_TYPE_DELIVERY = "notificationType\":\"Delivery";
    public static final String NOTIFICATION_TYPE_COMPLAINT = "notificationType\":\"Complaint";
    @Context
    private HttpServletRequest request;
    @Autowired
    private SNSNotificationService snsNotificationService;
    private static final Logger DEBUGLOGGER = Logger.getLogger((String)"SNSResourceLogger");

    @POST
    @Path(value="notification")
    @Consumes(value={"text/plain"})
    public Response listenNotification(String requestParams) throws JsonParseException, JsonMappingException, IOException {
        DEBUGLOGGER.debug((Object)("############# Response From AWS ########## " + requestParams));
        Response.ResponseBuilder responseBuilder = Response.status((int)403);
        if (requestParams.contains(NOTIFICATION_TYPE_BOUNCE)) {
            this.snsNotificationService.saveBouncedMessage(requestParams);
        } else if (requestParams.contains(NOTIFICATION_TYPE_DELIVERY)) {
            this.snsNotificationService.saveDeliveryMessage(requestParams);
        } else if (requestParams.contains(NOTIFICATION_TYPE_COMPLAINT)) {
            this.snsNotificationService.saveComplaintMessage(requestParams);
        }
        responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @POST
    @Path(value="getNotification")
    @Produces(value={"application/json"})
    public NotificationDTO getNotification() {
        NotificationDTO notificationDTO = new NotificationDTO();
        notificationDTO.setMessage("hgsfdhgsdhcv");
        return notificationDTO;
    }
}

