/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.rs;

import in.serosoft.messaging.entity.MsgEventConfig;
import in.serosoft.messaging.entity.MsgInitRuleConfig;
import in.serosoft.messaging.service.MsgEventConfigService;
import in.serosoft.messaging.service.MsgInitRuleConfigService;
import in.serosoft.messaging.utility.ServerApplicationContextUtil;
import java.text.ParseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/cronschedular/")
public class SchedularResource {
    @Autowired
    MsgEventConfigService msgEventConfigService;
    @Autowired
    MsgInitRuleConfigService msgInitRuleConfigService;
    @Autowired
    private AmqpTemplate messageQueueTemplate;

    @POST
    @Path(value="updateTrigger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Long updateTrigger(@QueryParam(value="cronexp") String cronexpression) throws SchedulerException, ParseException {
        StdScheduler stdScheduler = this.getStdScheduler();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("cronTrigger", "group1").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronexpression)).build();
        stdScheduler.scheduleJob((Trigger)trigger);
        return 1L;
    }

    @POST
    @Path(value="addTrigger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Long addTrigger(@QueryParam(value="job") String jobName, @QueryParam(value="trigger") String triggerName, @QueryParam(value="cronexp") String cronexpression) throws SchedulerException, ParseException {
        StdScheduler stdScheduler = this.getStdScheduler();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("contextData", triggerName + " cdata");
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, "group1").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronexpression)).usingJobData(jobDataMap).forJob(jobName, "group1").build();
        stdScheduler.scheduleJob((Trigger)trigger);
        return 1L;
    }

    @POST
    @Path(value="removeTrigger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Long removeTrigger(@QueryParam(value="job") String jobName, @QueryParam(value="trigger") String triggerName) throws SchedulerException, ParseException {
        StdScheduler stdScheduler = this.getStdScheduler();
        TriggerKey triggerKey = new TriggerKey(triggerName, "group1");
        stdScheduler.resumeTrigger(triggerKey);
        return 1L;
    }

    private StdScheduler getStdScheduler() {
        StdScheduler stdScheduler = (StdScheduler)ServerApplicationContextUtil.getBeanById((String)"stdScheduler");
        return stdScheduler;
    }

    @POST
    @Path(value="scheduleEvent")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Long scheduleEvent(@QueryParam(value="msgEventId") Long msgEventId, @QueryParam(value="trigger") String cronDef) throws SchedulerException, ParseException {
        MsgEventConfig msgEventConfig = (MsgEventConfig)this.msgEventConfigService.findById(msgEventId);
        MsgInitRuleConfig msgInitRuleConfig = msgEventConfig.getMsgInitRuleConfig();
        msgInitRuleConfig.setInitScheduleCronDef(cronDef);
        this.msgInitRuleConfigService.update((Object)msgInitRuleConfig);
        this.messageQueueTemplate.convertAndSend("ScheduleMsgQueue", (Object)msgEventId);
        return 1L;
    }

    @POST
    @Path(value="scheduleAdhocEvent")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Long scheduleAdhocEvent(@QueryParam(value="msgEventId") Long msgEventId, @QueryParam(value="trigger") String cronDef) throws SchedulerException, ParseException {
        this.messageQueueTemplate.convertAndSend("AdhocMsgEvtQueue", (Object)msgEventId);
        return 1L;
    }
}

