/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.scheduler;

import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.utility.Gateway4SMSUtil;
import in.serosoft.messaging.utility.ServerApplicationContextUtil;
import java.io.IOException;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class SMSDeliveryStatusUpdaterJob
extends QuartzJobBean {
    private MsgRecipientLogService msgRecipientLogService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        this.msgRecipientLogService = this.getMsgRecipientLogService();
        List msgRecipientLogs = this.msgRecipientLogService.findAllSentSMSLogs();
        for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
            this.updateDeliveryStatus(msgRecipientLog);
            this.msgRecipientLogService.update((Object)msgRecipientLog);
        }
    }

    private void updateDeliveryStatus(MsgRecipientLog msgRecipientLog) {
        String messageId = msgRecipientLog.getMessageId();
        String status = msgRecipientLog.getDeliveryStatus();
        try {
            status = Gateway4SMSUtil.getDeliveryReports((String)messageId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        msgRecipientLog.setDeliveryStatus(status);
    }

    public MsgRecipientLogService getMsgRecipientLogService() {
        MsgRecipientLogService msgRecipientLogService = (MsgRecipientLogService)ServerApplicationContextUtil.getBeanById((String)"msgRecipientLogService");
        return msgRecipientLogService;
    }
}

