/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.cb.entity.SearchConfigTable;
import in.serosoft.cb.enumeration.LogicalOperatorEnum;
import in.serosoft.cb.enumeration.SearchCriteriaTypeEnum;
import in.serosoft.cb.model.CBSearchResult;
import in.serosoft.cb.model.ResultDocument;
import in.serosoft.cb.model.advanced.AdvancedSearchCriteria;
import in.serosoft.cb.model.advanced.AdvancedSearchDTO;
import in.serosoft.cb.model.advanced.SearchCriteria;
import in.serosoft.cb.service.SearchEngineService;
import in.serosoft.cb.service.SearchTableColumnService;
import in.serosoft.messaging.dao.DataProviderDAO;
import in.serosoft.messaging.dao.MsgGenericDAO;
import in.serosoft.messaging.entity.CbDataProvider;
import in.serosoft.messaging.entity.DataProvider;
import in.serosoft.messaging.entity.DataProviderInputParam;
import in.serosoft.messaging.entity.DataProviderInstance;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.entity.MsgScopeParam;
import in.serosoft.messaging.entity.MsgTemplateConfig;
import in.serosoft.messaging.entity.SqlDataProvider;
import in.serosoft.messaging.entity.TemplateDataProvider;
import in.serosoft.messaging.helper.CriteriaBuilderSearchHelper;
import in.serosoft.messaging.service.CbDataProviderService;
import in.serosoft.messaging.service.DataProviderEvaluationService;
import in.serosoft.messaging.service.DataProviderInstanceService;
import in.serosoft.messaging.service.MsgScopeParamService;
import in.serosoft.messaging.service.SqlDataProviderService;
import in.serosoft.messaging.service.impl.MsgGenericServiceImpl;
import in.serosoft.messaging.wsentity.WSMsgRecipientTemplateData;
import in.serosoft.messaging.wsentity.WSMsgRecipientTemplateDataFields;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="dataProviderEvaluationService")
public class DataProviderEvaluationServiceImpl
extends MsgGenericServiceImpl<DataProvider>
implements DataProviderEvaluationService {
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");
    private static final String NAMED_PARAMS = "namedParams";
    private static final String USER_ID = "USER_ID";
    @Autowired
    private DataProviderDAO dataProviderDAO;
    @Autowired
    MsgScopeParamService msgScopeParamService;
    @Autowired
    SearchEngineService searchEngineService;
    @Autowired
    SearchTableColumnService searchTableColumnService;
    @Autowired
    SqlDataProviderService sqlDataProviderService;
    @Autowired
    CbDataProviderService cbDataProviderService;
    @Autowired
    DataProviderInstanceService dataProviderInstanceService;

    public MsgGenericDAO<DataProvider, Long> getBaseDAO() {
        return this.dataProviderDAO;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public List<ResultDocument> executeCBSavedSearch(DataProviderInstance dataProviderInstance, Map<Long, Object> msgContextMap) {
        DataProvider dataProvider = (DataProvider)this.dataProviderDAO.findById(dataProviderInstance.getDataProvider().getId());
        List msgScopeParams = this.msgScopeParamService.findAll();
        AdvancedSearchDTO advancedSearchDTO = this.searchEngineService.loadSaveSearch(dataProviderInstance.getSavedRuleRefId());
        advancedSearchDTO = CriteriaBuilderSearchHelper.replaceNamedParameter((AdvancedSearchDTO)advancedSearchDTO, msgContextMap, (DataProvider)dataProvider, (List)msgScopeParams);
        CBSearchResult cbSearchResult = this.searchEngineService.executeSearch(advancedSearchDTO);
        return cbSearchResult.getResultDocuments();
    }

    public List<ResultDocument> buildSQLAndExecuteSearch(Long dataProviderId, List<Long> receipientIds, Map<Integer, String> resultColumns, Map<Long, Object> msgContextMap) {
        SqlDataProvider sqlDataProvider = this.sqlDataProviderService.findbyDtproviderId(dataProviderId);
        String sql = sqlDataProvider.getSqlQuery();
        String ids = receipientIds.toString();
        ids = ids.substring(1, ids.length() - 1);
        sql = sql.replace("namedParams", ids);
        sql = this.replaceMessageScopeIds(sql, msgContextMap);
        List resultDocument = this.sqlDataProviderService.executeSQLQuery(sql, resultColumns);
        return resultDocument;
    }

    private String replaceMessageScopeIds(String sql, Map<Long, Object> msgContextMap) {
        String programCriteriaExp = "<MSG@PROGRAM_CRITERIA>([^>]*)</MSG>";
        String acadLocCriteriaExp = "<MSG@ACAD_LOC_CRITERIA>([^>]*)</MSG>";
        String batchCriteriaExp = "<MSG@BATCH_CRITERIA>([^>]*)</MSG>";
        if (msgContextMap.get(6L) != null) {
            List programIds = (List)msgContextMap.get(6L);
            sql = sql.replaceFirst(programCriteriaExp, "$1");
            sql = sql.replace("msg_scope_programIds", StringUtils.collectionToCommaDelimitedString((Collection)programIds));
        } else {
            sql = sql.replaceFirst(programCriteriaExp, " ");
        }
        if (msgContextMap.get(7L) != null) {
            List acadLocIds = (List)msgContextMap.get(7L);
            sql = sql.replaceFirst(acadLocCriteriaExp, "$1");
            sql = sql.replace("msg_scope_acad_loc_Ids", StringUtils.collectionToCommaDelimitedString((Collection)acadLocIds));
        } else {
            sql = sql.replaceFirst(acadLocCriteriaExp, " ");
        }
        if (msgContextMap.get(3L) != null) {
            List batchIds = (List)msgContextMap.get(3L);
            sql = sql.replaceFirst(batchCriteriaExp, "$1");
            sql = sql.replace("msg_scope_batchIds", StringUtils.collectionToCommaDelimitedString((Collection)batchIds));
        } else {
            sql = sql.replaceFirst(batchCriteriaExp, " ");
        }
        return sql;
    }

    public List<ResultDocument> buildSQLAndExecuteSearch(Long dataProviderId, List<Long> receipientIds) {
        SqlDataProvider sqlDataProvider = this.sqlDataProviderService.findbyDtproviderId(dataProviderId);
        Map resultColumns = this.buildResultColumns(sqlDataProvider.getJsonString());
        String sql = sqlDataProvider.getSqlQuery();
        String ids = receipientIds.toString();
        ids = ids.substring(1, ids.length() - 1);
        sql = sql.replace("namedParams", ids);
        List resultDocument = this.sqlDataProviderService.executeSQLQuery(sql, resultColumns);
        DEBUGCOMMONLOGGER.debug((Object)("###### DataProviderEvaluationServiceImpl MsgReceipntsQueue #1 buildSQLAndExecuteSearch dataProviderId ########## " + dataProviderId + " sqlDataProvider " + sqlDataProvider.getId() + " receipientIds " + ids));
        return resultDocument;
    }

    private Map<Integer, String> buildResultColumns(String sqlQuery) {
        HashMap<Integer, String> resultColumns = new HashMap<Integer, String>();
        try {
            WSMsgRecipientTemplateData wsMsgRecipientTemplateData = (WSMsgRecipientTemplateData)new ObjectMapper().readValue(sqlQuery, WSMsgRecipientTemplateData.class);
            List wsMsgRecipientTemplateDataFields = wsMsgRecipientTemplateData.getSearchResultViewColumns();
            Collections.sort(wsMsgRecipientTemplateDataFields, new WSMsgRecipientTemplateDataFields());
            for (WSMsgRecipientTemplateDataFields wsMsgRecipientTemplateDataField : wsMsgRecipientTemplateDataFields) {
                resultColumns.put(wsMsgRecipientTemplateDataField.getDisplayOrder(), wsMsgRecipientTemplateDataField.getResultKey());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultColumns;
    }

    public List<ResultDocument> readRecipientsData(MsgRecipientTypeLog msgRecipientTypeLog, List<Long> receipientIds) {
        if (msgRecipientTypeLog.getMsgRecipientType().getDataProvider() != null) {
            Long dataProviderId = msgRecipientTypeLog.getMsgRecipientType().getDataProvider().getId();
            List resultDocuments = this.buildSQLAndExecuteSearch(dataProviderId, receipientIds);
            return resultDocuments;
        }
        return new ArrayList<ResultDocument>();
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public List<Long> buildDistributionList(MsgRecipientTypeLog msgRecipientTypeLog, Map<Long, Object> msgContextMap) {
        Long distrListInstanceId = msgRecipientTypeLog.getMsgEventRecipientConfig().getDistrListInstance().getId();
        DataProviderInstance distrListInstance = (DataProviderInstance)this.dataProviderInstanceService.findById(distrListInstanceId);
        ArrayList<Long> receipientIds = new ArrayList<Long>();
        if (distrListInstance.getSavedRuleRefId() != null) {
            List resultDocuments = this.executeCBSavedSearch(distrListInstance, msgContextMap);
            for (ResultDocument resultDocument : resultDocuments) {
                Long id = Long.valueOf(resultDocument.get((Object)"USER_ID").toString());
                receipientIds.add(id);
            }
        } else {
            Long dataProviderId = distrListInstance.getDataProvider().getId();
            HashMap<Integer, String> resultColumns = new HashMap<Integer, String>();
            resultColumns.put(0, "USER_ID");
            ArrayList<Long> contextRecordid = new ArrayList<Long>();
            if (msgContextMap.get(1L) != null) {
                contextRecordid.add(Long.valueOf(msgContextMap.get(1L).toString()));
            }
            List resultDocuments = this.buildSQLAndExecuteSearch(dataProviderId, contextRecordid, resultColumns);
            for (ResultDocument resultDocument : resultDocuments) {
                Long id = Long.valueOf(resultDocument.get((Object)"USER_ID").toString());
                receipientIds.add(id);
            }
        }
        return receipientIds;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public List<ResultDocument> buildDistributionListWithExtraDetails(MsgRecipientTypeLog msgRecipientTypeLog, Map<Long, Object> msgContextMap) {
        List resultDocuments = null;
        if (msgRecipientTypeLog.getMsgEventRecipientConfig().getSelectiveRecipients() != null) {
            String[] receipients;
            resultDocuments = new ArrayList();
            for (String receipientId : receipients = StringUtils.tokenizeToStringArray((String)msgRecipientTypeLog.getMsgEventRecipientConfig().getSelectiveRecipients(), (String)",")) {
                HashMap<String, Long> userIdMap = new HashMap<String, Long>();
                userIdMap.put("USER_ID", Long.valueOf(receipientId));
                ResultDocument rd = new ResultDocument();
                rd.putAll(userIdMap);
                resultDocuments.add((ResultDocument)rd);
            }
            return resultDocuments;
        }
        Long distrListInstanceId = msgRecipientTypeLog.getMsgEventRecipientConfig().getDistrListInstance().getId();
        DataProviderInstance distrListInstance = (DataProviderInstance)this.dataProviderInstanceService.findById(distrListInstanceId);
        if (distrListInstance.getSavedRuleRefId() != null) {
            resultDocuments = this.executeCBSavedSearch(distrListInstance, msgContextMap);
        } else {
            Long dataProviderId = distrListInstance.getDataProvider().getId();
            HashMap<Integer, String> resultColumns = new HashMap<Integer, String>();
            resultColumns.put(0, "USER_ID");
            ArrayList<Long> contextRecordid = new ArrayList<Long>();
            if (msgContextMap.get(1L) != null) {
                contextRecordid.add(Long.valueOf(msgContextMap.get(1L).toString()));
            } else {
                Long scopeParamId = ((DataProviderInputParam)distrListInstance.getDataProvider().getDataProviderInputParams().iterator().next()).getMsgScopeParam().getId();
                contextRecordid.add(Long.valueOf(msgContextMap.get(scopeParamId).toString()));
            }
            resultDocuments = this.buildSQLAndExecuteSearch(dataProviderId, contextRecordid, resultColumns, msgContextMap);
        }
        return resultDocuments;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public ResultDocument readTemplateData(MsgTemplateConfig msgTemplateConfig, Map<Long, Object> msgContextMap) {
        if (msgTemplateConfig.getWhetherStaticMsg().booleanValue()) {
            return null;
        }
        TemplateDataProvider templateDataProvider = msgTemplateConfig.getTemplateDataProvider();
        if (templateDataProvider != null) {
            Long dataProviderId = templateDataProvider.getDataProvider().getId();
            DataProvider dataProvider = (DataProvider)this.dataProviderDAO.findById(dataProviderId);
            List resultDocument = new ArrayList();
            if (dataProvider.getDataProviderType().equals("CB")) {
                resultDocument = this.buildCBAndExecuteSeacrh(dataProvider, msgContextMap);
            } else if (dataProvider.getDataProviderType().equals("SQL")) {
                ArrayList<Long> contextScopeParamIds = new ArrayList<Long>();
                Long scopeParamId = ((DataProviderInputParam)dataProvider.getDataProviderInputParams().iterator().next()).getMsgScopeParam().getId();
                contextScopeParamIds.add(Long.valueOf(msgContextMap.get(scopeParamId).toString()));
                resultDocument = this.buildSQLAndExecuteSearch(dataProviderId, contextScopeParamIds);
            }
            return (ResultDocument)resultDocument.get(0);
        }
        return null;
    }

    public List<ResultDocument> buildCBAndExecuteSeacrh(DataProvider dataProvider, Map<Long, Object> msgContextMap) {
        CbDataProvider cbDataProvider = this.cbDataProviderService.findByDtproviderId(dataProvider.getId());
        Set dataProviderInputParams = dataProvider.getDataProviderInputParams();
        AdvancedSearchDTO advancedSearchDTO = new AdvancedSearchDTO();
        advancedSearchDTO.setConfigCode(cbDataProvider.getSearchConfigCode());
        advancedSearchDTO.setViewCode(cbDataProvider.getSearchResultViewCode());
        SearchCriteria cbSearchCriteria = new SearchCriteria();
        cbSearchCriteria.setLogicalOperator(LogicalOperatorEnum.AND);
        cbSearchCriteria.setType(SearchCriteriaTypeEnum.LOGICAL);
        ArrayList<SearchCriteria> contextSearchCriterias = new ArrayList<SearchCriteria>();
        for (DataProviderInputParam dataProviderInputParam : dataProviderInputParams) {
            SearchCriteria sqlSearchCriteria = this.buildSqlSearchCriteria(cbDataProvider.getSearchConfigCode(), dataProviderInputParam, msgContextMap);
            contextSearchCriterias.add(sqlSearchCriteria);
        }
        cbSearchCriteria.setSearchCriterias(contextSearchCriterias);
        advancedSearchDTO.setCbSearchCriteria(cbSearchCriteria);
        CBSearchResult cbSearchResult = this.searchEngineService.executeSearch(advancedSearchDTO);
        List resultDocuments = cbSearchResult.getResultDocuments();
        String extraParamJson = (String)msgContextMap.get(8L);
        if (extraParamJson != null) {
            this.insertExtraParams(resultDocuments, extraParamJson);
        }
        return resultDocuments;
    }

    public void insertExtraParams(List<ResultDocument> resultDocuments, String extraParamJson) {
        Map extraParamMap = DataProviderEvaluationServiceImpl.buildHashmapFromJson((String)extraParamJson);
        for (Map.Entry entry : extraParamMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            for (ResultDocument resultDocument : resultDocuments) {
                if (resultDocument.get((Object)key) == null) continue;
                resultDocument.put((Object)key, (Object)value);
            }
        }
    }

    public static Map<String, String> buildHashmapFromJson(String jsonString) {
        Map<String, String> extraParamMap = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            extraParamMap = (Map)mapper.readValue(jsonString, HashMap.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return extraParamMap;
    }

    private SearchCriteria buildSqlSearchCriteria(String configCode, DataProviderInputParam dataProviderInputParam, Map<Long, Object> msgContextMap) {
        String paramName = dataProviderInputParam.getParamName();
        String searchConfigTableAlias = paramName.substring(0, paramName.indexOf(46));
        String columnName = paramName.substring(paramName.indexOf(46) + 1, paramName.length());
        SearchConfigTable searchConfigTable = this.searchTableColumnService.findSearchConfigTableByTableAlias(configCode, searchConfigTableAlias);
        Long searchTableColumnId = this.searchTableColumnService.findSearchTableColumnIdByColumnName(searchConfigTable.getSearchTableBySearchTableId().getId(), columnName);
        Object[] paramValues = this.readParamValue(msgContextMap, dataProviderInputParam.getMsgScopeParam());
        AdvancedSearchCriteria advancedSearchCriteria = new AdvancedSearchCriteria();
        advancedSearchCriteria.setSearchConfigEntityId(searchConfigTable.getId());
        advancedSearchCriteria.setSearchTableColumnId(searchTableColumnId);
        advancedSearchCriteria.setSearchCriteriaOperatorId(this.findSearchCriteriaOperatorId(dataProviderInputParam));
        advancedSearchCriteria.setOperands(paramValues);
        SearchCriteria sqlSearchCriteria = new SearchCriteria();
        sqlSearchCriteria.setAdvancedSearchCriteria(advancedSearchCriteria);
        sqlSearchCriteria.setType(SearchCriteriaTypeEnum.SQL);
        return sqlSearchCriteria;
    }

    private Object[] readParamValue(Map<Long, Object> msgContextMap, MsgScopeParam msgScopeParam) {
        if (msgContextMap.get(msgScopeParam.getId()) instanceof String || msgContextMap.get(msgScopeParam.getId()) instanceof Long) {
            Object[] paramValues = new Object[]{msgContextMap.get(msgScopeParam.getId())};
            return paramValues;
        }
        if (msgContextMap.get(msgScopeParam.getId()) instanceof ArrayList) {
            ArrayList list = (ArrayList)msgContextMap.get(msgScopeParam.getId());
            Object[] objectArray = new Object[list.size()];
            objectArray = list.toArray(objectArray);
            return objectArray;
        }
        return new Object[0];
    }

    private Long findSearchCriteriaOperatorId(DataProviderInputParam dataProviderInputParam) {
        Long searchCriteriaOperatorId = dataProviderInputParam.getParamDataType().equals("NUMBER") ? Long.valueOf(18L) : Long.valueOf(9L);
        return searchCriteriaOperatorId;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true)
    public DataProvider findDataProviderById(Long id) {
        return (DataProvider)this.dataProviderDAO.findById(id);
    }

    public DataProviderInstance findDataProviderInstanceById(Long id) {
        DataProviderInstance distrListInstance = (DataProviderInstance)this.dataProviderInstanceService.findById(id);
        return distrListInstance;
    }

    public List<ResultDocument> buildSQLAndExecuteSearch(Long dataProviderId, List<Long> receipientIds, Map<Integer, String> resultColumns) {
        SqlDataProvider sqlDataProvider = this.sqlDataProviderService.findbyDtproviderId(dataProviderId);
        String sql = sqlDataProvider.getSqlQuery();
        String ids = receipientIds.toString();
        ids = ids.substring(1, ids.length() - 1);
        sql = sql.replace("namedParams", ids);
        List resultDocument = this.sqlDataProviderService.executeSQLQuery(sql, resultColumns);
        DEBUGCOMMONLOGGER.debug((Object)("###### DataProviderEvaluationServiceImpl MsgReceipntsQueue #1 buildSQLAndExecuteSearch dataProviderId ########## " + dataProviderId + " sqlDataProvider " + sqlDataProvider.getId() + " receipientIds " + ids));
        return resultDocument;
    }
}

