/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.cb.model.ResultDocument;
import in.serosoft.messaging.dto.MessageDTO;
import in.serosoft.messaging.dto.SystemInternalNotificationInfoDTO;
import in.serosoft.messaging.dto.UserInfoDTO;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.MsgRecipientDocuments;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.entity.MsgScopeParam;
import in.serosoft.messaging.entity.MsgTemplate;
import in.serosoft.messaging.entity.MsgTemplateConfig;
import in.serosoft.messaging.entity.TemplateConfigDocuments;
import in.serosoft.messaging.helper.MsgContentBuilderHelper;
import in.serosoft.messaging.helper.MsgRcpntsQueueHelper;
import in.serosoft.messaging.service.DataProviderEvaluationService;
import in.serosoft.messaging.service.GatewayCredentialsService;
import in.serosoft.messaging.service.MsgContentBuilderService;
import in.serosoft.messaging.service.MsgDeliveryModeLogService;
import in.serosoft.messaging.service.MsgErrorsService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRecipientDocumentsService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRecipientTypeLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.MsgScopeParamService;
import in.serosoft.messaging.service.MsgTemplateConfigService;
import in.serosoft.messaging.service.MsgTemplateService;
import in.serosoft.messaging.service.TemplateConfigDocumentsService;
import in.serosoft.messaging.wsentity.WSMsgTemplateRecipientDataList;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="msgContentBuilderService")
public class MsgContentBuilderServiceImpl
implements MsgContentBuilderService {
    private static final String PARENT_NAME = "parentName";
    private static final String FACULTY_NAME = "facultyName";
    private static final String DD_MM_YYYY = "dd-MM-yyyy";
    private static final String ATTENDANCE_LIST = "attendanceList";
    private static final String ACADEMY_NAME2 = "academyName";
    private static final String STUDENT_FIRSTNAME = "STUDENT_FIRSTNAME";
    private static final String SLOT_TO = "SLOT_TO";
    private static final String SLOT_FROM = "SLOT_FROM";
    private static final String SESSION_DATE = "SESSION_DATE";
    private static final String PROGRAM_NAME = "PROGRAM_NAME";
    private static final String PARENT_LAST_NAME = "PARENT_LAST_NAME";
    private static final String PARENT_FIRST_NAME = "PARENT_FIRST_NAME";
    private static final String LANGUAGE_KEY = "LANGUAGE_KEY";
    private static final String USER_TYPE_KEY = "USER_TYPE_KEY";
    private static final String LAST_NAME = "LAST_NAME";
    private static final String FIRST_NAME = "FIRST_NAME";
    private static final String COURSE_NAME = "COURSE_NAME";
    private static final String PRESENT_PERCENTAGE = "PRESENT_PERCENTAGE";
    private static final String COURSE_CODE = "COURSE_CODE";
    private static final String STUDENT_NAME = "studentName";
    private static final String TOTAL_LEAVE = "TOTAL_LEAVE";
    private static final String TOTAL_ABSENT = "TOTAL_ABSENT";
    private static final String TOTAL_PRESENT = "TOTAL_PRESENT";
    private static final String TOTAL_SESSIONS = "TOTAL_SESSIONS";
    private static final String COMPONENT_DESC = "COMPONENT_DESC";
    private static final String ACADEMY_NAME = "ACADEMY_NAME";
    private static final String HOSTEL_CHECK_OUT_LIST = "hostelCheckOutList";
    private static final String HOSTEL_MANAGER_NAME = "hostelManager";
    private static final String HOSTEL_ADMIN_NAME = "hostelAdmin";
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    MsgRecipientTypeLogService msgRecipientTypeLogService;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    MsgDeliveryModeLogService msgDeliveryModeLogService;
    @Autowired
    DataProviderEvaluationService dataProviderEvaluationService;
    @Autowired
    MsgTemplateService msgTemplateService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    TemplateConfigDocumentsService templateConfigDocumentsService;
    @Autowired
    MsgErrorsService msgErrorsService;
    @Autowired
    MsgTemplateConfigService messageTemplateConfigService;
    @Autowired
    MsgRecipientDocumentsService msgRecipientDocumentsService;
    @Autowired
    MsgScopeParamService mesMsgScopeParamService;
    @Autowired
    GatewayCredentialsService gatewayCredentialsService;
    @Value(value="${document.constant.base.dir}")
    private String baseDir;

    public MessageDTO buildContents(Long msgRcpntLogId, Logger debugLogger, String queueListener) {
        String queryForParentRP;
        String queryForCommittee;
        UserInfoDTO userInfoDTO;
        String sposorQuery;
        String studentQuery;
        String applicantQuery;
        UserInfoDTO userInfoDTO2;
        MsgRecipientLog msgRecipientLog = (MsgRecipientLog)this.msgRecipientLogService.findById(msgRcpntLogId);
        debugLogger.debug((Object)(queueListener + "#2.1 Read msgRecipientLog id: " + msgRecipientLog.getId()));
        MsgRecipientTypeLog msgRecipientTypeLog = (MsgRecipientTypeLog)this.msgRecipientTypeLogService.findById(msgRecipientLog.getMsgRecipientTypeLog().getId());
        debugLogger.debug((Object)(queueListener + "#2.2 Read msgRecipientTypeLog id: " + msgRecipientTypeLog.getId()));
        MsgLog msgLog = (MsgLog)this.msgLogService.findById(msgRecipientTypeLog.getMsgLog().getId());
        debugLogger.debug((Object)(queueListener + "#2.3 Read msgLog id: " + msgLog.getId()));
        debugLogger.debug((Object)(queueListener + "#2.4 Reading recipientData basic details"));
        ResultDocument recipientData = this.readRecipientData(msgRecipientTypeLog, msgRecipientLog.getRecipientId());
        debugLogger.debug((Object)(queueListener + "#2.6 Read recipientData basic details complete. "));
        debugLogger.debug((Object)(queueListener + "#2.8 Building msgContextMap."));
        Map msgContextMap = this.msgRuleEvaluationService.buildMessageContextMap(msgRecipientTypeLog);
        debugLogger.debug((Object)(queueListener + "#2.9 Building msgContextMap complete. Size:" + msgContextMap.size()));
        debugLogger.debug((Object)(queueListener + "#2.10 Building Recepient List."));
        List receipientIds = MsgRcpntsQueueHelper.buildRecepientList((MsgRecipientLog)msgRecipientLog);
        debugLogger.debug((Object)(queueListener + "#2.11 Build Recepient List Complete. Size:" + receipientIds.size()));
        msgContextMap.put(4L, receipientIds);
        debugLogger.debug((Object)(queueListener + "#2.12 Reading distribution scope parameters and pushing to msgContextMap"));
        this.readDistributionScopeParameters(msgContextMap, msgRecipientLog);
        debugLogger.debug((Object)(queueListener + "#2.13 Read distribution scope parameters complete and pushed to msgContextMap size :" + msgContextMap.size()));
        debugLogger.debug((Object)(queueListener + "#2.14 Reading msgTemplateConfig"));
        MsgTemplateConfig msgTemplateConfig = null;
        if (null != msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgTemplateConfig().getSystemMsgEvent()) {
            msgTemplateConfig = this.msgTemplateService.findByLanguage(msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgTemplateConfig().getSystemMsgEvent().getId(), (String)recipientData.get((Object)LANGUAGE_KEY), msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgRecipientType().getId());
            if (msgTemplateConfig == null) {
                msgTemplateConfig = (MsgTemplateConfig)this.messageTemplateConfigService.findById(msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgTemplateConfig().getId());
                if ((String)recipientData.get((Object)LANGUAGE_KEY) == null) {
                    msgRecipientLog.setTemplateTosend(msgTemplateConfig.getTemplateLanguageValue());
                    msgRecipientLog.setTemplateActuallySent(msgTemplateConfig.getTemplateLanguageValue());
                } else {
                    msgRecipientLog.setTemplateTosend((String)recipientData.get((Object)LANGUAGE_KEY));
                    msgRecipientLog.setTemplateActuallySent(msgTemplateConfig.getTemplateLanguageValue());
                }
            } else {
                msgRecipientLog.setTemplateTosend((String)recipientData.get((Object)LANGUAGE_KEY));
                msgRecipientLog.setTemplateActuallySent(msgTemplateConfig.getTemplateLanguageValue());
            }
        } else {
            msgTemplateConfig = (MsgTemplateConfig)this.messageTemplateConfigService.findById(msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgTemplateConfig().getId());
        }
        if (null != recipientData.get((Object)USER_TYPE_KEY)) {
            msgRecipientLog.setUserType((String)recipientData.get((Object)USER_TYPE_KEY));
        }
        this.msgRecipientLogService.update((Object)msgRecipientLog);
        debugLogger.debug((Object)(queueListener + "#2.15 Reading templateData"));
        ResultDocument templateData = this.dataProviderEvaluationService.readTemplateData(msgTemplateConfig, msgContextMap);
        if (templateData != null) {
            Set templateDataKeys = templateData.keySet();
            for (String key : templateDataKeys) {
                if (!(templateData.get((Object)key) instanceof Double)) continue;
                Double d = (Double)templateData.get((Object)key);
                String str = String.format("%.2f", d);
                templateData.put((Object)key, (Object)str);
            }
            debugLogger.debug((Object)(queueListener + "#2.15 Reading templateData complete. size:" + templateData.size()));
        }
        debugLogger.debug((Object)(queueListener + "#2.16 Reading static attachemnts"));
        List templateConfigDocuments = this.templateConfigDocumentsService.findByMsgTemplateConfigId(msgTemplateConfig.getId());
        List attachmentsPaths = this.readAttachment(templateConfigDocuments);
        debugLogger.debug((Object)(queueListener + "#2.17 Reading static attachemnts complete. found " + attachmentsPaths.size() + " attachments."));
        debugLogger.debug((Object)(queueListener + "#2.18 Reading Message template"));
        MsgTemplate msgTemplate = this.msgTemplateService.findByMsgTemplateCnfgAndMode(msgTemplateConfig.getId(), msgRecipientLog.getMsgDeliveryMode().getId());
        debugLogger.debug((Object)(queueListener + "#2.19 building message DTO"));
        MessageDTO messageDTO = MsgContentBuilderHelper.buildMessageDTO((MsgRecipientLog)msgRecipientLog, (MsgTemplate)msgTemplate, (ResultDocument)recipientData, (ResultDocument)templateData, (MsgRecipientTypeLog)msgRecipientTypeLog, (List)attachmentsPaths, (MsgTemplateConfig)msgTemplateConfig);
        messageDTO.setMsgLogId(msgLog.getId());
        if (null != msgTemplate) {
            debugLogger.debug((Object)(queueListener + "#2.19.1 building message DTO TemplateID )" + msgTemplateConfig.getTemplateId()));
            messageDTO.setTemplateId(msgTemplateConfig.getTemplateId());
        }
        Long acadLocId = null;
        if (msgContextMap.get(14L) != null) {
            acadLocId = Long.valueOf((String)msgContextMap.get(14L));
        }
        messageDTO.setEventTriggerAcademyLocationId(acadLocId);
        Long msgFromUserId = 1L;
        if (msgContextMap.get(15L) != null) {
            msgFromUserId = Long.valueOf((String)msgContextMap.get(15L));
        }
        messageDTO.setMsgFromUserId(msgFromUserId);
        debugLogger.debug((Object)(queueListener + "#2.20 Reading dynamic attachments"));
        List msgRecipientDynamicDocuments = this.readMsgRecipientDynamicDocuments(msgRecipientLog);
        debugLogger.debug((Object)(queueListener + "#2.21 Reading dynamic attachments complete size:" + msgRecipientDynamicDocuments.size()));
        messageDTO.setMsgRecipientDynamicDocuments(msgRecipientDynamicDocuments);
        debugLogger.debug((Object)(queueListener + "#2.21 Added msgRecipientDynamicDocuments to messageDTO"));
        String msgRecipientType = msgRecipientLog.getMsgRecipientTypeLog().getMsgRecipientType().getCode();
        String studentCode = null;
        String applicantCode = null;
        String userCode = null;
        String facultyAdhocUserCode = null;
        String facultyLimeSurveyUserCode = null;
        String studentLimeSurveyStudentCode = null;
        String applicantLimeSurveyApplicantCode = null;
        String enquiryLimeSurveyEnquiryCode = null;
        String sponsorCode = null;
        String externalUserApplicantCode = null;
        String approveApplicationCode = null;
        String rejectApplicationCode = null;
        String approveAdmissionApplicantCode = null;
        String externalUserFPCode = null;
        String appLogCreCode = null;
        String parentLoginCode = null;
        String studentFPCode = null;
        String applicantRPCode = null;
        String committeeCode = null;
        String committeeAdhocCode = null;
        String parentRPCode = null;
        Boolean msgRecipientLogDeleted = false;
        if ("student".equalsIgnoreCase(msgRecipientType)) {
            userInfoDTO2 = this.gatewayCredentialsService.readStudentCodeInfo(msgRecipientLog.getRecipientId());
            if (userInfoDTO2 != null && userInfoDTO2.getStudentCode() != null) {
                studentCode = userInfoDTO2.getStudentCode();
            }
        } else if ("APPLICANT_ADHOC".equalsIgnoreCase(msgRecipientType)) {
            userInfoDTO2 = this.gatewayCredentialsService.readApplicantCodeInfo(msgRecipientLog.getRecipientId());
            if (userInfoDTO2 != null && userInfoDTO2.getApplicantCode() != null) {
                applicantCode = userInfoDTO2.getApplicantCode();
            }
        } else if ("User".equalsIgnoreCase(msgRecipientType)) {
            userInfoDTO2 = this.gatewayCredentialsService.readUserCodeInfo(msgRecipientLog.getRecipientId());
            if (userInfoDTO2 != null && userInfoDTO2.getUserCode() != null) {
                userCode = userInfoDTO2.getUserCode();
            }
        } else if ("FACULTY_ADHOC".equalsIgnoreCase(msgRecipientType)) {
            userInfoDTO2 = this.gatewayCredentialsService.readUserCodeInfo(msgRecipientLog.getRecipientId());
            if (userInfoDTO2 != null && userInfoDTO2.getUserCode() != null) {
                facultyAdhocUserCode = userInfoDTO2.getUserCode();
            }
        } else if ("LIME_SURVEY_FAC_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
            userInfoDTO2 = this.gatewayCredentialsService.readLimeSurveyStaffCode(msgRecipientLog.getRecipientId());
            if (userInfoDTO2 != null && userInfoDTO2.getUserCode() != null) {
                facultyLimeSurveyUserCode = userInfoDTO2.getUserCode();
            }
        } else if ("LIME_SURVEY_STU_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
            userInfoDTO2 = this.gatewayCredentialsService.readLimeSurveyStaffCode(msgRecipientLog.getRecipientId());
            if (userInfoDTO2 != null && userInfoDTO2.getStudentCode() != null) {
                studentLimeSurveyStudentCode = userInfoDTO2.getStudentCode();
            }
        } else if ("LIME_SURVEY_APP_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
            userInfoDTO2 = this.gatewayCredentialsService.readLimeSurveyApplicantCode(msgRecipientLog.getRecipientId());
            if (userInfoDTO2 != null && userInfoDTO2.getApplicantCode() != null) {
                applicantLimeSurveyApplicantCode = userInfoDTO2.getApplicantCode();
            }
        } else if ("LIME_SURVEY_ENQ_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
            userInfoDTO2 = this.gatewayCredentialsService.readLimeSurveyEnquiryCode(msgRecipientLog.getRecipientId());
            if (userInfoDTO2 != null && userInfoDTO2.getEnquiryCode() != null) {
                enquiryLimeSurveyEnquiryCode = userInfoDTO2.getEnquiryCode();
            }
        } else if ("MsgManualBill".equalsIgnoreCase(msgRecipientType)) {
            applicantQuery = "select applicantId as id from bill_header where id=";
            studentQuery = "select studentId as id from bill_header where id=";
            sposorQuery = "select sponsorId as id from bill_header where id=";
            String userQuery = "select userId as id from bill_header where id=";
            SystemInternalNotificationInfoDTO applicant = this.gatewayCredentialsService.billMadeFor(applicantQuery, msgRecipientLog.getRecipientId());
            SystemInternalNotificationInfoDTO student = this.gatewayCredentialsService.billMadeFor(studentQuery, msgRecipientLog.getRecipientId());
            SystemInternalNotificationInfoDTO sponsor = this.gatewayCredentialsService.billMadeFor(sposorQuery, msgRecipientLog.getRecipientId());
            SystemInternalNotificationInfoDTO user = this.gatewayCredentialsService.billMadeFor(userQuery, msgRecipientLog.getRecipientId());
            if (applicant.getId() != null) {
                String queryForApplicant = "select application.code as code from application inner join bill_header on application.id=bill_header.applicantId where bill_header.id=" + msgRecipientLog.getRecipientId();
                UserInfoDTO userInfoDTO3 = this.gatewayCredentialsService.readCodeForManualBillReceiptGeneration(queryForApplicant);
                applicantCode = userInfoDTO3.getCode();
            } else if (student.getId() != null) {
                String queryForStudent = "select users.code as code from users inner join students ON students.userId = users.id inner join bill_header on students.userId=bill_header.studentId where bill_header.id=" + msgRecipientLog.getRecipientId();
                UserInfoDTO userInfoDTO4 = this.gatewayCredentialsService.readCodeForManualBillReceiptGeneration(queryForStudent);
                studentCode = userInfoDTO4.getCode();
            } else if (sponsor.getId() != null) {
                String queryForSponsor = "select sponsors.sponsorshipCode as code from sponsors inner join bill_header on sponsors.id=bill_header.sponsorId where bill_header.id=" + msgRecipientLog.getRecipientId();
                UserInfoDTO userInfoDTO5 = this.gatewayCredentialsService.readCodeForManualBillReceiptGeneration(queryForSponsor);
                sponsorCode = userInfoDTO5.getCode();
            } else if (user.getId() != null) {
                String queryForUser = "select users.code as code from users inner join bill_header on users.id=bill_header.userId where bill_header.id=" + msgRecipientLog.getRecipientId();
                UserInfoDTO userInfoDTO6 = this.gatewayCredentialsService.readCodeForManualBillReceiptGeneration(queryForUser);
                userCode = userInfoDTO6.getCode();
            }
        } else if ("MSG_MANUAL_RECEIPT".equalsIgnoreCase(msgRecipientType)) {
            applicantQuery = "select applicantId as id from receipt_header where id=";
            studentQuery = "select studentId as id from receipt_header where id=";
            sposorQuery = "select sponsorId as id from receipt_header where id=";
            String userQuery = "select userId as id from receipt_header where id=";
            SystemInternalNotificationInfoDTO applicant = this.gatewayCredentialsService.billMadeFor(applicantQuery, msgRecipientLog.getRecipientId());
            SystemInternalNotificationInfoDTO student = this.gatewayCredentialsService.billMadeFor(studentQuery, msgRecipientLog.getRecipientId());
            SystemInternalNotificationInfoDTO sponsor = this.gatewayCredentialsService.billMadeFor(sposorQuery, msgRecipientLog.getRecipientId());
            SystemInternalNotificationInfoDTO user = this.gatewayCredentialsService.billMadeFor(userQuery, msgRecipientLog.getRecipientId());
            if (applicant.getId() != null) {
                String queryForApplicant = "select application.code as code from application inner join receipt_header on application.id=receipt_header.applicantId where receipt_header.id=" + msgRecipientLog.getRecipientId();
                UserInfoDTO userInfoDTO7 = this.gatewayCredentialsService.readCodeForManualBillReceiptGeneration(queryForApplicant);
                applicantCode = userInfoDTO7.getCode();
            } else if (student.getId() != null) {
                String queryForStudent = "select users.code as code from users inner join students ON students.userId = users.id inner join receipt_header on students.userId=receipt_header.studentId where receipt_header.id=" + msgRecipientLog.getRecipientId();
                UserInfoDTO userInfoDTO8 = this.gatewayCredentialsService.readCodeForManualBillReceiptGeneration(queryForStudent);
                studentCode = userInfoDTO8.getCode();
            } else if (sponsor.getId() != null) {
                String queryForSponsor = "select sponsors.sponsorshipCode as code from sponsors inner join receipt_header on sponsors.id=receipt_header.sponsorId where receipt_header.id=" + msgRecipientLog.getRecipientId();
                UserInfoDTO userInfoDTO9 = this.gatewayCredentialsService.readCodeForManualBillReceiptGeneration(queryForSponsor);
                sponsorCode = userInfoDTO9.getCode();
            } else if (user.getId() != null) {
                String queryForUser = "select users.code as code from users inner join receipt_header on users.id=receipt_header.userId where receipt_header.id=" + msgRecipientLog.getRecipientId();
                UserInfoDTO userInfoDTO10 = this.gatewayCredentialsService.readCodeForManualBillReceiptGeneration(queryForUser);
                userCode = userInfoDTO10.getCode();
            }
        } else if ("ADD_EXTERNAL_USER_RECIPIENT_INFO".equalsIgnoreCase(msgRecipientType)) {
            String queryForExternalUserCountryCode;
            UserInfoDTO usInfoDTO;
            String queryForExternalUserAdd = "select application.code as code from external_users inner join external_user_association on external_users.id=external_user_association.externalUserId inner join application on external_user_association.applicationId=application.id where external_users.id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForExternalUserAdd);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                externalUserApplicantCode = userInfoDTO.getCode();
            }
            if (msgRecipientLog.getMsgDeliveryMode().getId() == 2L && (usInfoDTO = this.gatewayCredentialsService.getCountryCodeForEvents(queryForExternalUserCountryCode = "SELECT applicant_person.mobileCountryCode as countryCode FROM external_users INNER JOIN external_user_association ON external_users.id = external_user_association.externalUserId INNER JOIN application ON external_user_association.applicationId = application.id INNER JOIN applicant_person on applicant_person.id = application.applicantPersonId WHERE external_users.id =" + msgRecipientLog.getRecipientId())) != null && !usInfoDTO.getCountryCode().equals("+91") && !usInfoDTO.getCountryCode().equals("91") && usInfoDTO.getCountryCode() == null) {
                this.msgRecipientLogService.delete(msgRecipientLog.getId());
                msgRecipientLogDeleted = true;
                messageDTO.setMsgRecipientLogId(null);
            }
        } else if ("APPROVE_APPLICATION_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
            String queryForApproveApplication = "select application.code as code from application where application.id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForApproveApplication);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                approveApplicationCode = userInfoDTO.getCode();
            }
        } else if ("REJECT_APPLICATION_RECIPIENTS".equalsIgnoreCase(msgRecipientType)) {
            String queryForRejectApplication = "select application.code as code from application where application.id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForRejectApplication);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                rejectApplicationCode = userInfoDTO.getCode();
            }
        } else if ("APPROVE_ADMISSION_APPLICANT_INFO".equalsIgnoreCase(msgRecipientType)) {
            String queryForApproveAdApplicant = "select application.code as code from applicant_person inner join application on application.applicantPersonId=applicant_person.id where applicant_person.id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForApproveAdApplicant);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                approveAdmissionApplicantCode = userInfoDTO.getCode();
            }
        } else if ("EXTERNAL_USER_FORGOT_PASSWORD_RECEPIENT_INFO".equalsIgnoreCase(msgRecipientType)) {
            String queryForExtUserFP = "select application.code as code from external_users inner join external_user_association on external_users.id=external_user_association.externalUserId inner join application on external_user_association.applicationId=application.id where external_users.id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForExtUserFP);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                externalUserFPCode = userInfoDTO.getCode();
            }
        } else if ("APPLICANT_LOGIN_CREDENTIAL_INFO".equalsIgnoreCase(msgRecipientType)) {
            String queryForALCI = "select application.code as code from external_users inner join external_user_association on external_users.id=external_user_association.externalUserId inner join application on external_user_association.applicationId=application.id where external_users.id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForALCI);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                appLogCreCode = userInfoDTO.getCode();
            }
        } else if ("Parent".equalsIgnoreCase(msgRecipientType)) {
            String queryForParent = "select users.code as code from users where id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForParent);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                parentLoginCode = userInfoDTO.getCode();
            }
        } else if ("Student_FP".equalsIgnoreCase(msgRecipientType)) {
            String queryForStudentFP = "select users.code as code from users where id =" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForStudentFP);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                studentFPCode = userInfoDTO.getCode();
            }
        } else if ("APPLICANT_RESET_PASSWORD_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
            String queryForApplicantRP = "select application.code as code from external_users inner join external_user_association on external_users.id=external_user_association.externalUserId inner join application on external_user_association.applicationId=application.id where external_users.id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForApplicantRP);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                applicantRPCode = userInfoDTO.getCode();
            }
        } else if ("COMMITTEE".equalsIgnoreCase(msgRecipientType)) {
            queryForCommittee = "select users.code as code from users where id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForCommittee);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                committeeCode = userInfoDTO.getCode();
            }
        } else if ("COMMITTEE_ADHOC".equalsIgnoreCase(msgRecipientType)) {
            queryForCommittee = "select users.code as code from users where id=" + msgRecipientLog.getRecipientId();
            userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForCommittee);
            if (userInfoDTO != null && userInfoDTO.getCode() != null) {
                committeeAdhocCode = userInfoDTO.getCode();
            }
        } else if ("PARENT_RESET_PASSWORD_RECIPIENT".equalsIgnoreCase(msgRecipientType) && (userInfoDTO = this.gatewayCredentialsService.readCodeForEvents(queryForParentRP = "select users.code as code from users where id=" + msgRecipientLog.getRecipientId())) != null && userInfoDTO.getCode() != null) {
            parentRPCode = userInfoDTO.getCode();
        }
        if (messageDTO.getMessageContent() != null && !msgRecipientLogDeleted.booleanValue()) {
            String firstName = null;
            String lastName = null;
            if ("CREATE_ENQUIRY_VELOCITY_RECIPIENTS".equalsIgnoreCase(msgRecipientType) || "SUBMIT_APPLICATION_RECIPIENTS".equalsIgnoreCase(msgRecipientType) || "ADD_EXTERNAL_USER_VELOCITY_RECIPIENT_INFO".equalsIgnoreCase(msgRecipientType) || "MSG_COURSEWISE_WEEKLY_PARENT".equalsIgnoreCase(msgRecipientType) || "ENQUIRY_REMINDER_TO_SCHEDULE_AN_APPOINTMENT_PARENT_RECIPIENT".equalsIgnoreCase(msgRecipientType) || "ENQUIRY_REMINDER_TO_APPLY_PARENT_RECIPIENT".equalsIgnoreCase(msgRecipientType) || "CREATE_ENQUIRY_PARENT_RECIPIENTS".equalsIgnoreCase(msgRecipientType) || "SUBMIT_APPLICATION_PAY_NOW_BUZZ_PARENT_RECIPIENT".equalsIgnoreCase(msgRecipientType)) {
                firstName = (String)recipientData.get((Object)PARENT_FIRST_NAME);
                lastName = (String)recipientData.get((Object)PARENT_LAST_NAME);
                if ("MSG_COURSEWISE_WEEKLY_PARENT".equalsIgnoreCase(msgRecipientType)) {
                    firstName = (String)recipientData.get((Object)PARENT_NAME);
                }
            } else if ("COMPLETE_ADMISSION_VELOCITY_INFO".equalsIgnoreCase(msgRecipientType)) {
                firstName = (String)recipientData.get((Object)"STUDENT_NAME");
            } else {
                firstName = (String)recipientData.get((Object)FIRST_NAME);
                lastName = (String)recipientData.get((Object)LAST_NAME);
            }
            String recipientName = firstName;
            if (lastName != null) {
                recipientName = firstName + " " + lastName;
            }
            msgRecipientLog.setMsgContent(messageDTO.getMessageContent());
            if (studentCode != null) {
                msgRecipientLog.setRecipientFullName(studentCode + "/" + recipientName);
            } else if (applicantCode != null) {
                msgRecipientLog.setRecipientFullName(applicantCode + "/" + recipientName);
            } else if (userCode != null) {
                msgRecipientLog.setRecipientFullName(userCode + "/" + recipientName);
            } else if (facultyAdhocUserCode != null) {
                msgRecipientLog.setRecipientFullName(facultyAdhocUserCode + "/" + recipientName);
            } else if (facultyLimeSurveyUserCode != null) {
                msgRecipientLog.setRecipientFullName(facultyLimeSurveyUserCode + "/" + recipientName);
            } else if (studentLimeSurveyStudentCode != null) {
                msgRecipientLog.setRecipientFullName(studentLimeSurveyStudentCode + "/" + recipientName);
            } else if (enquiryLimeSurveyEnquiryCode != null) {
                msgRecipientLog.setRecipientFullName(enquiryLimeSurveyEnquiryCode + "/" + recipientName);
            } else if (applicantLimeSurveyApplicantCode != null) {
                msgRecipientLog.setRecipientFullName(applicantLimeSurveyApplicantCode + "/" + recipientName);
            } else if (sponsorCode != null) {
                msgRecipientLog.setRecipientFullName(sponsorCode + "/" + recipientName);
            } else if (externalUserApplicantCode != null) {
                msgRecipientLog.setRecipientFullName(externalUserApplicantCode + "/" + recipientName);
            } else if (approveApplicationCode != null) {
                msgRecipientLog.setRecipientFullName(approveApplicationCode + "/" + recipientName);
            } else if (rejectApplicationCode != null) {
                msgRecipientLog.setRecipientFullName(rejectApplicationCode + "/" + recipientName);
            } else if (approveAdmissionApplicantCode != null) {
                msgRecipientLog.setRecipientFullName(approveAdmissionApplicantCode + "/" + recipientName);
            } else if (externalUserFPCode != null) {
                msgRecipientLog.setRecipientFullName(externalUserFPCode + "/" + recipientName);
            } else if (appLogCreCode != null) {
                msgRecipientLog.setRecipientFullName(appLogCreCode + "/" + recipientName);
            } else if (parentLoginCode != null) {
                msgRecipientLog.setRecipientFullName(parentLoginCode + "/" + recipientName);
            } else if (studentFPCode != null) {
                msgRecipientLog.setRecipientFullName(studentFPCode + "/" + recipientName);
            } else if (applicantRPCode != null) {
                msgRecipientLog.setRecipientFullName(applicantRPCode + "/" + recipientName);
            } else if (committeeCode != null) {
                msgRecipientLog.setRecipientFullName(committeeCode + "/" + recipientName);
            } else if (committeeAdhocCode != null) {
                msgRecipientLog.setRecipientFullName(committeeAdhocCode + "/" + recipientName);
            } else if (parentRPCode != null) {
                msgRecipientLog.setRecipientFullName(parentRPCode + "/" + recipientName);
            } else {
                msgRecipientLog.setRecipientFullName(recipientName);
            }
            this.msgRecipientLogService.update((Object)msgRecipientLog);
        }
        return messageDTO;
    }

    private List<String> readAttachment(List<TemplateConfigDocuments> templateConfigDocuments) {
        ArrayList<String> attachmentPaths = new ArrayList<String>();
        for (TemplateConfigDocuments templateConfigDocument : templateConfigDocuments) {
            String path = this.templateConfigDocumentsService.readDocumenthPath(templateConfigDocument.getDocumentId());
            attachmentPaths.add(this.baseDir + File.separatorChar + path);
        }
        return attachmentPaths;
    }

    private void readDistributionScopeParameters(Map<Long, Object> msgContextMap, MsgRecipientLog msgRecipientLog) {
        if (msgRecipientLog.getRecipientContextData() != null) {
            ResultDocument rd = null;
            try {
                rd = (ResultDocument)new ObjectMapper().readValue(msgRecipientLog.getRecipientContextData(), ResultDocument.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Map msgScopeParamMap = this.mesMsgScopeParamService.findAllMsgScopeParams();
            for (String key : msgScopeParamMap.keySet()) {
                if (rd.get((Object)key) == null) continue;
                MsgScopeParam msp = (MsgScopeParam)msgScopeParamMap.get(key);
                msgContextMap.put(msp.getId(), Long.valueOf(rd.get((Object)key).toString()));
            }
        }
    }

    private List<MsgRecipientDocuments> readMsgRecipientDynamicDocuments(MsgRecipientLog msgRecipientLog) {
        return this.msgRecipientDocumentsService.findByRecipientTypeLogIdAndRecipientId(msgRecipientLog.getMsgRecipientTypeLog().getId(), msgRecipientLog.getRecipientId());
    }

    private ResultDocument readRecipientData(MsgRecipientTypeLog msgRecipientTypeLog, Long recipientId) {
        ArrayList<Long> receipientIds = new ArrayList<Long>();
        receipientIds.add(recipientId);
        List recipientsData = this.dataProviderEvaluationService.readRecipientsData(msgRecipientTypeLog, receipientIds);
        String recipientEventCode = msgRecipientTypeLog.getMsgEventRecipientConfig().getMsgRecipientType().getCode();
        if (recipientsData != null) {
            if (recipientEventCode.equalsIgnoreCase("MSG_COURSEWISE_WEEKLY_STUDENT")) {
                if (this.getRecipientData(recipientsData) != null) {
                    return this.getRecipientData(recipientsData);
                }
                return null;
            }
            if (recipientEventCode.equalsIgnoreCase("MSG_COURSEWISE_WEEKLY_PARENT")) {
                if (this.getRecipientDataForParent(recipientsData) != null) {
                    return this.getRecipientDataForParent(recipientsData);
                }
                return null;
            }
            if (recipientEventCode.equalsIgnoreCase("CONSOLIDATED_ATTENDANCE_MISSED_BY_FACULTY_RCPNT_TYPE")) {
                if (this.getRecipientDataForFacultyAttendance(recipientsData) != null) {
                    return this.getRecipientDataForFacultyAttendance(recipientsData);
                }
                return null;
            }
            if (recipientEventCode.equalsIgnoreCase("CONSOLIDATED_ATTENDANCE_MISSED_BY_TEACHER_RCPNT_TYPE")) {
                if (this.getRecipientDataForTeacherAttendance(recipientsData) != null) {
                    return this.getRecipientDataForTeacherAttendance(recipientsData);
                }
                return null;
            }
            if (recipientEventCode.equalsIgnoreCase("HOMEWORK_ASSIGNMENT_SUBMISSION_GRP_RCPNT")) {
                if (this.getRecipientDataForHWAssignment(recipientsData) != null) {
                    return this.getRecipientDataForHWAssignment(recipientsData);
                }
                return null;
            }
            if (recipientEventCode.equalsIgnoreCase("CONSOLIDATED_COURSE_WISE_ABSENT_FATHER_REPORT_RCPNT") || recipientEventCode.equalsIgnoreCase("CONSOLIDATED_COURSE_WISE_ABSENT_MOTHER_REPORT_RCPNT") || recipientEventCode.equalsIgnoreCase("CONSOLIDATED_COURSE_WISE_ABSENT_FATHER") || recipientEventCode.equalsIgnoreCase("CONSOLIDATED_COURSE_WISE_ABSENT_MOTHER")) {
                if (this.getRecipientDataForCourseWiseAbsent(recipientsData) != null) {
                    return this.getRecipientDataForCourseWiseAbsent(recipientsData);
                }
                return null;
            }
            if (recipientEventCode.equalsIgnoreCase("CONSOLIDATED_COURSE_WISE_ABSENT_STUDENT_REPORT_RCPNT") || recipientEventCode.equalsIgnoreCase("CONSOLIDATED_COURSE_WISE_ABSENT_STUDENT")) {
                if (this.getRecipientDataForCourseWiseAbsentStudent(recipientsData) != null) {
                    return this.getRecipientDataForCourseWiseAbsentStudent(recipientsData);
                }
                return null;
            }
            if (recipientEventCode.equalsIgnoreCase("HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_RECIPIENT") || recipientEventCode.equalsIgnoreCase("HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_RECIPIENT")) {
                if (this.getRecipientDataForHostelCheckOut(recipientsData) != null) {
                    return this.getRecipientDataForHostelCheckOut(recipientsData);
                }
                return null;
            }
            return (ResultDocument)recipientsData.get(0);
        }
        return null;
    }

    private ResultDocument getRecipientData(List<ResultDocument> recipientsData) {
        ResultDocument resultDocument = new ResultDocument();
        String recipientName = null;
        if (recipientsData.get(0).get((Object)FIRST_NAME) != null) {
            recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)LAST_NAME) != null) {
                recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
            }
        }
        String programName = recipientsData.get(0).get((Object)PROGRAM_NAME).toString();
        String batchName = recipientsData.get(0).get((Object)"BATCH_NAME").toString();
        String periodName = recipientsData.get(0).get((Object)"PERIOD_NAME").toString();
        String academyName = recipientsData.get(0).get((Object)ACADEMY_NAME).toString();
        String language = null;
        if (null != recipientsData.get(0).get((Object)LANGUAGE_KEY)) {
            language = recipientsData.get(0).get((Object)LANGUAGE_KEY).toString();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DD_MM_YYYY);
        String date = dateFormat.format(new Date());
        ArrayList<WSMsgTemplateRecipientDataList> recipientDataLists = new ArrayList<WSMsgTemplateRecipientDataList>();
        for (ResultDocument recipientsDataList : recipientsData) {
            WSMsgTemplateRecipientDataList dataList = new WSMsgTemplateRecipientDataList();
            dataList.setCourseName(recipientsDataList.get((Object)COURSE_NAME).toString());
            if (recipientsDataList.get((Object)COURSE_CODE) != null) {
                dataList.setCourseName(recipientsDataList.get((Object)COURSE_CODE).toString() + "-" + recipientsDataList.get((Object)COURSE_NAME).toString());
            }
            if (recipientsDataList.get((Object)PRESENT_PERCENTAGE) != null) {
                dataList.setTotalpresentPercentage(recipientsDataList.get((Object)PRESENT_PERCENTAGE).toString());
            }
            if (recipientsDataList.get((Object)COMPONENT_DESC) != null) {
                dataList.setCourseComponent(recipientsDataList.get((Object)COMPONENT_DESC).toString());
            }
            if (recipientsDataList.get((Object)COMPONENT_DESC) == null) {
                dataList.setCourseComponent("-");
            }
            if (recipientsDataList.get((Object)TOTAL_SESSIONS) != null) {
                dataList.setTotalSession(recipientsDataList.get((Object)TOTAL_SESSIONS).toString());
            }
            if (recipientsDataList.get((Object)TOTAL_PRESENT) != null) {
                dataList.setTotalPresent(recipientsDataList.get((Object)TOTAL_PRESENT).toString());
            }
            if (recipientsDataList.get((Object)TOTAL_ABSENT) != null) {
                dataList.setTotalAbsent(recipientsDataList.get((Object)TOTAL_ABSENT).toString());
            }
            if (recipientsDataList.get((Object)TOTAL_LEAVE) != null) {
                dataList.setTotalLeaves(recipientsDataList.get((Object)TOTAL_LEAVE).toString());
            }
            recipientDataLists.add(dataList);
        }
        resultDocument.put((Object)STUDENT_NAME, (Object)recipientName);
        resultDocument.put((Object)ATTENDANCE_LIST, recipientDataLists);
        resultDocument.put((Object)"programName", (Object)programName);
        resultDocument.put((Object)"batchName", (Object)batchName);
        resultDocument.put((Object)"periodName", (Object)periodName);
        resultDocument.put((Object)ACADEMY_NAME2, (Object)academyName);
        resultDocument.put((Object)"date", (Object)date);
        resultDocument.put((Object)LANGUAGE_KEY, (Object)language);
        resultDocument.put((Object)FIRST_NAME, (Object)recipientName);
        return resultDocument;
    }

    private ResultDocument getRecipientDataForParent(List<ResultDocument> recipientsData) {
        ResultDocument resultDocument = new ResultDocument();
        String recipientName = null;
        String parentName = null;
        if (recipientsData.get(0).get((Object)FIRST_NAME) != null) {
            recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)LAST_NAME) != null) {
                recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString() + " " + recipientsData.get(0).get((Object)LAST_NAME).toString();
            }
        }
        if (recipientsData.get(0).get((Object)PARENT_FIRST_NAME) != null) {
            parentName = recipientsData.get(0).get((Object)PARENT_FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)PARENT_LAST_NAME) != null) {
                parentName = recipientsData.get(0).get((Object)PARENT_FIRST_NAME).toString() + " " + recipientsData.get(0).get((Object)PARENT_LAST_NAME).toString();
            }
        }
        String programName = recipientsData.get(0).get((Object)PROGRAM_NAME).toString();
        String batchName = recipientsData.get(0).get((Object)"BATCH_NAME").toString();
        String periodName = recipientsData.get(0).get((Object)"PERIOD_NAME").toString();
        String academyName = recipientsData.get(0).get((Object)ACADEMY_NAME).toString();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DD_MM_YYYY);
        String date = dateFormat.format(new Date());
        ArrayList<WSMsgTemplateRecipientDataList> recipientDataLists = new ArrayList<WSMsgTemplateRecipientDataList>();
        for (ResultDocument recipientsDataList : recipientsData) {
            WSMsgTemplateRecipientDataList dataList = new WSMsgTemplateRecipientDataList();
            dataList.setCourseName(recipientsDataList.get((Object)COURSE_NAME).toString());
            if (recipientsDataList.get((Object)COURSE_CODE) != null) {
                dataList.setCourseName(recipientsDataList.get((Object)COURSE_CODE).toString() + "-" + recipientsDataList.get((Object)COURSE_NAME).toString());
            }
            if (recipientsDataList.get((Object)PRESENT_PERCENTAGE) != null) {
                dataList.setTotalpresentPercentage(recipientsDataList.get((Object)PRESENT_PERCENTAGE).toString());
            } else {
                dataList.setTotalpresentPercentage("0");
            }
            if (recipientsDataList.get((Object)TOTAL_SESSIONS) != null) {
                dataList.setTotalSession(recipientsDataList.get((Object)TOTAL_SESSIONS).toString());
            }
            if (recipientsDataList.get((Object)TOTAL_PRESENT) != null) {
                dataList.setTotalPresent(recipientsDataList.get((Object)TOTAL_PRESENT).toString());
            }
            if (recipientsDataList.get((Object)TOTAL_ABSENT) != null) {
                dataList.setTotalAbsent(recipientsDataList.get((Object)TOTAL_ABSENT).toString());
            }
            if (recipientsDataList.get((Object)TOTAL_LEAVE) != null) {
                dataList.setTotalLeaves(recipientsDataList.get((Object)TOTAL_LEAVE).toString());
            }
            recipientDataLists.add(dataList);
        }
        if (recipientsData.get(0).get((Object)"STUDENT_CODE") != null) {
            resultDocument.put((Object)STUDENT_NAME, (Object)(recipientName + " - " + recipientsData.get(0).get((Object)"STUDENT_CODE").toString()));
        } else {
            resultDocument.put((Object)STUDENT_NAME, (Object)recipientName);
        }
        if (recipientsData.get(0).get((Object)"PARENT_SALUTATION") != null) {
            resultDocument.put((Object)PARENT_NAME, (Object)(recipientsData.get(0).get((Object)"PARENT_SALUTATION").toString() + " " + parentName));
        } else {
            resultDocument.put((Object)PARENT_NAME, (Object)parentName);
        }
        resultDocument.put((Object)ATTENDANCE_LIST, recipientDataLists);
        resultDocument.put((Object)"programName", (Object)programName);
        resultDocument.put((Object)"batchName", (Object)batchName);
        resultDocument.put((Object)"periodName", (Object)periodName);
        resultDocument.put((Object)ACADEMY_NAME2, (Object)academyName);
        resultDocument.put((Object)"date", (Object)date);
        return resultDocument;
    }

    private ResultDocument getRecipientDataForFacultyAttendance(List<ResultDocument> recipientsData) {
        ResultDocument resultDocument = new ResultDocument();
        String recipientName = null;
        if (recipientsData.get(0).get((Object)FIRST_NAME) != null) {
            recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)LAST_NAME) != null) {
                recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString() + " " + recipientsData.get(0).get((Object)LAST_NAME).toString();
            }
        }
        String academyName = recipientsData.get(0).get((Object)ACADEMY_NAME).toString();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DD_MM_YYYY);
        String date = dateFormat.format(new Date());
        ArrayList<WSMsgTemplateRecipientDataList> recipientDataLists = new ArrayList<WSMsgTemplateRecipientDataList>();
        for (ResultDocument recipientsDataList : recipientsData) {
            WSMsgTemplateRecipientDataList dataList = new WSMsgTemplateRecipientDataList();
            if (recipientsDataList.get((Object)"COURSE_VARIANT_DESCRIPTION") != null) {
                dataList.setCourseVariant(recipientsDataList.get((Object)"COURSE_VARIANT_DESCRIPTION").toString());
            }
            if (recipientsDataList.get((Object)SESSION_DATE) != null) {
                dataList.setSessionDate(recipientsDataList.get((Object)SESSION_DATE).toString());
            }
            if (recipientsDataList.get((Object)SLOT_FROM) != null) {
                dataList.setSlotFrom(recipientsDataList.get((Object)SLOT_FROM).toString());
            }
            if (recipientsDataList.get((Object)SLOT_TO) != null) {
                dataList.setSlotTo(recipientsDataList.get((Object)SLOT_TO).toString());
            }
            recipientDataLists.add(dataList);
        }
        if (recipientsData.get(0).get((Object)"SALUTATION_NAME") != null) {
            resultDocument.put((Object)FACULTY_NAME, (Object)(recipientsData.get(0).get((Object)"SALUTATION_NAME").toString() + " " + recipientName));
        } else {
            resultDocument.put((Object)FACULTY_NAME, (Object)recipientName);
        }
        resultDocument.put((Object)ATTENDANCE_LIST, recipientDataLists);
        resultDocument.put((Object)ACADEMY_NAME2, (Object)academyName);
        resultDocument.put((Object)"date", (Object)date);
        return resultDocument;
    }

    private ResultDocument getRecipientDataForTeacherAttendance(List<ResultDocument> recipientsData) {
        ResultDocument resultDocument = new ResultDocument();
        String recipientName = null;
        if (recipientsData.get(0).get((Object)FIRST_NAME) != null) {
            recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
        }
        String academyName = recipientsData.get(0).get((Object)ACADEMY_NAME).toString();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DD_MM_YYYY);
        String date = dateFormat.format(new Date());
        ArrayList<WSMsgTemplateRecipientDataList> recipientDataLists = new ArrayList<WSMsgTemplateRecipientDataList>();
        for (ResultDocument recipientsDataList : recipientsData) {
            WSMsgTemplateRecipientDataList dataList = new WSMsgTemplateRecipientDataList();
            if (recipientsDataList.get((Object)PROGRAM_NAME) != null) {
                dataList.setProgramName(recipientsDataList.get((Object)PROGRAM_NAME).toString());
            }
            if (recipientsDataList.get((Object)SESSION_DATE) != null) {
                dataList.setSessionDate(recipientsDataList.get((Object)SESSION_DATE).toString());
            }
            if (recipientsDataList.get((Object)"SECTION_CODE") != null) {
                dataList.setCourseVariant(recipientsDataList.get((Object)"SECTION_CODE").toString());
            }
            recipientDataLists.add(dataList);
        }
        resultDocument.put((Object)FACULTY_NAME, (Object)recipientName);
        resultDocument.put((Object)ATTENDANCE_LIST, recipientDataLists);
        resultDocument.put((Object)ACADEMY_NAME2, (Object)academyName);
        resultDocument.put((Object)"date", (Object)date);
        return resultDocument;
    }

    private ResultDocument getRecipientDataForHWAssignment(List<ResultDocument> recipientsData) {
        ResultDocument resultDocument = new ResultDocument();
        String recipientName = null;
        String courseCode = null;
        if (recipientsData.get(0).get((Object)FIRST_NAME) != null) {
            recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)LAST_NAME) != null) {
                recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString() + " " + recipientsData.get(0).get((Object)LAST_NAME).toString();
            }
        }
        String academyName = recipientsData.get(0).get((Object)"ACADEMY_NAME_LOCATION").toString();
        String groupName = recipientsData.get(0).get((Object)"GROUP_NAME").toString();
        if (recipientsData.get(0).get((Object)COURSE_CODE) != null) {
            courseCode = recipientsData.get(0).get((Object)COURSE_CODE).toString() + "/";
        }
        if (recipientsData.get(0).get((Object)COURSE_CODE) != null) {
            courseCode = courseCode + recipientsData.get(0).get((Object)"COURSE_NAME_TO_BE_PRINTED");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DD_MM_YYYY);
        String date = dateFormat.format(new Date());
        ArrayList<WSMsgTemplateRecipientDataList> recipientDataLists = new ArrayList<WSMsgTemplateRecipientDataList>();
        for (ResultDocument recipientsDataList : recipientsData) {
            WSMsgTemplateRecipientDataList dataList = new WSMsgTemplateRecipientDataList();
            if (recipientsDataList.get((Object)"CODE") != null) {
                dataList.setRecipientFirstName(recipientsDataList.get((Object)"CODE").toString());
            }
            if (recipientsDataList.get((Object)STUDENT_FIRSTNAME) != null) {
                dataList.setRecipientFirstName(recipientsDataList.get((Object)"CODE").toString() + " / " + recipientsDataList.get((Object)STUDENT_FIRSTNAME).toString());
            }
            if (recipientsDataList.get((Object)"STUDENT_LASTNAME") != null) {
                dataList.setRecipientFirstName(recipientsDataList.get((Object)"CODE").toString() + " / " + recipientsDataList.get((Object)STUDENT_FIRSTNAME).toString() + " " + recipientsDataList.get((Object)"STUDENT_LASTNAME").toString());
            }
            recipientDataLists.add(dataList);
        }
        resultDocument.put((Object)FACULTY_NAME, (Object)recipientName);
        resultDocument.put((Object)"groupName", (Object)groupName);
        resultDocument.put((Object)"hwList", recipientDataLists);
        resultDocument.put((Object)"courseCode", (Object)courseCode);
        resultDocument.put((Object)ACADEMY_NAME2, (Object)academyName);
        resultDocument.put((Object)"date", (Object)date);
        return resultDocument;
    }

    private ResultDocument getRecipientDataForCourseWiseAbsent(List<ResultDocument> recipientsData) {
        ResultDocument resultDocument = new ResultDocument();
        String recipientName = null;
        String studentName = null;
        String sessionDate = null;
        String displayName = null;
        if (recipientsData.get(0).get((Object)FIRST_NAME) != null) {
            studentName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)LAST_NAME) != null) {
                studentName = recipientsData.get(0).get((Object)FIRST_NAME).toString() + " " + recipientsData.get(0).get((Object)LAST_NAME).toString();
            }
        }
        if (recipientsData.get(0).get((Object)PARENT_FIRST_NAME) != null) {
            recipientName = recipientsData.get(0).get((Object)PARENT_FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)PARENT_LAST_NAME) != null) {
                recipientName = recipientsData.get(0).get((Object)PARENT_FIRST_NAME).toString() + " " + recipientsData.get(0).get((Object)PARENT_LAST_NAME).toString();
            }
        }
        if (recipientsData.get(0).get((Object)SESSION_DATE) != null) {
            sessionDate = recipientsData.get(0).get((Object)SESSION_DATE).toString();
            if (recipientsData.get(0).get((Object)SESSION_DATE) != null) {
                sessionDate = recipientsData.get(0).get((Object)SESSION_DATE).toString();
            }
        }
        if (recipientsData.get(0).get((Object)ACADEMY_NAME) != null) {
            displayName = recipientsData.get(0).get((Object)ACADEMY_NAME).toString();
            if (recipientsData.get(0).get((Object)ACADEMY_NAME) != null) {
                displayName = recipientsData.get(0).get((Object)ACADEMY_NAME).toString();
            }
        }
        ArrayList<WSMsgTemplateRecipientDataList> recipientDataLists = new ArrayList<WSMsgTemplateRecipientDataList>();
        for (ResultDocument recipientsDataList : recipientsData) {
            WSMsgTemplateRecipientDataList dataList = new WSMsgTemplateRecipientDataList();
            if (recipientsDataList.get((Object)COURSE_CODE) != null) {
                dataList.setCourseCode(recipientsDataList.get((Object)COURSE_CODE).toString());
            }
            if (recipientsDataList.get((Object)COURSE_NAME) != null) {
                dataList.setCourseName(recipientsDataList.get((Object)COURSE_NAME).toString());
            }
            if (recipientsDataList.get((Object)SLOT_FROM) != null && recipientsDataList.get((Object)SLOT_TO) != null) {
                dataList.setSlotFrom(recipientsDataList.get((Object)SLOT_FROM).toString() + "-" + recipientsDataList.get((Object)SLOT_TO).toString());
            }
            recipientDataLists.add(dataList);
        }
        resultDocument.put((Object)PARENT_NAME, (Object)recipientName);
        resultDocument.put((Object)"displayName", (Object)displayName);
        resultDocument.put((Object)STUDENT_NAME, (Object)studentName);
        resultDocument.put((Object)"sessionDate", (Object)sessionDate);
        resultDocument.put((Object)ATTENDANCE_LIST, recipientDataLists);
        return resultDocument;
    }

    private ResultDocument getRecipientDataForCourseWiseAbsentStudent(List<ResultDocument> recipientsData) {
        ResultDocument resultDocument = new ResultDocument();
        String recipientName = null;
        String sessionDate = null;
        String displayName = null;
        if (recipientsData.get(0).get((Object)FIRST_NAME) != null) {
            recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)LAST_NAME) != null) {
                recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString() + " " + recipientsData.get(0).get((Object)LAST_NAME).toString();
            }
        }
        if (recipientsData.get(0).get((Object)SESSION_DATE) != null) {
            sessionDate = recipientsData.get(0).get((Object)SESSION_DATE).toString();
            if (recipientsData.get(0).get((Object)SESSION_DATE) != null) {
                sessionDate = recipientsData.get(0).get((Object)SESSION_DATE).toString();
            }
        }
        if (recipientsData.get(0).get((Object)ACADEMY_NAME) != null) {
            displayName = recipientsData.get(0).get((Object)ACADEMY_NAME).toString();
            if (recipientsData.get(0).get((Object)ACADEMY_NAME) != null) {
                displayName = recipientsData.get(0).get((Object)ACADEMY_NAME).toString();
            }
        }
        ArrayList<WSMsgTemplateRecipientDataList> recipientDataLists = new ArrayList<WSMsgTemplateRecipientDataList>();
        for (ResultDocument recipientsDataList : recipientsData) {
            WSMsgTemplateRecipientDataList dataList = new WSMsgTemplateRecipientDataList();
            if (recipientsDataList.get((Object)COURSE_CODE) != null) {
                dataList.setCourseCode(recipientsDataList.get((Object)COURSE_CODE).toString());
            }
            if (recipientsDataList.get((Object)COURSE_NAME) != null) {
                dataList.setCourseName(recipientsDataList.get((Object)COURSE_NAME).toString());
            }
            if (recipientsDataList.get((Object)SLOT_FROM) != null && recipientsDataList.get((Object)SLOT_TO) != null) {
                dataList.setSlotFrom(recipientsDataList.get((Object)SLOT_FROM).toString() + "-" + recipientsDataList.get((Object)SLOT_TO).toString());
            }
            recipientDataLists.add(dataList);
        }
        resultDocument.put((Object)"recipientName", (Object)recipientName);
        resultDocument.put((Object)"displayName", (Object)displayName);
        resultDocument.put((Object)"sessionDate", (Object)sessionDate);
        resultDocument.put((Object)ATTENDANCE_LIST, recipientDataLists);
        return resultDocument;
    }

    private ResultDocument getRecipientDataForHostelCheckOut(List<ResultDocument> recipientsData) {
        ResultDocument resultDocument = new ResultDocument();
        String recipientName = null;
        if (recipientsData.get(0).get((Object)FIRST_NAME) != null) {
            recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString();
            if (recipientsData.get(0).get((Object)LAST_NAME) != null) {
                recipientName = recipientsData.get(0).get((Object)FIRST_NAME).toString() + " " + recipientsData.get(0).get((Object)LAST_NAME);
            }
        }
        String language = null;
        if (null != recipientsData.get(0).get((Object)LANGUAGE_KEY)) {
            language = recipientsData.get(0).get((Object)LANGUAGE_KEY).toString();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DD_MM_YYYY);
        String date = dateFormat.format(new Date());
        ArrayList<WSMsgTemplateRecipientDataList> recipientDataLists = new ArrayList<WSMsgTemplateRecipientDataList>();
        for (ResultDocument recipientsDataList : recipientsData) {
            WSMsgTemplateRecipientDataList dataList = new WSMsgTemplateRecipientDataList();
            dataList.setStudentNumber(recipientsDataList.get((Object)"STUDENT_NUMBER").toString());
            dataList.setStudentName(recipientsDataList.get((Object)"STUDENT_NAME").toString());
            resultDocument.put((Object)"STUDENT_NUMBER", recipientsDataList.get((Object)"STUDENT_NUMBER"));
            resultDocument.put((Object)"STUDENT_NAME", recipientsDataList.get((Object)"STUDENT_NAME"));
            resultDocument.put((Object)"HOSTEL_BUILDING", recipientsDataList.get((Object)"HOSTEL_BUILDING"));
            resultDocument.put((Object)"HOSTEL_FLOOR", recipientsDataList.get((Object)"HOSTEL_FLOOR"));
            resultDocument.put((Object)"HOSTEL_BED_NO", recipientsDataList.get((Object)"HOSTEL_BED_NO"));
            resultDocument.put((Object)"EXPECTED_CHECK_OUT_DATE", recipientsDataList.get((Object)"EXPECTED_CHECK_OUT_DATE"));
            resultDocument.put((Object)"CHECK_IN_DATE", recipientsDataList.get((Object)"CHECK_IN_DATE"));
            resultDocument.put((Object)"ROOM_NO", recipientsDataList.get((Object)"ROOM_NO"));
            resultDocument.put((Object)"HOSTEL_MANAGER_NAME", recipientsDataList.get((Object)"HOSTEL_MANAGER_NAME"));
            resultDocument.put((Object)"HOSTEL_ADMIN_NAME", recipientsDataList.get((Object)"HOSTEL_ADMIN_NAME"));
            resultDocument.put((Object)"HOSTEL_CODE_NAME", recipientsDataList.get((Object)"HOSTEL_CODE_NAME"));
            if (recipientsDataList.get((Object)"HOSTEL_BUILDING") != null) {
                dataList.setBuilding(recipientsDataList.get((Object)"HOSTEL_BUILDING").toString());
            }
            if (recipientsDataList.get((Object)"HOSTEL_FLOOR") != null) {
                dataList.setFloor(recipientsDataList.get((Object)"HOSTEL_FLOOR").toString());
            }
            if (recipientsDataList.get((Object)"HOSTEL_BED_NO") != null) {
                dataList.setBedNo(recipientsDataList.get((Object)"HOSTEL_BED_NO").toString());
            }
            if (recipientsDataList.get((Object)"EXPECTED_CHECK_OUT_DATE") != null) {
                dataList.setExpectedCheckOutDate(recipientsDataList.get((Object)"EXPECTED_CHECK_OUT_DATE").toString());
            }
            if (recipientsDataList.get((Object)"CHECK_IN_DATE") != null) {
                dataList.setCheckedInDate(recipientsDataList.get((Object)"CHECK_IN_DATE").toString());
            }
            if (recipientsDataList.get((Object)"ROOM_NO") != null) {
                dataList.setRoomNo(recipientsDataList.get((Object)"ROOM_NO").toString());
            }
            if (recipientsDataList.get((Object)"ROOM_NO") != null) {
                dataList.setRoomNo(recipientsDataList.get((Object)"ROOM_NO").toString());
            }
            if (recipientsDataList.get((Object)"HOSTEL_CODE_NAME") != null) {
                dataList.setHostel(recipientsDataList.get((Object)"HOSTEL_CODE_NAME").toString());
            }
            recipientDataLists.add(dataList);
        }
        resultDocument.put((Object)HOSTEL_MANAGER_NAME, (Object)recipientName);
        resultDocument.put((Object)HOSTEL_ADMIN_NAME, (Object)recipientName);
        resultDocument.put((Object)HOSTEL_CHECK_OUT_LIST, recipientDataLists);
        resultDocument.put((Object)LANGUAGE_KEY, (Object)language);
        resultDocument.put((Object)FIRST_NAME, (Object)recipientName);
        return resultDocument;
    }
}

