/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.messaging.dao.MsgDeliveryModeLogDAO;
import in.serosoft.messaging.dao.MsgLogDAO;
import in.serosoft.messaging.dao.ScheduleMessageEventLogDAO;
import in.serosoft.messaging.dao.UserTriggeredMsgEvtLogDAO;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.model.MsgCount;
import in.serosoft.messaging.service.MsgCountUpdaterJobService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="msgCountUpdaterJobService")
public class MsgCountUpdaterJobServiceImpl
implements MsgCountUpdaterJobService {
    @Autowired
    UserTriggeredMsgEvtLogDAO userTriggeredMsgEvtLogDAO;
    @Autowired
    ScheduleMessageEventLogDAO scheduleMessageEventLogDAO;
    @Autowired
    MsgLogDAO msgLogDAO;
    @Autowired
    MsgDeliveryModeLogDAO msgDeliveryModeLogDAO;

    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<MsgLog> findMsgLogstoUpdate() {
        return this.msgLogDAO.findAllMsgCountUpdatableLogs();
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<MsgCount> findMessageCounts(Long msgLogId, String type) {
        return this.msgLogDAO.findAllMsgCountsByMsgLogId(msgLogId, type);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void updateMessageCounts(MsgCount msgCount, String type) {
        this.msgDeliveryModeLogDAO.updateCount(msgCount, type);
    }
}

