/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.messaging.dao.MsgLogDAO;
import in.serosoft.messaging.dao.ScheduleMessageEventLogDAO;
import in.serosoft.messaging.dao.UserTriggeredMsgEvtLogDAO;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.service.MsgLogFlushingJobService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="msgLogFlushingJobService")
public class MsgLogFlushingJobServiceImpl
implements MsgLogFlushingJobService {
    @Autowired
    UserTriggeredMsgEvtLogDAO userTriggeredMsgEvtLogDAO;
    @Autowired
    ScheduleMessageEventLogDAO scheduleMessageEventLogDAO;
    @Autowired
    MsgLogDAO msgLogDAO;

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public List<MsgLog> findAllFlushableLogs() {
        return this.msgLogDAO.findAllFlushableLogs();
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void flushMsgLogRecord(MsgLog msgLog) {
        if (msgLog.getUserTriggeredMsgEvtLog() != null) {
            this.userTriggeredMsgEvtLogDAO.delete((Object)msgLog.getUserTriggeredMsgEvtLog());
        }
        if (msgLog.getScheduleMessageEventLog() != null) {
            this.scheduleMessageEventLogDAO.delete((Object)msgLog.getScheduleMessageEventLog());
        }
        this.msgLogDAO.delete((Object)msgLog);
    }
}

