/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.cb.model.ResultDocument;
import in.serosoft.messaging.dto.EmailDomainConfigurationDTO;
import in.serosoft.messaging.dto.RecepientInfoDTO;
import in.serosoft.messaging.entity.AdhocRecipients;
import in.serosoft.messaging.entity.MsgDeliveryMode;
import in.serosoft.messaging.entity.MsgEventRecipientConfig;
import in.serosoft.messaging.entity.MsgRecipientLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.helper.MsgRcpntTypeQueueHelper;
import in.serosoft.messaging.helper.MsgRcpntsQueueHelper;
import in.serosoft.messaging.service.AdhocMsgDynamicAttachmentService;
import in.serosoft.messaging.service.AdhocMsgEventConfigService;
import in.serosoft.messaging.service.AdhocRecipientsService;
import in.serosoft.messaging.service.DataProviderEvaluationService;
import in.serosoft.messaging.service.GatewayCredentialsService;
import in.serosoft.messaging.service.MsgDeliveryModeLogService;
import in.serosoft.messaging.service.MsgEventRecipientConfigService;
import in.serosoft.messaging.service.MsgRcpntTypeLogQueueService;
import in.serosoft.messaging.service.MsgRecipientLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.MsgTemplateConfigDocService;
import in.serosoft.messaging.service.SystemMsgEventConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="msgRcpntTypeLogQueueService")
public class MsgRcpntTypeLogQueueServiceImpl
implements MsgRcpntTypeLogQueueService {
    private static final String ADHOC_RECIPIENTS = "AdhocRecipients";
    private static final String REJECT_APPLICATION_RECIPIENTS = "REJECT_APPLICATION_RECIPIENTS";
    @Autowired
    DataProviderEvaluationService dataProviderEvaluationService;
    @Autowired
    MsgRuleEvaluationService msgRuleEvaluationService;
    @Autowired
    AdhocRecipientsService adhocRecipientsService;
    @Autowired
    MsgDeliveryModeLogService msgDeliveryModeLogService;
    @Autowired
    MsgRecipientLogService msgRecipientLogService;
    @Autowired
    private AmqpTemplate messageQueueTemplate;
    @Autowired
    AdhocMsgEventConfigService adhocMsgEventConfigService;
    @Autowired
    SystemMsgEventConfigService systemMsgEventConfigService;
    @Autowired
    MsgTemplateConfigDocService msgTemplateConfigDocService;
    @Autowired
    MsgEventRecipientConfigService msgEventRecipientConfigService;
    @Autowired
    AdhocMsgDynamicAttachmentService adhocMsgDynamicAttachmentService;
    @Autowired
    GatewayCredentialsService gatewayCredentialService;

    public List<Long> buildDistributionList(MsgRecipientTypeLog msgRecipientTypeLog, Map<Long, Object> msgContextMap) {
        List<Long> receipientIds = new ArrayList<Long>();
        if (!msgRecipientTypeLog.getMsgRecipientType().getCode().equals(ADHOC_RECIPIENTS)) {
            if (msgContextMap.get(9L) != null) {
                String selectedRcpntIds = (String)msgContextMap.get(9L);
                receipientIds = MsgRcpntTypeQueueHelper.convertStringToListOfLong((String)selectedRcpntIds);
                msgContextMap.put(4L, receipientIds);
            } else {
                receipientIds = this.dataProviderEvaluationService.buildDistributionList(msgRecipientTypeLog, msgContextMap);
                msgContextMap.put(4L, receipientIds);
            }
        }
        return receipientIds;
    }

    public Map<Long, ResultDocument> buildDistributionListWithExtraDetails(MsgRecipientTypeLog msgRecipientTypeLog, Map<Long, Object> msgContextMap) {
        List receipients = new ArrayList();
        HashMap<Long, ResultDocument> distributionListWithContextData = new HashMap<Long, ResultDocument>();
        List receipientIds = new ArrayList();
        if (!msgRecipientTypeLog.getMsgRecipientType().getCode().equals(ADHOC_RECIPIENTS)) {
            if (msgContextMap.get(9L) != null) {
                String selectedRcpntIds = (String)msgContextMap.get(9L);
                receipientIds = MsgRcpntTypeQueueHelper.convertStringToListOfLong((String)selectedRcpntIds);
                msgContextMap.put(4L, receipientIds);
            } else {
                receipients = this.dataProviderEvaluationService.buildDistributionListWithExtraDetails(msgRecipientTypeLog, msgContextMap);
                receipientIds = MsgRcpntTypeQueueHelper.buildRecipientIdsAndDistributionContext(receipients, distributionListWithContextData);
                msgContextMap.put(4L, receipientIds);
            }
        }
        return distributionListWithContextData;
    }

    public List<Long> evaluateDistributionRule(MsgRecipientTypeLog msgRecipientTypeLog, Map<Long, Object> msgContextMap) {
        List<Long> receipientIds = new ArrayList<Long>();
        if (!msgRecipientTypeLog.getMsgRecipientType().getCode().equals(ADHOC_RECIPIENTS)) {
            receipientIds = this.msgRuleEvaluationService.evaluateDistributionRule(msgRecipientTypeLog, msgContextMap);
        }
        return receipientIds;
    }

    public List<ResultDocument> readRecipientsBasicDetails(MsgRecipientTypeLog msgRecipientTypeLog, List<Long> receipientIds) {
        if (!msgRecipientTypeLog.getMsgRecipientType().getCode().equals(ADHOC_RECIPIENTS) && receipientIds.size() > 0) {
            List recepients = this.dataProviderEvaluationService.readRecipientsData(msgRecipientTypeLog, receipientIds);
            return recepients;
        }
        return new ArrayList<ResultDocument>();
    }

    public List<MsgRecipientLog> buildAndCreateMsgRecipientLogs(MsgRecipientTypeLog msgRecipientTypeLog, List<ResultDocument> recipients, List<AdhocRecipients> adhocRecipients, Map<Long, ResultDocument> distributionListContextData) {
        if (adhocRecipients == null && recipients == null) {
            return new ArrayList<MsgRecipientLog>();
        }
        List msgDeliveryModeLogs = this.msgDeliveryModeLogService.findByMsgRcpntTypeLogId(msgRecipientTypeLog.getId());
        List msgRecipientLogs = null;
        if (msgRecipientTypeLog.getMsgRecipientType().getCode().equals(ADHOC_RECIPIENTS)) {
            msgRecipientLogs = MsgRcpntTypeQueueHelper.createMessageAdhocRecipientsLog((MsgRecipientTypeLog)msgRecipientTypeLog, adhocRecipients, (List)msgDeliveryModeLogs);
        } else {
            EmailDomainConfigurationDTO emailDomainConfigurationDTO = this.gatewayCredentialService.readEmailDomainControl();
            msgRecipientLogs = MsgRcpntTypeQueueHelper.createMessageRecipientsLog((MsgRecipientTypeLog)msgRecipientTypeLog, recipients, (List)msgDeliveryModeLogs, distributionListContextData, (EmailDomainConfigurationDTO)emailDomainConfigurationDTO);
        }
        RecepientInfoDTO recepientInfoDTO = null;
        for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
            if (msgRecipientTypeLog.getMsgRecipientType().getCode().equals(REJECT_APPLICATION_RECIPIENTS)) {
                recepientInfoDTO = this.gatewayCredentialService.getOwnerNameForRejectApplication(msgRecipientLog.getRecipientId());
                msgRecipientLog.setSendBy(recepientInfoDTO.getFirstName());
            }
            this.msgRecipientLogService.create((Object)msgRecipientLog);
        }
        return msgRecipientLogs;
    }

    public void publishToNextQueue(MsgRecipientTypeLog msgRecipientTypeLog, List<MsgRecipientLog> msgRecipientLogs) {
        block8: {
            if (msgRecipientLogs == null || msgRecipientLogs.size() <= 0) break block8;
            Boolean hasDynamicAttachements = this.hasDynamicAttachements(msgRecipientTypeLog);
            if (hasDynamicAttachements.booleanValue() && !msgRecipientTypeLog.getMsgRecipientType().getCode().equals(ADHOC_RECIPIENTS)) {
                if (!this.whetherSystemEvent(msgRecipientTypeLog)) {
                    this.messageQueueTemplate.convertAndSend("DocumentMgntQueue", (Object)msgRecipientTypeLog.getId());
                    for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                        if (!msgRecipientLog.getMsgDeliveryMode().getCode().equals("SMS") && !msgRecipientLog.getMsgDeliveryMode().getCode().equals("LETTER") && !msgRecipientLog.getMsgDeliveryMode().getCode().equals("PushNotification")) continue;
                        this.publishAsPerDeliveryModeQueue(msgRecipientLog);
                    }
                } else {
                    for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                        if (msgRecipientLog.getMsgDeliveryMode().getCode().equals("SMS") || msgRecipientLog.getMsgDeliveryMode().getCode().equals("LETTER") || msgRecipientLog.getMsgDeliveryMode().getCode().equals("PushNotification")) {
                            this.publishAsPerDeliveryModeQueue(msgRecipientLog);
                            continue;
                        }
                        if (msgRecipientLog.getFailureCode() != null && msgRecipientLog.getFailureCode().equals("CONTACT_NOT_AVAILABLE") || msgRecipientLog.getFailureCode() != null && (msgRecipientLog.getFailureCode().equals("EMAIL_ID_NOT_VALID") || msgRecipientLog.getFailureCode().equals("SNS_EMAIL_RESTRICTED"))) continue;
                        this.messageQueueTemplate.convertAndSend("SysMsgEventDocMgntQueue", (Object)msgRecipientLog.getId());
                    }
                }
            } else {
                for (MsgRecipientLog msgRecipientLog : msgRecipientLogs) {
                    this.publishAsPerDeliveryModeQueue(msgRecipientLog);
                }
            }
        }
    }

    private void publishAsPerDeliveryModeQueue(MsgRecipientLog msgRecipientLog) {
        if (!(msgRecipientLog.getFailureCode() != null && msgRecipientLog.getFailureCode().equals("CONTACT_NOT_AVAILABLE") || msgRecipientLog.getFailureCode() != null && (msgRecipientLog.getFailureCode().equals("EMAIL_ID_NOT_VALID") || msgRecipientLog.getFailureCode().equals("SNS_EMAIL_RESTRICTED")))) {
            MsgDeliveryMode msgDeliveryMode = msgRecipientLog.getMsgDeliveryMode();
            String queueName = MsgRcpntsQueueHelper.findQueueNameForDeliveryMode((String)msgDeliveryMode.getCode());
            this.messageQueueTemplate.convertAndSend(queueName, (Object)msgRecipientLog.getId());
        }
    }

    private Boolean hasDynamicAttachements(MsgRecipientTypeLog msgRecipientTypeLog) {
        MsgEventRecipientConfig msgEventRecipientConfig;
        List templateAttachments;
        Long msgEventConfigId = msgRecipientTypeLog.getMsgLog().getMsgEventConfig().getId();
        this.adhocMsgEventConfigService.findById(msgEventConfigId);
        List attachments = new ArrayList();
        if (!this.whetherSystemEvent(msgRecipientTypeLog) ? (attachments = this.adhocMsgDynamicAttachmentService.findAllByMsgEventConfigId(msgEventConfigId)) != null && attachments.size() > 0 : (templateAttachments = this.msgTemplateConfigDocService.findByMsgTemplateConfigId((msgEventRecipientConfig = this.msgEventRecipientConfigService.findByMsgEventConfigAndRecipientType(msgEventConfigId, msgRecipientTypeLog.getMsgRecipientType().getId())).getMsgTemplateConfig().getId())) != null && templateAttachments.size() > 0) {
            return true;
        }
        return false;
    }

    private boolean whetherSystemEvent(MsgRecipientTypeLog msgRecipientTypeLog) {
        Long msgEventConfigId = msgRecipientTypeLog.getMsgLog().getMsgEventConfig().getId();
        Object config = this.adhocMsgEventConfigService.findById(msgEventConfigId);
        return config == null;
    }
}

