/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.cb.model.CBSearchResult;
import in.serosoft.cb.model.ResultDocument;
import in.serosoft.cb.model.advanced.AdvancedSearchDTO;
import in.serosoft.cb.service.SearchEngineService;
import in.serosoft.messaging.entity.DataProvider;
import in.serosoft.messaging.entity.DataProviderInstance;
import in.serosoft.messaging.entity.MsgInitRuleConfig;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.MsgRecipientTypeLog;
import in.serosoft.messaging.helper.CriteriaBuilderSearchHelper;
import in.serosoft.messaging.helper.MessageContextHelper;
import in.serosoft.messaging.service.DataProviderEvaluationService;
import in.serosoft.messaging.service.MsgEventScopeService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgRuleEvaluationService;
import in.serosoft.messaging.service.MsgScopeParamService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="msgRuleEvaluationService")
public class MsgRuleEvaluationServiceImpl
implements MsgRuleEvaluationService {
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    MsgEventScopeService msgEventScopeService;
    @Autowired
    MsgScopeParamService msgScopeParamService;
    @Autowired
    SearchEngineService searchEngineService;
    @Autowired
    DataProviderEvaluationService dataProviderEvaluationService;

    public Boolean isValidInitiationRule(MsgInitRuleConfig msgInitRuleConfig, Map<Long, Object> msgContextScopeParamMap) {
        if (msgInitRuleConfig.getDataProviderInstance() != null) {
            CBSearchResult cbSearchResult = this.evaluateRule(msgInitRuleConfig, msgContextScopeParamMap);
            if (cbSearchResult.getResultDocuments().size() != 0) {
                return true;
            }
            return false;
        }
        return true;
    }

    public CBSearchResult evaluateRule(MsgInitRuleConfig msgInitRuleConfig, Map<Long, Object> msgContextScopeParamMap) {
        if (msgInitRuleConfig.getDataProviderInstance() != null) {
            Long savedSearchId = msgInitRuleConfig.getDataProviderInstance().getSavedRuleRefId();
            DataProvider dataProvider = this.dataProviderEvaluationService.findDataProviderById(msgInitRuleConfig.getDataProviderInstance().getDataProvider().getId());
            List msgScopeParams = this.msgScopeParamService.findAll();
            if (savedSearchId != null) {
                AdvancedSearchDTO advancedSearchDTO = this.searchEngineService.loadSaveSearch(savedSearchId);
                advancedSearchDTO = CriteriaBuilderSearchHelper.replaceNamedParameter((AdvancedSearchDTO)advancedSearchDTO, msgContextScopeParamMap, (DataProvider)dataProvider, (List)msgScopeParams);
                CBSearchResult cbSearchResult = this.searchEngineService.executeSearch(advancedSearchDTO, Long.valueOf(1L), Integer.valueOf(10));
                return cbSearchResult;
            }
        }
        return null;
    }

    public List<Long> evaluateDistributionRule(MsgRecipientTypeLog msgRecipientTypeLog, Map<Long, Object> msgContextMap) {
        DataProviderInstance distrRuleInstance = msgRecipientTypeLog.getMsgEventRecipientConfig().getDistrRuleInstance();
        if (distrRuleInstance != null) {
            DataProviderInstance distrListInstance = this.dataProviderEvaluationService.findDataProviderInstanceById(distrRuleInstance.getId());
            List resultDocuments = this.dataProviderEvaluationService.executeCBSavedSearch(distrListInstance, msgContextMap);
            ArrayList<Long> receipientIds = new ArrayList<Long>();
            for (ResultDocument resultDocument : resultDocuments) {
                Long id = Long.valueOf(resultDocument.get((Object)"USER_ID").toString());
                receipientIds.add(id);
            }
            return receipientIds;
        }
        return (List)msgContextMap.get(4L);
    }

    public Map<Long, Object> buildMessageContextMap(MsgRecipientTypeLog msgRecipientTypeLog) {
        MsgLog msgLog = (MsgLog)this.msgLogService.findById(msgRecipientTypeLog.getMsgLog().getId());
        List msgEventScopes = this.msgEventScopeService.findByMsgEventConfigId(msgLog.getMsgEventConfig().getId());
        ArrayList msgLogContextParams = new ArrayList(msgLog.getMsgLogContextParams());
        Map msgContextMap = MessageContextHelper.buildMsgContextMap(msgLogContextParams, (List)msgEventScopes);
        return msgContextMap;
    }
}

