/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.messaging.entity.AdhocMsgEventConfig;
import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.entity.ScheduleEventTriggerDetails;
import in.serosoft.messaging.entity.ScheduleMessageEventLog;
import in.serosoft.messaging.entity.SystemMsgEventConfig;
import in.serosoft.messaging.entity.UserTriggeredMsgEvtLog;
import in.serosoft.messaging.enumeration.StatusCode;
import in.serosoft.messaging.helper.MsgLogHelper;
import in.serosoft.messaging.service.AdhocMsgEventConfigService;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.MsgScopeParamService;
import in.serosoft.messaging.service.ScheduleEventTriggerDetailsService;
import in.serosoft.messaging.service.ScheduleMessageEventLogService;
import in.serosoft.messaging.service.ScheduledEventJobService;
import in.serosoft.messaging.service.SchedulerService;
import in.serosoft.messaging.service.SystemMsgEventConfigService;
import in.serosoft.messaging.service.UserTriggeredMsgEvtLogService;
import java.util.Date;
import java.util.Map;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="scheduledEventJobService")
public class ScheduledEventJobServiceImpl
implements ScheduledEventJobService {
    @Autowired
    SystemMsgEventConfigService systemMsgEventConfigService;
    @Autowired
    ScheduleMessageEventLogService scheduleMessageEventLogService;
    @Autowired
    AdhocMsgEventConfigService adhocMsgEventConfigService;
    @Autowired
    MsgLogService msgLogService;
    @Autowired
    ScheduleEventTriggerDetailsService scheduleEventTriggerDetailsService;
    @Autowired
    MsgScopeParamService msgScopeParamService;
    @Autowired
    SchedulerService schedulerService;
    @Autowired
    private AmqpTemplate amqpTemplate;
    @Autowired
    UserTriggeredMsgEvtLogService userTriggeredMsgEvtLogService;

    public void processEvent(Long sysMsgEvtConfigId) {
        SystemMsgEventConfig systemMsgEventConfig = (SystemMsgEventConfig)this.systemMsgEventConfigService.findById(sysMsgEvtConfigId);
        if (systemMsgEventConfig.getWhetherEnabled().booleanValue()) {
            ScheduleMessageEventLog scheduleMessageEventLog = new ScheduleMessageEventLog();
            scheduleMessageEventLog.setCreatedTimeStamp(new Date());
            scheduleMessageEventLog.setStatusCode(StatusCode.START);
            scheduleMessageEventLog.setRepeatitionCount(Integer.valueOf(0));
            scheduleMessageEventLog.setSystemMsgEventConfig(systemMsgEventConfig);
            Long id = this.scheduleMessageEventLogService.create((Object)scheduleMessageEventLog);
            if (systemMsgEventConfig.getSystemMsgEvent().getCode().equalsIgnoreCase("MSG_COURSEWISE_WEEKLY_ATTENDACE_REPORT") || systemMsgEventConfig.getSystemMsgEvent().getCode().equalsIgnoreCase("MSG_COURSEWISE_WEEKLY_ATTENDACE_PARENT_REPORT") || systemMsgEventConfig.getSystemMsgEvent().getCode().equalsIgnoreCase("ATTENDANCE_MISSED_BY_FACULTY") || systemMsgEventConfig.getSystemMsgEvent().getCode().equalsIgnoreCase("CONSOLIDATED_ATTENDANCE_MISSED_BY_FACULTY")) {
                ScheduleEventTriggerDetails scheduleEventTriggerDetails = new ScheduleEventTriggerDetails();
                scheduleEventTriggerDetails.setAcademyLocation(systemMsgEventConfig.getMsgConfigLevelValue().toString());
                scheduleEventTriggerDetails.setStatus(StatusCode.START.getCodeValue());
                scheduleEventTriggerDetails.setTriggeredOn(new Date());
                scheduleEventTriggerDetails.setScheduleMessageEventLogId(id.toString());
                scheduleEventTriggerDetails.setDisplayCode(systemMsgEventConfig.getSystemMsgEvent().getCode());
                this.scheduleEventTriggerDetailsService.create((Object)scheduleEventTriggerDetails);
            }
            this.amqpTemplate.convertAndSend("ScheduleMsgEvtLogQueue", (Object)id);
        }
    }

    public void processAdhocEvent(Long adhocMsgEvtConfigId) {
        AdhocMsgEventConfig adhocMsgEventConfig = (AdhocMsgEventConfig)this.adhocMsgEventConfigService.findById(adhocMsgEvtConfigId);
        Map msgScopeParams = this.msgScopeParamService.findAllMsgScopeParams();
        MsgLog msgLog = MsgLogHelper.buildMsgLogRecord((AdhocMsgEventConfig)adhocMsgEventConfig, (Map)msgScopeParams);
        Long msgLogId = this.msgLogService.create((Object)msgLog);
        this.amqpTemplate.convertAndSend("MsgLogQueue", (Object)msgLogId);
        if (adhocMsgEventConfig.getMsgInitRuleConfig() == null) {
            this.schedulerService.removeTrigger(adhocMsgEventConfig.getDisplayCode());
        }
    }

    public void processScheduledRepeatitiveEvent(MsgLog msgLog) {
        SystemMsgEventConfig systemMsgEventConfig = (SystemMsgEventConfig)this.systemMsgEventConfigService.findById(msgLog.getMsgEventConfig().getId());
        ScheduleMessageEventLog scheduleMessageEventLog = msgLog.getScheduleMessageEventLog();
        if ((long)scheduleMessageEventLog.getRepeatitionCount().intValue() < systemMsgEventConfig.getRepeatitionFrequency()) {
            Long msgLogId = this.msgLogService.create((Object)msgLog);
            this.amqpTemplate.convertAndSend("MsgLogQueue", (Object)msgLogId);
        }
        if ((long)(scheduleMessageEventLog.getRepeatitionCount() + 1) == systemMsgEventConfig.getRepeatitionFrequency()) {
            this.schedulerService.removeTrigger(systemMsgEventConfig.getSystemMsgEvent().getCode() + msgLog.getId());
        }
        scheduleMessageEventLog.setRepeatitionCount(Integer.valueOf(scheduleMessageEventLog.getRepeatitionCount() + 1));
        this.scheduleMessageEventLogService.update((Object)scheduleMessageEventLog);
    }

    public void processUserTrigerredRepeatitiveEvent(MsgLog msgLog) {
        Long msgLogId = msgLog.getId();
        SystemMsgEventConfig systemMsgEventConfig = (SystemMsgEventConfig)this.systemMsgEventConfigService.findById(msgLog.getMsgEventConfig().getId());
        UserTriggeredMsgEvtLog userTriggeredMsgEvtLog = (UserTriggeredMsgEvtLog)this.userTriggeredMsgEvtLogService.findById(msgLog.getUserTriggeredMsgEvtLog().getId());
        if ((long)userTriggeredMsgEvtLog.getRepeatitionCount().intValue() < systemMsgEventConfig.getRepeatitionFrequency()) {
            msgLog.setStatusCode(StatusCode.START);
            Long id = this.msgLogService.create((Object)msgLog);
            this.amqpTemplate.convertAndSend("MsgLogQueue", (Object)id);
        }
        if ((long)(userTriggeredMsgEvtLog.getRepeatitionCount() + 1) == systemMsgEventConfig.getRepeatitionFrequency()) {
            this.schedulerService.removeTrigger(systemMsgEventConfig.getSystemMsgEvent().getCode() + msgLogId);
        }
        userTriggeredMsgEvtLog.setRepeatitionCount(Integer.valueOf(userTriggeredMsgEvtLog.getRepeatitionCount() + 1));
        this.userTriggeredMsgEvtLogService.update((Object)userTriggeredMsgEvtLog);
    }
}

