/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.messaging.entity.MsgLog;
import in.serosoft.messaging.service.MsgLogService;
import in.serosoft.messaging.service.SchedulerService;
import in.serosoft.messaging.service.SystemMsgEventConfigService;
import in.serosoft.messaging.utility.ServerApplicationContextUtil;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schedulerService")
public class SchedulerServiceImpl
implements SchedulerService {
    private StdScheduler stdScheduler;
    @Autowired
    SystemMsgEventConfigService systemMsgEventConfigService;
    @Autowired
    MsgLogService msgLogService;

    public void addTrigger(String eventCode, String cronExpression, Long msgEvtConfigId, String jobName) {
        try {
            this.stdScheduler = this.getStdScheduler();
            CronTrigger cronTrigger = (CronTrigger)this.stdScheduler.getTrigger(new TriggerKey(eventCode, "Academia"));
            if (cronTrigger == null) {
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("contextData", eventCode);
                jobDataMap.put("msgEvtConfigId", (Object)msgEvtConfigId);
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(eventCode, "Academia").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).usingJobData(jobDataMap).forJob(jobName, "Academia").build();
                this.stdScheduler.scheduleJob((Trigger)trigger);
            } else {
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("contextData", eventCode);
                jobDataMap.put("msgEvtConfigId", (Object)msgEvtConfigId);
                CronTrigger newTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(eventCode, "Academia").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).usingJobData(jobDataMap).forJob(jobName, "Academia").build();
                this.stdScheduler.rescheduleJob(new TriggerKey(eventCode, "Academia"), (Trigger)newTrigger);
            }
        }
        catch (SchedulerException e1) {
            e1.printStackTrace();
        }
    }

    public void updateTrigger(String eventCode, String cronExpression) {
        try {
            this.stdScheduler = this.getStdScheduler();
            CronTrigger cronTrigger = (CronTrigger)this.stdScheduler.getTrigger(new TriggerKey(eventCode, "Academia"));
            cronTrigger.getTriggerBuilder().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
            this.stdScheduler.rescheduleJob(new TriggerKey(eventCode, "Academia"), (Trigger)cronTrigger);
        }
        catch (SchedulerException e1) {
            e1.printStackTrace();
        }
    }

    public void removeTrigger(String eventCode) {
        try {
            this.stdScheduler = this.getStdScheduler();
            this.stdScheduler.unscheduleJob(new TriggerKey(eventCode, "Academia"));
        }
        catch (SchedulerException e1) {
            e1.printStackTrace();
        }
    }

    private StdScheduler getStdScheduler() {
        StdScheduler stdScheduler = (StdScheduler)ServerApplicationContextUtil.getBeanById((String)"stdScheduler");
        return stdScheduler;
    }

    public void addTrigger(String eventCode, String repeatitionCron, MsgLog msgLog, String jobName, String msgEventType) {
        try {
            this.stdScheduler = this.getStdScheduler();
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("contextData", eventCode);
            jobDataMap.put("msgEventType", msgEventType);
            jobDataMap.put("msgLog", (Object)msgLog);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(eventCode + msgLog.getId(), "Academia").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)repeatitionCron)).usingJobData(jobDataMap).forJob(jobName, "Academia").build();
            this.stdScheduler.scheduleJob((Trigger)trigger);
        }
        catch (SchedulerException e1) {
            e1.printStackTrace();
        }
    }
}

