/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.service.impl;

import in.serosoft.messaging.entity.MsgConfigLevel;
import in.serosoft.messaging.entity.SystemMsgEvent;
import in.serosoft.messaging.entity.SystemMsgEventConfig;
import in.serosoft.messaging.service.SelectiveDistributionEventService;
import in.serosoft.messaging.service.SelectiveDistributionListService;
import in.serosoft.messaging.service.SystemMsgEventConfigService;
import in.serosoft.messaging.service.SystemMsgEventService;
import in.serosoft.messaging.service.UserTriggeredMsgEvtLogService;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="selectiveDistributionEventService")
public class SelectiveDistributionEventServiceImpl
implements SelectiveDistributionEventService {
    @Autowired
    SystemMsgEventConfigService systemMsgEventConfigService;
    @Autowired
    UserTriggeredMsgEvtLogService userTriggeredMsgEvtLogService;
    @Autowired
    SystemMsgEventService systemMsgEventService;
    @Autowired
    private SelectiveDistributionListService selectiveDistributionListService;
    @Autowired
    private AmqpTemplate messageQueueTemplate;

    public List<SystemMsgEventConfig> findSystemMsgEventConfigs(String eventCode, Map<String, Object> contextParameters) {
        SystemMsgEvent systemMsgEvent = this.systemMsgEventService.findByEventCode(eventCode);
        MsgConfigLevel msgConfigLevel = systemMsgEvent.getMsgConfigLevel();
        Long configLevelValue = null;
        configLevelValue = msgConfigLevel.getCode().equals("Organization") ? Long.valueOf(1L) : (Long)contextParameters.get("ALID");
        List systemMsgEventConfigs = this.systemMsgEventConfigService.findByMsgEventCode(systemMsgEvent.getId(), msgConfigLevel.getId(), configLevelValue);
        return systemMsgEventConfigs;
    }

    public void logIfEventEnabled(List<SystemMsgEventConfig> systemMsgEventConfigs, Map<String, Object> contextParameters) {
        for (SystemMsgEventConfig systemMsgEventConfig : systemMsgEventConfigs) {
            if (!systemMsgEventConfig.getWhetherEnabled().booleanValue()) continue;
            Long msgLogId = this.selectiveDistributionListService.createMsgLogRecords(systemMsgEventConfig, contextParameters);
            this.messageQueueTemplate.convertAndSend("MsgLogQueue", (Object)msgLogId);
        }
    }
}

