/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.messaging.utility;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClientBuilder;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import in.serosoft.messaging.dto.EmailCredentialsDTO;
import in.serosoft.messaging.dto.MessageDTO;
import in.serosoft.messaging.entity.MsgRecipientDocuments;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class AWSMailSender {
    private static final Logger DEBUGCOMMONLOGGER = Logger.getLogger((String)"MsgCommonQueueListenerLogger");

    public static void main(String[] args) {
        String[] to = new String[]{"nilesh.gupta@serosoft.in", "ashok.wagh@e-zest.in"};
        AWSMailSender.sendMail((String)"test", (String)"testmsg", (String)"academia-v2@e-zest.in", (String[])to);
    }

    public static void sendMail(String subject, String message, String from, String[] to) {
        try {
            Session s = Session.getInstance((Properties)new Properties(), null);
            MimeMessage mimeMessage = new MimeMessage(s);
            mimeMessage.setFrom((Address)new InternetAddress(from));
            for (String toMail : to) {
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toMail));
            }
            mimeMessage.setSubject(subject);
            MimeMultipart mimeBodyPart = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            part.setContent((Object)message, "text/html");
            mimeBodyPart.addBodyPart((BodyPart)part);
            mimeMessage.setContent((Multipart)mimeBodyPart);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)outputStream);
            RawMessage rawMessage = new RawMessage(ByteBuffer.wrap(outputStream.toByteArray()));
            String keyID = "AKIAIXKZ6LBUD4PKXPMQ";
            String secretKey = "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";
            BasicAWSCredentials credentials = new BasicAWSCredentials(keyID, secretKey);
            AmazonSimpleEmailServiceClient client = (AmazonSimpleEmailServiceClient)((AmazonSimpleEmailServiceClientBuilder)((AmazonSimpleEmailServiceClientBuilder)AmazonSimpleEmailServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withRegion("us-east-1")).build();
            SendRawEmailRequest rawEmailRequest = new SendRawEmailRequest(rawMessage);
            rawEmailRequest.setDestinations(Arrays.asList(to));
            rawEmailRequest.setSource(from);
            client.sendRawEmail(rawEmailRequest);
        }
        catch (IOException | MessagingException e) {
            DEBUGCOMMONLOGGER.debug((Object)("####### AWSMailSender Exception ######### " + e));
        }
    }

    public static String sendMail(MessageDTO messageDTO, EmailCredentialsDTO emailCredentialsDTO, String keyID, String secretKey) throws MessagingException, AddressException, NoSuchProviderException {
        try {
            Session s = Session.getInstance((Properties)new Properties(), null);
            MimeMessage mimeMessage = new MimeMessage(s);
            mimeMessage.setFrom((Address)new InternetAddress(emailCredentialsDTO.getFrom() != null ? emailCredentialsDTO.getFrom().toLowerCase() : null));
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(messageDTO.getContact() != null ? messageDTO.getContact().toLowerCase() : null));
            mimeMessage.setSubject(messageDTO.getSubject());
            MimeMultipart mimeBodyPart = new MimeMultipart();
            MimeBodyPart part = new MimeBodyPart();
            if (messageDTO.getIsInvitation()) {
                part.addHeader("Content-Class", "urn:content-classes:calendarmessage");
                part.setHeader("Content-ID", "calendar_message");
                part.setContent((Object)messageDTO.getMessageContent(), "text/calendar;method=REQUEST");
                mimeBodyPart.addBodyPart((BodyPart)part);
            } else {
                part.setContent((Object)messageDTO.getMessageContent(), "text/html");
                mimeBodyPart.addBodyPart((BodyPart)part);
            }
            AWSMailSender.attachStaticDocuments((Multipart)mimeBodyPart, (MessageDTO)messageDTO);
            AWSMailSender.attachDynamicDocuments((Multipart)mimeBodyPart, (MessageDTO)messageDTO);
            if (null != messageDTO.getPdfPassword()) {
                AWSMailSender.attachPasswordDocuments((Multipart)mimeBodyPart, (MessageDTO)messageDTO);
            }
            mimeMessage.setContent((Multipart)mimeBodyPart);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)outputStream);
            RawMessage rawMessage = new RawMessage(ByteBuffer.wrap(outputStream.toByteArray()));
            BasicAWSCredentials credentials = null;
            if (null != emailCredentialsDTO) {
                credentials = new BasicAWSCredentials(emailCredentialsDTO.getSmtpUserName(), emailCredentialsDTO.getSmtpPassword());
            }
            String region = AWSMailSender.selectAWSSignV4RegionForEmail((EmailCredentialsDTO)emailCredentialsDTO);
            AmazonSimpleEmailServiceClient client = (AmazonSimpleEmailServiceClient)((AmazonSimpleEmailServiceClientBuilder)((AmazonSimpleEmailServiceClientBuilder)AmazonSimpleEmailServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withRegion(region)).build();
            SendRawEmailRequest rawEmailRequest = new SendRawEmailRequest(rawMessage);
            String[] to = new String[]{messageDTO.getContact()};
            rawEmailRequest.setDestinations(Arrays.asList(to));
            rawEmailRequest.setSource(emailCredentialsDTO.getFrom());
            SendRawEmailResult response = client.sendRawEmail(rawEmailRequest);
            return response.getMessageId();
        }
        catch (IOException | MessagingException e) {
            DEBUGCOMMONLOGGER.debug((Object)("####### AWSMailSender Exception ######### " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    private static void attachStaticDocuments(Multipart multipart, MessageDTO messageDTO) throws MessagingException {
        List attachmentPaths = messageDTO.getAttachmentPaths();
        if (attachmentPaths != null && attachmentPaths.size() > 0) {
            for (String path : attachmentPaths) {
                MimeBodyPart attachments = new MimeBodyPart();
                FileDataSource source = new FileDataSource(path);
                attachments.setDataHandler(new DataHandler((DataSource)source));
                attachments.setFileName(source.getName());
                multipart.addBodyPart((BodyPart)attachments);
                DEBUGCOMMONLOGGER.debug((Object)("AWSMailSender attachStaticDocuments" + source.getName()));
            }
        }
    }

    private static void attachDynamicDocuments(Multipart multipart, MessageDTO messageDTO) throws MessagingException {
        List dynaDocuments = messageDTO.getMsgRecipientDynamicDocuments();
        if (dynaDocuments != null && dynaDocuments.size() > 0) {
            for (MsgRecipientDocuments msgRecipientDocuments : dynaDocuments) {
                byte[] doc = msgRecipientDocuments.getDocument();
                MimeBodyPart attachments = new MimeBodyPart();
                ByteArrayDataSource bds = new ByteArrayDataSource(doc, "application/octate_stream; charset=UTF-8");
                attachments.setDataHandler(new DataHandler((DataSource)bds));
                attachments.setFileName(msgRecipientDocuments.getDocumentName());
                multipart.addBodyPart((BodyPart)attachments);
                DEBUGCOMMONLOGGER.debug((Object)("AWSMailSender attachStaticDocuments" + msgRecipientDocuments.getDocumentName()));
            }
        }
    }

    private static void attachPasswordDocuments(Multipart multipart, MessageDTO messageDTO) throws MessagingException {
        byte[] doc = messageDTO.getPdfPassword();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
        String fileName = "Reset_Password_" + LocalDateTime.now().format(format);
        MimeBodyPart attachments = new MimeBodyPart();
        ByteArrayDataSource bds = new ByteArrayDataSource(doc, "application/octate_stream; charset=UTF-8");
        attachments.setDataHandler(new DataHandler((DataSource)bds));
        attachments.setFileName(fileName + ".PDF");
        multipart.addBodyPart((BodyPart)attachments);
        DEBUGCOMMONLOGGER.debug((Object)("AWSMailSender attachPasswordDocuments" + attachments.getFileName()));
    }

    private static String selectAWSSignV4RegionForEmail(EmailCredentialsDTO emailCredentialsDTO) {
        String region = null;
        if (emailCredentialsDTO.getHost() != null) {
            String host = emailCredentialsDTO.getHost();
            region = host.contains("us-west-2") || host.contains("US_WEST_2") ? "us-west-2" : (host.contains("ap-northeast-1") || host.contains("AP_NORTHEAST_1") ? "ap-northeast-1" : (host.contains("ap-southeast-1") || host.contains("AP_SOUTHEAST_1") ? "ap-southeast-1" : (host.contains("ap-southeast-2") || host.contains("AP_SOUTHEAST_2") ? "ap-southeast-2" : (host.contains("cn-north-1") || host.contains("CN_NORTH_1") ? "cn-north-1" : (host.contains("eu-west-1") || host.contains("EU_WEST_1") ? "eu-west-1" : (host.contains("GovCloud") ? "GovCloud" : (host.contains("sa-east-1") || host.contains("SA_EAST_1") ? "sa-east-1" : (host.contains("us-west-1") || host.contains("US_WEST_1") ? "us-west-1" : "us-east-1"))))))));
        }
        return region;
    }
}

