<?php

class PaymentGatewayLoader
{
    private $basePath        = "paymentGateway";
    private $paymentGateways = [
        'network'        => 'Network',
        'flywire'        => 'Flywire',
        'adityabirla'    => 'Aditya Birla',
        'jncb'           => 'JNCB',
        'paydunya'       => 'Pay Dunya',
        'bsp'            => 'BSP',
        'stripe'         => 'Stripe',
        'dpo'            => 'DPO',
        'mpgs'           => 'MPGS',
        'mips'           => 'MIPS',
        'payu'           => 'PayU',
        'paygate'        => 'PayGate',
        'authorizedotnet'=> 'Authorize.Net',
        'grayquest'      => 'GrayQuest',
        'paytm'          => 'Paytm',
        'icici'          => 'ICICI',
        'doku'           => 'DOKU',
        'ccavenue'      => 'CCAvenue'
    ];
    public function __construct($basePath = null, $paymentGateways = null)
    {
        if ($basePath) {
            $this->basePath        = $basePath;
            $this->paymentGateways = $paymentGateways;
        }
    }

    public function getDisplayName($key)
    {
        if (array_key_exists($key , $this->paymentGateways))
        {
            return $this->paymentGateways[$key];
        }
    }

    public function loadPaymentGateway($activeGateway, $conn, $paymentType, $result, $tableName, $merchantDetails)
    {

        if (array_key_exists($activeGateway, $this->paymentGateways)) {
            $gatewayFile = "{$this->basePath}/{$activeGateway}/paymentRequest.php";
            // return $gatewayFile;
            if (file_exists($gatewayFile)) {
                require_once $gatewayFile;
                (new PaymentRequest($conn))->paymentRequest($result, $paymentType, $tableName, $merchantDetails);
            } else {
                throw new Exception("Payment gateway file for {$activeGateway} not found.");
            }
        } else {
            throw new Exception("Invalid payment gateway: {$activeGateway}");
        }
    }

    public function loadReceiptFunctions($activeGateway, $connMain, $conn, $paymentRequest)
    {
        if (array_key_exists($activeGateway, $this->paymentGateways)) {
            $gatewayFile = "{$this->basePath}/{$activeGateway}/paymentRequest.php";
                        
            if (file_exists($gatewayFile)) {
                require_once $gatewayFile;
                try {

                    if ($paymentRequest && isset($paymentRequest['screen'])) {
                        switch ($paymentRequest['screen']) {
                            case 'online-payment':
                                (new PaymentRequest($conn))->onlinePaymentReceipt($paymentRequest, $connMain);
                                break;
                            case 'sendPaymentLink-payment':
                                (new PaymentRequest($conn))->sendPaymentLinkReceipt($paymentRequest, $connMain);
                                break;
                            case 'enrollment-payment':
                                (new PaymentRequest($conn))->courseEnrollementPaymentReceipt($paymentRequest, $connMain);
                                break;
                            case 'revaluation-payment':
                                (new PaymentRequest($conn))->RevaluationReceipt($paymentRequest, $connMain);
                                break;
                            case 'declaration-payment':
                                (new PaymentRequest($conn))->declarationPaymentReceipt($paymentRequest, $connMain);
                                break;
                            case 'exam-payment':
                                (new PaymentRequest($conn))->examAssessmentReceipt($paymentRequest, $connMain);
                                break;
                            case 'advance-payment':
                                (new PaymentRequest($conn))->advancePaymentReceipt($paymentRequest, $connMain);
                                break;
                            case 'donation-payment':
                                (new PaymentRequest($conn))->donationPaymentReceipt($paymentRequest, $connMain);
                                break;
                            case 'course-registration-payment':
                                (new PaymentRequest($conn))->courseRegistrationPaymentReceipt($paymentRequest, $connMain);
                                break;
                            case 'course-registration-pending-payment':
                                (new PaymentRequest($conn))->courseRegistrationPendingPaymentReceipt($paymentRequest, $connMain);
                                break; 
                            default:
                                throw new Exception("Unsupported payment screen type: {$paymentRequest['screen']}");
                        }
                    } else {
                        throw new Exception("Invalid or missing 'screen' key in paymentRequest.");

                    }

                } catch (Exception $e) {
                    // Provide a more detailed error message here
                    throw new Exception("Error including payment gateway file for {$activeGateway}. Please check the file path.");
                }

            } else {
                throw new Exception("Payment gateway file for {$activeGateway} not found.");
            }
        } else {
            throw new Exception("Invalid payment gateway: {$activeGateway}");
        }

    }
}
