


CREATE TABLE `assessment_payment` (
  `id` bigint(20) NOT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` timestamp NULL DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(255) DEFAULT NULL,
  `formSubmissionStatus` tinyint(1) DEFAULT 0,
  `lastUpdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `studentCode` varchar(45) DEFAULT NULL,
  `studentName` varchar(255) DEFAULT NULL,
  `program` varchar(255) DEFAULT NULL,
  `batch` varchar(255) DEFAULT NULL,
  `feeHead` varchar(255) DEFAULT NULL,
  `academyLocationId` int(11) DEFAULT NULL,
  `curlCheckCount` int(11) DEFAULT 0,
  `callbackResponce` longtext DEFAULT NULL,
  `paymentOption` varchar(20) DEFAULT NULL,
  `paymentRequest` longtext DEFAULT NULL,
  `emailStatus` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'This field is for email status it will set to 1 when email will be sent, also it will set to 1 if any receipt is generated via cron.',
  `notificationResponse` longtext DEFAULT NULL
) ENGINE=InnoDB ;

-- --------------------------------------------------------

--
-- Table structure for table `assessment_payment_detail`
--

CREATE TABLE `assessment_payment_detail` (
  `id` bigint(20) NOT NULL,
  `examAssessmentPaymentId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `receiptId` varchar(255) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `voucherMode` bigint(20) DEFAULT NULL,
  `evaluationGroupId` bigint(20) DEFAULT NULL,
  `currency` bigint(20) DEFAULT NULL,
  `feePlanType` bigint(20) DEFAULT NULL,
  `stageName` bigint(20) DEFAULT NULL,
  `appliedDate` date DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `courseName` varchar(255) DEFAULT NULL,
  `eventName` varchar(255) DEFAULT NULL
) ENGINE=InnoDB ;

-- --------------------------------------------------------

--
-- Table structure for table `curl_executation`
--

CREATE TABLE `curl_executation` (
  `id` int(11) NOT NULL,
  `remote_ip` varchar(255) DEFAULT NULL,
  `execute_status` tinyint(4) DEFAULT NULL COMMENT 'Execution status means cron is Execute or not Execution Status => 1 (Cron Execute) Execution Status => 0 (Cron Not Execute)',
  `current_executation` tinyint(4) DEFAULT NULL COMMENT 'Current Execution => 1 (Cron Is Running State) Current Execution => 0 (Cron Is stop status)',
  `date_time` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `declaration_payment`
--

CREATE TABLE `declaration_payment` (
  `id` bigint(20) NOT NULL,
  `onlinePaymentId` varchar(255) DEFAULT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `screentype` varchar(50) DEFAULT NULL,
  `amount` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(235) DEFAULT NULL,
  `paymentOption` varchar(235) DEFAULT NULL,
  `applicantId` varchar(255) DEFAULT NULL,
  `studentId` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `formSubmissionStatus` int(11) NOT NULL DEFAULT 0,
  `applicationStatus` varchar(255) DEFAULT NULL,
  `academyLocationId` varchar(45) DEFAULT NULL,
  `currency` varchar(45) DEFAULT NULL,
  `curlCheckCount` int(11) DEFAULT 0,
  `returnUrlResponse` longtext DEFAULT NULL,
  `notificationResponse` longtext DEFAULT NULL,
  `studentName` varchar(255) DEFAULT NULL,
  `program` varchar(255) DEFAULT NULL,
  `batch` varchar(255) DEFAULT NULL,
  `feeHead` varchar(255) DEFAULT NULL,
  `notificationHeader` longtext DEFAULT NULL,
  `moduleId` int(11) DEFAULT 0,
  `setupId` int(11) DEFAULT 0,
  `portalLinkSave` varchar(255) DEFAULT NULL,
  `paymentRequest` longtext DEFAULT NULL,
  `emailStatus` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'This field is for email status it will set to 1 when email will be sent, also it will set to 1 if any receipt is generated via cron.'
) ENGINE=InnoDB ;

-- --------------------------------------------------------

--
-- Table structure for table `donation_payment`
--

CREATE TABLE `donation_payment` (
  `id` bigint(20) NOT NULL,
  `onlinePaymentId` varchar(255) DEFAULT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `amount` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(235) DEFAULT NULL,
  `address` longtext DEFAULT NULL,
  `paymentOption` varchar(235) DEFAULT NULL,
  `formSubmissionStatus` int(11) NOT NULL DEFAULT 0,
  `academyLocationId` varchar(45) DEFAULT NULL,
  `currency` varchar(45) DEFAULT NULL,
  `curlCheckCount` int(11) DEFAULT 0,
  `notificationResponse` longtext DEFAULT NULL,
  `paymentRequest` longtext DEFAULT NULL,
  `emailStatus` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'This field is for email status it will set to 1 when email will be sent, also it will set to 1 if any receipt is generated via cron.',
  `paymentType` varchar(50) DEFAULT NULL,
  `redirectURL` varchar(500) DEFAULT NULL,
  `alumniToken` longtext NOT NULL
) ENGINE=InnoDB ;

-- --------------------------------------------------------

--
-- Table structure for table `enrollment_payment`
--

CREATE TABLE `enrollment_payment` (
  `id` bigint(20) NOT NULL,
  `onlinePaymentId` varchar(255) DEFAULT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `amount` varchar(45) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(45) DEFAULT NULL,
  `studentId` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT current_timestamp(),
  `paymentOption` varchar(45) DEFAULT NULL,
  `formSubmissionStatus` int(11) NOT NULL DEFAULT 0,
  `academyLocationId` varchar(45) DEFAULT NULL,
  `studentName` varchar(255) DEFAULT NULL,
  `program` varchar(255) DEFAULT NULL,
  `programId` varchar(50) DEFAULT NULL,
  `batch` varchar(255) DEFAULT NULL,
  `feeHead` varchar(255) DEFAULT NULL,
  `curlCheckCount` int(11) DEFAULT 0,
  `paymentRequest` longtext DEFAULT NULL,
  `emailStatus` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'This field is for email status it will set to 1 when email will be sent, also it will set to 1 if any receipt is generated via cron.',
  `notificationResponse` longtext DEFAULT NULL
) ENGINE=InnoDB ;

-- --------------------------------------------------------

--
-- Table structure for table `mobile_payment`
--

CREATE TABLE `mobile_payment` (
  `id` bigint(20) NOT NULL,
  `onlinePaymentId` varchar(255) DEFAULT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `amount` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(45) DEFAULT NULL,
  `applicantId` varchar(255) DEFAULT NULL,
  `studentId` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `paymentOption` varchar(45) DEFAULT NULL,
  `formSubmissionStatus` int(11) NOT NULL DEFAULT 0,
  `academyLocationId` varchar(45) DEFAULT NULL,
  `notificationResponse` longtext DEFAULT NULL,
  `paymentRequest` longtext DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL
) ENGINE=InnoDB ;

-- --------------------------------------------------------

--
-- Table structure for table `online_payment`
--

CREATE TABLE `online_payment` (
  `id` bigint(20) NOT NULL,
  `onlinePaymentId` varchar(255) DEFAULT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `amount` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(235) DEFAULT NULL,
  `paymentOption` varchar(235) DEFAULT NULL,
  `applicantId` varchar(255) DEFAULT NULL,
  `studentId` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `formSubmissionStatus` int(11) NOT NULL DEFAULT 0,
  `academyLocationId` varchar(45) DEFAULT NULL,
  `currency` varchar(45) DEFAULT NULL,
  `curlCheckCount` int(11) DEFAULT 0,
  `notificationResponse` longtext DEFAULT NULL,
  `studentName` varchar(255) DEFAULT NULL,
  `program` varchar(255) DEFAULT NULL,
  `batch` varchar(255) DEFAULT NULL,
  `feeHead` varchar(255) DEFAULT NULL,
  `paymentRequest` longtext DEFAULT NULL,
  `emailStatus` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'This field is for email status it will set to 1 when email will be sent, also it will set to 1 if any receipt is generated via cron.',
  `paymentType` varchar(60) DEFAULT NULL
) ENGINE=InnoDB ;

-- --------------------------------------------------------

--
-- Table structure for table `payment_request`
--

CREATE TABLE `payment_request` (
  `id` bigint(20) NOT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `screen` varchar(100) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `onlinePaymentId` int(11) DEFAULT 0,
  `paymentId` int(11) DEFAULT NULL,
  `payment_gateway` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payment_screen`
--

CREATE TABLE `payment_screen` (
  `id` int(11) NOT NULL,
  `screenName` varchar(50) DEFAULT NULL,
  `tableName` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `payment_screen`
--

INSERT INTO `payment_screen` (`id`, `screenName`, `tableName`) VALUES
(1, 'Online Payment', 'online_payment'),
(2, 'Declaration Payment', 'declaration_payment'),
(3, 'Exam Payment', 'assessment_payment'),
(4, 'Revaluation Payment', 'reval_payment'),
(5, 'Course Enrollment', 'enrollment_payment'),
(6, 'Donation', 'donation_payment');

-- --------------------------------------------------------

--
-- Table structure for table `reval_payment`
--

CREATE TABLE `reval_payment` (
  `id` bigint(20) NOT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `academyLocationId` varchar(255) DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `currency` varchar(50) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phoneNo` varchar(255) DEFAULT NULL,
  `formSubmissionStatus` tinyint(1) DEFAULT 0,
  `lastUpdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `studentCode` varchar(45) DEFAULT NULL,
  `paymentOption` varchar(255) DEFAULT NULL,
  `curlCheckCount` int(11) DEFAULT 0,
  `paymentRequest` longtext DEFAULT NULL,
  `emailStatus` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'This field is for email status it will set to 1 when email will be sent, also it will set to 1 if any receipt is generated via cron.',
  `notificationResponse` longtext DEFAULT NULL
) ENGINE=InnoDB ;

-- --------------------------------------------------------

--
-- Table structure for table `reval_payment_detail`
--

CREATE TABLE `reval_payment_detail` (
  `id` bigint(20) NOT NULL,
  `examRevalPaymentId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `receiptId` bigint(20) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `examRevalRuleMappingId` bigint(20) DEFAULT NULL,
  `examinationResultId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `eventId` bigint(20) DEFAULT NULL,
  `revaluationType` varchar(30) DEFAULT NULL,
  `appliedDate` date DEFAULT NULL,
  `previousMarks` double DEFAULT NULL,
  `previousGrade` varchar(30) DEFAULT NULL,
  `previousGradePoint` double DEFAULT NULL,
  `previousResultStatus` varchar(60) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `courseName` varchar(255) DEFAULT NULL,
  `eventName` varchar(255) DEFAULT NULL,
  `billNo` varchar(255) DEFAULT NULL,
  `receiptNo` varchar(255) DEFAULT NULL
) ENGINE=InnoDB;

-- --------------------------------------------------------

--
-- Table structure for table `reverse_transaction_receipt`
--

CREATE TABLE `reverse_transaction_receipt` (
  `id` int(11) NOT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `date_time` timestamp NULL DEFAULT NULL,
  `action` int(11) DEFAULT 0
);

CREATE TABLE `advance_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `onlinePaymentId` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `txnId` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `gatewayConfig` longtext COLLATE utf8mb4_general_ci,
  `academyLocationId` int DEFAULT NULL,
  `paymentOption` text COLLATE utf8mb4_general_ci,
  `paymentStatus` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `paymentDate` datetime NOT NULL,
  `receiptStatus` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `receiptId` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `formSubmissionStatus` varchar(1) COLLATE utf8mb4_general_ci DEFAULT '0',
  `currency` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `phoneNo` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `applicantId` int NOT NULL,
  `studentId` int NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `callbackResponce` longtext COLLATE utf8mb4_general_ci,
  `curlCheckCount` int DEFAULT NULL,
  `paymentRequest` longtext COLLATE utf8mb4_general_ci,
  `notificationResponse` longtext COLLATE utf8mb4_general_ci,
  `emailStatus` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
);

--
-- Table structure for table `course_registration_payment`
--



--
-- Indexes for dumped tables
--

--
-- Indexes for table `assessment_payment`
--
ALTER TABLE `assessment_payment`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `assessment_payment_detail`
--
ALTER TABLE `assessment_payment_detail`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `curl_executation`
--
ALTER TABLE `curl_executation`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `declaration_payment`
--
ALTER TABLE `declaration_payment`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `donation_payment`
--
ALTER TABLE `donation_payment`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `enrollment_payment`
--
ALTER TABLE `enrollment_payment`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `mobile_payment`
--
ALTER TABLE `mobile_payment`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `online_payment`
--
ALTER TABLE `online_payment`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `payment_request`
--
ALTER TABLE `payment_request`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `payment_screen`
--
ALTER TABLE `payment_screen`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `reval_payment`
--
ALTER TABLE `reval_payment`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `reval_payment_detail`
--
ALTER TABLE `reval_payment_detail`
  ADD PRIMARY KEY (`id`),
  ADD KEY `network_reval_payment_detail_examRevalPaymentId` (`examRevalPaymentId`);

--
-- Indexes for table `reverse_transaction_receipt`
--
ALTER TABLE `reverse_transaction_receipt`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `assessment_payment`
--
ALTER TABLE `assessment_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `assessment_payment_detail`
--
ALTER TABLE `assessment_payment_detail`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `curl_executation`
--
ALTER TABLE `curl_executation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `declaration_payment`
--
ALTER TABLE `declaration_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `donation_payment`
--
ALTER TABLE `donation_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `enrollment_payment`
--
ALTER TABLE `enrollment_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `mobile_payment`
--
ALTER TABLE `mobile_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `online_payment`
--
ALTER TABLE `online_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment_request`
--
ALTER TABLE `payment_request`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment_screen`
--
ALTER TABLE `payment_screen`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

--
-- AUTO_INCREMENT for table `reval_payment`
--
ALTER TABLE `reval_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `reval_payment_detail`
--
ALTER TABLE `reval_payment_detail`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `reverse_transaction_receipt`
--
ALTER TABLE `reverse_transaction_receipt`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
COMMIT;

ALTER TABLE `online_payment`
ADD COLUMN `sendPaymentLinkId` VARCHAR(255) NULL DEFAULT NULL AFTER `onlinePaymentId`,
ADD COLUMN `phoneCode` VARCHAR(255) NULL DEFAULT NULL AFTER `email`;

ALTER TABLE `declaration_payment`
ADD COLUMN `receiptId` VARCHAR(45) NULL DEFAULT NULL AFTER `receiptStatus`;

INSERT INTO `payment_screen` (`id`, `screenName`, `tableName`) VALUES (NULL, 'Advance Payment', 'advance_payment');

ALTER TABLE `advance_payment` 
CHANGE COLUMN `applicantId` `applicantId` VARCHAR(225) NULL DEFAULT NULL ,
CHANGE COLUMN `studentId` `studentId` VARCHAR(225) NULL DEFAULT NULL ;


-- Vaults-Feb-2025 Sprint updated Query

ALTER TABLE `donation_payment` ADD `alumniDonationRangeId` INT(255) NOT NULL AFTER `alumniToken`;
ALTER TABLE `donation_payment` ADD `serverUrl` VARCHAR(255) NULL DEFAULT NULL AFTER `redirectURL`;

-- X March -2025 sprint updated Query

ALTER TABLE `advance_payment` ADD `requestUrl` VARCHAR(255) NULL AFTER `emailStatus`;

CREATE TABLE `traslation_message` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tranlation_key` varchar(255) DEFAULT NULL,
  `tranlation_value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
INSERT INTO `traslation_message` 
VALUES 
    (1, 'TRANSACTION_ERROR', 'Unfortunately your transaction could not be processed. <br />Please try again later or contact your campus for assistance.'),
    (2, 'PAYMENT_GATEWAY_SERVER_ERROR', 'Unfortunately your transaction could not be processed. <br />Please try again later or contact your campus for assistance.'),
    (3, 'SERVER_ERROR', 'Oops! Something went wrong. <br />Please contact your campus for assistance.'),
    (4, 'MERCHANT_DETAILS_NOT_CONFIGURED', 'Unfortunately your transaction could not be processed. <br />Please contact your campus for assistance.'),
    (5, 'TRANSACTION_DATA_NOT_FOUND', 'Unfortunately your transaction details could not be found. <br /> Please contact your campus for assistance.'),
    (6, 'INVALID_TRANSACTION_ID', 'Invalid Transaction - please try again.'),
    (7, 'TRANSACTION_SUCCESS_RECEIPT_GENERATED', 'Thank you for your payment. Your Transaction ID is [TRANSACTION_ID].<br /> Please close the window.'),
    (8, 'TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED', 'Your transaction was successful-but a receipt was not generated.<br /><br /> Please note your Transaction ID [TRANSACTION_ID] and contact your campus for assistance.'),
    (9, 'GO_TO_Home_Page', 'Go to Home Page'),
    (10, 'TRANSACTION_SUCCESS_ENROLLEMENT_INPROGRESS', 'Thank you for your payment. Your Transaction ID is [TRANSACTION_ID]. Please check your enrollment after sometime. <br /> Please close the window.'),
    (11, 'INVALID_PAYMENT_GATEWAY_SELECTED', 'Invalid payment gateway selected.'),
    (12, 'PROCEED_WITH_PAYMENT', 'Proceed with Payment'),
    (13, 'TRANSACTION_ALREADY_PROCESSED', 'This transaction has already been processed. Please do not submit the same payment again.'),
    (14, 'TRANSACTION_NOT_SUCCESS', 'Unfortunately, Your transaction could not be processed, your Order Status is [ORDER_STATUS].'),
    (15, 'TRANSACTION_SUCCESS_RECEIPT_GENERATED_REGISTRATION', 'Thank you for payment. <br />Your Course successfully enrolled. Your Transaction id is [TRANSACTION_ID].<br /> Please close the window.'),
    (16, 'PAYMENT_PROCESSED_GENERIC', 'Thank you! Your payment request has been processed. You will receive a confirmation shortly.<br /> Please close the window.');

CREATE TABLE `course_registration_payment` (
  `id` bigint(20) NOT NULL,
  `onlinePaymentId` varchar(255) DEFAULT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `amount` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `cellCountryCode` varchar(45) DEFAULT NULL,
  `phoneNo` varchar(235) DEFAULT NULL,
  `mobileNo` varchar(235) DEFAULT NULL,
  `paymentOption` varchar(235) DEFAULT NULL,
  `studentId` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `formSubmissionStatus` int(11) NOT NULL DEFAULT 0,
  `academyLocationId` varchar(45) DEFAULT NULL,
  `currency` varchar(45) DEFAULT NULL,
  `curlCheckCount` int(11) DEFAULT 0,
  `notificationResponse` longtext DEFAULT NULL,
  `paymentRequest` longtext DEFAULT NULL,
  `indigatorStatus` text DEFAULT NULL,
  `admissionId` int(11) DEFAULT NULL,
  `emailStatus` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'This field is for email status it will set to 1 when email will be sent, also it will set to 1 if any receipt is generated via cron.',
  `requestUrl` varchar(255) DEFAULT NULL,
  `paymentType` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `course_registration_payment`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `course_registration_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
COMMIT;

CREATE TABLE `course_registration_pending_payment` (
  `id` bigint(20) NOT NULL,
  `onlinePaymentIds` varchar(255) DEFAULT NULL,
  `txnId` varchar(255) DEFAULT NULL,
  `gatewayConfig` longtext DEFAULT NULL,
  `paymentStatus` varchar(45) DEFAULT NULL,
  `paymentDate` datetime DEFAULT NULL,
  `receiptStatus` varchar(45) DEFAULT NULL,
  `amount` varchar(45) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `cellCountryCode` varchar(45) DEFAULT NULL,
  `phoneNo` varchar(235) DEFAULT NULL,
  `mobileNo` varchar(235) DEFAULT NULL,
  `paymentOption` varchar(235) DEFAULT NULL,
  `studentId` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `formSubmissionStatus` int(11) NOT NULL DEFAULT 0,
  `academyLocationId` varchar(45) DEFAULT NULL,
  `currency` varchar(45) DEFAULT NULL,
  `curlCheckCount` int(11) DEFAULT 0,
  `notificationResponse` longtext DEFAULT NULL,
  `paymentRequest` longtext DEFAULT NULL,
  `transactionUpdateErp` text DEFAULT NULL,
  `emailStatus` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'This field is for email status it will set to 1 when email will be sent, also it will set to 1 if any receipt is generated via cron.',
  `requestUrl` varchar(255) DEFAULT NULL,
  `paymentType` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `course_registration_pending_payment`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `course_registration_pending_payment`
  MODIFY `id` bigint(20) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
COMMIT;
INSERT INTO payment_screen (screenName, tableName) VALUES ('Pay Now', 'course_registration_payment');
INSERT INTO payment_screen (screenName, tableName) VALUES ('Pay Later', 'course_registration_pending_payment');
ALTER TABLE `declaration_payment` ADD `paymentType` VARCHAR(255) NOT NULL AFTER `emailStatus`;
ALTER TABLE `online_payment` ADD `requestUrl` LONGTEXT NULL AFTER `paymentType`;
ALTER TABLE `declaration_payment` ADD `requestUrl` LONGTEXT NULL AFTER `paymentType`;
ALTER TABLE `reval_payment` ADD `requestUrl` LONGTEXT NULL AFTER `notificationResponse`;
ALTER TABLE `donation_payment` ADD `requestUrl` LONGTEXT NULL AFTER `paymentType`;
ALTER TABLE `assessment_payment` ADD `requestUrl` LONGTEXT NULL AFTER `notificationResponse`;
ALTER TABLE `enrollment_payment` ADD `paymentType` VARCHAR(255) NOT NULL AFTER `notificationResponse`;

ALTER TABLE `online_payment` CHANGE `feeHead` `feeHead` LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL;

CREATE TABLE `grayquest_notification` (
  `id` int(11) NOT NULL,
  `onlinePaymentId` varchar(255) NOT NULL,
  `txnId` varchar(255) NOT NULL,
  `notification_data` longtext NOT NULL,
  `status` varchar(500) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

ALTER TABLE `grayquest_notification`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `grayquest_notification`
--
ALTER TABLE `grayquest_notification`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
COMMIT;


ALTER TABLE advance_payment MODIFY amount VARCHAR(255) NULL;
