<?php
require_once "authorizeDotNetPaymentGateway.php";
require_once "./config/QueryBuilder.php";

class PaymentRequest
{
    private $conn;
    private $queryBuilder;
    private $authorizeObj;
    private $translationMsg;
    public function __construct($conn)
    {
        $this->conn         = $conn;
        $this->queryBuilder = new QueryBuilder($conn);
        $this->authorizeObj       = new AuthorizeDotNetPaymentGateway();
        $this->translationMsg =  json_decode(TRANSLATION_MSG, true);
    }

    public function paymentRequest($data, $screenName, $tableName, $merchantDetails)
    {
        if ($data['gatewayConfig']) {
            echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TXN_ID_ALREADY_GENERATED'].'</h4>
                    </div>';
        } else {
            $currencyCode = $data['currency'];
            $activeGateway = $data['paymentOption'];
            $invoiceId = 'INV-'.$data['id'].mt_rand(1000,9999);
            $gatewayJSON = <<<GATEWAYJSON
            {
                "apiLoginId": "{$merchantDetails['apiLoginId']}",
                "transactionKey": "{$merchantDetails['transactionKey']}",
                "environment": "{$merchantDetails['environmentURL']}",
                "currency": "{$merchantDetails['currency']}",
                "paymentFormURL": "{$merchantDetails['paymentFormURL']}",
                "invoiceId": "{$invoiceId}"
            }
            GATEWAYJSON;
            
            $updateData = ['gatewayConfig' => $gatewayJSON, 'academyLocationId' => $data['academyLocationId'], 'paymentOption' => $activeGateway];
            $where = ['id' => $data['id']];
            $result = $this->queryBuilder->update($tableName, $updateData, $where);
            if($result == 1)
            {
                $paymentRequestColumnData = ['screen' => $screenName, 'txnId' => $invoiceId, 'paymentDate' => date('Y-m-d H:i:s'), 'onlinePaymentId' => !empty($data['onlinePaymentId']) ? $data['onlinePaymentId'] : (isset($data['onlinePaymentId']) ? 0 : NULL), 'paymentId' => $data['id'], 'payment_gateway' => $activeGateway];
                $this->queryBuilder->insert('payment_request', $paymentRequestColumnData);
                $where = ['id' => $data['id']];
                $paymentDetails = $this->queryBuilder->selectById($tableName, '*', $where);
                $gatewayInfo = '';
                if ($paymentDetails && $paymentDetails['gatewayConfig']) {
                    $gatewayInfoArr = json_decode($paymentDetails['gatewayConfig'], true);

                    $requiredKeys = ['apiLoginId', 'transactionKey', 'environment', 'currency', 'paymentFormURL', 'invoiceId'];
                    
                    if (count(array_filter($gatewayInfoArr, fn($value) => !empty($value) && isset($value))) === count($requiredKeys)) {
                        $gatewayInfo = 'EXIST';
                    }
                }
                if (!$paymentDetails || $paymentDetails == 0 || $gatewayInfo = '') {

                    echo '<div class="col-md-12 text-center alert alert-warning">
                             <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                          </div>';
                }
                else if($gatewayInfoArr['currency'] != $data['currency']){
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.$this->translationMsg['CURRENCY_NOT_SUPPORTED'].'</h4>
                        </div>';
                }
                else {
                    $paymentRequest = $this->authorizeObj->createOrder($paymentDetails);    
                                 
                    if(isset($paymentRequest['token']) && $paymentRequest['token'])
                    {
                        $updateData = ['paymentRequest' => $paymentRequest['paymentRequest']];
                        $where = ['id' => $data['id']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo ' <form id="paymentForm" method="POST" action="'.$gatewayInfoArr['paymentFormURL'].'">
                                    <input type="hidden" name="token" value="'.$paymentRequest['token'].'"/> <br><br>
                                    <button>'.$this->translationMsg['PAY_NOW'].'</button>
                                </form>
                                <script>
                                    document.getElementById("paymentForm").submit();
                                </script>';
                    }
                    else
                    {
                        echo '<div class="col-md-12 text-center alert alert-warning">
                           <h4>'.$this->translationMsg['PAYMENT_GATEWAY_SERVER_ERROR'].'</h4>
                          </div>';
                    }
                }
            }
            else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                       <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                      </div>';
            }
        }
    }

    public function onlinePaymentReceipt($paymentRequest , $connMain)
    {
        require_once("academia/onlinePayment.php");
        $tableName = 'online_payment';
        $notificationBody = $paymentRequest['notificationBody'];
        $invoiceId = $notificationBody['payload']['invoiceNumber'];
        $txnId = $notificationBody['payload']['id'];
        
        $onlinePaymentObj = new OnlinePayment();
        $onlinePaymentObj->setConnection($this->conn, $connMain);

        $additionalConditions = 'gatewayConfig LIKE ?';
        $additionalParams = ['%' . $invoiceId . '%'];                
        $onlinePaymentInfo = $this->queryBuilder->select('online_payment', '*', ['id'=> $paymentRequest['paymentId']] , [], $additionalConditions , $additionalParams , 'id DESC' , 1); 
             
        if ($onlinePaymentInfo && count($onlinePaymentInfo) == 1 && $onlinePaymentInfo[0]['id'] == $paymentRequest['paymentId']) {
            $onlinePaymentInfo = $onlinePaymentInfo[0];
            $updateData = ['txnId' => $txnId];
            $where = ['id' => $paymentRequest['paymentId']];
            $this->queryBuilder->update($tableName, $updateData, $where);                 


            if ($onlinePaymentInfo['formSubmissionStatus'] != 1 && $txnId) {
                $onlinePaymentInfo['txnId'] = $txnId;
                $orderInfo = $this->authorizeObj->fetchOrder($onlinePaymentInfo);
                $updateData = ['notificationResponse' => json_encode($orderInfo['notificationResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['transactionStatus']];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);                   
                if ($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['notificationResponse']['transaction']) && $orderInfo['notificationResponse']['transaction']['transId'] == $txnId && $orderInfo['notificationResponse']['transaction']['order']['invoiceNumber'] == $invoiceId) {                    
                    $response = $onlinePaymentObj->createReceipt($onlinePaymentInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';

                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                                </div>';
                    }
                    
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderInfo['transactionStatus'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
               <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }
    }

    public function RevaluationReceipt($paymentRequest, $connMain)
    {
        require_once "academia/revaluationPayment.php";
        $tableName = 'reval_payment';
        $notificationBody = $paymentRequest['notificationBody'];
        $invoiceId = $notificationBody['payload']['invoiceNumber'];
        $txnId = $notificationBody['payload']['id'];

        $revalObj = new RevaluationPayment();
        $revalObj->setConnection($this->conn, $connMain);

        $additionalConditions = 'gatewayConfig LIKE ?';
        $additionalParams = ['%' . $invoiceId . '%'];
        $revalInfo = $this->queryBuilder->select($tableName, '*', ['id' => $paymentRequest['paymentId']], [], $additionalConditions, $additionalParams, 'id DESC', 1);

        if ($revalInfo && count($revalInfo) == 1 && $revalInfo[0]['id'] == $paymentRequest['paymentId']) {
            $revalInfo = $revalInfo[0];
            $updateData = ['txnId' => $txnId];
            $where = ['id' => $paymentRequest['paymentId']];
            $this->queryBuilder->update($tableName, $updateData, $where);

            if ($revalInfo['formSubmissionStatus'] != 1 && $txnId) {
                $revalInfo['txnId'] = $txnId;
                $orderInfo = $this->authorizeObj->fetchOrder($revalInfo);
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['notificationResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $orderInfo['transactionStatus']
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);
                if ($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['notificationResponse']['transaction']) && $orderInfo['notificationResponse']['transaction']['transId'] == $txnId && $orderInfo['notificationResponse']['transaction']['order']['invoiceNumber'] == $invoiceId) {
                    $response = $revalObj->createReceipt($revalInfo['id'], $revalInfo['amount'], $txnId, $orderInfo['status']);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]", $orderInfo['transactionStatus'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
                </div>';
        }
    }

    public function declarationPaymentReceipt($paymentRequest, $connMain)
    {
        require_once("academia/declarationPayment.php");
        $tableName = 'declaration_payment';
        $notificationBody = $paymentRequest['notificationBody'];
        $invoiceId = $notificationBody['payload']['invoiceNumber'];
        $txnId = $notificationBody['payload']['id'];

        $declarationPaymentObj = new DeclarationPayment();
        $declarationPaymentObj->setConnection($this->conn, $connMain);
        
        $additionalConditions = 'gatewayConfig LIKE ?';
        $additionalParams = ['%' . $invoiceId . '%'];                
        $declarationPaymentInfo = $this->queryBuilder->select($tableName, '*', ['id'=> $paymentRequest['paymentId']] , [], $additionalConditions , $additionalParams , 'id DESC' , 1); 

        if ($declarationPaymentInfo && count($declarationPaymentInfo) == 1 && $declarationPaymentInfo[0]['id'] == $paymentRequest['paymentId']) {
            
            $declarationPaymentInfo = $declarationPaymentInfo[0];
            $updateData = ['txnId' => $txnId];
            $where = ['id' => $paymentRequest['paymentId']];
            $this->queryBuilder->update($tableName, $updateData, $where);      

            if ($declarationPaymentInfo['formSubmissionStatus'] != 1 && $txnId) {
                $declarationPaymentInfo['txnId'] = $txnId;
                $orderInfo = $this->authorizeObj->fetchOrder($declarationPaymentInfo);
                $updateData = ['notificationResponse' => json_encode($orderInfo['notificationResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['transactionStatus']];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);   

                if ($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['notificationResponse']['transaction']) && $orderInfo['notificationResponse']['transaction']['transId'] == $txnId && $orderInfo['notificationResponse']['transaction']['order']['invoiceNumber'] == $invoiceId) {                    
                    $response = $declarationPaymentObj->createReceipt($declarationPaymentInfo);
                    if (isset($response['status']) && $response['status'] === 'SUCCESS') {
                        $updateData = [
                            'receiptStatus' => $response['status'],
                            'receiptId' => $response['receiptId']
                        ];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $orderInfo['txnID'], $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $orderInfo['txnID'], $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                            </div>';
                    }
                    
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderInfo['transactionStatus'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
                </div>';
        }
    }

    public function examAssessmentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/examinationPayment.php";
        $tableName = 'assessment_payment';

        $notificationBody = $paymentRequest['notificationBody'];
        $invoiceId = $notificationBody['payload']['invoiceNumber'];
        $txnId = $notificationBody['payload']['id'];

        $examObj = new ExaminationPayment();
        $examObj->setConnection($this->conn, $connMain);

        $additionalConditions = 'gatewayConfig LIKE ?';
        $additionalParams = ['%' . $invoiceId . '%'];                
        $examInfo = $this->queryBuilder->select($tableName, '*', ['id'=> $paymentRequest['paymentId']] , [], $additionalConditions , $additionalParams , 'id DESC' , 1); 
         
        if ($examInfo && count($examInfo) == 1 && $examInfo[0]['id'] == $paymentRequest['paymentId']){
            $examInfo = $examInfo[0];
            $updateData = ['txnId' => $txnId];
            $where = ['id' => $paymentRequest['paymentId']];
            $this->queryBuilder->update($tableName, $updateData, $where);    

            if ($examInfo['formSubmissionStatus'] != 1  && $txnId) {
                $examInfo['txnId'] = $txnId;
                $orderInfo = $this->authorizeObj->fetchOrder($examInfo);

                $updateData = ['notificationResponse' => json_encode($orderInfo['notificationResponse']), 'formSubmissionStatus' => 1, 'paymentStatus' => $orderInfo['transactionStatus']];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);       

                if ($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['notificationResponse']['transaction']) && $orderInfo['notificationResponse']['transaction']['transId'] == $txnId && $orderInfo['notificationResponse']['transaction']['order']['invoiceNumber'] == $invoiceId){
                    $response = $examObj->createReceipt($examInfo['id'], $examInfo['academyLocationId'], $txnId, $examInfo['amount'],$examInfo['currency']);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $result = $this->queryBuilder->update($tableName, $updateData, $where);
                        $tableName2 = 'assessment_payment_detail';
                        $updateDataDetail = ['receiptId' => $response['receiptId']];
                        $updateWhere = ['examAssessmentPaymentId' => $paymentRequest['paymentId']];
                        $result2 = $this->queryBuilder->update($tableName2, $updateDataDetail, $updateWhere);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                    <h4>'.str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                                </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                            <h4>'. str_replace("[TRANSACTION_ID]",$txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                         </div>';
                    }
                } else {
                   echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]",$orderInfo['transactionStatus'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'.</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                 <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
          </div>';
        }       
    }



    public function courseEnrollementPaymentReceipt($paymentRequest, $connMain)
    {
        require_once("academia/courseEnrollement.php");
        $tableName = 'enrollment_payment';
        $notificationBody = $paymentRequest['notificationBody'];
        $invoiceId = $notificationBody['payload']['invoiceNumber'];
        $txnId = $notificationBody['payload']['id'];

        $courseEnrollementPaymentObj = new CourseEnrollement();
        $courseEnrollementPaymentObj->setConnection($this->conn, $connMain);

        $additionalConditions = 'gatewayConfig LIKE ?';
        $additionalParams = ['%' . $invoiceId . '%'];
        $courseEnrollementInfo = $this->queryBuilder->select($tableName, '*', ['id' => $paymentRequest['paymentId']], [], $additionalConditions, $additionalParams, 'id DESC', 1);

        if ($courseEnrollementInfo && count($courseEnrollementInfo) == 1 && $courseEnrollementInfo[0]['id'] == $paymentRequest['paymentId']) {
            $courseEnrollementInfo = $courseEnrollementInfo[0];
            $updateData = ['txnId' => $txnId];
            $where = ['id' => $paymentRequest['paymentId']];
            $this->queryBuilder->update($tableName, $updateData, $where);

            if ($courseEnrollementInfo['formSubmissionStatus'] != 1 && $txnId) {
                $courseEnrollementInfo['txnId'] = $txnId;
                $orderInfo = $this->authorizeObj->fetchOrder($courseEnrollementInfo);
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['notificationResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $orderInfo['transactionStatus']
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);

                if ($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['notificationResponse']['transaction']) && $orderInfo['notificationResponse']['transaction']['transId'] == $txnId && $orderInfo['notificationResponse']['transaction']['order']['invoiceNumber'] == $invoiceId) {
                    $response = $courseEnrollementPaymentObj->createReceipt($courseEnrollementInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]", $orderInfo['transactionStatus'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
                </div>';
        }
    }

    public function sendPaymentLinkReceipt($paymentRequest, $connMain)
    {
        require_once "academia/sendPaymentLinkPayment.php";
        $tableName = 'online_payment';
        $notificationBody = $paymentRequest['notificationBody'];
        $invoiceId = $notificationBody['payload']['invoiceNumber'];
        $txnId = $notificationBody['payload']['id'];

        $sendPaymentLinkObj = new SendPaymentLinkPayment();
        $sendPaymentLinkObj->setConnection($this->conn, $connMain);

        $additionalConditions = 'gatewayConfig LIKE ?';
        $additionalParams = ['%' . $invoiceId . '%'];
        $sendPaymentLinkInfo = $this->queryBuilder->select($tableName, '*', ['id' => $paymentRequest['paymentId']], [], $additionalConditions, $additionalParams, 'id DESC', 1);

        if ($sendPaymentLinkInfo && count($sendPaymentLinkInfo) == 1 && $sendPaymentLinkInfo[0]['id'] == $paymentRequest['paymentId']) {
            $sendPaymentLinkInfo = $sendPaymentLinkInfo[0];
            $updateData = ['txnId' => $txnId];
            $where = ['id' => $paymentRequest['paymentId']];
            $this->queryBuilder->update($tableName, $updateData, $where);

            if ($sendPaymentLinkInfo['formSubmissionStatus'] != 1 && $txnId) {
                $sendPaymentLinkInfo['txnId'] = $txnId;
                $orderInfo = $this->authorizeObj->fetchOrder($sendPaymentLinkInfo);
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['notificationResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $orderInfo['transactionStatus']
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);

                if ($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['notificationResponse']['transaction']) && $orderInfo['notificationResponse']['transaction']['transId'] == $txnId && $orderInfo['notificationResponse']['transaction']['order']['invoiceNumber'] == $invoiceId) {
                    $response = $sendPaymentLinkObj->createReceipt($sendPaymentLinkInfo['sendPaymentLinkId'], $sendPaymentLinkInfo['onlinePaymentId'], $txnId, $orderInfo['status']);
                    if ($response == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]", $orderInfo['transactionStatus'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
                </div>';
        }
    }
    public function advancePaymentReceipt($paymentRequest, $connMain)
    {
        require_once "academia/advancePayment.php";
        $tableName = 'advance_payment';
        $notificationBody = $paymentRequest['notificationBody'];
        $invoiceId = $notificationBody['payload']['invoiceNumber'];
        $txnId = $notificationBody['payload']['id'];

        $advancePaymentObj = new AdvancePayment();
        $advancePaymentObj->setConnection($this->conn, $connMain);

        $additionalConditions = 'gatewayConfig LIKE ?';
        $additionalParams = ['%' . $invoiceId . '%'];
        $advancePaymentInfo = $this->queryBuilder->select($tableName, '*', ['id' => $paymentRequest['paymentId']], [], $additionalConditions, $additionalParams, 'id DESC', 1);

        if ($advancePaymentInfo && count($advancePaymentInfo) == 1 && $advancePaymentInfo[0]['id'] == $paymentRequest['paymentId']) {
            $advancePaymentInfo = $advancePaymentInfo[0];
            $updateData = ['txnId' => $txnId];
            $where = ['id' => $paymentRequest['paymentId']];
            $this->queryBuilder->update($tableName, $updateData, $where);

            if ($advancePaymentInfo['formSubmissionStatus'] != 1 && $txnId) {
                $advancePaymentInfo['txnId'] = $txnId;
                $orderInfo = $this->authorizeObj->fetchOrder($advancePaymentInfo);
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['notificationResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $orderInfo['transactionStatus']
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);

                if ($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['notificationResponse']['transaction']) && $orderInfo['notificationResponse']['transaction']['transId'] == $txnId && $orderInfo['notificationResponse']['transaction']['order']['invoiceNumber'] == $invoiceId) {
                    $response = $advancePaymentObj->createReceipt($advancePaymentInfo);
                    if (isset($response['status']) && $response['status'] == 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response['status'], 'receiptId' => $response['receiptId']];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]", $orderInfo['transactionStatus'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
                </div>';
        }
    }
    public function donationPaymentReceipt($paymentRequest, $connMain)
    {
        require_once("academia/donationPayment.php");
        $tableName = 'donation_payment';
        $notificationBody = $paymentRequest['notificationBody'];
        $invoiceId = $notificationBody['payload']['invoiceNumber'];
        $txnId = $notificationBody['payload']['id'];

        $donationObj = new DonationPayment();
        $donationObj->setConnection($this->conn, $connMain);

        $additionalConditions = 'gatewayConfig LIKE ?';
        $additionalParams = ['%' . $invoiceId . '%'];
        $donationInfo = $this->queryBuilder->select($tableName, '*', ['id' => $paymentRequest['paymentId']], [], $additionalConditions, $additionalParams, 'id DESC', 1);

        if ($donationInfo && count($donationInfo) == 1 && $donationInfo[0]['id'] == $paymentRequest['paymentId']) {
            $donationInfo = $donationInfo[0];
            $updateData = ['txnId' => $txnId];
            $where = ['id' => $paymentRequest['paymentId']];
            $this->queryBuilder->update($tableName, $updateData, $where);

            if ($donationInfo['formSubmissionStatus'] != 1 && $txnId) {
                $donationInfo['txnId'] = $txnId;
                $orderInfo = $this->authorizeObj->fetchOrder($donationInfo);
                $updateData = [
                    'notificationResponse' => json_encode($orderInfo['notificationResponse']),
                    'formSubmissionStatus' => 1,
                    'paymentStatus' => $orderInfo['transactionStatus']
                ];
                $where = ['id' => $paymentRequest['paymentId']];
                $this->queryBuilder->update($tableName, $updateData, $where);

                if ($orderInfo['status'] == 'SUCCESS' && isset($orderInfo['notificationResponse']['transaction']) && $orderInfo['notificationResponse']['transaction']['transId'] == $txnId && $orderInfo['notificationResponse']['transaction']['order']['invoiceNumber'] == $invoiceId) {
                    $response = $donationObj->createReceipt($donationInfo, 'TXN_SUCCESS');
                    if ($response === 'SUCCESS') {
                        $updateData = ['receiptStatus' => $response];
                        $where = ['id' => $paymentRequest['paymentId']];
                        $this->queryBuilder->update($tableName, $updateData, $where);
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_GENERATED']).'</h4>
                            </div>';
                    } else {
                        echo '<div class="col-md-12 text-center alert alert-success">
                                <h4>'.str_replace("[TRANSACTION_ID]", $txnId, $this->translationMsg['TRANSACTION_SUCCESS_RECEIPT_NOT_GENERATED']).'</h4>
                            </div>';
                    }
                } else {
                    echo '<div class="col-md-12 text-center alert alert-warning">
                            <h4>'.str_replace("[ORDER_STATUS]", $orderInfo['transactionStatus'], $this->translationMsg['TRANSACTION_NOT_SUCCESS']).'</h4>
                        </div>';
                }
            } else {
                echo '<div class="col-md-12 text-center alert alert-warning">
                        <h4>'.$this->translationMsg['TRANSACTION_ERROR'].'</h4>
                    </div>';
            }
        } else {
            echo '<div class="col-md-12 text-center alert alert-warning">
                    <h4>'.$this->translationMsg['TRANSACTION_DATA_NOT_FOUND'].'</h4>
                </div>';
        }
    }

}
